/*
   Copyright (C) 2004 by James Gregory
   Part of the GalaxyHack project
 
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License.
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY.
 
   See the COPYING file for more details.
*/

#ifndef GUARD_SettingsStruct
#define GUARD_SettingsStruct

#include "GlobalConstants.h"

#include <string>

using std::string;

class SettingsStruct {
public:
	SettingsStruct() {dontWriteSound = false; batch = false; randomSeed = standardRandomSeed;}
	string commander;
	
	bool fullScreen;
	string videoDriver;
	int screenWidth;
	int screenHeight;
	
	bool bMusic;
	bool disableSound;	
	bool dontWriteSound;
	
	int howGreenIsGreen;
	
	int SSCost;
	int maxSSPoints;
	int FrCost;
	int maxFrPoints;
	int LCSCost;
	int MCSCost;
	int HCSCost;

	string defaultSSPic;
	string defaultFrPic;
	string defaultCSPic;
	
	string defaultSSEngine;
	string defaultSSArmour;
	
	string defaultFrEngine;
	string defaultFrArmour;
	
	string defaultCSEngine;	
	string defaultHCSArmour;
	string defaultMCSArmour;
	string defaultLCSArmour;

	vector<string> rememberFleets;
	
	//base data path
	string bdp;

	bool batch;
	int maxFrames;
	int randomSeed;
};

#endif
