/*
 * Decompiled with CFR 0.152.
 */
package jlibs.core.lang.ref;

import java.lang.ref.PhantomReference;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import jlibs.core.lang.ImpossibleException;

public class Finalizer
extends ReferenceQueue
implements Runnable {
    public static final Finalizer INSTANCE = new Finalizer();
    private Map<Reference, Runnable> tracked = new ConcurrentHashMap<Reference, Runnable>();

    private Finalizer() {
        Thread thread = new Thread((Runnable)this, "JLibsFinalizer");
        thread.setPriority(1);
        thread.setDaemon(true);
        thread.start();
    }

    @Override
    public void run() {
        block5: while (true) {
            try {
                while (true) {
                    Reference ref = super.remove();
                    Runnable runnable = this.tracked.remove(ref);
                    try {
                        if (runnable == null) continue block5;
                        runnable.run();
                        continue block5;
                    }
                    catch (ThreadDeath td) {
                        throw td;
                    }
                    catch (Throwable thr) {
                        thr.printStackTrace();
                        continue;
                    }
                    break;
                }
            }
            catch (InterruptedException ie) {
                ie.printStackTrace();
                continue;
            }
            break;
        }
    }

    public <T> WeakReference<T> track(T obj, Runnable runnable) {
        return this.track(obj, WeakReference.class, runnable);
    }

    public <T, R extends Reference<T>> R track(T obj, Class<R> type, Runnable runnable) {
        Reference ref;
        Class<R> clazz = type;
        if (clazz == WeakReference.class) {
            ref = new WeakReference<T>(obj, this);
        } else if (clazz == SoftReference.class) {
            ref = new SoftReference<T>(obj, this);
        } else if (clazz == PhantomReference.class) {
            ref = new PhantomReference<T>(obj, this);
        } else {
            throw new ImpossibleException();
        }
        this.tracked.put(ref, runnable);
        return (R)ref;
    }

    public void trackGC(Object obj) {
        this.trackGC(obj, null);
    }

    public void trackGC(Object obj, String message) {
        if (message == null) {
            message = obj.getClass().getName() + '@' + System.identityHashCode(obj);
        }
        this.track(obj, new MessagePrinter(message));
    }

    private static class MessagePrinter
    implements Runnable {
        private String message;

        private MessagePrinter(String message) {
            this.message = message;
        }

        @Override
        public void run() {
            System.out.println("JLibsFinalizer: '" + this.message + "' got garbage collected.");
        }
    }
}

