/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.formcomponents;

import com.install4j.api.Util;
import com.install4j.api.beans.ScriptProperty;
import com.install4j.api.beans.VariableErrorHandlingDescriptor;
import com.install4j.api.context.UserCanceledException;
import com.install4j.api.formcomponents.FormEnvironment;
import com.install4j.api.screens.Console;
import com.install4j.runtime.beans.formcomponents.LeadingLabelComponent;
import com.install4j.runtime.installer.helper.Logger;
import com.install4j.runtime.util.HyperlinkLabel;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JLabel;

public class HyperlinkActionLabelComponent
extends LeadingLabelComponent {
    private String hyperlinkText;
    private ScriptProperty actionScript;
    private HyperlinkLabel label;

    public String getHyperlinkText() {
        return this.hyperlinkText;
    }

    public void setHyperlinkText(String string) {
        this.hyperlinkText = string;
    }

    public ScriptProperty getActionScript() {
        return this.actionScript;
    }

    public void setActionScript(ScriptProperty scriptProperty) {
        this.actionScript = scriptProperty;
    }

    public void initialize() {
        super.initialize();
        this.label.setText(HyperlinkActionLabelComponent.replaceVariables(this.hyperlinkText, VariableErrorHandlingDescriptor.ALWAYS_ERROR_MESSAGE));
    }

    public void setFormEnvironment(FormEnvironment formEnvironment) {
        super.setFormEnvironment(formEnvironment);
        if (this.label != null && formEnvironment != null) {
            this.label.setName(formEnvironment.getId(this));
        }
    }

    public JComponent createCenterComponent() {
        this.label = new HyperlinkLabel(new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                HyperlinkActionLabelComponent.this.doHyperlink();
            }
        });
        return this.label;
    }

    private void doHyperlink() {
        if (this.actionScript != null) {
            try {
                this.getContext().runScript(this.actionScript, this, new Object[]{this.getFormEnvironment()});
            }
            catch (Exception exception) {
                Util.printAnnotatedStackTrace(exception);
                Logger.getInstance().log(exception);
            }
        }
    }

    public boolean isFillCenterHorizontal() {
        return false;
    }

    public Object getConfigurationObject() {
        return this.label;
    }

    public Class getConfigurationObjectClass() {
        return JLabel.class;
    }

    public boolean handleConsole(Console console) throws UserCanceledException {
        String string = this.getLabelText();
        if (string.length() > 0) {
            console.println(string);
        }
        if (console.askYesNo(HyperlinkActionLabelComponent.replaceVariables(this.hyperlinkText, VariableErrorHandlingDescriptor.ALWAYS_ERROR_MESSAGE), false)) {
            this.doHyperlink();
        }
        return true;
    }
}

