/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.actions.text;

import com.install4j.api.beans.PropertyLoggingInterceptor;
import com.install4j.api.beans.VariableErrorHandlingDescriptor;
import com.install4j.api.context.Context;
import com.install4j.runtime.beans.actions.files.AbstractModifySingleFileAction;
import com.install4j.runtime.installer.helper.Logger;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;

public class WriteTextFileAction
extends AbstractModifySingleFileAction
implements PropertyLoggingInterceptor {
    private String text = "";
    private String encoding = "";
    private boolean escaped = true;
    private boolean append = false;
    private boolean logText = true;

    public boolean isLogText() {
        return this.logText;
    }

    public void setLogText(boolean bl) {
        this.logText = bl;
    }

    public boolean isEscaped() {
        return this.escaped;
    }

    public void setEscaped(boolean bl) {
        this.escaped = bl;
    }

    public String getText() {
        return WriteTextFileAction.replaceVariables(this.text, VariableErrorHandlingDescriptor.ALWAYS_ERROR_MESSAGE);
    }

    public void setText(String string) {
        this.text = string;
    }

    public String getEncoding() {
        return WriteTextFileAction.replaceVariables(this.encoding);
    }

    public void setEncoding(String string) {
        this.encoding = string;
    }

    public boolean isAppend() {
        return this.append;
    }

    public void setAppend(boolean bl) {
        this.append = bl;
    }

    protected boolean modifyFile(File file, Context context) throws IOException {
        String string;
        BufferedWriter bufferedWriter;
        String string2 = this.getEncoding();
        String string3 = this.getText();
        if (this.isEscaped()) {
            try {
                string3 = WriteTextFileAction.loadConvert(string3);
            }
            catch (Exception exception) {
                Logger.getInstance().log(exception);
                return false;
            }
        }
        FileOutputStream fileOutputStream = new FileOutputStream(file.getAbsolutePath(), this.append);
        if (string2 != null && string2.trim().length() > 0) {
            try {
                bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)fileOutputStream, string2));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                Logger.getInstance().log(unsupportedEncodingException);
                bufferedWriter = new BufferedWriter(new OutputStreamWriter(fileOutputStream));
            }
        } else {
            bufferedWriter = new BufferedWriter(new OutputStreamWriter(fileOutputStream));
        }
        BufferedWriter bufferedWriter2 = new BufferedWriter(bufferedWriter);
        BufferedReader bufferedReader = new BufferedReader(new StringReader(string3));
        while ((string = bufferedReader.readLine()) != null) {
            bufferedWriter2.write(string);
            bufferedWriter2.newLine();
        }
        bufferedWriter2.close();
        return true;
    }

    private static String loadConvert(String string) {
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n);
        int n2 = 0;
        while (n2 < n) {
            int n3;
            if ((n3 = string.charAt(n2++)) == 92) {
                if ((n3 = string.charAt(n2++)) == 117) {
                    int n4 = 0;
                    block6: for (int i = 0; i < 4; ++i) {
                        n3 = string.charAt(n2++);
                        switch (n3) {
                            case 48: 
                            case 49: 
                            case 50: 
                            case 51: 
                            case 52: 
                            case 53: 
                            case 54: 
                            case 55: 
                            case 56: 
                            case 57: {
                                n4 = (n4 << 4) + n3 - 48;
                                continue block6;
                            }
                            case 97: 
                            case 98: 
                            case 99: 
                            case 100: 
                            case 101: 
                            case 102: {
                                n4 = (n4 << 4) + 10 + n3 - 97;
                                continue block6;
                            }
                            case 65: 
                            case 66: 
                            case 67: 
                            case 68: 
                            case 69: 
                            case 70: {
                                n4 = (n4 << 4) + 10 + n3 - 65;
                                continue block6;
                            }
                            default: {
                                throw new IllegalArgumentException("Malformed \\uxxxx encoding.");
                            }
                        }
                    }
                    stringBuffer.append((char)n4);
                    continue;
                }
                if (n3 == 116) {
                    n3 = 9;
                } else if (n3 == 114) {
                    n3 = 13;
                } else if (n3 == 110) {
                    n3 = 10;
                } else if (n3 == 102) {
                    n3 = 12;
                }
                stringBuffer.append((char)n3);
                continue;
            }
            stringBuffer.append((char)n3);
        }
        return stringBuffer.toString();
    }

    public Object getLogValueForProperty(String string, Object object) {
        return this.maybeFilterLogReplacement(string, "text", object, this.logText);
    }
}

