/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.actions.desktop;

import com.install4j.api.actions.AutoUninstallAction;
import com.install4j.api.beans.VariableErrorHandlingDescriptor;
import com.install4j.api.context.Context;
import com.install4j.api.context.InstallerContext;
import com.install4j.api.context.UninstallerContext;
import com.install4j.api.context.UserCanceledException;
import com.install4j.runtime.beans.actions.SystemInstallAction;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.helper.Logger;
import com.install4j.runtime.installer.helper.MenuHelper;
import com.install4j.runtime.installer.helper.comm.ExecutionContext;
import com.install4j.runtime.installer.helper.comm.HelperCommunication;
import com.install4j.runtime.installer.helper.comm.actions.FetchBooleanAction;
import com.install4j.runtime.installer.helper.comm.actions.RunAction;
import com.install4j.runtime.installer.platform.unix.Execution;
import com.install4j.runtime.installer.platform.win32.FolderInfo;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Properties;

public class AddStartupItemAction
extends SystemInstallAction
implements AutoUninstallAction {
    private Properties persistentProperties = new Properties();
    private File executable;
    private String name;
    private boolean allUsers;
    private boolean hide = false;
    private static final String PROPNAME_EXECUTABLE = "executable";

    public boolean install(InstallerContext installerContext) throws UserCanceledException {
        try {
            File file = installerContext.getDestinationFile(this.getExecutable());
            if (InstallerUtil.isWindows()) {
                if (!file.exists()) {
                    file = installerContext.getDestinationFile(this.getExecutable() + ".exe");
                }
                Logger.getInstance().info(this, "using " + file + ", " + file.exists());
                boolean bl = this.isAllUsers();
                if (bl && !InstallerUtil.checkWriteable(FolderInfo.getSpecialFolder(4, true))) {
                    bl = false;
                }
                MenuHelper.installWindowsMenu(bl ? ExecutionContext.MAXIMUM : ExecutionContext.UNELEVATED, new File(FolderInfo.getSpecialFolder(4, bl), this.getName()), file, null);
            } else if (InstallerUtil.isMacOS()) {
                Logger.getInstance().info(this, "using " + file + ", " + file.exists());
                AddStartupItemAction.doRollback(file.getAbsolutePath());
                if (AddStartupItemAction.addOnMac(file, this.isHide())) {
                    this.getPersistentProperties().setProperty(PROPNAME_EXECUTABLE, file.getAbsolutePath());
                } else {
                    return false;
                }
            }
            return true;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return false;
        }
    }

    private static boolean addOnMac(final File file, final boolean bl) {
        return HelperCommunication.getInstance().fetchBoolean(ExecutionContext.UNELEVATED, new FetchBooleanAction(){

            protected boolean fetchValue(Context context) throws Exception {
                String string = file.getName();
                if (string.endsWith(".app")) {
                    string = string.substring(0, string.length() - 4);
                }
                return AddStartupItemAction.executeScript("tell app \"System Events\" to make login item at end with properties {path:\"" + file.getAbsolutePath() + "\", hidden:" + bl + ", name:\"" + string + "\"}");
            }
        });
    }

    private static boolean executeScript(String string) throws IOException {
        Logger.getInstance().info(null, string);
        File file = File.createTempFile("i4j", ".script");
        PrintWriter printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream(file)), "UTF-8"));
        printWriter.println(string);
        printWriter.close();
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = Execution.executeAndWait(new String[]{"/usr/bin/osascript", file.getAbsolutePath()}, stringBuffer);
        Logger.getInstance().info(null, stringBuffer.toString());
        file.delete();
        return bl;
    }

    public Properties getPersistentProperties() {
        return this.persistentProperties;
    }

    public void setPersistentProperties(Properties properties) {
        this.persistentProperties = properties;
    }

    public void rollback(InstallerContext installerContext) {
        if (InstallerUtil.isMacOS()) {
            AddStartupItemAction.doRollback(installerContext.getDestinationFile(this.getExecutable()).getAbsolutePath());
        }
    }

    public boolean uninstall(UninstallerContext uninstallerContext) throws UserCanceledException {
        if (InstallerUtil.isMacOS()) {
            AddStartupItemAction.doRollback(this.getPersistentProperties().getProperty(PROPNAME_EXECUTABLE));
        }
        return true;
    }

    private static void doRollback(final String string) {
        HelperCommunication.getInstance().executeAction(ExecutionContext.UNELEVATED, new RunAction(){

            protected void run(Context context) throws Exception {
                if (string != null) {
                    File file = new File(string);
                    String string2 = file.getName();
                    if (string2.endsWith(".app")) {
                        string2 = string2.substring(0, string2.length() - 4);
                    }
                    AddStartupItemAction.executeScript("tell app \"System Events\" to delete login item \"" + string2 + "\"");
                }
            }
        });
    }

    public boolean isHide() {
        return this.hide;
    }

    public void setHide(boolean bl) {
        this.hide = bl;
    }

    public String getName() {
        return AddStartupItemAction.replaceVariables(this.name, VariableErrorHandlingDescriptor.ALWAYS_ERROR_MESSAGE);
    }

    public void setName(String string) {
        this.name = string;
    }

    public File getExecutable() {
        return AddStartupItemAction.replaceVariables(this.executable);
    }

    public void setExecutable(File file) {
        this.executable = file;
    }

    public boolean isAllUsers() {
        return this.allUsers;
    }

    public void setAllUsers(boolean bl) {
        this.allUsers = bl;
    }
}

