/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.testng.IClass;
import org.testng.ITest;
import org.testng.ITestContext;
import org.testng.ITestObjectFactory;
import org.testng.annotations.ITestAnnotation;
import org.testng.collections.Lists;
import org.testng.collections.Objects;
import org.testng.internal.IObject;
import org.testng.internal.IParameterInfo;
import org.testng.internal.annotations.IAnnotationFinder;
import org.testng.internal.objects.DefaultTestObjectFactory;
import org.testng.internal.objects.Dispenser;
import org.testng.internal.objects.IObjectDispenser;
import org.testng.internal.objects.pojo.BasicAttributes;
import org.testng.internal.objects.pojo.CreationAttributes;
import org.testng.internal.objects.pojo.DetailedAttributes;
import org.testng.xml.XmlClass;
import org.testng.xml.XmlTest;

public class ClassImpl
implements IClass,
IObject {
    private final Class<?> m_class;
    private IObject.IdentifiableObject m_defaultInstance = null;
    private final IAnnotationFinder m_annotationFinder;
    private final List<IObject.IdentifiableObject> identifiableObjects = Lists.newArrayList();
    private final Map<Class<?>, IClass> m_classes;
    private long[] m_instanceHashCodes;
    private final IObject.IdentifiableObject m_instance;
    private final ITestObjectFactory m_objectFactory;
    private String m_testName = null;
    private final XmlClass m_xmlClass;
    private final ITestContext m_testContext;

    public ClassImpl(ITestContext context, Class<?> cls, XmlClass xmlClass, IObject.IdentifiableObject instance, Map<Class<?>, IClass> classes, IAnnotationFinder annotationFinder, ITestObjectFactory objectFactory) {
        ITestAnnotation annotation;
        this.m_testContext = context;
        this.m_class = cls;
        this.m_classes = classes;
        this.m_xmlClass = xmlClass;
        this.m_annotationFinder = annotationFinder;
        this.m_instance = instance;
        this.m_objectFactory = objectFactory;
        if (IObject.IdentifiableObject.unwrap(instance) instanceof ITest) {
            this.m_testName = ((ITest)instance.getInstance()).getTestName();
        }
        if (this.m_testName == null && (annotation = this.m_annotationFinder.findAnnotation(cls, ITestAnnotation.class)) != null && !annotation.getTestName().isEmpty()) {
            this.m_testName = annotation.getTestName();
        }
    }

    @Override
    public String getTestName() {
        return this.m_testName;
    }

    @Override
    public String getName() {
        return this.m_class.getName();
    }

    @Override
    public Class<?> getRealClass() {
        return this.m_class;
    }

    @Override
    public long[] getInstanceHashCodes() {
        return this.m_instanceHashCodes;
    }

    @Override
    public XmlTest getXmlTest() {
        return this.m_testContext.getCurrentXmlTest();
    }

    @Override
    public XmlClass getXmlClass() {
        return this.m_xmlClass;
    }

    private IObject.IdentifiableObject getDefaultInstance(boolean create, String errMsgPrefix) {
        if (this.m_defaultInstance == null) {
            if (this.m_instance != null) {
                this.m_defaultInstance = this.m_instance;
            } else {
                DetailedAttributes detailed;
                BasicAttributes basic;
                CreationAttributes attributes;
                IObjectDispenser dispenser;
                Object raw;
                ITestObjectFactory factory = this.m_objectFactory;
                if (factory instanceof DefaultTestObjectFactory) {
                    factory = this.m_testContext.getSuite().getObjectFactory();
                }
                if ((raw = (dispenser = Dispenser.newInstance(factory)).dispense(attributes = new CreationAttributes(this.m_testContext, basic = new BasicAttributes(this, null), detailed = this.newDetailedAttributes(create, errMsgPrefix)))) != null) {
                    this.m_defaultInstance = new IObject.IdentifiableObject(raw);
                }
            }
        }
        return this.m_defaultInstance;
    }

    @Override
    public Object[] getInstances(boolean create) {
        return this.getInstances(create, "");
    }

    @Override
    public Object[] getInstances(boolean create, String errorMsgPrefix) {
        return Arrays.stream(this.getObjects(create, errorMsgPrefix)).map(IObject.IdentifiableObject::getInstance).toArray(Object[]::new);
    }

    @Override
    public void addObject(IObject.IdentifiableObject instance) {
        this.identifiableObjects.add(instance);
    }

    @Override
    public IObject.IdentifiableObject[] getObjects(boolean create, String errorMsgPrefix) {
        IObject.IdentifiableObject[] result = new IObject.IdentifiableObject[]{};
        if (!this.identifiableObjects.isEmpty()) {
            result = this.identifiableObjects.toArray(new IObject.IdentifiableObject[0]);
        } else {
            IObject.IdentifiableObject defaultInstance = this.getDefaultInstance(create, errorMsgPrefix);
            if (defaultInstance != null) {
                result = new IObject.IdentifiableObject[]{defaultInstance};
            }
        }
        int m_instanceCount = this.identifiableObjects.size();
        this.m_instanceHashCodes = new long[m_instanceCount];
        for (int i = 0; i < m_instanceCount; ++i) {
            this.m_instanceHashCodes[i] = ClassImpl.computeHashCode(this.identifiableObjects.get(i).getInstance());
        }
        return result;
    }

    public String toString() {
        return Objects.toStringHelper(this.getClass()).add("class", this.m_class.getName()).toString();
    }

    @Override
    public void addInstance(Object instance) {
        this.addObject(new IObject.IdentifiableObject(instance));
    }

    private static int computeHashCode(Object instance) {
        return IParameterInfo.embeddedInstance(instance).hashCode();
    }

    private DetailedAttributes newDetailedAttributes(boolean create, String errMsgPrefix) {
        DetailedAttributes ea = new DetailedAttributes();
        ea.setXmlTest(this.m_testContext.getCurrentXmlTest());
        ea.setClasses(this.m_classes);
        ea.setFinder(this.m_annotationFinder);
        ea.setDeclaringClass(this.m_class);
        ea.setErrorMsgPrefix(errMsgPrefix);
        ea.setCreate(create);
        return ea;
    }
}

