/*
 * Decompiled with CFR 0.152.
 */
package org.jmock.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import junit.framework.AssertionFailedError;
import org.jmock.core.Invocation;
import org.jmock.core.InvocationMatcher;
import org.jmock.core.Invokable;
import org.jmock.core.Stub;
import org.jmock.core.StubMatchersCollection;
import org.jmock.core.stub.VoidStub;

public class InvocationMocker
implements Invokable,
StubMatchersCollection {
    private String name = null;
    private List matchers = new ArrayList();
    private Stub stub = VoidStub.INSTANCE;
    private Describer describer;
    public static final Describer DEFAULT_DESCRIBER = new Describer(){

        public boolean hasDescription() {
            return true;
        }

        public void describeTo(StringBuffer buffer, List matchers, Stub stub, String name) {
            for (InvocationMatcher matcher : matchers) {
                if (!matcher.hasDescription()) continue;
                matcher.describeTo(buffer).append(", ");
            }
            stub.describeTo(buffer);
            if (name != null) {
                buffer.append(" [").append(name).append("]");
            }
        }
    };

    public InvocationMocker() {
        this(DEFAULT_DESCRIBER);
    }

    public InvocationMocker(Describer describer) {
        this.describer = describer;
    }

    public boolean matches(Invocation invocation) {
        Iterator i = this.matchers.iterator();
        while (i.hasNext()) {
            if (((InvocationMatcher)i.next()).matches(invocation)) continue;
            return false;
        }
        return true;
    }

    public Object invoke(Invocation invocation) throws Throwable {
        Iterator i = this.matchers.iterator();
        while (i.hasNext()) {
            ((InvocationMatcher)i.next()).invoked(invocation);
        }
        return this.stub.invoke(invocation);
    }

    public void verify() {
        try {
            Iterator i = this.matchers.iterator();
            while (i.hasNext()) {
                ((InvocationMatcher)i.next()).verify();
            }
        }
        catch (AssertionFailedError error) {
            AssertionFailedError newError = new AssertionFailedError(error.getMessage() + "\n" + this.toString());
            newError.fillInStackTrace();
            throw newError;
        }
    }

    public void setName(String name) {
        this.name = name;
    }

    public void addMatcher(InvocationMatcher matcher) {
        this.matchers.add(matcher);
    }

    public void setStub(Stub stub) {
        this.stub = stub;
    }

    public String toString() {
        return this.describeTo(new StringBuffer()).toString();
    }

    public boolean hasDescription() {
        return this.describer.hasDescription();
    }

    public StringBuffer describeTo(StringBuffer buffer) {
        this.describer.describeTo(buffer, Collections.unmodifiableList(this.matchers), this.stub, this.name);
        return buffer;
    }

    public static interface Describer {
        public boolean hasDescription();

        public void describeTo(StringBuffer var1, List var2, Stub var3, String var4);
    }
}

