// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/vision/v1/product_search_service.proto

#include "google/cloud/vision/v1/product_search_connection.h"
#include "google/cloud/vision/v1/internal/product_search_connection_impl.h"
#include "google/cloud/vision/v1/internal/product_search_option_defaults.h"
#include "google/cloud/vision/v1/internal/product_search_stub_factory.h"
#include "google/cloud/vision/v1/internal/product_search_tracing_connection.h"
#include "google/cloud/vision/v1/product_search_options.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/credentials.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/pagination_range.h"
#include "google/cloud/internal/unified_grpc_credentials.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace vision_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

ProductSearchConnection::~ProductSearchConnection() = default;

StatusOr<google::cloud::vision::v1::ProductSet>
ProductSearchConnection::CreateProductSet(
    google::cloud::vision::v1::CreateProductSetRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StreamRange<google::cloud::vision::v1::ProductSet>
ProductSearchConnection::ListProductSets(
    google::cloud::vision::v1::
        ListProductSetsRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::vision::v1::ProductSet>>();
}

StatusOr<google::cloud::vision::v1::ProductSet>
ProductSearchConnection::GetProductSet(
    google::cloud::vision::v1::GetProductSetRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::vision::v1::ProductSet>
ProductSearchConnection::UpdateProductSet(
    google::cloud::vision::v1::UpdateProductSetRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

Status ProductSearchConnection::DeleteProductSet(
    google::cloud::vision::v1::DeleteProductSetRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::vision::v1::Product>
ProductSearchConnection::CreateProduct(
    google::cloud::vision::v1::CreateProductRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StreamRange<google::cloud::vision::v1::Product>
ProductSearchConnection::ListProducts(
    google::cloud::vision::v1::
        ListProductsRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::vision::v1::Product>>();
}

StatusOr<google::cloud::vision::v1::Product>
ProductSearchConnection::GetProduct(
    google::cloud::vision::v1::GetProductRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::vision::v1::Product>
ProductSearchConnection::UpdateProduct(
    google::cloud::vision::v1::UpdateProductRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

Status ProductSearchConnection::DeleteProduct(
    google::cloud::vision::v1::DeleteProductRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::vision::v1::ReferenceImage>
ProductSearchConnection::CreateReferenceImage(
    google::cloud::vision::v1::CreateReferenceImageRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

Status ProductSearchConnection::DeleteReferenceImage(
    google::cloud::vision::v1::DeleteReferenceImageRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StreamRange<google::cloud::vision::v1::ReferenceImage>
ProductSearchConnection::ListReferenceImages(
    google::cloud::vision::v1::
        ListReferenceImagesRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::vision::v1::ReferenceImage>>();
}

StatusOr<google::cloud::vision::v1::ReferenceImage>
ProductSearchConnection::GetReferenceImage(
    google::cloud::vision::v1::GetReferenceImageRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

Status ProductSearchConnection::AddProductToProductSet(
    google::cloud::vision::v1::AddProductToProductSetRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

Status ProductSearchConnection::RemoveProductFromProductSet(
    google::cloud::vision::v1::RemoveProductFromProductSetRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StreamRange<google::cloud::vision::v1::Product>
ProductSearchConnection::ListProductsInProductSet(
    google::cloud::vision::v1::
        ListProductsInProductSetRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::vision::v1::Product>>();
}

future<StatusOr<google::cloud::vision::v1::ImportProductSetsResponse>>
ProductSearchConnection::ImportProductSets(
    google::cloud::vision::v1::ImportProductSetsRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::vision::v1::ImportProductSetsResponse>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
ProductSearchConnection::ImportProductSets(
    NoAwaitTag, google::cloud::vision::v1::ImportProductSetsRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::vision::v1::ImportProductSetsResponse>>
ProductSearchConnection::ImportProductSets(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::vision::v1::ImportProductSetsResponse>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::vision::v1::BatchOperationMetadata>>
ProductSearchConnection::PurgeProducts(
    google::cloud::vision::v1::PurgeProductsRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::vision::v1::BatchOperationMetadata>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation> ProductSearchConnection::PurgeProducts(
    NoAwaitTag, google::cloud::vision::v1::PurgeProductsRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::vision::v1::BatchOperationMetadata>>
ProductSearchConnection::PurgeProducts(google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::vision::v1::BatchOperationMetadata>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

std::shared_ptr<ProductSearchConnection> MakeProductSearchConnection(
    Options options) {
  internal::CheckExpectedOptions<CommonOptionList, GrpcOptionList,
                                 UnifiedCredentialsOptionList,
                                 ProductSearchPolicyOptionList>(options,
                                                                __func__);
  options = vision_v1_internal::ProductSearchDefaultOptions(std::move(options));
  auto background = internal::MakeBackgroundThreadsFactory(options)();
  auto auth = internal::CreateAuthenticationStrategy(background->cq(), options);
  auto stub = vision_v1_internal::CreateDefaultProductSearchStub(
      std::move(auth), options);
  return vision_v1_internal::MakeProductSearchTracingConnection(
      std::make_shared<vision_v1_internal::ProductSearchConnectionImpl>(
          std::move(background), std::move(stub), std::move(options)));
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace vision_v1
}  // namespace cloud
}  // namespace google
