// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/api/serviceusage/v1/serviceusage.proto

#include "google/cloud/serviceusage/v1/internal/service_usage_option_defaults.h"
#include "google/cloud/serviceusage/v1/service_usage_connection.h"
#include "google/cloud/serviceusage/v1/service_usage_options.h"
#include "google/cloud/internal/populate_common_options.h"
#include "google/cloud/internal/populate_grpc_options.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace serviceusage_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

namespace {
auto constexpr kBackoffScaling = 2.0;
}  // namespace

Options ServiceUsageDefaultOptions(Options options) {
  options = internal::PopulateCommonOptions(
      std::move(options), "GOOGLE_CLOUD_CPP_SERVICE_USAGE_ENDPOINT", "",
      "GOOGLE_CLOUD_CPP_SERVICE_USAGE_AUTHORITY",
      "serviceusage.googleapis.com");
  options = internal::PopulateGrpcOptions(std::move(options));
  if (!options.has<serviceusage_v1::ServiceUsageRetryPolicyOption>()) {
    options.set<serviceusage_v1::ServiceUsageRetryPolicyOption>(
        serviceusage_v1::ServiceUsageLimitedTimeRetryPolicy(
            std::chrono::minutes(30))
            .clone());
  }
  if (!options.has<serviceusage_v1::ServiceUsageBackoffPolicyOption>()) {
    options.set<serviceusage_v1::ServiceUsageBackoffPolicyOption>(
        ExponentialBackoffPolicy(
            std::chrono::seconds(0), std::chrono::seconds(1),
            std::chrono::minutes(5), kBackoffScaling, kBackoffScaling)
            .clone());
  }
  if (!options.has<serviceusage_v1::ServiceUsagePollingPolicyOption>()) {
    options.set<serviceusage_v1::ServiceUsagePollingPolicyOption>(
        GenericPollingPolicy<
            serviceusage_v1::ServiceUsageRetryPolicyOption::Type,
            serviceusage_v1::ServiceUsageBackoffPolicyOption::Type>(
            options.get<serviceusage_v1::ServiceUsageRetryPolicyOption>()
                ->clone(),
            ExponentialBackoffPolicy(std::chrono::seconds(1),
                                     std::chrono::minutes(5), kBackoffScaling)
                .clone())
            .clone());
  }
  if (!options.has<
          serviceusage_v1::ServiceUsageConnectionIdempotencyPolicyOption>()) {
    options.set<serviceusage_v1::ServiceUsageConnectionIdempotencyPolicyOption>(
        serviceusage_v1::MakeDefaultServiceUsageConnectionIdempotencyPolicy());
  }

  return options;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace serviceusage_v1_internal
}  // namespace cloud
}  // namespace google
