// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/osconfig/v1/osconfig_zonal_service.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_OSCONFIG_V1_OS_CONFIG_ZONAL_CONNECTION_IDEMPOTENCY_POLICY_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_OSCONFIG_V1_OS_CONFIG_ZONAL_CONNECTION_IDEMPOTENCY_POLICY_H

#include "google/cloud/idempotency.h"
#include "google/cloud/version.h"
#include <google/cloud/osconfig/v1/osconfig_zonal_service.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace osconfig_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

class OsConfigZonalServiceConnectionIdempotencyPolicy {
 public:
  virtual ~OsConfigZonalServiceConnectionIdempotencyPolicy();

  /// Create a new copy of this object.
  virtual std::unique_ptr<OsConfigZonalServiceConnectionIdempotencyPolicy>
  clone() const;

  virtual google::cloud::Idempotency CreateOSPolicyAssignment(
      google::cloud::osconfig::v1::CreateOSPolicyAssignmentRequest const&
          request);

  virtual google::cloud::Idempotency UpdateOSPolicyAssignment(
      google::cloud::osconfig::v1::UpdateOSPolicyAssignmentRequest const&
          request);

  virtual google::cloud::Idempotency GetOSPolicyAssignment(
      google::cloud::osconfig::v1::GetOSPolicyAssignmentRequest const& request);

  virtual google::cloud::Idempotency ListOSPolicyAssignments(
      google::cloud::osconfig::v1::ListOSPolicyAssignmentsRequest request);

  virtual google::cloud::Idempotency ListOSPolicyAssignmentRevisions(
      google::cloud::osconfig::v1::ListOSPolicyAssignmentRevisionsRequest
          request);

  virtual google::cloud::Idempotency DeleteOSPolicyAssignment(
      google::cloud::osconfig::v1::DeleteOSPolicyAssignmentRequest const&
          request);

  virtual google::cloud::Idempotency GetOSPolicyAssignmentReport(
      google::cloud::osconfig::v1::GetOSPolicyAssignmentReportRequest const&
          request);

  virtual google::cloud::Idempotency ListOSPolicyAssignmentReports(
      google::cloud::osconfig::v1::ListOSPolicyAssignmentReportsRequest
          request);

  virtual google::cloud::Idempotency GetInventory(
      google::cloud::osconfig::v1::GetInventoryRequest const& request);

  virtual google::cloud::Idempotency ListInventories(
      google::cloud::osconfig::v1::ListInventoriesRequest request);

  virtual google::cloud::Idempotency GetVulnerabilityReport(
      google::cloud::osconfig::v1::GetVulnerabilityReportRequest const&
          request);

  virtual google::cloud::Idempotency ListVulnerabilityReports(
      google::cloud::osconfig::v1::ListVulnerabilityReportsRequest request);
};

std::unique_ptr<OsConfigZonalServiceConnectionIdempotencyPolicy>
MakeDefaultOsConfigZonalServiceConnectionIdempotencyPolicy();

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace osconfig_v1
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_OSCONFIG_V1_OS_CONFIG_ZONAL_CONNECTION_IDEMPOTENCY_POLICY_H
