// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/monitoring/v3/alert_service.proto

#include "google/cloud/monitoring/v3/internal/alert_policy_connection_impl.h"
#include "google/cloud/monitoring/v3/internal/alert_policy_option_defaults.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/pagination_range.h"
#include "google/cloud/internal/retry_loop.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace monitoring_v3_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN
namespace {

std::unique_ptr<monitoring_v3::AlertPolicyServiceRetryPolicy> retry_policy(
    Options const& options) {
  return options.get<monitoring_v3::AlertPolicyServiceRetryPolicyOption>()
      ->clone();
}

std::unique_ptr<BackoffPolicy> backoff_policy(Options const& options) {
  return options.get<monitoring_v3::AlertPolicyServiceBackoffPolicyOption>()
      ->clone();
}

std::unique_ptr<monitoring_v3::AlertPolicyServiceConnectionIdempotencyPolicy>
idempotency_policy(Options const& options) {
  return options
      .get<monitoring_v3::AlertPolicyServiceConnectionIdempotencyPolicyOption>()
      ->clone();
}

}  // namespace

AlertPolicyServiceConnectionImpl::AlertPolicyServiceConnectionImpl(
    std::unique_ptr<google::cloud::BackgroundThreads> background,
    std::shared_ptr<monitoring_v3_internal::AlertPolicyServiceStub> stub,
    Options options)
    : background_(std::move(background)),
      stub_(std::move(stub)),
      options_(internal::MergeOptions(
          std::move(options), AlertPolicyServiceConnection::options())) {}

StreamRange<google::monitoring::v3::AlertPolicy>
AlertPolicyServiceConnectionImpl::ListAlertPolicies(
    google::monitoring::v3::ListAlertPoliciesRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency = idempotency_policy(*current)->ListAlertPolicies(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::monitoring::v3::AlertPolicy>>(
      current, std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<monitoring_v3::AlertPolicyServiceRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          Options const& options,
          google::monitoring::v3::ListAlertPoliciesRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context, Options const& options,
                   google::monitoring::v3::ListAlertPoliciesRequest const&
                       request) {
              return stub->ListAlertPolicies(context, options, request);
            },
            options, r, function_name);
      },
      [](google::monitoring::v3::ListAlertPoliciesResponse r) {
        std::vector<google::monitoring::v3::AlertPolicy> result(
            r.alert_policies().size());
        auto& messages = *r.mutable_alert_policies();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StatusOr<google::monitoring::v3::AlertPolicy>
AlertPolicyServiceConnectionImpl::GetAlertPolicy(
    google::monitoring::v3::GetAlertPolicyRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetAlertPolicy(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::monitoring::v3::GetAlertPolicyRequest const& request) {
        return stub_->GetAlertPolicy(context, options, request);
      },
      *current, request, __func__);
}

StatusOr<google::monitoring::v3::AlertPolicy>
AlertPolicyServiceConnectionImpl::CreateAlertPolicy(
    google::monitoring::v3::CreateAlertPolicyRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->CreateAlertPolicy(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::monitoring::v3::CreateAlertPolicyRequest const& request) {
        return stub_->CreateAlertPolicy(context, options, request);
      },
      *current, request, __func__);
}

Status AlertPolicyServiceConnectionImpl::DeleteAlertPolicy(
    google::monitoring::v3::DeleteAlertPolicyRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->DeleteAlertPolicy(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::monitoring::v3::DeleteAlertPolicyRequest const& request) {
        return stub_->DeleteAlertPolicy(context, options, request);
      },
      *current, request, __func__);
}

StatusOr<google::monitoring::v3::AlertPolicy>
AlertPolicyServiceConnectionImpl::UpdateAlertPolicy(
    google::monitoring::v3::UpdateAlertPolicyRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->UpdateAlertPolicy(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::monitoring::v3::UpdateAlertPolicyRequest const& request) {
        return stub_->UpdateAlertPolicy(context, options, request);
      },
      *current, request, __func__);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace monitoring_v3_internal
}  // namespace cloud
}  // namespace google
