// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/edgenetwork/v1/service.proto

#include "google/cloud/edgenetwork/v1/internal/edge_network_option_defaults.h"
#include "google/cloud/edgenetwork/v1/edge_network_connection.h"
#include "google/cloud/edgenetwork/v1/edge_network_options.h"
#include "google/cloud/internal/populate_common_options.h"
#include "google/cloud/internal/populate_grpc_options.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace edgenetwork_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

namespace {
auto constexpr kBackoffScaling = 2.0;
}  // namespace

Options EdgeNetworkDefaultOptions(Options options) {
  options = internal::PopulateCommonOptions(
      std::move(options), "GOOGLE_CLOUD_CPP_EDGE_NETWORK_ENDPOINT", "",
      "GOOGLE_CLOUD_CPP_EDGE_NETWORK_AUTHORITY", "edgenetwork.googleapis.com");
  options = internal::PopulateGrpcOptions(std::move(options));
  if (!options.has<edgenetwork_v1::EdgeNetworkRetryPolicyOption>()) {
    options.set<edgenetwork_v1::EdgeNetworkRetryPolicyOption>(
        edgenetwork_v1::EdgeNetworkLimitedTimeRetryPolicy(
            std::chrono::minutes(30))
            .clone());
  }
  if (!options.has<edgenetwork_v1::EdgeNetworkBackoffPolicyOption>()) {
    options.set<edgenetwork_v1::EdgeNetworkBackoffPolicyOption>(
        ExponentialBackoffPolicy(
            std::chrono::seconds(0), std::chrono::seconds(1),
            std::chrono::minutes(5), kBackoffScaling, kBackoffScaling)
            .clone());
  }
  if (!options.has<edgenetwork_v1::EdgeNetworkPollingPolicyOption>()) {
    options.set<edgenetwork_v1::EdgeNetworkPollingPolicyOption>(
        GenericPollingPolicy<
            edgenetwork_v1::EdgeNetworkRetryPolicyOption::Type,
            edgenetwork_v1::EdgeNetworkBackoffPolicyOption::Type>(
            options.get<edgenetwork_v1::EdgeNetworkRetryPolicyOption>()
                ->clone(),
            ExponentialBackoffPolicy(std::chrono::seconds(1),
                                     std::chrono::minutes(5), kBackoffScaling)
                .clone())
            .clone());
  }
  if (!options.has<
          edgenetwork_v1::EdgeNetworkConnectionIdempotencyPolicyOption>()) {
    options.set<edgenetwork_v1::EdgeNetworkConnectionIdempotencyPolicyOption>(
        edgenetwork_v1::MakeDefaultEdgeNetworkConnectionIdempotencyPolicy());
  }

  return options;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace edgenetwork_v1_internal
}  // namespace cloud
}  // namespace google
