// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/dialogflow/cx/v3/version.proto

#include "google/cloud/dialogflow_cx/versions_client.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace dialogflow_cx {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

VersionsClient::VersionsClient(std::shared_ptr<VersionsConnection> connection,
                               Options opts)
    : connection_(std::move(connection)),
      options_(
          internal::MergeOptions(std::move(opts), connection_->options())) {}
VersionsClient::~VersionsClient() = default;

StreamRange<google::cloud::dialogflow::cx::v3::Version>
VersionsClient::ListVersions(std::string const& parent, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::dialogflow::cx::v3::ListVersionsRequest request;
  request.set_parent(parent);
  return connection_->ListVersions(request);
}

StreamRange<google::cloud::dialogflow::cx::v3::Version>
VersionsClient::ListVersions(
    google::cloud::dialogflow::cx::v3::ListVersionsRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListVersions(std::move(request));
}

StatusOr<google::cloud::dialogflow::cx::v3::Version> VersionsClient::GetVersion(
    std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::dialogflow::cx::v3::GetVersionRequest request;
  request.set_name(name);
  return connection_->GetVersion(request);
}

StatusOr<google::cloud::dialogflow::cx::v3::Version> VersionsClient::GetVersion(
    google::cloud::dialogflow::cx::v3::GetVersionRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetVersion(request);
}

future<StatusOr<google::cloud::dialogflow::cx::v3::Version>>
VersionsClient::CreateVersion(
    std::string const& parent,
    google::cloud::dialogflow::cx::v3::Version const& version, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::dialogflow::cx::v3::CreateVersionRequest request;
  request.set_parent(parent);
  *request.mutable_version() = version;
  return connection_->CreateVersion(request);
}

StatusOr<google::longrunning::Operation> VersionsClient::CreateVersion(
    NoAwaitTag, std::string const& parent,
    google::cloud::dialogflow::cx::v3::Version const& version, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::dialogflow::cx::v3::CreateVersionRequest request;
  request.set_parent(parent);
  *request.mutable_version() = version;
  return connection_->CreateVersion(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::dialogflow::cx::v3::Version>>
VersionsClient::CreateVersion(
    google::cloud::dialogflow::cx::v3::CreateVersionRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateVersion(request);
}

StatusOr<google::longrunning::Operation> VersionsClient::CreateVersion(
    NoAwaitTag,
    google::cloud::dialogflow::cx::v3::CreateVersionRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateVersion(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::dialogflow::cx::v3::Version>>
VersionsClient::CreateVersion(google::longrunning::Operation const& operation,
                              Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateVersion(operation);
}

StatusOr<google::cloud::dialogflow::cx::v3::Version>
VersionsClient::UpdateVersion(
    google::cloud::dialogflow::cx::v3::Version const& version,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::dialogflow::cx::v3::UpdateVersionRequest request;
  *request.mutable_version() = version;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdateVersion(request);
}

StatusOr<google::cloud::dialogflow::cx::v3::Version>
VersionsClient::UpdateVersion(
    google::cloud::dialogflow::cx::v3::UpdateVersionRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateVersion(request);
}

Status VersionsClient::DeleteVersion(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::dialogflow::cx::v3::DeleteVersionRequest request;
  request.set_name(name);
  return connection_->DeleteVersion(request);
}

Status VersionsClient::DeleteVersion(
    google::cloud::dialogflow::cx::v3::DeleteVersionRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteVersion(request);
}

future<StatusOr<google::protobuf::Struct>> VersionsClient::LoadVersion(
    std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::dialogflow::cx::v3::LoadVersionRequest request;
  request.set_name(name);
  return connection_->LoadVersion(request);
}

StatusOr<google::longrunning::Operation> VersionsClient::LoadVersion(
    NoAwaitTag, std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::dialogflow::cx::v3::LoadVersionRequest request;
  request.set_name(name);
  return connection_->LoadVersion(NoAwaitTag{}, request);
}

future<StatusOr<google::protobuf::Struct>> VersionsClient::LoadVersion(
    google::cloud::dialogflow::cx::v3::LoadVersionRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->LoadVersion(request);
}

StatusOr<google::longrunning::Operation> VersionsClient::LoadVersion(
    NoAwaitTag,
    google::cloud::dialogflow::cx::v3::LoadVersionRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->LoadVersion(NoAwaitTag{}, request);
}

future<StatusOr<google::protobuf::Struct>> VersionsClient::LoadVersion(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->LoadVersion(operation);
}

StatusOr<google::cloud::dialogflow::cx::v3::CompareVersionsResponse>
VersionsClient::CompareVersions(std::string const& base_version, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::dialogflow::cx::v3::CompareVersionsRequest request;
  request.set_base_version(base_version);
  return connection_->CompareVersions(request);
}

StatusOr<google::cloud::dialogflow::cx::v3::CompareVersionsResponse>
VersionsClient::CompareVersions(
    google::cloud::dialogflow::cx::v3::CompareVersionsRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CompareVersions(request);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace dialogflow_cx
}  // namespace cloud
}  // namespace google
