// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/bigquery/migration/v2/migration_service.proto

#include "google/cloud/bigquery/migration/v2/migration_connection.h"
#include "google/cloud/bigquery/migration/v2/internal/migration_connection_impl.h"
#include "google/cloud/bigquery/migration/v2/internal/migration_option_defaults.h"
#include "google/cloud/bigquery/migration/v2/internal/migration_stub_factory.h"
#include "google/cloud/bigquery/migration/v2/internal/migration_tracing_connection.h"
#include "google/cloud/bigquery/migration/v2/migration_options.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/credentials.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/pagination_range.h"
#include "google/cloud/internal/unified_grpc_credentials.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace bigquery_migration_v2 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

MigrationServiceConnection::~MigrationServiceConnection() = default;

StatusOr<google::cloud::bigquery::migration::v2::MigrationWorkflow>
MigrationServiceConnection::CreateMigrationWorkflow(
    google::cloud::bigquery::migration::v2::
        CreateMigrationWorkflowRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::bigquery::migration::v2::MigrationWorkflow>
MigrationServiceConnection::GetMigrationWorkflow(
    google::cloud::bigquery::migration::v2::
        GetMigrationWorkflowRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StreamRange<google::cloud::bigquery::migration::v2::MigrationWorkflow>
MigrationServiceConnection::ListMigrationWorkflows(
    google::cloud::bigquery::migration::v2::
        ListMigrationWorkflowsRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::bigquery::migration::v2::MigrationWorkflow>>();
}

Status MigrationServiceConnection::DeleteMigrationWorkflow(
    google::cloud::bigquery::migration::v2::
        DeleteMigrationWorkflowRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

Status MigrationServiceConnection::StartMigrationWorkflow(
    google::cloud::bigquery::migration::v2::
        StartMigrationWorkflowRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::bigquery::migration::v2::MigrationSubtask>
MigrationServiceConnection::GetMigrationSubtask(
    google::cloud::bigquery::migration::v2::GetMigrationSubtaskRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StreamRange<google::cloud::bigquery::migration::v2::MigrationSubtask>
MigrationServiceConnection::ListMigrationSubtasks(
    google::cloud::bigquery::migration::v2::
        ListMigrationSubtasksRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::bigquery::migration::v2::MigrationSubtask>>();
}

std::shared_ptr<MigrationServiceConnection> MakeMigrationServiceConnection(
    Options options) {
  internal::CheckExpectedOptions<CommonOptionList, GrpcOptionList,
                                 UnifiedCredentialsOptionList,
                                 MigrationServicePolicyOptionList>(options,
                                                                   __func__);
  options = bigquery_migration_v2_internal::MigrationServiceDefaultOptions(
      std::move(options));
  auto background = internal::MakeBackgroundThreadsFactory(options)();
  auto auth = internal::CreateAuthenticationStrategy(background->cq(), options);
  auto stub = bigquery_migration_v2_internal::CreateDefaultMigrationServiceStub(
      std::move(auth), options);
  return bigquery_migration_v2_internal::MakeMigrationServiceTracingConnection(
      std::make_shared<
          bigquery_migration_v2_internal::MigrationServiceConnectionImpl>(
          std::move(background), std::move(stub), std::move(options)));
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace bigquery_migration_v2
}  // namespace cloud
}  // namespace google
