// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/aiplatform/v1/notebook_service.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_AIPLATFORM_V1_NOTEBOOK_CONNECTION_IDEMPOTENCY_POLICY_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_AIPLATFORM_V1_NOTEBOOK_CONNECTION_IDEMPOTENCY_POLICY_H

#include "google/cloud/idempotency.h"
#include "google/cloud/version.h"
#include <google/cloud/aiplatform/v1/notebook_service.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace aiplatform_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

class NotebookServiceConnectionIdempotencyPolicy {
 public:
  virtual ~NotebookServiceConnectionIdempotencyPolicy();

  /// Create a new copy of this object.
  virtual std::unique_ptr<NotebookServiceConnectionIdempotencyPolicy> clone()
      const;

  virtual google::cloud::Idempotency CreateNotebookRuntimeTemplate(
      google::cloud::aiplatform::v1::CreateNotebookRuntimeTemplateRequest const&
          request);

  virtual google::cloud::Idempotency GetNotebookRuntimeTemplate(
      google::cloud::aiplatform::v1::GetNotebookRuntimeTemplateRequest const&
          request);

  virtual google::cloud::Idempotency ListNotebookRuntimeTemplates(
      google::cloud::aiplatform::v1::ListNotebookRuntimeTemplatesRequest
          request);

  virtual google::cloud::Idempotency DeleteNotebookRuntimeTemplate(
      google::cloud::aiplatform::v1::DeleteNotebookRuntimeTemplateRequest const&
          request);

  virtual google::cloud::Idempotency UpdateNotebookRuntimeTemplate(
      google::cloud::aiplatform::v1::UpdateNotebookRuntimeTemplateRequest const&
          request);

  virtual google::cloud::Idempotency AssignNotebookRuntime(
      google::cloud::aiplatform::v1::AssignNotebookRuntimeRequest const&
          request);

  virtual google::cloud::Idempotency GetNotebookRuntime(
      google::cloud::aiplatform::v1::GetNotebookRuntimeRequest const& request);

  virtual google::cloud::Idempotency ListNotebookRuntimes(
      google::cloud::aiplatform::v1::ListNotebookRuntimesRequest request);

  virtual google::cloud::Idempotency DeleteNotebookRuntime(
      google::cloud::aiplatform::v1::DeleteNotebookRuntimeRequest const&
          request);

  virtual google::cloud::Idempotency UpgradeNotebookRuntime(
      google::cloud::aiplatform::v1::UpgradeNotebookRuntimeRequest const&
          request);

  virtual google::cloud::Idempotency StartNotebookRuntime(
      google::cloud::aiplatform::v1::StartNotebookRuntimeRequest const&
          request);

  virtual google::cloud::Idempotency CreateNotebookExecutionJob(
      google::cloud::aiplatform::v1::CreateNotebookExecutionJobRequest const&
          request);

  virtual google::cloud::Idempotency GetNotebookExecutionJob(
      google::cloud::aiplatform::v1::GetNotebookExecutionJobRequest const&
          request);

  virtual google::cloud::Idempotency ListNotebookExecutionJobs(
      google::cloud::aiplatform::v1::ListNotebookExecutionJobsRequest request);

  virtual google::cloud::Idempotency DeleteNotebookExecutionJob(
      google::cloud::aiplatform::v1::DeleteNotebookExecutionJobRequest const&
          request);
};

std::unique_ptr<NotebookServiceConnectionIdempotencyPolicy>
MakeDefaultNotebookServiceConnectionIdempotencyPolicy();

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace aiplatform_v1
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_AIPLATFORM_V1_NOTEBOOK_CONNECTION_IDEMPOTENCY_POLICY_H
