/*****************************************************************************
 *                                                                           *
 *  LSCP documentation reference built into LSCP shell.                      *
 *                                                                           *
 *  Copyright (c) 2014 - 2016 Christian Schoenebeck                          *
 *                                                                           *
 *  This program is part of LinuxSampler and released under the same terms.  *
 *                                                                           *
 *  This source file is auto generated by 'generate_lscp_shell_reference.pl' *
 *  from 'lscp.xml'. Thus do not modify this C++ file directly!              *
 *                                                                           *
 *****************************************************************************/

/*
   This C++ file should automatically be re-generated if lscp.xml was
   modified, if not, you may call "make parser" explicitly.
 */

#include "lscp_shell_reference.h"
#include <string.h>

static lscp_ref_entry_t lscp_reference[] = {
    { "SET CHANNEL MIDI_INPUT_TYPE",
      "DEPRECATED: THIS COMMAND WILL DISAPPEAR!\n\nThe front-end can alter th"
      "e MIDI input type on a specific sampler channel by sending the followi"
      "ng command:\n\nSET CHANNEL MIDI_INPUT_TYPE <sampler-channel> <midi-inp"
      "ut-type>\n\nWhere <midi-input-type> is currently only \"ALSA\" and <sa"
      "mpler-channel> is the respective sampler channel number.\n\nIf more th"
      "an 1 MIDI inputs are currently connected to this sampler channel: Send"
      "ing this command will disconnect ALL currently connected MIDI input po"
      "rts connected to this sampler channel before establishing the new MIDI"
      " input connection. So this command does NOT add the connection, it rep"
      "laces all existing ones instead. This behavior is due to preserving fu"
      "ll behavior backward compatibility.\n\nPossible Answers:\n\n\"OK\" - o"
      "n success\n\n\"WRN:<warning-code>:<warning-message>\" - if MIDI input"
      "type was set, but there are noteworthy issue(s) related, providing an"
      "appropriate warning code and warning message\n\n\"ERR:<error-code>:<er"
      "ror-message>\" - in case it failed, providing an appropriate error cod"
      "e and error message\n\nExamples:\n\n\n\nDeprecated:\n\nShould not be u"
      "sed anymore. This command is currently only preserved for backward com"
      "patibility.\n\nThis command is a relict from times where only 1 MIDI i"
      "nput per sampler channels was allowed and where no sophisticated drive"
      "r management existed yet. Use \"ADD CHANNEL MIDI_INPUT\" and \"REMOVE"
      "CHANNEL MIDI_INPUT\" instead.\n\n"
    },
    { "INSERT SEND_EFFECT_CHAIN EFFECT",
      "The front-end can add an unused effect instance to a certain position"
      "of a send effect chain by sending the following command:\n\nINSERT SEN"
      "D_EFFECT_CHAIN EFFECT <audio-device> <effect-chain> <chain-pos> <effec"
      "t-instance>\n\nWhere <audio-device> should be replaced by the numerica"
      "l ID of the audio output device as given by the \"CREATE AUDIO_OUTPUT_"
      "DEVICE\" or \"LIST AUDIO_OUTPUT_DEVICES\" command, <effect-chain> by t"
      "he numerical ID as returned by the \"ADD SEND_EFFECT_CHAIN\" or \"LIST"
      " SEND_EFFECT_CHAINS\" command, <effect-instance> as returned by the \""
      "CREATE EFFECT_INSTANCE\" or \"LIST EFFECT_INSTANCES\" command and <cha"
      "in-pos> the exact position of the effect chain where the supplied effe"
      "ct shall be inserted to.\n\nOnly unused effect instances can be added"
      "to the effect chain. Trying to add an effect instance which is already"
      " in use somewhere in the audio signal path of the sampler will result"
      "in an error.\n\nPossible Answers:\n\n\"OK\" - in case the effect insta"
      "nce was added successfully to the chain\n\n\"ERR:<error-code>:<error-m"
      "essage>\" - if the effect instance could not be added\n\nExamples:\n\n"
      "C: \"INSERT SEND_EFFECT_CHAIN EFFECT 0 2 4 38\"\n\nS: \"OK\"\n\n"
    },
    { "FIND LOST DB_INSTRUMENT_FILES",
      "The front-end can retrieve the list of all instrument files in the ins"
      "truments database that don't exist in the filesystem by sending the fo"
      "llowing command:\n\nFIND LOST DB_INSTRUMENT_FILES\n\nPossible Answers:"
      "\n\nA comma separated list with the absolute path names (encapsulated"
      "into apostrophes) of all lost instrument files.\n\n\"ERR:<error-code>:"
      "<error-message>\" - in case it failed, providing an appropriate error"
      "code and error message.\n\nExample:\n\nC: \"FIND LOST DB_INSTRUMENT_FI"
      "LES\"\n\nS: \"'/gigs/Bosendorfer 290.gig','/gigs/Steinway D.gig','/gig"
      "s/Free Piano.gig'\"\n\n"
    },
    { "LIST CHANNEL MIDI_INPUTS",
      "The front-end can query a list of all currently connected MIDI inputs"
      "of a certain sampler channel by sending the following command:\n\nLIST"
      " CHANNEL MIDI_INPUTS <sampler-channel>\n\nWhere <sampler-channel> is t"
      "he sampler channel number as returned by the \"ADD CHANNEL\" or \"LIST"
      " CHANNELS\" command.\n\nPossible Answers:\n\nThe sampler will answer b"
      "y sending a comma separated list of MIDI input device ID - MIDI input"
      "port number pairs, where each pair is encapsulated into curly braces."
      "The list is returned in one single line. The MIDI input device ID corr"
      "esponds to the number returned by \"LIST MIDI_INPUT_DEVICES\" and the"
      "port number is the index of the respective MIDI port of that MIDI inpu"
      "t device.\n\nExample:\n\nC: \"LIST CHANNEL MIDI_INPUTS 0\"\n\nS: \"{0,"
      "0},{1,3},{2,0}\"\n\nSince:\n\nIntroduced with LSCP v1.6\n\n"
    },
    { "DESTROY EFFECT_INSTANCE",
      "The front-end can destroy an unusued effect instance and thus freeing"
      "it from memory by sending the following command:\n\nDESTROY EFFECT_INS"
      "TANCE <effect-instance>\n\nWhere <effect-instance> is the numerical ID"
      " of the effect instance as returned by the \"CREATE EFFECT_INSTANCE\""
      "or \"LIST EFFECT_INSTANCES\" command.\n\nThe effect instance can only"
      "be destroyed if it's not used in any part of the sampler's audio signa"
      "l path anymore. If the effect instance is still in use somewhere, tryi"
      "ng to destroy the effect instance will result in an error message.\n\n"
      "Possible Answers:\n\n\"OK\" - in case the effect instance was successf"
      "ully destroyed\n\n\"ERR:<error-code>:<error-message>\" - in case it fa"
      "iled, providing an appropriate error code and error message\n\nExample"
      "s:\n\nC: \"DESTROY EFFECT_INSTANCE 5\"\n\nS: \"OK\"\n\n"
    },
    { "SUBSCRIBE AUDIO_OUTPUT_DEVICE_COUNT",
      "Client may want to be notified when the total number of audio output d"
      "evices on the back-end changes by issuing the following command:\n\nSU"
      "BSCRIBE AUDIO_OUTPUT_DEVICE_COUNT\n\nServer will start sending the fol"
      "lowing notification messages:\n\n\"NOTIFY:AUDIO_OUTPUT_DEVICE_COUNT:<d"
      "evices>\"\n\nwhere <devices> will be replaced by the new number of aud"
      "io output devices.\n\n"
    },
    { "SET STREAMS",
      "The client can alter the current global sampler-wide limit for maximum"
      " disk streams by sending the following command:\n\nSET STREAMS <max-st"
      "reams>\n\nWhere <max-streams> should be replaced by the integer value,"
      " reflecting the new global amount limit of maximum disk streams. This"
      "value has to be positive.\n\nPossible Answers:\n\n\"OK\" - on success"
      "\n\n\"WRN:<warning-code>:<warning-message>\" - if the disk stream limit"
      " was set, but there are noteworthy issue(s) related, providing an appr"
      "opriate warning code and warning message\n\n\"ERR:<error-code>:<error-"
      "message>\" - in case it failed, providing an appropriate error code an"
      "d error message\n\nNote: the given value will be passed to all sampler"
      " engine instances. The total amount of maximum disk streams on the run"
      "ning system might thus be as big as the given value multiplied by the"
      "current amount of engine instances.\n\nCaution: when adjusting the dis"
      "k stream limit, you SHOULD also adjust the voice limit respectively an"
      "d vice versa.\n\n"
    },
    { "SUBSCRIBE EFFECT_INSTANCE_INFO",
      "Client may want to be notified when changes were made to effect instan"
      "ces on the back-end by issuing the following command:\n\nSUBSCRIBE EFF"
      "ECT_INSTANCE_INFO\n\nServer will start sending the following notificat"
      "ion messages:\n\n\"EFFECT_INSTANCE_INFO:<instance-id>\"\n\nwhere <inst"
      "ance-id> will be replaced by the numerical ID of the effect instance."
      "\n\n"
    },
    { "SUBSCRIBE MIDI_INSTRUMENT_COUNT",
      "Client may want to be notified when the number of MIDI instrument maps"
      " on the back-end changes by issuing the following command:\n\nSUBSCRIB"
      "E MIDI_INSTRUMENT_COUNT\n\nServer will start sending the following not"
      "ification messages:\n\n\"NOTIFY:MIDI_INSTRUMENT_COUNT:<map-id> <instru"
      "ments>\"\n\nwhere <map-id> is the numerical ID of the MIDI instrument"
      "map, in which the nuber of instruments has changed and <instruments> w"
      "ill be replaced by the new number of MIDI instruments in the specified"
      " map.\n\n"
    },
    { "SET CHANNEL MUTE",
      "The front-end can mute/unmute a specific sampler channel by sending th"
      "e following command:\n\nSET CHANNEL MUTE <sampler-channel> <mute>\n\nW"
      "here <sampler-channel> is the respective sampler channel number as ret"
      "urned by the \"ADD CHANNEL\" or \"LIST CHANNELS\" command and <mute> s"
      "hould be replaced either by \"1\" to mute the channel or \"0\" to unmu"
      "te the channel.\n\nPossible Answers:\n\n\"OK\" - on success\n\n\"WRN:<"
      "warning-code>:<warning-message>\" - if the channel was muted/unmuted,"
      "but there are noteworthy issue(s) related, providing an appropriate wa"
      "rning code and warning message\n\n\"ERR:<error-code>:<error-message>\""
      " - in case it failed, providing an appropriate error code and error me"
      "ssage\n\nExamples:\n\n\n\n"
    },
    { "LIST AUDIO_OUTPUT_DEVICES",
      "Use the following command to list all created audio output devices:\n"
      "\nLIST AUDIO_OUTPUT_DEVICES\n\nPossible Answers:\n\nLinuxSampler will a"
      "nswer by sending a comma separated list with the numerical IDs of all"
      "audio output devices.\n\nExample:\n\nC: \"LIST AUDIO_OUTPUT_DEVICES\""
      "\n\nS: \"0,1,4,5\"\n\n"
    },
    { "REMOVE DB_INSTRUMENT",
      "The front-end can remove a particular instrument from the instruments"
      "database by sending the following command:\n\nREMOVE DB_INSTRUMENT <in"
      "str_path>\n\nWhere <instr_path> is the absolute path name (in the inst"
      "ruments database) of the instrument to remove.\n\nPossible Answers:\n"
      "\n\"OK\" - if the instrument is removed successfully\n\n\"ERR:<error-co"
      "de>:<error-message>\" - if the given path does not exist or is a direc"
      "tory.\n\nExamples:\n\nC: \"REMOVE DB_INSTRUMENT '/Piano Collection/Bos"
      "endorfer 290'\"\n\nS: \"OK\"\n\n"
    },
    { "DESTROY AUDIO_OUTPUT_DEVICE",
      "Use the following command to destroy a created output device:\n\nDESTR"
      "OY AUDIO_OUTPUT_DEVICE <device-id>\n\nWhere <device-id> should be repl"
      "aced by the numerical ID of the audio output device as given by the \""
      "CREATE AUDIO_OUTPUT_DEVICE\" or \"LIST AUDIO_OUTPUT_DEVICES\" command."
      "\n\nPossible Answers:\n\n\"OK\" - in case the device was successfully"
      "destroyed\n\n\"WRN:<warning-code>:<warning-message>\" - in case the de"
      "vice was destroyed successfully, but there are noteworthy issue(s) rel"
      "ated (e.g. an audio over ethernet driver was unloaded but the other ho"
      "st might not be informed about this situation), providing an appropria"
      "te warning code and warning message\n\n\"ERR:<error-code>:<error-messa"
      "ge>\" - in case it failed, providing an appropriate error code and err"
      "or message\n\nExample:\n\nC: \"DESTROY AUDIO_OUTPUT_DEVICE 0\"\n\nS: "
      "\"OK\"\n\n"
    },
    { "SET VOLUME",
      "The client can alter the current global sampler-wide volume attenuatio"
      "n by sending the following command:\n\nSET VOLUME <volume>\n\nWhere <v"
      "olume> should be replaced by the optional dotted floating point value,"
      " reflecting the new global volume parameter. This value might usually"
      "be in the range between 0.0 and 1.0, that is for attenuating the overa"
      "ll volume.\n\nPossible Answers:\n\n\"OK\" - on success\n\n\"WRN:<warni"
      "ng-code>:<warning-message>\" - if the global volume was set, but there"
      " are noteworthy issue(s) related, providing an appropriate warning cod"
      "e and warning message\n\n\"ERR:<error-code>:<error-message>\" - in cas"
      "e it failed, providing an appropriate error code and error message\n\n"
    },
    { "UNMAP MIDI_INSTRUMENT",
      "The front-end can delete an entry from a MIDI instrument map by sendin"
      "g the following command:\n\nUNMAP MIDI_INSTRUMENT <map> <midi_bank> <m"
      "idi_prog>\n\nWhere <map> is the numeric ID of the MIDI instrument map,"
      " <midi_bank> is an integer value between 0..16383 reflecting the MIDI"
      "bank value and <midi_prog> an integer value between 0..127 reflecting"
      "the MIDI program value of the map's entrie's key index triple.\n\nPoss"
      "ible Answers:\n\n\"OK\" - usually\n\n\"ERR:<error-code>:<error-message"
      ">\" - when index out of bounds\n\nExample:\n\nC: \"UNMAP MIDI_INSTRUME"
      "NT 0 2 127\"\n\nS: \"OK\"\n\n"
    },
    { "GET MIDI_INSTRUMENT_MAPS",
      "The front-end can retrieve the current amount of MIDI instrument maps"
      "by sending the following command:\n\nGET MIDI_INSTRUMENT_MAPS\n\nPossi"
      "ble Answers:\n\nThe sampler will answer by returning the current numbe"
      "r of MIDI instrument maps.\n\nExample:\n\nC: \"GET MIDI_INSTRUMENT_MAP"
      "S\"\n\nS: \"2\"\n\n"
    },
    { "GET AUDIO_OUTPUT_CHANNEL_PARAMETER INFO",
      "Use the following command to get detailed information about specific a"
      "udio channel parameter:\n\nGET AUDIO_OUTPUT_CHANNEL_PARAMETER INFO <de"
      "v-id> <chan> <param>\n\nWhere <dev-id> is the numerical ID of the audi"
      "o output device as returned by the \"CREATE AUDIO_OUTPUT_DEVICE\" or "
      "\"LIST AUDIO_OUTPUT_DEVICES\" command, <chan> the audio channel number"
      "and <param> a specific channel parameter name for which information sh"
      "ould be obtained (as returned by the \"GET AUDIO_OUTPUT_CHANNEL INFO\""
      " command).\n\nPossible Answers:\n\nLinuxSampler will answer by sending"
      " a <CRLF> separated list. Each answer line begins with the information"
      " category name followed by a colon and then a space character <SP> and"
      " finally the info character string to that info category. There are in"
      "formation which is always returned, independently of the given channel"
      " parameter and there is optional information which is only shown depen"
      "dently to the given audio channel. At the moment the following informa"
      "tion categories are defined:\n\nTYPE - either \"BOOL\" for boolean val"
      "ue(s) or \"INT\" for integer value(s) or \"FLOAT\" for dotted number(s"
      ") or \"STRING\" for character string(s) (always returned)\n\nDESCRIPTI"
      "ON - arbitrary text describing the purpose of the parameter (always re"
      "turned)\n\nFIX - either true or false, if true then this parameter is"
      "read only, thus cannot be altered (always returned)\n\nMULTIPLICITY -"
      "either true or false, defines if this parameter allows only one value"
      "or a list of values, where true means multiple values and false only a"
      " single value allowed (always returned)\n\nRANGE_MIN - defines lower l"
      "imit of the allowed value range for this parameter, can be an integer"
      "value as well as a dotted number, usually used in conjunction with 'RA"
      "NGE_MAX', but may also appear without (optionally returned, dependent"
      "to driver and channel parameter)\n\nRANGE_MAX - defines upper limit of"
      " the allowed value range for this parameter, can be an integer value a"
      "s well as a dotted number, usually used in conjunction with 'RANGE_MIN"
      "', but may also appear without (optionally returned, dependent to driv"
      "er and channel parameter)\n\nPOSSIBILITIES - comma separated list of p"
      "ossible values for this parameter, character strings are encapsulated"
      "into apostrophes (optionally returned, dependent to driver and channel"
      " parameter)\n\nThe mentioned fields above don't have to be in particul"
      "ar order.\n\nExample:\n\nC: \"GET AUDIO_OUTPUT_CHANNEL_PARAMETER INFO"
      "1 0 JACK_BINDINGS\"\n\nS: \"DESCRIPTION: bindings to other JACK client"
      "s\"\n\n\"TYPE: STRING\"\n\n\"FIX: false\"\n\n\"MULTIPLICITY: true\"\n"
      "\n\"POSSIBILITIES: 'PCM:0','PCM:1','ardour:0','ardour:1'\"\n\n\".\"\n\n"
    },
    { "SET DB_INSTRUMENT DESCRIPTION",
      "The front-end can alter the description of a specific instrument by se"
      "nding the following command:\n\nSET DB_INSTRUMENT DESCRIPTION <instr>"
      "<desc>\n\nWhere <instr> is the absolute path name of the instrument an"
      "d <desc> is the new description for the instrument (encapsulated into"
      "apostrophes, supporting escape sequences as described in chapter \" Ch"
      "aracter Set and Escape Sequences \").\n\nPossible Answers:\n\n\"OK\" -"
      " on success\n\n\"ERR:<error-code>:<error-message>\" - in case the give"
      "n instrument does not exists.\n\nExample:\n\nC: \"SET DB_INSTRUMENT DE"
      "SCRIPTION '/Piano Collection/Acoustic/Bosendorfer 290' 'No comment :)'"
      "\"\n\nS: \"OK\"\n\n"
    },
    { "SET CHANNEL AUDIO_OUTPUT_DEVICE",
      "The front-end can set the audio output device on a specific sampler ch"
      "annel by sending the following command:\n\nSET CHANNEL AUDIO_OUTPUT_DE"
      "VICE <sampler-channel> <audio-device-id>\n\nWhere <sampler-channel> is"
      " the respective sampler channel number as returned by the \"ADD CHANNE"
      "L\" or \"LIST CHANNELS\" command and <audio-device-id> is the numerica"
      "l ID of the audio output device as given by the \"CREATE AUDIO_OUTPUT_"
      "DEVICE\" or \"LIST AUDIO_OUTPUT_DEVICES\" command.\n\nPossible Answers"
      ":\n\n\"OK\" - on success\n\n\"WRN:<warning-code>:<warning-message>\" -"
      " if audio output device was set, but there are noteworthy issue(s) rel"
      "ated, providing an appropriate warning code and warning message\n\n\"E"
      "RR:<error-code>:<error-message>\" - in case it failed, providing an ap"
      "propriate error code and error message\n\nExamples:\n\n\n\n"
    },
    { "SET DB_INSTRUMENT_DIRECTORY NAME",
      "The front-end can alter the name of a specific instrument directory by"
      " sending the following command:\n\nSET DB_INSTRUMENT_DIRECTORY NAME <d"
      "ir> <name>\n\nWhere <dir> is the absolute path name of the directory a"
      "nd <name> is the new name for that directory.\n\nPossible Answers:\n\n"
      "\"OK\" - on success\n\n\"ERR:<error-code>:<error-message>\" - in case"
      "the given directory does not exists, or if a directory with name equal"
      " to the new name already exists.\n\nExample:\n\nC: \"SET DB_INSTRUMENT"
      "_DIRECTORY NAME '/Piano Collection/Acustic' 'Acoustic'\"\n\nS: \"OK\""
      "\n\n"
    },
    { "GET MIDI_INSTRUMENTS",
      "The front-end can query the amount of currently existing entries in a"
      "MIDI instrument map by sending the following command:\n\nGET MIDI_INST"
      "RUMENTS <map>\n\nThe front-end can query the amount of currently exist"
      "ing entries in all MIDI instrument maps by sending the following comma"
      "nd:\n\nGET MIDI_INSTRUMENTS ALL\n\nPossible Answers:\n\nThe sampler wi"
      "ll answer by sending the current number of entries in the MIDI instrum"
      "ent map(s).\n\nExample:\n\nC: \"GET MIDI_INSTRUMENTS 0\"\n\nS: \"234\""
      "\n\nC: \"GET MIDI_INSTRUMENTS ALL\"\n\nS: \"954\"\n\n"
    },
    { "UNSUBSCRIBE",
      "The front-end can unregister itself if it doesn't want to receive even"
      "t messages anymore by sending the following command:\n\nUNSUBSCRIBE <e"
      "vent-id>\n\nWhere <event-id> will be replaced by the respective event"
      "that client doesn't want to receive anymore.\n\nPossible Answers:\n\n"
      "\"OK\" - on success\n\n\"WRN:<warning-code>:<warning-message>\" - if un"
      "registration succeeded, but there are noteworthy issue(s) related, pro"
      "viding an appropriate warning code and warning message\n\n\"ERR:<error"
      "-code>:<error-message>\" - in case it failed, providing an appropriate"
      " error code and error message\n\nExamples:\n\n\n\n"
    },
    { "SET MIDI_INSTRUMENT_MAP NAME",
      "The front-end can alter the custom name of a MIDI instrument map by se"
      "nding the following command:\n\nSET MIDI_INSTRUMENT_MAP NAME <map> <na"
      "me>\n\nWhere <map> is the numerical ID of the map and <name> the new c"
      "ustom name of the map, which does not have to be unique (name MUST be"
      "encapsulated into apostrophes and supports escape sequences as describ"
      "ed in chapter \" Character Set and Escape Sequences \").\n\nPossible A"
      "nswers:\n\n\"OK\" - on success\n\n\"ERR:<error-code>:<error-message>\""
      " - in case the given map does not exist\n\nExample:\n\nC: \"SET MIDI_I"
      "NSTRUMENT_MAP NAME 0 'Foo instruments'\"\n\nS: \"OK\"\n\n"
    },
    { "GET DB_INSTRUMENT_DIRECTORIES",
      "The front-end can retrieve the current amount of directories in a spec"
      "ific directory by sending the following command:\n\nGET DB_INSTRUMENT_"
      "DIRECTORIES [RECURSIVE] <dir>\n\nWhere <dir> should be replaced by the"
      " absolute path name of the directory. If RECURSIVE is specified, the n"
      "umber of all directories, including those located in subdirectories of"
      " the specified directory, will be returned.\n\nPossible Answers:\n\nTh"
      "e current number of instrument directories in the specified directory."
      "\n\n\"ERR:<error-code>:<error-message>\" - if the given directory does"
      " not exist.\n\nExample:\n\nC: \"GET DB_INSTRUMENT_DIRECTORIES '/'\"\n"
      "\nS: \"2\"\n\n"
    },
    { "GET AVAILABLE_ENGINES",
      "The front-end can ask for the number of available engines by sending t"
      "he following command:\n\nGET AVAILABLE_ENGINES\n\nPossible Answers:\n"
      "\nLinuxSampler will answer by sending the number of available engines."
      "\n\nExample:\n\nC: \"GET AVAILABLE_ENGINES\"\n\nS: \"4\"\n\n"
    },
    { "ADD SEND_EFFECT_CHAIN",
      "The front-end can add a send effect chain by sending the following com"
      "mand:\n\nADD SEND_EFFECT_CHAIN <audio-device>\n\nWhere <audio-device>"
      "should be replaced by the numerical ID of the audio output device as g"
      "iven by the \"CREATE AUDIO_OUTPUT_DEVICE\" or \"LIST AUDIO_OUTPUT_DEVI"
      "CES\" command.\n\nPossible Answers:\n\n\"OK[<effect-chain>]\" - in cas"
      "e the send effect chain was added successfully, where <effect-chain> i"
      "s the numerical ID of the new send effect chain\n\n\"ERR:<error-code>:"
      "<error-message>\" - if the send effect chain could not be added\n\nExa"
      "mples:\n\nC: \"ADD SEND_EFFECT_CHAIN 0\"\n\nS: \"OK[2]\"\n\n"
    },
    { "GET VOICES",
      "The client can ask for the current global sampler-wide limit for maxim"
      "um voices by sending the following command:\n\nGET VOICES\n\nPossible"
      "Answers:\n\nLinuxSampler will answer by returning the number for the c"
      "urrent limit of maximum voices.\n\nThe voice limit setting defines how"
      " many voices should maximum be processed by the sampler at the same ti"
      "me. If the user triggers new notes which would exceed that voice limit"
      ", the sampler engine will react by stealing old voices for those newly"
      " triggered notes. Note that the amount of voices triggered by a new no"
      "te can be larger than one and is dependent to the respective instrumen"
      "t and probably further criterias.\n\n"
    },
    { "GET SEND_EFFECT_CHAIN INFO",
      "The front-end can ask for information of a send effect chain by sendin"
      "g the following command:\n\nGET SEND_EFFECT_CHAIN INFO <audio-device>"
      "<effect-chain>\n\nWhere <audio-device> should be replaced by the numer"
      "ical ID of the audio output device as given by the \"CREATE AUDIO_OUTP"
      "UT_DEVICE\" or \"LIST AUDIO_OUTPUT_DEVICES\" command and <effect-chain"
      "> by the numerical ID as returned by the \"ADD SEND_EFFECT_CHAIN\" or"
      "\"LIST SEND_EFFECT_CHAINS\" command.\n\nPossible Answers:\n\nLinuxSamp"
      "ler will answer by sending a <CRLF> separated list. Each answer line b"
      "egins with the information category name, followed by a colon and then"
      " a space character <SP> and finally the info character string to that"
      "information category. At the moment the following categories are defin"
      "ed:\n\nEFFECT_COUNT - amount of effects in this send effect chain\n\nE"
      "FFECT_SEQUENCE - comma separated list of the numerical IDs of the effe"
      "ct instances in this send effect chain, in the order as they are procs"
      "sed in the effect chain\n\nThe mentioned fields above don't have to be"
      " in particular order.\n\nExample:\n\nC: \"GET SEND_EFFECT_CHAIN INFO 0"
      " 2\"\n\nS: \"EFFECT_COUNT: 3\"\n\n\"EFFECT_SEQUENCE: 31,4,7\"\n\n\".\""
      "\n\n"
    },
    { "REMOVE SEND_EFFECT_CHAIN",
      "The front-end can remove a send effect chain by sending the following"
      "command:\n\nREMOVE SEND_EFFECT_CHAIN <audio-device> <effect-chain>\n\n"
      "Where <audio-device> should be replaced by the numerical ID of the aud"
      "io output device as given by the \"CREATE AUDIO_OUTPUT_DEVICE\" or \"L"
      "IST AUDIO_OUTPUT_DEVICES\" command and <effect-chain> by the numerical"
      " ID as returned by the \"ADD SEND_EFFECT_CHAIN\" or \"LIST SEND_EFFECT"
      "_CHAINS\" command.\n\nPossible Answers:\n\n\"OK\" - in case the send e"
      "ffect chain was removed successfully\n\n\"ERR:<error-code>:<error-mess"
      "age>\" - if the send effect chain could not be removed\n\nExamples:\n"
      "\nC: \"REMOVE SEND_EFFECT_CHAIN 0 2\"\n\nS: \"OK\"\n\n"
    },
    { "SUBSCRIBE TOTAL_STREAM_COUNT",
      "Client may want to be notified when the total number of disk streams o"
      "n the back-end changes by issuing the following command:\n\nSUBSCRIBE"
      "TOTAL_STREAM_COUNT\n\nServer will start sending the following notifica"
      "tion messages:\n\n\"NOTIFY:TOTAL_STREAM_COUNT:<streams>\"\n\nwhere <st"
      "reams> will be replaced by the new number of all currently active disk"
      " streams.\n\n"
    },
    { "SUBSCRIBE DB_INSTRUMENT_COUNT",
      "Client may want to be notified when the number of instruments in a par"
      "ticular directory in the instruments database is changed by issuing th"
      "e following command:\n\nSUBSCRIBE DB_INSTRUMENT_COUNT\n\nServer will s"
      "tart sending the following notification messages:\n\n\"NOTIFY:DB_INSTR"
      "UMENT_COUNT:<dir-path>\"\n\nwhere <dir-path> will be replaced by the a"
      "bsolute path name of the directory in the instruments database, in whi"
      "ch the number of instruments is changed.\n\nNote that when a non-empty"
      " directory is removed, this event is not sent for the instruments in t"
      "hat directory.\n\n"
    },
    { "SUBSCRIBE",
      "The front-end can register itself to the LinuxSampler application to b"
      "e informed about noteworthy events by sending this command:\n\nSUBSCRI"
      "BE <event-id>\n\nwhere <event-id> will be replaced by the respective e"
      "vent that client wants to subscribe to.\n\nPossible Answers:\n\n\"OK\""
      " - on success\n\n\"WRN:<warning-code>:<warning-message>\" - if registr"
      "ation succeeded, but there are noteworthy issue(s) related, providing"
      "an appropriate warning code and warning message\n\n\"ERR:<error-code>:"
      "<error-message>\" - in case it failed, providing an appropriate error"
      "code and error message\n\nExamples:\n\n\n\n"
    },
    { "SET FX_SEND LEVEL",
      "The front-end can alter the current send level of an effect send entit"
      "y by sending the following command:\n\nSET FX_SEND LEVEL <sampler-chan"
      "> <fx-send-id> <volume>\n\nWhere <sampler-chan> is the sampler channel"
      " number as returned by the \"ADD CHANNEL\" or \"LIST CHANNELS\" comman"
      "d, <fx-send-id> reflects the numerical ID of the effect send entity as"
      " returned by the \"CREATE FX_SEND\" or \"LIST FX_SENDS\" command and <"
      "volume> is an optionally dotted positive number (a value smaller than"
      "1.0 means attenuation, whereas a value greater than 1.0 means amplific"
      "ation) reflecting the new send level.\n\nPossible Answers:\n\n\"OK\" -"
      " on success\n\n\"WRN:<warning-code>:<warning-message>\" - if new send"
      "level was set, but there are noteworthy issue(s) related, providing an"
      " appropriate warning code and warning message\n\n\"ERR:<error-code>:<e"
      "rror-message>\" - in case it failed, providing an appropriate error co"
      "de and error message\n\nExample:\n\nC: \"SET FX_SEND LEVEL 0 0 0.15\""
      "\n\nS: \"OK\"\n\n"
    },
    { "GET DB_INSTRUMENTS",
      "The front-end can retrieve the current amount of instruments in a spec"
      "ific directory by sending the following command:\n\nGET DB_INSTRUMENTS"
      " [RECURSIVE] <dir>\n\nWhere <dir> should be replaced by the absolute p"
      "ath name of the directory. If RECURSIVE is specified, the number of al"
      "l instruments, including those located in subdirectories of the specif"
      "ied directory, will be returned.\n\nPossible Answers:\n\nThe current n"
      "umber of instruments in the specified directory.\n\n\"ERR:<error-code>"
      ":<error-message>\" - if the given directory does not exist.\n\nExample"
      ":\n\nC: \"GET DB_INSTRUMENTS '/Piano Collection'\"\n\nS: \"2\"\n\n"
    },
    { "MAP MIDI_INSTRUMENT",
      "The front-end can create a new or replace an existing entry in a sampl"
      "er's MIDI instrument map by sending the following command:\n\nMAP MIDI"
      "_INSTRUMENT [NON_MODAL] <map> <midi_bank> <midi_prog> <engine_name> <f"
      "ilename> <instrument_index> <volume_value> [<instr_load_mode>] [<name>"
      "]\n\nWhere <map> is the numeric ID of the map to alter, <midi_bank> is"
      " an integer value between 0..16383 reflecting the MIDI bank select ind"
      "ex, <midi_prog> an integer value between 0..127 reflecting the MIDI pr"
      "ogram change index, <engine_name> a sampler engine name as returned by"
      " the \"LIST AVAILABLE_ENGINES\" command (not encapsulated into apostro"
      "phes), <filename> the name of the instrument's file to be deployed (en"
      "capsulated into apostrophes, supporting escape sequences as described"
      "in chapter \" Character Set and Escape Sequences \"), <instrument_inde"
      "x> the index (integer value) of the instrument within the given file,"
      "<volume_value> reflects the master volume of the instrument as optiona"
      "lly dotted number (where a value < 1.0 means attenuation and a value >"
      " 1.0 means amplification). This parameter easily allows to adjust the"
      "volume of all intruments within a custom instrument map without having"
      " to adjust their instrument files. The OPTIONAL <instr_load_mode> argu"
      "ment defines the life time of the instrument, that is when the instrum"
      "ent should be loaded, when freed and has exactly the following possibi"
      "lities:\n\n\"ON_DEMAND\" - The instrument will be loaded when needed,"
      "that is when demanded by at least one sampler channel. It will immedia"
      "tely be freed from memory when not needed by any sampler channel anymo"
      "re.\n\n\"ON_DEMAND_HOLD\" - The instrument will be loaded when needed,"
      " that is when demanded by at least one sampler channel. It will be kep"
      "t in memory even when not needed by any sampler channel anymore. Instr"
      "uments with this mode are only freed when the sampler is reset or all"
      "mapping entries with this mode (and respective instrument) are explici"
      "tly changed to \"ON_DEMAND\" and no sampler channel is using the instr"
      "ument anymore.\n\n\"PERSISTENT\" - The instrument will immediately be"
      "loaded into memory when this mapping command is sent and the instrumen"
      "t is kept all the time. Instruments with this mode are only freed when"
      " the sampler is reset or all mapping entries with this mode (and respe"
      "ctive instrument) are explicitly changed to \"ON_DEMAND\" and no sampl"
      "er channel is using the instrument anymore.\n\nnot supplied - In case"
      "there is no <instr_load_mode> argument given, it will be up to the Ins"
      "trumentManager to decide which mode to use. Usually it will use \"ON_D"
      "EMAND\" if an entry for the given instrument does not exist in the Ins"
      "trumentManager's list yet, otherwise if an entry already exists, it wi"
      "ll simply stick with the mode currently reflected by the already exist"
      "ing entry, that is it will not change the mode.\n\nThe <instr_load_mod"
      "e> argument thus allows to define an appropriate strategy (low memory"
      "consumption vs. fast instrument switching) for each instrument individ"
      "ually. Note, the following restrictions apply to this argument: \"ON_D"
      "EMAND_HOLD\" and \"PERSISTENT\" have to be supported by the respective"
      " sampler engine (which is technically the case when the engine provide"
      "s an InstrumentManager for its format). If this is not the case the ar"
      "gument will automatically fall back to the default value \"ON_DEMAND\""
      ". Also the load mode of one instrument may automatically change the la"
      "od mode of other instrument(s), i.e. because the instruments are part"
      "of the same file and the engine does not allow a way to manage load mo"
      "des for them individually. Due to this, in case the frontend shows the"
      " load modes of entries, the frontend should retrieve the actual mode b"
      "y i.e. sending \"GET MIDI_INSTRUMENT INFO\" command(s). Finally the OP"
      "TIONAL <name> argument allows to set a custom name (encapsulated into"
      "apostrophes, supporting escape sequences as described in chapter \" Ch"
      "aracter Set and Escape Sequences \") for the mapping entry, useful for"
      " frontends for displaying an appropriate name for mapped instruments ("
      "using \"GET MIDI_INSTRUMENT INFO\" ).\n\nBy default, \"MAP MIDI_INSTRU"
      "MENT\" commands block until the mapping is completely established in t"
      "he sampler. The OPTIONAL \"NON_MODAL\" argument however causes the res"
      "pective \"MAP MIDI_INSTRUMENT\" command to return immediately, that is"
      " to let the sampler establish the mapping in the background. So this a"
      "rgument might be especially useful for mappings with a \"PERSISTENT\""
      "type, because these have to load the respective instruments immediatel"
      "y and might thus block for a very long time. It is recommended however"
      " to use the OPTIONAL \"NON_MODAL\" argument only if really necessary,"
      "because it has the following drawbacks: as \"NON_MODAL\" instructions"
      "return immediately, they may not necessarily return an error i.e. when"
      " the given instrument file turns out to be corrupt, beside that subseq"
      "uent commands in a LSCP instruction sequence might fail, because manda"
      "tory mappings are not yet completed.\n\nPossible Answers:\n\n\"OK\" -"
      "usually\n\n\"ERR:<error-code>:<error-message>\" - when the given map o"
      "r engine does not exist or a value is out of range\n\nExamples:\n\nC:"
      "\"MAP MIDI_INSTRUMENT 0 3 0 gig '/usr/share/Steinway D.gig' 0 0.8 PERS"
      "ISTENT\"\n\nS: \"OK\"\n\nC: \"MAP MIDI_INSTRUMENT 0 4 50 gig '/home/jo"
      "hn/foostrings.gig' 7 1.0\"\n\nS: \"OK\"\n\nC: \"MAP MIDI_INSTRUMENT 0"
      "0 0 gig '/usr/share/piano.gig' 0 1.0 'Normal Piano'\"\n\nS: \"OK\"\n\n"
      "C: \"MAP MIDI_INSTRUMENT 0 1 0 gig '/usr/share/piano.gig' 0 0.25 'Sile"
      "nt Piano'\"\n\nS: \"OK\"\n\nC: \"MAP MIDI_INSTRUMENT NON_MODAL 1 8 120"
      " gig '/home/joe/foodrums.gig' 0 1.0 PERSISTENT 'Foo Drumkit'\"\n\nS: "
      "\"OK\"\n\n"
    },
    { "LIST DB_INSTRUMENTS",
      "The front-end can retrieve the current list of instruments in specific"
      " directory by sending the following command:\n\nLIST DB_INSTRUMENTS [R"
      "ECURSIVE] <dir>\n\nWhere <dir> should be replaced by the absolute path"
      " name of the directory. If RECURSIVE is specified, the absolute path n"
      "ames of all instruments, including those located in subdirectories of"
      "the specified directory, will be returned.\n\nPossible Answers:\n\nA c"
      "omma separated list of all instruments (encapsulated into apostrophes)"
      " in the specified directory.\n\n\"ERR:<error-code>:<error-message>\" -"
      " if the given directory does not exist.\n\nExample:\n\nC: \"LIST DB_IN"
      "STRUMENTS '/Piano Collection'\"\n\nS: \"'Bosendorfer 290','Steinway D'"
      "\"\n\nC: \"LIST DB_INSTRUMENTS RECURSIVE '/Piano Collection'\"\n\nS: "
      "\"'/Piano Collection/Bosendorfer 290','/Piano Collection/Steinway D','/"
      "Piano Collection/Lite/Free Piano'\"\n\n"
    },
    { "GET AUDIO_OUTPUT_DRIVER_PARAMETER INFO",
      "Use the following command to get detailed information about a specific"
      " audio output driver parameter:\n\nGET AUDIO_OUTPUT_DRIVER_PARAMETER I"
      "NFO <audio> <prm> [<deplist>]\n\nWhere <audio> is the name of the audi"
      "o output driver as returned by the \"LIST AVAILABLE_AUDIO_OUTPUT_DRIVE"
      "RS\" command, <prm> a specific parameter name for which information sh"
      "ould be obtained (as returned by the \"GET AUDIO_OUTPUT_DRIVER INFO\""
      "command) and <deplist> is an optional list of parameters on which the"
      "sought parameter <prm> depends on, <deplist> is a list of key-value pa"
      "irs in form of \"key1=val1 key2=val2 ...\", where character string val"
      "ues are encapsulated into apostrophes ('). Arguments given with <depli"
      "st> which are not dependency parameters of <prm> will be ignored, mean"
      "s the front-end application can simply put all parameters into <deplis"
      "t> with the values already selected by the user.\n\nPossible Answers:"
      "\n\nLinuxSampler will answer by sending a <CRLF> separated list. Each a"
      "nswer line begins with the information category name followed by a col"
      "on and then a space character <SP> and finally the info character stri"
      "ng to that info category. There are information which is always return"
      "ed, independently of the given driver parameter and there are optional"
      " information which is only shown dependently to given driver parameter"
      ". At the moment the following information categories are defined:\n\nT"
      "YPE - either \"BOOL\" for boolean value(s) or \"INT\" for integer valu"
      "e(s) or \"FLOAT\" for dotted number(s) or \"STRING\" for character str"
      "ing(s) (always returned, no matter which driver parameter)\n\nDESCRIPT"
      "ION - arbitrary text describing the purpose of the parameter (always r"
      "eturned, no matter which driver parameter)\n\nMANDATORY - either true"
      "or false, defines if this parameter must be given when the device is t"
      "o be created with the 'CREATE AUDIO_OUTPUT_DEVICE' command (always ret"
      "urned, no matter which driver parameter)\n\nFIX - either true or false"
      ", if false then this parameter can be changed at any time, once the de"
      "vice is created by the 'CREATE AUDIO_OUTPUT_DEVICE' command (always re"
      "turned, no matter which driver parameter)\n\nMULTIPLICITY - either tru"
      "e or false, defines if this parameter allows only one value or a list"
      "of values, where true means multiple values and false only a single va"
      "lue allowed (always returned, no matter which driver parameter)\n\nDEP"
      "ENDS - comma separated list of parameters this parameter depends on, m"
      "eans the values for fields 'DEFAULT', 'RANGE_MIN', 'RANGE_MAX' and 'PO"
      "SSIBILITIES' might depend on these listed parameters, for example assu"
      "ming that an audio driver (like the ALSA driver) offers parameters 'ca"
      "rd' and 'samplerate' then parameter 'samplerate' would depend on 'card"
      "' because the possible values for 'samplerate' depends on the sound ca"
      "rd which can be chosen by the 'card' parameter (optionally returned, d"
      "ependent to driver parameter)\n\nDEFAULT - reflects the default value"
      "for this parameter which is used when the device is created and not ex"
      "plicitly given with the 'CREATE AUDIO_OUTPUT_DEVICE' command, in case"
      "of MULTIPLCITY=true, this is a comma separated list, that's why charac"
      "ter strings are encapsulated into apostrophes (') (optionally returned"
      ", dependent to driver parameter)\n\nRANGE_MIN - defines lower limit of"
      " the allowed value range for this parameter, can be an integer value a"
      "s well as a dotted number, this parameter is often used in conjunction"
      " with RANGE_MAX, but may also appear without (optionally returned, dep"
      "endent to driver parameter)\n\nRANGE_MAX - defines upper limit of the"
      "allowed value range for this parameter, can be an integer value as wel"
      "l as a dotted number, this parameter is often used in conjunction with"
      " RANGE_MIN, but may also appear without (optionally returned, dependen"
      "t to driver parameter)\n\nPOSSIBILITIES - comma separated list of poss"
      "ible values for this parameter, character strings are encapsulated int"
      "o apostrophes (optionally returned, dependent to driver parameter)\n\n"
      "The mentioned fields above don't have to be in particular order.\n\nEx"
      "amples:\n\nC: \"GET AUDIO_OUTPUT_DRIVER_PARAMETER INFO ALSA CARD\"\n\n"
      "S: \"DESCRIPTION: sound card to be used\"\n\n\"TYPE: STRING\"\n\n\"MAN"
      "DATORY: false\"\n\n\"FIX: true\"\n\n\"MULTIPLICITY: false\"\n\n\"DEFAU"
      "LT: '0,0'\"\n\n\"POSSIBILITIES: '0,0','1,0','2,0'\"\n\n\".\"\n\nC: \"G"
      "ET AUDIO_OUTPUT_DRIVER_PARAMETER INFO ALSA SAMPLERATE\"\n\nS: \"DESCRI"
      "PTION: output sample rate in Hz\"\n\n\"TYPE: INT\"\n\n\"MANDATORY: fal"
      "se\"\n\n\"FIX: false\"\n\n\"MULTIPLICITY: false\"\n\n\"DEPENDS: card\""
      "\n\n\"DEFAULT: 44100\"\n\n\".\"\n\nC: \"GET AUDIO_OUTPUT_DRIVER_PARAME"
      "TER INFO ALSA SAMPLERATE CARD='0,0'\"\n\nS: \"DESCRIPTION: output samp"
      "le rate in Hz\"\n\n\"TYPE: INT\"\n\n\"MANDATORY: false\"\n\n\"FIX: fal"
      "se\"\n\n\"MULTIPLICITY: false\"\n\n\"DEPENDS: card\"\n\n\"DEFAULT: 441"
      "00\"\n\n\"RANGE_MIN: 22050\"\n\n\"RANGE_MAX: 96000\"\n\n\".\"\n\n"
    },
    { "FORMAT INSTRUMENTS_DB",
      "The front-end can remove all instruments and directories and re-create"
      " the instruments database structure (e.g., in case of a database corru"
      "ption) by sending the following command:\n\nFORMAT INSTRUMENTS_DB\n\nP"
      "ossible Answers:\n\n\"OK\" - on success\n\n\"ERR:<error-code>:<error-m"
      "essage>\" - If the formatting of the instruments database failed.\n\n"
    },
    { "ADD MIDI_INSTRUMENT_MAP",
      "The front-end can add a new MIDI instrument map by sending the followi"
      "ng command:\n\nADD MIDI_INSTRUMENT_MAP [<name>]\n\nWhere <name> is an"
      "optional argument allowing to assign a custom name to the new map. MID"
      "I instrument Map names do not have to be unique, but MUST be encapsula"
      "ted into apostrophes and support escape sequences as described in chap"
      "ter \" Character Set and Escape Sequences \".\n\nPossible Answers:\n\n"
      "\"OK[<map>]\" - in case a new MIDI instrument map could be added, wher"
      "e <map> reflects the unique ID of the newly created MIDI instrument ma"
      "p\n\n\"ERR:<error-code>:<error-message>\" - when a new map could not b"
      "e created, which might never occur in practice\n\nExamples:\n\nC: \"AD"
      "D MIDI_INSTRUMENT_MAP 'Standard Map'\"\n\nS: \"OK[0]\"\n\nC: \"ADD MID"
      "I_INSTRUMENT_MAP 'Standard Drumkit'\"\n\nS: \"OK[1]\"\n\nC: \"ADD MIDI"
      "_INSTRUMENT_MAP\"\n\nS: \"OK[5]\"\n\n"
    },
    { "SUBSCRIBE CHANNEL_COUNT",
      "Client may want to be notified when the total number of channels on th"
      "e back-end changes by issuing the following command:\n\nSUBSCRIBE CHAN"
      "NEL_COUNT\n\nServer will start sending the following notification mess"
      "ages:\n\n\"NOTIFY:CHANNEL_COUNT:<channels>\"\n\nwhere <channels> will"
      "be replaced by the new number of sampler channels.\n\n"
    },
    { "SEND CHANNEL MIDI_DATA",
      "The front-end can send MIDI events to a specific sampler channel by se"
      "nding the following command:\n\nSEND CHANNEL MIDI_DATA <midi-msg> <sam"
      "pler-chan> <arg1> <arg2>\n\nWhere <sampler-chan> is the sampler channe"
      "l number as returned by the \"ADD CHANNEL\" or \"LIST CHANNELS\" comma"
      "nd, <arg1> and <arg2> arguments depend on the <midi-msg> argument, whi"
      "ch specifies the MIDI message type. Currently, the following MIDI mess"
      "ages are supported:\n\n\"NOTE_ON\" - For turning on MIDI notes, where"
      "<arg1> specifies the key number and <arg2> the velocity as described i"
      "n the MIDI specification.\n\n\"NOTE_OFF\" - For turning a currently pl"
      "aying MIDI note off, where <arg1> specifies the key number and <arg2>"
      "the velocity as described in the MIDI specification.\n\n\"CC\" - For c"
      "hanging a MIDI controller, where <arg1> specifies the controller numbe"
      "r and <arg2> the new value of the controller as described in the Contr"
      "ol Change section of the MIDI specification.\n\nCAUTION: This command"
      "is provided for implementations of virtual MIDI keyboards and no realt"
      "ime guarantee whatsoever will be made!\n\nPossible Answers:\n\n\"OK\""
      "- on success\n\n\"ERR:<error-code>:<error-message>\" - in case it fail"
      "ed, providing an appropriate error code and error message\n\nExample:"
      "\n\nC: \"SEND CHANNEL MIDI_DATA NOTE_ON 0 56 112\"\n\nS: \"OK\"\n\n"
    },
    { "SUBSCRIBE CHANNEL_INFO",
      "Client may want to be notified when changes were made to sampler chann"
      "els on the back-end by issuing the following command:\n\nSUBSCRIBE CHA"
      "NNEL_INFO\n\nServer will start sending the following notification mess"
      "ages:\n\n\"NOTIFY:CHANNEL_INFO:<sampler-channel>\"\n\nwhere <sampler-c"
      "hannel> will be replaced by the sampler channel the channel info chang"
      "e occurred. The front-end will have to send the respective command to"
      "actually get the channel info. Because these messages will be triggere"
      "d by LSCP commands issued by other clients rather than real time event"
      "s happening on the server, it is believed that an empty notification m"
      "essage is sufficient here.\n\n"
    },
    { "LIST MIDI_INSTRUMENT_MAPS",
      "The number of MIDI instrument maps can change on runtime. To get the c"
      "urrent list of MIDI instrument maps, the front-end can send the follow"
      "ing command:\n\nLIST MIDI_INSTRUMENT_MAPS\n\nPossible Answers:\n\nThe"
      "sampler will answer by returning a comma separated list with all MIDI"
      "instrument maps' numerical IDs.\n\nExample:\n\nC: \"LIST MIDI_INSTRUME"
      "NT_MAPS\"\n\nS: \"0,1,5,12\"\n\n"
    },
    { "LIST CHANNELS",
      "The number of sampler channels can change on runtime. To get the curre"
      "nt list of sampler channels, the front-end can send the following comm"
      "and:\n\nLIST CHANNELS\n\nPossible Answers:\n\nLinuxSampler will answer"
      " by returning a comma separated list with all sampler channels numeric"
      "al IDs.\n\nExample:\n\nC: \"LIST CHANNELS\"\n\nS: \"0,1,2,3,4,5,6,9,10"
      ",11,15,20\"\n\n"
    },
    { "SET ECHO",
      "To enable or disable back sending of commands to the client the follow"
      "ing command can be used:\n\nSET ECHO <value>\n\nWhere <value> should b"
      "e replaced either by \"1\" to enable echo mode or \"0\" to disable ech"
      "o mode. When echo mode is enabled, all commands send to LinuxSampler w"
      "ill be immediately send back and after this echo the actual response t"
      "o the command will be returned. Echo mode will only be altered for the"
      " client connection that issued the \"SET ECHO\" command, not globally"
      "for all client connections.\n\nPossible Answers:\n\n\"OK\" - usually\n"
      "\n\"ERR:<error-code>:<error-message>\" - on syntax error, e.g. non boo"
      "lean value\n\nExamples:\n\n\n\n"
    },
    { "ADD DB_INSTRUMENTS",
      "The front-end can add one or more instruments to the instruments datab"
      "ase by sending the following command:\n\nADD DB_INSTRUMENTS [NON_MODAL"
      "] [<mode>[ FILE_AS_DIR]] <db_dir> <file_path> [<instr_index>]\n\nWhere"
      " <db_dir> is the absolute path name of a directory (encapsulated into"
      "apostrophes) in the instruments database in which only the new instrum"
      "ents (that are not already in the database) will be added, <file_path>"
      " is the absolute path name of a file or directory in the file system ("
      "encapsulated into apostrophes). In case an instrument file is supplied"
      ", only the instruments in the specified file will be added to the inst"
      "ruments database. If the optional <instr_index> (the index of the inst"
      "rument within the given file) is supplied too, then only the specified"
      " instrument will be added. In case a directory is supplied, the instru"
      "ments in that directory will be added. The OPTIONAL <mode> argument is"
      " only applied when a directory is provided as <file_path> and specifie"
      "s how the scanning will be done and has exactly the following possibil"
      "ities:\n\n\"RECURSIVE\" - All instruments will be processed, including"
      " those in the subdirectories, and the respective subdirectory tree str"
      "ucture will be recreated in the instruments database\n\n\"NON_RECURSIV"
      "E\" - Only the instruments in the specified directory will be added, t"
      "he instruments in the subdirectories will not be processed.\n\n\"FLAT"
      "\" - All instruments will be processed, including those in the subdirec"
      "tories, but the respective subdirectory structure will not be recreate"
      "d in the instruments database. All instruments will be added directly"
      "in the specified database directory.\n\nIf FILE_AS_DIR argument is sup"
      "plied, all instruments in an instrument file will be added to a separa"
      "te directory in the instruments database, which name will be the name"
      "of the instrument file with the file extension stripped off.\n\nThe di"
      "fference between regular and NON_MODAL versions of the command is that"
      " the regular command returns when the scanning is finished while NON_M"
      "ODAL version returns immediately and a background process is launched."
      " The GET DB_INSTRUMENTS_JOB INFO command can be used to monitor the sc"
      "anning progress.\n\nPossible Answers:\n\n\"OK\" - on success when NON_"
      "MODAL is not supplied\n\n\"OK[<job-id>]\" - on success when NON_MODAL"
      "is supplied, where <job-id> is a numerical ID used to obtain status in"
      "formation about the job progress. See GET DB_INSTRUMENTS_JOB INFO \n\n"
      "\"ERR:<error-code>:<error-message>\" - if an invalid path is specified"
      ".\n\nExamples:\n\nC: \"ADD DB_INSTRUMENTS '/Piano Collection' '/home/m"
      "e/gigs/PMI Bosendorfer 290.gig' 0\"\n\nS: \"OK\"\n\n"
    },
    { "SET AUDIO_OUTPUT_CHANNEL_PARAMETER",
      "Use the following command to alter a specific setting of an audio outp"
      "ut channel:\n\nSET AUDIO_OUTPUT_CHANNEL_PARAMETER <dev-id> <chn> <key>"
      "=<value>\n\nWhere <dev-id> should be replaced by the numerical ID of t"
      "he audio output device as returned by the \"CREATE AUDIO_OUTPUT_DEVICE"
      "\" or \"LIST AUDIO_OUTPUT_DEVICES\" command, <chn> by the audio channe"
      "l number, <key> by the name of the parameter to change and <value> by"
      "the new value for this parameter.\n\nPossible Answers:\n\n\"OK\" - in"
      "case setting was successfully changed\n\n\"WRN:<warning-code>:<warning"
      "-message>\" - in case setting was changed successfully, but there are"
      "noteworthy issue(s) related, providing an appropriate warning code and"
      " warning message\n\n\"ERR:<error-code>:<error-message>\" - in case it"
      "failed, providing an appropriate error code and error message\n\nExamp"
      "le:\n\nC: \"SET AUDIO_OUTPUT_CHANNEL PARAMETER 0 0 JACK_BINDINGS='PCM:"
      "0'\"\n\nS: \"OK\"\n\nC: \"SET AUDIO_OUTPUT_CHANNEL PARAMETER 0 0 NAME="
      "'monitor left'\"\n\nS: \"OK\"\n\n"
    },
    { "GET FX_SEND INFO",
      "The front-end can ask for the current settings of an effect send entit"
      "y by sending the following command:\n\nGET FX_SEND INFO <sampler-chann"
      "el> <fx-send-id>\n\nWhere <sampler-channel> is the sampler channel num"
      "ber as returned by the \"ADD CHANNEL\" or \"LIST CHANNELS\" command an"
      "d <fx-send-id> reflects the numerical ID of the effect send entity as"
      "returned by the \"CREATE FX_SEND\" or \"LIST FX_SENDS\" command.\n\nPo"
      "ssible Answers:\n\nThe sampler will answer by sending a <CRLF> separat"
      "ed list. Each answer line begins with the settings category name follo"
      "wed by a colon and then a space character <SP> and finally the info ch"
      "aracter string to that setting category. At the moment the following c"
      "ategories are defined:\n\nNAME - name of the effect send entity (note"
      "that this character string may contain escape sequences )\n\nMIDI_CONT"
      "ROLLER - a value between 0 and 127 reflecting the MIDI controller whic"
      "h is able to modify the effect send's send level\n\nLEVEL - optionally"
      " dotted number reflecting the effect send's current send level (where"
      "a value < 1.0 means attenuation and a value > 1.0 means amplification)"
      "\n\nAUDIO_OUTPUT_ROUTING - comma separated list which reflects to whic"
      "h audio channel of the selected audio output device each effect send o"
      "utput channel is routed to, e.g. \"0,3\" would mean the effect send's"
      "output channel 0 is routed to channel 0 of the audio output device and"
      " the effect send's output channel 1 is routed to the channel 3 of the"
      "audio output device (see \"SET FX_SEND AUDIO_OUTPUT_CHANNEL\" for deta"
      "ils), if an internal send effect is assigned to the effect send, then"
      "this setting defines the audio channel routing to that effect instance"
      " respectively\n\nEFFECT - destination send effect chain ID and destina"
      "tion effect chain position, separated by comma in the form \"<effect-c"
      "hain>,<chain-pos>\" or \"NONE\" if there is no send effect assigned to"
      " the effect send\n\nThe mentioned fields above don't have to be in par"
      "ticular order.\n\nExample:\n\nC: \"GET FX_SEND INFO 0 0\"\n\nS: \"NAME"
      ": Reverb Send\"\n\n\"MIDI_CONTROLLER: 91\"\n\n\"LEVEL: 0.3\"\n\n\"AUDI"
      "O_OUTPUT_ROUTING: 2,3\"\n\n\"EFFECT: NONE\"\n\n\".\"\n\nC: \"GET FX_SE"
      "ND INFO 0 1\"\n\nS: \"NAME: Delay Send (Internal)\"\n\n\"MIDI_CONTROLL"
      "ER: 93\"\n\n\"LEVEL: 0.51\"\n\n\"AUDIO_OUTPUT_ROUTING: 1,2\"\n\n\"EFFE"
      "CT: 2,0\"\n\n\".\"\n\n"
    },
    { "MOVE DB_INSTRUMENT",
      "The front-end can move a specific instrument to another directory by s"
      "ending the following command:\n\nMOVE DB_INSTRUMENT <instr> <dst>\n\nW"
      "here <instr> is the absolute path name of the instrument to move and <"
      "dst> is the directory where the instrument will be moved to.\n\nPossib"
      "le Answers:\n\n\"OK\" - on success\n\n\"ERR:<error-code>:<error-messag"
      "e>\" - in case the given instrument does not exists, or if an instrume"
      "nt with name equal to the name of the specified instrument already exi"
      "sts in the destination directory.\n\nExample:\n\nC: \"MOVE DB_INSTRUME"
      "NT '/Piano Collection/Bosendorfer 290' '/Piano Collection/Acoustic'\""
      "\n\nS: \"OK\"\n\n"
    },
    { "EDIT INSTRUMENT",
      "The front-end can request to open an appropriate instrument editor app"
      "lication by sending the following command:\n\nEDIT CHANNEL INSTRUMENT"
      "<sampler-channel>\n\nWhere <sampler-channel> should be replaced by the"
      " number of the sampler channel as given by the \"ADD CHANNEL\" or \"LI"
      "ST CHANNELS\" command.\n\nThe sampler will try to ask all registered i"
      "nstrument editors (or to be more specific: their sampler plugins) whet"
      "her they are capable to handle the instrument on the given sampler cha"
      "nnel. The sampler will simply use the first instrument editor applicat"
      "ion which replied with a positive answer and spawn that instrument edi"
      "tor application within the sampler's process and provide that applicat"
      "ion access to the instrument's data structures, so both applications c"
      "an share and access the same instruments data at the same time, thus a"
      "llowing to immediately hear changes with the sampler made by the instr"
      "ument editor.\n\nNote: consequently instrument editors are always spaw"
      "ned locally on the same machine where the sampler is running on!\n\nPo"
      "ssible Answers:\n\n\"OK\" - when an appropriate instrument editor was"
      "launched\n\n\"WRN:<warning-code>:<warning-message>\" - when an appropr"
      "iate instrument editor was launched, but there are noteworthy issues\n"
      "\n\"ERR:<error-code>:<error-message>\" - when an appropriate instrumen"
      "t editor could not be launched\n\nExamples:\n\nC: \"EDIT CHANNEL INSTR"
      "UMENT 0\"\n\nS: \"OK\"\n\n"
    },
    { "REMOVE MIDI_INSTRUMENT_MAP",
      "The front-end can delete a particular MIDI instrument map by sending t"
      "he following command:\n\nREMOVE MIDI_INSTRUMENT_MAP <map>\n\nWhere <ma"
      "p> reflects the unique ID of the map to delete as returned by the \"LI"
      "ST MIDI_INSTRUMENT_MAPS\" command.\n\nThe front-end can delete all MID"
      "I instrument maps by sending the following command:\n\nREMOVE MIDI_INS"
      "TRUMENT_MAP ALL\n\nPossible Answers:\n\n\"OK\" - in case the map(s) co"
      "uld be deleted\n\n\"ERR:<error-code>:<error-message>\" - when the give"
      "n map does not exist\n\nExamples:\n\nC: \"REMOVE MIDI_INSTRUMENT_MAP 0"
      "\"\n\nS: \"OK\"\n\nC: \"REMOVE MIDI_INSTRUMENT_MAP ALL\"\n\nS: \"OK\""
      "\n\n"
    },
    { "ADD CHANNEL",
      "A new sampler channel can be added to the end of the sampler channel l"
      "ist by sending the following command:\n\nADD CHANNEL\n\nThis will incr"
      "ement the sampler channel count by one and the new sampler channel wil"
      "l be appended to the end of the sampler channel list. The front-end sh"
      "ould send the respective, related commands right after to e.g. load an"
      " engine, load an instrument and setting input, output method and event"
      "ually other commands to initialize the new channel. The front-end shou"
      "ld use the sampler channel returned by the answer of this command to p"
      "erform the previously recommended commands, to avoid race conditions e"
      ".g. with other front-ends that might also have sent an \"ADD CHANNEL\""
      " command.\n\nPossible Answers:\n\n\"OK[<sampler-channel>]\" - in case"
      "a new sampler channel could be added, where <sampler-channel> reflects"
      " the channel number of the new created sampler channel which should be"
      " used to set up the sampler channel by sending subsequent initializati"
      "on commands\n\n\"WRN:<warning-code>:<warning-message>\" - in case a ne"
      "w channel was added successfully, but there are noteworthy issue(s) re"
      "lated, providing an appropriate warning code and warning message\n\n\""
      "ERR:<error-code>:<error-message>\" - in case it failed, providing an a"
      "ppropriate error code and error message\n\nExample:\n\n\n\n"
    },
    { "GET SERVER INFO",
      "The client can ask for general information about the LinuxSampler inst"
      "ance by sending the following command:\n\nGET SERVER INFO\n\nPossible"
      "Answers:\n\nLinuxSampler will answer by sending a <CRLF> separated lis"
      "t. Each answer line begins with the information category name followed"
      " by a colon and then a space character <SP> and finally the info chara"
      "cter string to that information category. At the moment the following"
      "categories are defined:\n\nDESCRIPTION - arbitrary textual description"
      " about the sampler (note that the character string may contain escape"
      "sequences )\n\nVERSION - version of the sampler\n\nPROTOCOL_VERSION -"
      "version of the LSCP specification the sampler complies with (see  for"
      "details)\n\nINSTRUMENTS_DB_SUPPORT - either yes or no, specifies wheth"
      "er the sampler is build with instruments database support.\n\nThe ment"
      "ioned fields above don't have to be in particular order. Other fields"
      "might be added in future.\n\nExample:\n\nC: \"GET SERVER INFO\"\n\nS:"
      "\"DESCRIPTION: LinuxSampler - modular, streaming capable sampler\"\n\n"
      "\"VERSION: 1.0.0.svn23\"\n\n\"PROTOCOL_VERSION: 1.5\"\n\n\"INSTRUMENTS"
      "_DB_SUPPORT: no\"\n\n\".\"\n\n"
    },
    { "SET AUDIO_OUTPUT_DEVICE_PARAMETER",
      "Use the following command to alter a specific setting of a created aud"
      "io output device:\n\nSET AUDIO_OUTPUT_DEVICE_PARAMETER <device-id> <ke"
      "y>=<value>\n\nWhere <device-id> should be replaced by the numerical ID"
      " of the audio output device as given by the \"CREATE AUDIO_OUTPUT_DEVI"
      "CE\" or \"LIST AUDIO_OUTPUT_DEVICES\" command, <key> by the name of th"
      "e parameter to change and <value> by the new value for this parameter."
      "\n\nPossible Answers:\n\n\"OK\" - in case setting was successfully cha"
      "nged\n\n\"WRN:<warning-code>:<warning-message>\" - in case setting was"
      " changed successfully, but there are noteworthy issue(s) related, prov"
      "iding an appropriate warning code and warning message\n\n\"ERR:<error-"
      "code>:<error-message>\" - in case it failed, providing an appropriate"
      "error code and error message\n\nExample:\n\nC: \"SET AUDIO_OUTPUT_DEVI"
      "CE_PARAMETER 0 FRAGMENTSIZE=128\"\n\nS: \"OK\"\n\n"
    },
    { "GET MIDI_INSTRUMENT INFO",
      "The front-end can retrieve the current settings of a certain instrumen"
      "t map entry by sending the following command:\n\nGET MIDI_INSTRUMENT I"
      "NFO <map> <midi_bank> <midi_prog>\n\nWhere <map> is the numeric ID of"
      "the MIDI instrument map, <midi_bank> is an integer value between 0..16"
      "383 reflecting the MIDI bank value, <midi_bank> and <midi_prog> an int"
      "eger value between 0..127 reflecting the MIDI program value of the map"
      "'s entrie's key index triple.\n\nPossible Answers:\n\nLinuxSampler wil"
      "l answer by sending a <CRLF> separated list. Each answer line begins w"
      "ith the information category name followed by a colon and then a space"
      " character <SP> and finally the info character string to that info cat"
      "egory. At the moment the following categories are defined:\n\n\"NAME\""
      " - Name for this MIDI instrument map entry (if defined). This name sha"
      "ll be used by frontends for displaying a name for this mapped instrume"
      "nt. It can be set and changed with the \"MAP MIDI_INSTRUMENT\" command"
      " and does not have to be unique. (note that this character string may"
      "contain escape sequences )\n\n\"ENGINE_NAME\" - Name of the engine to"
      "be deployed for this instrument.\n\n\"INSTRUMENT_FILE\" - File name of"
      " the instrument (note that this path may contain escape sequences ).\n"
      "\n\"INSTRUMENT_NR\" - Index of the instrument within the file.\n\n\"IN"
      "STRUMENT_NAME\" - Name of the loaded instrument as reflected by its fi"
      "le. In contrast to the \"NAME\" field, the \"INSTRUMENT_NAME\" field c"
      "annot be changed (note that this character string may contain escape s"
      "equences ).\n\n\"LOAD_MODE\" - Life time of instrument (see \"MAP MIDI"
      "_INSTRUMENT\" for details about this setting).\n\n\"VOLUME\" - master"
      "volume of the instrument as optionally dotted number (where a value <"
      "1.0 means attenuation and a value > 1.0 means amplification)\n\nThe me"
      "ntioned fields above don't have to be in particular order.\n\nExample:"
      "\n\nC: \"GET MIDI_INSTRUMENT INFO 1 45 120\"\n\nS: \"NAME: Drums for F"
      "oo Song\"\n\n\"ENGINE_NAME: GigEngine\"\n\n\"INSTRUMENT_FILE: /usr/sha"
      "re/joesdrumkit.gig\"\n\n\"INSTRUMENT_NR: 0\"\n\n\"INSTRUMENT_NAME: Joe"
      "'s Drumkit\"\n\n\"LOAD_MODE: PERSISTENT\"\n\n\"VOLUME: 1.0\"\n\n\".\""
      "\n\n"
    },
    { "GET DB_INSTRUMENTS_JOB INFO",
      "The front-end can ask for the current status of a particular database"
      "instruments job by sending the following command:\n\nGET DB_INSTRUMENT"
      "S_JOB INFO <job-id>\n\nWhere <job-id> should be replaced by the numeri"
      "cal ID of the job the front-end is interested in.\n\nPossible Answers:"
      "\n\nLinuxSampler will answer by sending a <CRLF> separated list. Each"
      "answer line begins with the settings category name followed by a colon"
      " and then a space character <SP> and finally the info character string"
      " to that setting category. At the moment the following categories are"
      "defined:\n\nFILES_TOTAL - The total number of files scheduled for scan"
      "ning\n\nFILES_SCANNED - The current number of scanned files\n\nSCANNIN"
      "G - The absolute path name of the file which is currently being scanne"
      "d\n\nSTATUS - An integer value between 0 and 100 indicating the scanni"
      "ng progress percentage of the file which is currently being scanned\n"
      "\nThe mentioned fields above don't have to be in particular order.\n\nE"
      "xample:\n\nC: \"GET DB_INSTRUMENTS_JOB INFO 2\"\n\nS: \"FILES_TOTAL: 1"
      "2\"\n\n\"FILES_SCANNED: 7\"\n\n\"SCANNING: /home/me/gigs/Bosendorfer 2"
      "90.gig\"\n\n\"STATUS: 42\"\n\n\".\"\n\n"
    },
    { "GET EFFECT_INSTANCE_INPUT_CONTROL INFO",
      "Effects typically provide a certain set of effect parameters which can"
      " be altered by the user in realtime (e.g. depth of a reverb effect, du"
      "ration of a delay effect, dry / wet signal ratio). Those controllable"
      "effect parameters are called \"input controls\". The front-end can ask"
      " for the current information of an effect instance's input control by"
      "sending the following command:\n\nGET EFFECT_INSTANCE_INPUT_CONTROL IN"
      "FO <effect-instance> <input-control>\n\nWhere <effect-instance> is the"
      " numerical ID of an effect instance as returned by the \"CREATE EFFECT"
      "_INSTANCE\" or \"LIST EFFECT_INSTANCES\" command and <input-control> i"
      "s the index of the input control within the numerical bounds as return"
      "ed by the \"INPUT_CONTROLS\" field of the \"GET EFFECT_INSTANCE INFO\""
      " command.\n\nPossible Answers:\n\nLinuxSampler will answer by sending"
      "a <CRLF> separated list. Each answer line begins with the information"
      "category name, followed by a colon and then a space character <SP> and"
      " finally the info character string to that information category. There"
      " are information categories which are always returned, independent of"
      "the respective effect parameter and there are optional information cat"
      "egories which are only shown for certain effect parameters. At the mom"
      "ent the following categories are defined:\n\nDESCRIPTION - (always ret"
      "urned) human readable name of the effect parameter, intended to be dis"
      "played in user interfaces (note that the character string may contain"
      "escape sequences )\n\nVALUE - (always returned) current (optional dott"
      "ed) floating point value of this effect parameter\n\nRANGE_MIN - (opti"
      "onally returned) minimum allowed value for this effect parameter\n\nRA"
      "NGE_MAX - (optionally returned) maximum allowed value for this effect"
      "parameter\n\nPOSSIBILITIES - (optionally returned) comma separated lis"
      "t of (optional dotted) floating point numbers, reflecting the exact se"
      "t of possible values for this effect parameter\n\nDEFAULT - (optionall"
      "y returned) default value of this effect parameter\n\nThe mentioned fi"
      "elds above don't have to be in particular order.\n\nExample:\n\nC: \"G"
      "ET EFFECT_INSTANCE_INPUT_CONTROL INFO 1 0\"\n\nS: \"DESCRIPTION: Base"
      "delay (s)\"\n\n\"VALUE: 0.500\"\n\n\"RANGE_MIN: 0.000\"\n\n\".\"\n\n"
    },
    { "FIND DB_INSTRUMENT_DIRECTORIES",
      "The front-end can search for directories in specific directory by send"
      "ing the following command:\n\nFIND DB_INSTRUMENT_DIRECTORIES [NON_RECU"
      "RSIVE] <dir> <criteria-list>\n\nWhere <dir> should be replaced by the"
      "absolute path name of the directory to search in. If NON_RECURSIVE is"
      "specified, the directories located in subdirectories of the specified"
      "directory will not be searched. <criteria-list> is a list of search cr"
      "iterias in form of \"key1=val1 key2=val2 ...\". The following criteria"
      "s are allowed:\n\nNAME='<search-string>' Restricts the search to direc"
      "tories, which names satisfy the supplied search string (encapsulated i"
      "nto apostrophes, supporting escape sequences as described in chapter "
      "\" Character Set and Escape Sequences \").\n\nCREATED='[<date-after>].."
      "[<date-before>]' Restricts the search to directories, which creation d"
      "ate satisfies the specified period, where <date-after> and <date-befor"
      "e> are in \"YYYY-MM-DD HH:MM:SS\" format. If <date-after> is omitted t"
      "he search is restricted to directories created before <date-before>. I"
      "f <date-before> is omitted, the search is restricted to directories cr"
      "eated after <date-after>.\n\nMODIFIED='[<date-after>]..[<date-before>]"
      "' Restricts the search to directories, which date of last modification"
      " satisfies the specified period, where <date-after> and <date-before>"
      "are in \"YYYY-MM-DD HH:MM:SS\" format. If <date-after> is omitted the"
      "search is restricted to directories, which are last modified before <d"
      "ate-before>. If <date-before> is omitted, the search is restricted to"
      "directories, which are last modified after <date-after>.\n\nDESCRIPTIO"
      "N='<search-string>' Restricts the search to directories with descripti"
      "on that satisfies the supplied search string (encapsulated into apostr"
      "ophes, supporting escape sequences as described in chapter \" Characte"
      "r Set and Escape Sequences \").\n\nWhere <search-string> is either a r"
      "egular expression, or a word list separated with spaces for OR search"
      "and with '+' for AND search.\n\nPossible Answers:\n\nA comma separated"
      " list with the absolute path names (encapsulated into apostrophes) of"
      "all directories in the specified directory that satisfy the supplied s"
      "earch criterias.\n\n\"ERR:<error-code>:<error-message>\" - if the give"
      "n directory does not exist.\n\nExample:\n\nC: \"FIND DB_INSTRUMENT_DIR"
      "ECTORIES '/' NAME='Piano'\"\n\nS: \"'/Piano Collection'\"\n\nC: \"FIND"
      " DB_INSTRUMENT_DIRECTORIES '/' CREATED='..2007-04-01 09:30:13'\"\n\nS:"
      " \"'/Piano Collection','/Percussions'\"\n\n"
    },
    { "SET MIDI_INPUT_PORT_PARAMETER",
      "Use the following command to alter a specific setting of a MIDI input"
      "port:\n\nSET MIDI_INPUT_PORT_PARAMETER <device-id> <port> <key>=<value"
      ">\n\nWhere <device-id> should be replaced by the numerical ID of the M"
      "IDI device as returned by the \"CREATE MIDI_INPUT_DEVICE\" or \"LIST M"
      "IDI_INPUT_DEVICES\" command, <port> by the MIDI port number, <key> by"
      "the name of the parameter to change and <value> by the new value for t"
      "his parameter (encapsulated into apostrophes) or NONE (not encapsulate"
      "d into apostrophes) for specifying no value for parameters allowing a"
      "list of values.\n\nPossible Answers:\n\n\"OK\" - in case setting was s"
      "uccessfully changed\n\n\"WRN:<warning-code>:<warning-message>\" - in c"
      "ase setting was changed successfully, but there are noteworthy issue(s"
      ") related, providing an appropriate warning code and warning message\n"
      "\n\"ERR:<error-code>:<error-message>\" - in case it failed, providing"
      "an appropriate error code and error message\n\nExample:\n\nC: \"SET MI"
      "DI_INPUT_PORT_PARAMETER 0 0 ALSA_SEQ_BINDINGS='20:0'\"\n\nS: \"OK\"\n"
      "\nC: \"SET MIDI_INPUT_PORT_PARAMETER 0 0 ALSA_SEQ_BINDINGS=NONE\"\n\nS:"
      " \"OK\"\n\n"
    },
    { "GET CHANNEL VOICE_COUNT",
      "The front-end can ask for the current number of active voices on a sam"
      "pler channel by sending the following command:\n\nGET CHANNEL VOICE_CO"
      "UNT <sampler-channel>\n\nWhere <sampler-channel> is the sampler channe"
      "l number the front-end is interested in as returned by the \"ADD CHANN"
      "EL\" or \"LIST CHANNELS\" command.\n\nPossible Answers:\n\nLinuxSample"
      "r will answer by returning the number of active voices on that channel"
      ".\n\nExample:\n\n\n\n"
    },
    { "SET FX_SEND EFFECT",
      "The front-end can (re-)assign an internal destination effect to an eff"
      "ect send by sending the following command:\n\nSET FX_SEND EFFECT <samp"
      "ler-chan> <fx-send-id> <effect-chain> <chain-pos>\n\nWhere <sampler-ch"
      "an> is the sampler channel number as returned by the \"ADD CHANNEL\" o"
      "r \"LIST CHANNELS\" command, <fx-send-id> reflects the numerical ID of"
      " the effect send entity as returned by the \"CREATE FX_SEND\" or \"LIS"
      "T FX_SENDS\" command, <effect-chain> by the numerical ID of the destin"
      "ation effect chain as returned by the \"ADD SEND_EFFECT_CHAIN\" or \"L"
      "IST SEND_EFFECT_CHAINS\" command and <chain-pos> reflects the exact ef"
      "fect chain position in the effect chain which hosts the actual destina"
      "tion effect.\n\nNote: This command MUST NOT be used if you want to app"
      "ly audio effects externally! By default FX sends are routed directly t"
      "o the audio output device for that purpose. You can also revert this c"
      "ommand later on by sending \"REMOVE FX_SEND EFFECT\" , which will caus"
      "e the FX send to be routed directly to the sampler channel's audio out"
      "put device instead (i.e. for using external effects instead of interna"
      "l effects).\n\nPossible Answers:\n\n\"OK\" - on success\n\n\"ERR:<erro"
      "r-code>:<error-message>\" - in case it failed, providing an appropriat"
      "e error code and error message\n\nExample:\n\nC: \"SET FX_SEND EFFECT"
      "0 0 2 5\"\n\nS: \"OK\"\n\n"
    },
    { "SUBSCRIBE SEND_EFFECT_CHAIN_COUNT",
      "Client may want to be notified when the number of send effect chains i"
      "s changed by issuing the following command:\n\nSUBSCRIBE SEND_EFFECT_C"
      "HAIN_COUNT\n\nServer will start sending the following notification mes"
      "sages:\n\n\"NOTIFY:SEND_EFFECT_CHAIN_COUNT:<device-id> <chains>\"\n\nw"
      "here <device-id> will be replaced by the numerical ID of the audio out"
      "put device, in which the number of send effect chains is changed and <"
      "chains> will be replaced by the new number of send effect chains.\n\n"
    },
    { "GET AVAILABLE_EFFECTS",
      "The front-end can retrieve the amount of internal effects, available t"
      "o the sampler by sending the following command:\n\nGET AVAILABLE_EFFEC"
      "TS\n\nPossible Answers:\n\nThe sampler will answer by returning the cu"
      "rrent number of effects available to the sampler.\n\nExamples:\n\nC: "
      "\"GET AVAILABLE_EFFECTS\"\n\nS: \"129\"\n\n"
    },
    { "CREATE AUDIO_OUTPUT_DEVICE",
      "Use the following command to create a new audio output device for the"
      "desired audio output system:\n\nCREATE AUDIO_OUTPUT_DEVICE <audio-outp"
      "ut-driver> [<param-list>]\n\nWhere <audio-output-driver> should be rep"
      "laced by the desired audio output system as returned by the \"LIST AVA"
      "ILABLE_AUDIO_OUTPUT_DRIVERS\" command and <param-list> by an optional"
      "list of driver specific parameters in form of \"key1=val1 key2=val2 .."
      ".\", where character string values should be encapsulated into apostro"
      "phes ('). Note that there might be drivers which require parameter(s)"
      "to be given with this command. Use the previously described commands i"
      "n this chapter to get this information.\n\nPossible Answers:\n\n\"OK[<"
      "device-id>]\" - in case the device was successfully created, where <de"
      "vice-id> is the numerical ID of the new device\n\n\"WRN[<device-id>]:<"
      "warning-code>:<warning-message>\" - in case the device was created suc"
      "cessfully, where <device-id> is the numerical ID of the new device, bu"
      "t there are noteworthy issue(s) related (e.g. sound card doesn't suppo"
      "rt given hardware parameters and the driver is using fall-back values)"
      ", providing an appropriate warning code and warning message\n\n\"ERR:<"
      "error-code>:<error-message>\" - in case it failed, providing an approp"
      "riate error code and error message\n\nExamples:\n\nC: \"CREATE AUDIO_O"
      "UTPUT_DEVICE ALSA\"\n\nS: \"OK[0]\"\n\nC: \"CREATE AUDIO_OUTPUT_DEVICE"
      " ALSA CARD='2,0' SAMPLERATE=96000\"\n\nS: \"OK[1]\"\n\n"
    },
    { "SET FX_SEND MIDI_CONTROLLER",
      "The front-end can alter the MIDI controller of an effect send entity b"
      "y sending the following command:\n\nSET FX_SEND MIDI_CONTROLLER <sampl"
      "er-chan> <fx-send-id> <midi-ctrl>\n\nWhere <sampler-chan> is the sampl"
      "er channel number as returned by the \"ADD CHANNEL\" or \"LIST CHANNEL"
      "S\" command, <fx-send-id> reflects the numerical ID of the effect send"
      " entity as returned by the \"CREATE FX_SEND\" or \"LIST FX_SENDS\" com"
      "mand and <midi-ctrl> reflects the MIDI controller which shall be able"
      "to modify the effect send's send level.\n\nPossible Answers:\n\n\"OK\""
      " - on success\n\n\"WRN:<warning-code>:<warning-message>\" - if MIDI co"
      "ntroller was set, but there are noteworthy issue(s) related, providing"
      " an appropriate warning code and warning message\n\n\"ERR:<error-code>"
      ":<error-message>\" - in case it failed, providing an appropriate error"
      " code and error message\n\nExample:\n\nC: \"SET FX_SEND MIDI_CONTROLLE"
      "R 0 0 91\"\n\nS: \"OK\"\n\n"
    },
    { "SUBSCRIBE VOICE_COUNT",
      "Client may want to be notified when the number of voices on the back-e"
      "nd changes by issuing the following command:\n\nSUBSCRIBE VOICE_COUNT"
      "\n\nServer will start sending the following notification messages:\n\n"
      "\"NOTIFY:VOICE_COUNT:<sampler-channel> <voices>\"\n\nwhere <sampler-cha"
      "nnel> will be replaced by the sampler channel the voice count change o"
      "ccurred and <voices> by the new number of active voices on that channe"
      "l.\n\n"
    },
    { "QUIT",
      "The client can close its network connection to LinuxSampler by sending"
      " the following command:\n\nQUIT\n\nThis is probably more interesting f"
      "or manual telnet connections to LinuxSampler than really useful for a"
      "front-end implementation.\n\n"
    },
    { "CREATE MIDI_INPUT_DEVICE",
      "Use the following command to create a new MIDI input device for the de"
      "sired MIDI input system:\n\nCREATE MIDI_INPUT_DEVICE <midi-input-drive"
      "r> [<param-list>]\n\nWhere <midi-input-driver> should be replaced by t"
      "he desired MIDI input system as returned by the \"LIST AVAILABLE_MIDI_"
      "INPUT_DRIVERS\" command and <param-list> by an optional list of driver"
      " specific parameters in form of \"key1=val1 key2=val2 ...\", where cha"
      "racter string values should be encapsulated into apostrophes ('). Note"
      " that there might be drivers which require parameter(s) to be given wi"
      "th this command. Use the previously described commands in this chapter"
      " to get that information.\n\nPossible Answers:\n\n\"OK[<device-id>]\""
      "- in case the device was successfully created, where <device-id> is th"
      "e numerical ID of the new device\n\n\"WRN[<device-id>]:<warning-code>:"
      "<warning-message>\" - in case the driver was loaded successfully, wher"
      "e <device-id> is the numerical ID of the new device, but there are not"
      "eworthy issue(s) related, providing an appropriate warning code and wa"
      "rning message\n\n\"ERR:<error-code>:<error-message>\" - in case it fai"
      "led, providing an appropriate error code and error message\n\nExample:"
      "\n\nC: \"CREATE MIDI_INPUT_DEVICE ALSA\"\n\nS: \"OK[0]\"\n\n"
    },
    { "APPEND SEND_EFFECT_CHAIN EFFECT",
      "The front-end can add an unused effect instance to the end of a send e"
      "ffect chain by sending the following command:\n\nAPPEND SEND_EFFECT_CH"
      "AIN EFFECT <audio-device> <effect-chain> <effect-instance>\n\nWhere <a"
      "udio-device> should be replaced by the numerical ID of the audio outpu"
      "t device as given by the \"CREATE AUDIO_OUTPUT_DEVICE\" or \"LIST AUDI"
      "O_OUTPUT_DEVICES\" command and <effect-chain> by the numerical ID as r"
      "eturned by the \"ADD SEND_EFFECT_CHAIN\" or \"LIST SEND_EFFECT_CHAINS"
      "\" command and <effect-instance> as returned by the \"CREATE EFFECT_INS"
      "TANCE\" or \"LIST EFFECT_INSTANCES\" command.\n\nOnly unused effect in"
      "stances can be added to the effect chain. Trying to add an effect inst"
      "ance which is already in use somewhere in the audio signal path of the"
      " sampler will result in an error.\n\nPossible Answers:\n\n\"OK\" - in"
      "case the effect instance was added successfully to the chain\n\n\"ERR:"
      "<error-code>:<error-message>\" - if the effect instance could not be a"
      "dded\n\nExamples:\n\nC: \"APPEND SEND_EFFECT_CHAIN EFFECT 0 2 38\"\n\n"
      "S: \"OK\"\n\n"
    },
    { "GET AUDIO_OUTPUT_CHANNEL INFO",
      "Use the following command to get information about an audio channel:\n"
      "\nGET AUDIO_OUTPUT_CHANNEL INFO <device-id> <audio-chan>\n\nWhere <dev"
      "ice-id> is the numerical ID of the audio output device as given by the"
      " \"CREATE AUDIO_OUTPUT_DEVICE\" or \"LIST AUDIO_OUTPUT_DEVICES\" comma"
      "nd and <audio-chan> the audio channel number.\n\nPossible Answers:\n\n"
      "LinuxSampler will answer by sending a <CRLF> separated list. Each answ"
      "er line begins with the information category name followed by a colon"
      "and then a space character <SP> and finally the info character string"
      "to that info category. At the moment the following information categor"
      "ies are defined:\n\nNAME - arbitrary character string naming the chann"
      "el, which doesn't have to be unique (always returned by all audio chan"
      "nels)\n\nIS_MIX_CHANNEL - either true or false, a mix-channel is not a"
      " real, independent audio channel, but a virtual channel which is mixed"
      " to another real channel, this mechanism is needed for sampler engines"
      " which need more audio channels than the used audio system might be ab"
      "le to offer (always returned by all audio channels)\n\nMIX_CHANNEL_DES"
      "TINATION - numerical ID (positive integer including 0) which reflects"
      "the real audio channel (of the same audio output device) this mix chan"
      "nel refers to, means where the audio signal actually will be routed /"
      "added to (only returned in case the audio channel is mix channel)\n\nT"
      "he mentioned fields above don't have to be in particular order. The fi"
      "elds above are only those fields which are generally returned for the"
      "described cases by all audio channels regardless of the audio driver."
      "Every audio channel might have its own, additional driver and channel"
      "specific parameters.\n\nExamples:\n\nC: \"GET AUDIO_OUTPUT_CHANNEL INF"
      "O 0 0\"\n\nS: \"NAME: studio monitor left\"\n\n\"IS_MIX_CHANNEL: false"
      "\"\n\n\".\"\n\nC: \"GET AUDIO_OUTPUT_CHANNEL INFO 0 1\"\n\nS: \"NAME:"
      "studio monitor right\"\n\n\"IS_MIX_CHANNEL: false\"\n\n\".\"\n\nC: \"G"
      "ET AUDIO_OUTPUT_CHANNEL INFO 0 2\"\n\nS: \"NAME: studio monitor left\""
      "\n\n\"IS_MIX_CHANNEL: true\"\n\n\"MIX_CHANNEL_DESTINATION: 1\"\n\n\"."
      "\"\n\nC: \"GET AUDIO_OUTPUT_CHANNEL INFO 1 0\"\n\nS: \"NAME: 'ardour (l"
      "eft)'\"\n\n\"IS_MIX_CHANNEL: false\"\n\n\"JACK_BINDINGS: 'ardour:0'\""
      "\n\n\".\"\n\n"
    },
    { "CLEAR MIDI_INSTRUMENTS",
      "The front-end can clear a whole MIDI instrument map, that is delete al"
      "l its entries by sending the following command:\n\nCLEAR MIDI_INSTRUME"
      "NTS <map>\n\nWhere <map> is the numeric ID of the map to clear.\n\nThe"
      " front-end can clear all MIDI instrument maps, that is delete all entr"
      "ies of all maps by sending the following command:\n\nCLEAR MIDI_INSTRU"
      "MENTS ALL\n\nThe command \"CLEAR MIDI_INSTRUMENTS ALL\" does not delet"
      "e the maps, only their entries, thus the map's settings like custom na"
      "me will be preservevd.\n\nPossible Answers:\n\n\"OK\" - always\n\nExam"
      "ples:\n\nC: \"CLEAR MIDI_INSTRUMENTS 0\"\n\nS: \"OK\"\n\nC: \"CLEAR MI"
      "DI_INSTRUMENTS ALL\"\n\nS: \"OK\"\n\n"
    },
    { "SET DB_INSTRUMENT_DIRECTORY DESCRIPTION",
      "The front-end can alter the description of a specific instrument direc"
      "tory by sending the following command:\n\nSET DB_INSTRUMENT_DIRECTORY"
      "DESCRIPTION <dir> <desc>\n\nWhere <dir> is the absolute path name of t"
      "he directory and <desc> is the new description for the directory (enca"
      "psulated into apostrophes, supporting escape sequences as described in"
      " chapter \" Character Set and Escape Sequences \").\n\nPossible Answer"
      "s:\n\n\"OK\" - on success\n\n\"ERR:<error-code>:<error-message>\" - in"
      " case the given directory does not exists.\n\nExample:\n\nC: \"SET DB_"
      "INSTRUMENT_DIRECTORY DESCRIPTION '/Piano Collection' 'A collection of"
      "piano instruments in various format.'\"\n\nS: \"OK\"\n\n"
    },
    { "SET CHANNEL AUDIO_OUTPUT_CHANNEL",
      "The front-end can alter the audio output channel on a specific sampler"
      " channel by sending the following command:\n\nSET CHANNEL AUDIO_OUTPUT"
      "_CHANNEL <sampler-chan> <audio-out> <audio-in>\n\nWhere <sampler-chan>"
      " is the sampler channel number as returned by the \"ADD CHANNEL\" or "
      "\"LIST CHANNELS\" command, <audio-out> is the numerical ID of the sampl"
      "er channel's audio output channel which should be rerouted and <audio-"
      "in> is the numerical ID of the audio channel of the selected audio out"
      "put device where <audio-out> should be routed to.\n\nPossible Answers:"
      "\n\n\"OK\" - on success\n\n\"WRN:<warning-code>:<warning-message>\" -"
      "if audio output channel was set, but there are noteworthy issue(s) rel"
      "ated, providing an appropriate warning code and warning message\n\n\"E"
      "RR:<error-code>:<error-message>\" - in case it failed, providing an ap"
      "propriate error code and error message\n\nExamples:\n\n\n\n"
    },
    { "SUBSCRIBE STREAM_COUNT",
      "Client may want to be notified when the number of streams on the back-"
      "end changes by issuing the following command: SUBSCRIBE STREAM_COUNT\n"
      "\nSUBSCRIBE STREAM_COUNT\n\nServer will start sending the following no"
      "tification messages:\n\n\"NOTIFY:STREAM_COUNT:<sampler-channel> <strea"
      "ms>\"\n\nwhere <sampler-channel> will be replaced by the sampler chann"
      "el the stream count change occurred and <streams> by the new number of"
      " active disk streams on that channel.\n\n"
    },
    { "LIST MIDI_INPUT_DEVICES",
      "Use the following command to list all created MIDI input devices:\n\nL"
      "IST MIDI_INPUT_DEVICES\n\nPossible Answers:\n\nLinuxSampler will answe"
      "r by sending a comma separated list with the numerical Ids of all crea"
      "ted MIDI input devices.\n\nExamples:\n\nC: \"LIST MIDI_INPUT_DEVICES\""
      "\n\nS: \"0,1,2\"\n\nC: \"LIST MIDI_INPUT_DEVICES\"\n\nS: \"1,3\"\n\n"
    },
    { "SET CHANNEL SOLO",
      "The front-end can solo/unsolo a specific sampler channel by sending th"
      "e following command:\n\nSET CHANNEL SOLO <sampler-channel> <solo>\n\nW"
      "here <sampler-channel> is the respective sampler channel number as ret"
      "urned by the \"ADD CHANNEL\" or \"LIST CHANNELS\" command and <solo> s"
      "hould be replaced either by \"1\" to solo the channel or \"0\" to unso"
      "lo the channel.\n\nPossible Answers:\n\n\"OK\" - on success\n\n\"WRN:<"
      "warning-code>:<warning-message>\" - if the channel was soloed/unsoloed"
      ", but there are noteworthy issue(s) related, providing an appropriate"
      "warning code and warning message\n\n\"ERR:<error-code>:<error-message>"
      "\" - in case it failed, providing an appropriate error code and error"
      "message\n\nExamples:\n\n\n\n"
    },
    { "GET DB_INSTRUMENT INFO",
      "The front-end can ask for the current settings of an instrument by sen"
      "ding the following command:\n\nGET DB_INSTRUMENT INFO <instr_path>\n\n"
      "Where <instr_path> should be replaced by the absolute path name of the"
      " instrument the front-end is interested in.\n\nPossible Answers:\n\nLi"
      "nuxSampler will answer by sending a <CRLF> separated list. Each answer"
      " line begins with the settings category name followed by a colon and t"
      "hen a space character <SP> and finally the info character string to th"
      "at setting category. At the moment the following categories are define"
      "d:\n\nINSTRUMENT_FILE - File name of the instrument. Note that the cha"
      "racter string may contain escape sequences .\n\nINSTRUMENT_NR - Index"
      "of the instrument within the file.\n\nFORMAT_FAMILY - The format famil"
      "y of the instrument.\n\nFORMAT_VERSION - The format version of the ins"
      "trument.\n\nSIZE - The size of the instrument in bytes.\n\nCREATED - T"
      "he date and time when the instrument is added in the instruments datab"
      "ase, represented in \"YYYY-MM-DD HH:MM:SS\" format\n\nMODIFIED - The d"
      "ate and time of the last modification of the instrument's database set"
      "tings, represented in \"YYYY-MM-DD HH:MM:SS\" format\n\nDESCRIPTION -"
      "A brief description of the instrument. Note that the character string"
      "may contain escape sequences .\n\nIS_DRUM - either true or false, dete"
      "rmines whether the instrument is a drumkit or a chromatic instrument\n"
      "\nPRODUCT - The product title of the instrument. Note that the charact"
      "er string may contain escape sequences .\n\nARTISTS - Lists the artist"
      " names. Note that the character string may contain escape sequences ."
      "\n\nKEYWORDS - Provides a list of keywords that refer to the instrument"
      ". Keywords are separated with semicolon and blank. Note that the chara"
      "cter string may contain escape sequences .\n\nThe mentioned fields abo"
      "ve don't have to be in particular order.\n\nExample:\n\nC: \"GET DB_IN"
      "STRUMENT INFO '/Piano Collection/Bosendorfer 290'\"\n\nS: \"INSTRUMENT"
      "_FILE: /home/me/gigs/Bosendorfer 290.gig\"\n\n\"INSTRUMENT_NR: 0\"\n\n"
      "\"FORMAT_FAMILY: GIG\"\n\n\"FORMAT_VERSION: 2\"\n\n\"SIZE: 2050871870"
      "\"\n\n\"CREATED: 2007-02-05 10:23:12\"\n\n\"MODIFIED: 2007-04-07 12:50:"
      "21\"\n\n\"DESCRIPTION: \"\n\n\"IS_DRUM: false\"\n\n\"PRODUCT: GRANDIOS"
      "O Bosendorfer 290\"\n\n\"ARTISTS: Post Musical Instruments\"\n\n\"KEYW"
      "ORDS: Bosendorfer\"\n\n\".\"\n\n"
    },
    { "REMOVE SEND_EFFECT_CHAIN EFFECT",
      "The front-end can remove an effect instance from a certain position of"
      " a send effect chain by sending the following command:\n\nREMOVE SEND_"
      "EFFECT_CHAIN EFFECT <audio-device> <effect-chain> <chain-pos>\n\nWhere"
      " <audio-device> should be replaced by the numerical ID of the audio ou"
      "tput device as given by the \"CREATE AUDIO_OUTPUT_DEVICE\" or \"LIST A"
      "UDIO_OUTPUT_DEVICES\" command, <effect-chain> by the numerical ID as r"
      "eturned by the \"ADD SEND_EFFECT_CHAIN\" or \"LIST SEND_EFFECT_CHAINS"
      "\" command and <chain-pos> the exact position of the effect instance to"
      " be removed from the effect chain.\n\nPossible Answers:\n\n\"OK\" - in"
      " case the effect instance was removed successfully\n\n\"ERR:<error-cod"
      "e>:<error-message>\" - if the effect instance could not be removed\n\n"
      "Examples:\n\nC: \"REMOVE SEND_EFFECT_CHAIN EFFECT 0 2 4\"\n\nS: \"OK\""
      "\n\n"
    },
    { "COPY DB_INSTRUMENT_DIRECTORY",
      "The front-end can copy a specific instrument directory by sending the"
      "following command:\n\nCOPY DB_INSTRUMENT_DIRECTORY <dir> <dst>\n\nWher"
      "e <dir> is the absolute path name of the directory to copy and <dst> i"
      "s the location where the directory will be copied to.\n\nPossible Answ"
      "ers:\n\n\"OK\" - on success\n\n\"ERR:<error-code>:<error-message>\" -"
      "in case a given directory does not exists, or if a directory with name"
      " equal to the name of the specified directory already exists in the de"
      "stination directory. Error is also thrown when trying to copy a direct"
      "ory to a subdirectory of itself.\n\nExample:\n\nC: \"COPY DB_INSTRUMEN"
      "T_DIRECTORY '/Piano Collection/Acoustic' '/Acoustic/Pianos'\"\n\nS: \""
      "OK\"\n\n"
    },
    { "SUBSCRIBE MISCELLANEOUS",
      "Client may want to be notified of miscellaneous and debugging events o"
      "ccurring at the server by issuing the following command:\n\nSUBSCRIBE"
      "MISCELLANEOUS\n\nServer will start sending the following notification"
      "messages:\n\n\"NOTIFY:MISCELLANEOUS:<string>\"\n\nwhere <string> will"
      "be replaced by whatever data server wants to send to the client. Clien"
      "t MAY display this data to the user AS IS to facilitate debugging.\n\n"
    },
    { "GET FX_SENDS",
      "The front-end can ask for the amount of effect sends on a specific sam"
      "pler channel by sending the following command:\n\nGET FX_SENDS <sample"
      "r-channel>\n\nWhere <sampler-channel> is the respective sampler channe"
      "l number as returned by the \"ADD CHANNEL\" or \"LIST CHANNELS\" comma"
      "nd.\n\nPossible Answers:\n\nThe sampler will answer by returning the n"
      "umber of effect sends on the given sampler channel.\n\nExample:\n\nC:"
      "\"GET FX_SENDS 0\"\n\nS: \"2\"\n\n"
    },
    { "REMOVE FX_SEND EFFECT",
      "The front-end can (re-)assign a destination effect to an effect send b"
      "y sending the following command:\n\nREMOVE FX_SEND EFFECT <sampler-cha"
      "n> <fx-send-id>\n\nWhere <sampler-chan> is the sampler channel number"
      "as returned by the \"ADD CHANNEL\" or \"LIST CHANNELS\" command, <fx-s"
      "end-id> reflects the numerical ID of the effect send entity as returne"
      "d by the \"CREATE FX_SEND\" or \"LIST FX_SENDS\" command.\n\nAfter the"
      " destination effect has been removed from the effect send, the audio s"
      "ignal of the effect send will be routed directly to the audio output d"
      "evice, according to the audio channel routing setting of the effect se"
      "nd.\n\nPossible Answers:\n\n\"OK\" - on success\n\n\"ERR:<error-code>:"
      "<error-message>\" - in case it failed, providing an appropriate error"
      "code and error message\n\nExample:\n\nC: \"REMOVE FX_SEND EFFECT 0 0\""
      "\n\nS: \"OK\"\n\n"
    },
    { "GET MIDI_INPUT_DEVICES",
      "Use the following command to count all created MIDI input devices:\n\n"
      "GET MIDI_INPUT_DEVICES\n\nPossible Answers:\n\nLinuxSampler will answe"
      "r by sending the current number of all MIDI input devices.\n\nExample:"
      "\n\nC: \"GET MIDI_INPUT_DEVICES\"\n\nS: \"3\"\n\n"
    },
    { "GET CHANNEL STREAM_COUNT",
      "The front-end can ask for the current number of active disk streams on"
      " a sampler channel by sending the following command:\n\nGET CHANNEL ST"
      "REAM_COUNT <sampler-channel>\n\nWhere <sampler-channel> is the sampler"
      " channel number the front-end is interested in as returned by the \"AD"
      "D CHANNEL\" or \"LIST CHANNELS\" command.\n\nPossible Answers:\n\nLinu"
      "xSampler will answer by returning the number of active disk streams on"
      " that channel in case the engine supports disk streaming, if the engin"
      "e doesn't support disk streaming it will return \"NA\" for not availab"
      "le.\n\nExample:\n\n\n\n"
    },
    { "GET ENGINE INFO",
      "The front-end can ask for information about a specific engine by sendi"
      "ng the following command:\n\nGET ENGINE INFO <engine-name>\n\nWhere <e"
      "ngine-name> is an engine name as obtained by the \"LIST AVAILABLE_ENGI"
      "NES\" command.\n\nPossible Answers:\n\nLinuxSampler will answer by sen"
      "ding a <CRLF> separated list. Each answer line begins with the informa"
      "tion category name followed by a colon and then a space character <SP>"
      " and finally the info character string to that info category. At the m"
      "oment the following categories are defined:\n\nDESCRIPTION - arbitrary"
      " description text about the engine (note that the character string may"
      " contain escape sequences )\n\nVERSION - arbitrary character string re"
      "garding the engine's version\n\nThe mentioned fields above don't have"
      "to be in particular order.\n\nExamples:\n\nC: \"GET ENGINE INFO gig\""
      "\n\nS: \"DESCRIPTION: GigaSampler Format Engine\"\n\n\"VERSION: 1.110\""
      "\n\n\".\"\n\nC: \"GET ENGINE INFO sf2\"\n\nS: \"DESCRIPTION: SoundFont"
      " Format Engine\"\n\n\"VERSION: 1.4\"\n\n\".\"\n\nC: \"GET ENGINE INFO"
      "sfz\"\n\nS: \"DESCRIPTION: SFZ Format Engine\"\n\n\"VERSION: 1.11\"\n"
      "\n\".\"\n\n"
    },
    { "MOVE DB_INSTRUMENT_DIRECTORY",
      "The front-end can move a specific instrument directory by sending the"
      "following command:\n\nMOVE DB_INSTRUMENT_DIRECTORY <dir> <dst>\n\nWher"
      "e <dir> is the absolute path name of the directory to move and <dst> i"
      "s the location where the directory will be moved to.\n\nPossible Answe"
      "rs:\n\n\"OK\" - on success\n\n\"ERR:<error-code>:<error-message>\" - i"
      "n case a given directory does not exists, or if a directory with name"
      "equal to the name of the specified directory already exists in the des"
      "tination directory. Error is also thrown when trying to move a directo"
      "ry to a subdirectory of itself.\n\nExample:\n\nC: \"MOVE DB_INSTRUMENT"
      "_DIRECTORY '/Acoustic' '/Piano Collection/Acoustic'\"\n\nS: \"OK\"\n\n"
    },
    { "LIST AVAILABLE_AUDIO_OUTPUT_DRIVERS",
      "Use the following command to list all audio output drivers currently a"
      "vailable for the LinuxSampler instance:\n\nLIST AVAILABLE_AUDIO_OUTPUT"
      "_DRIVERS\n\nPossible Answers:\n\nLinuxSampler will answer by sending c"
      "omma separated character strings, each symbolizing an audio output dri"
      "ver.\n\nExample:\n\nC: \"LIST AVAILABLE_AUDIO_OUTPUT_DRIVERS\"\n\nS: "
      "\"ALSA,JACK\"\n\n"
    },
    { "GET FILE INSTRUMENT INFO",
      "The front-end can retrieve detailed information about a specific instr"
      "ument within a given instrument file by sending the following command:"
      "\n\nGET FILE INSTRUMENT INFO <filename> <instr-id>\n\nWhere <filename>"
      " is the name of the instrument file (encapsulated into apostrophes, su"
      "pporting escape sequences as described in chapter \" Character Set and"
      " Escape Sequences \") and <instr-id> is the numeric instrument ID as r"
      "eturned by the \"LIST FILE INSTRUMENTS\" command.\n\nThe sampler will"
      "try to ask all sampler engines, whether they support the given file an"
      "d ask the first engine with a positive answer for information about th"
      "e specific instrument in the given file.\n\nPossible Answers:\n\nLinux"
      "Sampler will answer by sending a <CRLF> separated list. Each answer li"
      "ne begins with the settings category name followed by a colon and then"
      " a space character <SP> and finally the info character string to that"
      "setting category. At the moment the following categories are defined:"
      "\n\nNAME - name of the instrument as stored in the instrument file\n\nF"
      "ORMAT_FAMILY - name of the sampler format of the given instrument\n\nF"
      "ORMAT_VERSION - version of the sampler format the instrumen is stored"
      "as\n\nPRODUCT - official product name of the instrument as stored in t"
      "he file\n\nARTISTS - artists / sample library vendor of the instrument"
      "\n\nKEY_BINDINGS - comma separated list of integer values representing"
      " the instrument's key mapping in the range between 0 .. 127, reflectin"
      "g the analog meaning of the MIDI specification.\n\nKEYSWITCH_BINDINGS"
      "- comma separated list of integer values representing the instrument's"
      " keyswitch mapping in the range between 0 .. 127, reflecting the analo"
      "g meaning of the MIDI specification.\n\nThe mentioned fields above don"
      "'t have to be in particular order.\n\nExample:\n\nC: \"GET FILE INSTRU"
      "MENT INFO 'D:/Sounds/Foo.gig' 0\"\n\nS: \"NAME: Lunatic Loops\"\n\n\"F"
      "ORMAT_FAMILY: GIG\"\n\n\"FORMAT_VERSION: 3\"\n\n\"PRODUCT: The Backbon"
      "e Bongo Beats\"\n\n\"ARTISTS: Jimmy the Fish\"\n\n\".\"\n\n"
    },
    { "SUBSCRIBE GLOBAL_INFO",
      "Client may want to be notified when changes to the global settings of"
      "the sampler were made by issuing the following command:\n\nSUBSCRIBE G"
      "LOBAL_INFO\n\nServer will start sending the following types of notific"
      "ation messages:\n\n\"NOTIFY:GLOBAL_INFO:VOLUME <volume>\" - Notifies t"
      "hat the golbal volume of the sampler is changed, where <volume> will b"
      "e replaced by the optional dotted floating point value, reflecting the"
      " new global volume parameter.\n\n\"NOTIFY:GLOBAL_INFO:VOICES <max-voic"
      "es>\" - Notifies that the golbal limit of the sampler for maximum voic"
      "es is changed, where <max-voices> will be an integer value, reflecting"
      " the new global voice limit parameter.\n\n\"NOTIFY:GLOBAL_INFO:STREAMS"
      " <max-streams>\" - Notifies that the golbal limit of the sampler for m"
      "aximum disk streams is changed, where <max-streams> will be an integer"
      " value, reflecting the new global disk streams limit parameter.\n\n"
    },
    { "SUBSCRIBE BUFFER_FILL",
      "Client may want to be notified when the buffer fill state of a disk st"
      "ream on the back-end changes by issuing the following command:\n\nSUBS"
      "CRIBE BUFFER_FILL\n\nServer will start sending the following notificat"
      "ion messages:\n\n\"NOTIFY:BUFFER_FILL:<sampler-channel> <fill-data>\""
      "\n\nwhere <sampler-channel> will be replaced by the sampler channel the"
      " buffer fill state change occurred on and <fill-data> will be replaced"
      " by the buffer fill data for this channel as described in  as if the "
      "\"GET CHANNEL BUFFER_FILL PERCENTAGE\" command was issued on this chann"
      "el.\n\n"
    },
    { "LIST AVAILABLE_MIDI_INPUT_DRIVERS",
      "Use the following command to list all MIDI input drivers currently ava"
      "ilable for the LinuxSampler instance:\n\nLIST AVAILABLE_MIDI_INPUT_DRI"
      "VERS\n\nPossible Answers:\n\nLinuxSampler will answer by sending comma"
      " separated character strings, each symbolizing a MIDI input driver.\n"
      "\nExample:\n\nC: \"LIST AVAILABLE_MIDI_INPUT_DRIVERS\"\n\nS: \"ALSA,JAC"
      "K\"\n\n"
    },
    { "GET EFFECT INFO",
      "The front-end can ask for general information about an effect by sendi"
      "ng the following command:\n\nGET EFFECT INFO <effect-index>\n\nWhere <"
      "effect-index> is the numerical ID of an effect as returned by the \"LI"
      "ST AVAILABLE_EFFECTS\" command.\n\nPossible Answers:\n\nLinuxSampler w"
      "ill answer by sending a <CRLF> separated list. Each answer line begins"
      " with the effect information category name, followed by a colon and th"
      "en a space character <SP> and finally the info character string to tha"
      "t effect information category. At the moment the following categories"
      "are defined:\n\nSYSTEM - name of the effect plugin system the effect i"
      "s based on (e.g. \"LADSPA\")\n\nMODULE - module of the effect plugin s"
      "ystem that contains this effect, the module is usually the dynamic-lin"
      "ked library (DLL) filename of the effect plugin, including full path ("
      "note that this filename may contain escape sequences )\n\nNAME - chara"
      "cter string defining the unique name of the effect within its module ("
      "note that the character string may contain escape sequences )\n\nDESCR"
      "IPTION - human readable name of the effect, intended to be displayed i"
      "n user interfaces (note that the character string may contain escape s"
      "equences )\n\nThe mentioned fields above don't have to be in particula"
      "r order.\n\nExample:\n\nC: \"GET EFFECT INFO 121\"\n\nS: \"SYSTEM: LAD"
      "SPA\"\n\n\"MODULE: /usr/lib/ladspa/lowpass_iir_1891.so\"\n\n\"NAME: lo"
      "wpass_iir\"\n\n\"DESCRIPTION: Glame Lowpass Filter\"\n\n\".\"\n\n"
    },
    { "SET FX_SEND AUDIO_OUTPUT_CHANNEL",
      "The front-end can alter the destination of an effect send's audio chan"
      "nel on a specific sampler channel by sending the following command:\n"
      "\nSET FX_SEND AUDIO_OUTPUT_CHANNEL <sampler-chan> <fx-send-id> <audio-s"
      "rc> <audio-dst>\n\nWhere <sampler-chan> is the sampler channel number"
      "as returned by the \"ADD CHANNEL\" or \"LIST CHANNELS\" command, <fx-s"
      "end-id> reflects the numerical ID of the effect send entity as returne"
      "d by the \"CREATE FX_SEND\" or \"LIST FX_SENDS\" command, <audio-src>"
      "is the numerical ID of the effect send's audio channel which should be"
      " rerouted and <audio-dst> is the numerical ID of either a) the audio o"
      "utput channel of the sampler channel's audio output device (i.e. if ex"
      "ternal effect shall be applied) or b) of the audio input channel of an"
      " internal effect assigned to the FX send where <audio-src> should be r"
      "outed to.\n\nNote that effect sends can only route audio to the same a"
      "udio output device as assigned to the effect send's sampler channel. A"
      "lso note that an effect send entity does always have exactly as much a"
      "udio channels as its sampler channel. So if the sampler channel is ste"
      "reo, the effect send does have two audio channels as well. Also keep i"
      "n mind that the amount of audio channels on a sampler channel might be"
      " dependant not only to the deployed sampler engine on the sampler chan"
      "nel, but also dependant to the instrument currently loaded. However yo"
      "u can (effectively) turn an i.e. stereo effect send into a mono one by"
      " simply altering its audio routing appropriately.\n\nPossible Answers:"
      "\n\n\"OK\" - on success\n\n\"WRN:<warning-code>:<warning-message>\" -"
      "if audio output channel was set, but there are noteworthy issue(s) rel"
      "ated, providing an appropriate warning code and warning message\n\n\"E"
      "RR:<error-code>:<error-message>\" - in case it failed, providing an ap"
      "propriate error code and error message\n\nExample:\n\nC: \"SET FX_SEND"
      " AUDIO_OUTPUT_CHANNEL 0 0 0 2\"\n\nS: \"OK\"\n\n"
    },
    { "SET DB_INSTRUMENT NAME",
      "The front-end can alter the name of a specific instrument by sending t"
      "he following command:\n\nSET DB_INSTRUMENT NAME <instr> <name>\n\nWher"
      "e <instr> is the absolute path name of the instrument and <name> is th"
      "e new name for that instrument.\n\nPossible Answers:\n\n\"OK\" - on su"
      "ccess\n\n\"ERR:<error-code>:<error-message>\" - in case the given inst"
      "rument does not exists, or if an instrument with name equal to the new"
      " name already exists.\n\nExample:\n\nC: \"SET DB_INSTRUMENT NAME '/Pia"
      "no Collection/Bosendorfer' 'Bosendorfer 290'\"\n\nS: \"OK\"\n\n"
    },
    { "SUBSCRIBE AUDIO_OUTPUT_DEVICE_INFO",
      "Client may want to be notified when changes were made to audio output"
      "devices on the back-end by issuing the following command:\n\nSUBSCRIBE"
      " AUDIO_OUTPUT_DEVICE_INFO\n\nServer will start sending the following n"
      "otification messages:\n\n\"NOTIFY:AUDIO_OUTPUT_DEVICE_INFO:<device-id>"
      "\"\n\nwhere <device-id> will be replaced by the numerical ID of the au"
      "dio output device, which settings has been changed. The front-end will"
      " have to send the respective command to actually get the audio output"
      "device info. Because these messages will be triggered by LSCP commands"
      " issued by other clients rather than real time events happening on the"
      " server, it is believed that an empty notification message is sufficie"
      "nt here.\n\n"
    },
    { "CREATE EFFECT_INSTANCE",
      "The front-end can spawn an instance of the desired effect by sending t"
      "he following command:\n\nCREATE EFFECT_INSTANCE <effect-system> <modul"
      "e> <effect-name>\n\nWhere <effect-system> is the \"SYSTEM\" field, <mo"
      "dule> the \"MODULE\" field and <effect-name> the \"NAME\" field as ret"
      "urned by the \"GET EFFECT INFO\" command. The filename of argument <mo"
      "dule> and the character string of argument <effect-name> may contain e"
      "scape sequences .\n\nThe sampler will try to load the requested effect"
      " and to create an instance of it. To allow loading the same effect on"
      "a different machine, probably even running a completely different oper"
      "ating system (e.g. Linux vs. Windows), the sampler tries to match <mod"
      "ule> \"softly\". That means it first tries to find an effect that exac"
      "tly matches the given <module> argument. If there is no exact match, t"
      "he sampler will try to lower the restrictions on matching the <module>"
      " argument more and more, e.g. by ignoring upper / lower case differenc"
      "es and by ignoring the path of the DLL filename and file extension. If"
      " there is still no match at the end, the sampler will try to ignore th"
      "e <module> argument completely and as a last resort search for an effe"
      "ct that only matches the given <effect-system> and <effect-name> argum"
      "ents.\n\nPossible Answers:\n\n\"OK[<effect-instance>]\" - in case the"
      "effect instance was successfully created, where <effect-instance> is t"
      "he numerical ID of the new effect instance\n\n\"WRN:<warning-code>:<wa"
      "rning-message>\" - in case the effect instance was spawned successfull"
      "y, but there are noteworthy issue(s) related, providing an appropriate"
      " warning code and warning message\n\n\"ERR:<error-code>:<error-message"
      ">\" - if the effect could not be instantiated\n\nExamples:\n\nC: \"CRE"
      "ATE EFFECT_INSTANCE LADSPA '/usr/lib/ladspa/mod_delay_1419.so' 'modDel"
      "ay'\"\n\nS: \"OK[0]\"\n\n"
    },
    { "GET CHANNEL INFO",
      "The front-end can ask for the current settings of a sampler channel by"
      " sending the following command:\n\nGET CHANNEL INFO <sampler-channel>"
      "\n\nWhere <sampler-channel> is the sampler channel number the front-end"
      " is interested in as returned by the \"ADD CHANNEL\" or \"LIST CHANNEL"
      "S\" command.\n\nPossible Answers:\n\nLinuxSampler will answer by sendi"
      "ng a <CRLF> separated list. Each answer line begins with the settings"
      "category name followed by a colon and then a space character <SP> and"
      "finally the info character string to that setting category. At the mom"
      "ent the following categories are defined:\n\nENGINE_NAME - name of the"
      " engine that is associated with the sampler channel, \"NONE\" if there"
      "'s no engine associated yet for this sampler channel\n\nAUDIO_OUTPUT_D"
      "EVICE - numerical ID of the audio output device which is currently con"
      "nected to this sampler channel to output the audio signal, \"-1\" if t"
      "here's no device connected to this sampler channel\n\nAUDIO_OUTPUT_CHA"
      "NNELS - number of output channels the sampler channel offers (dependen"
      "t to used sampler engine and loaded instrument)\n\nAUDIO_OUTPUT_ROUTIN"
      "G - comma separated list which reflects to which audio channel of the"
      "selected audio output device each sampler output channel is routed to,"
      " e.g. \"0,3\" would mean the engine's output channel 0 is routed to ch"
      "annel 0 of the audio output device and the engine's output channel 1 i"
      "s routed to the channel 3 of the audio output device\n\nINSTRUMENT_FIL"
      "E - the file name of the loaded instrument, \"NONE\" if there's no ins"
      "trument yet loaded for this sampler channel (note: since LSCP 1.2 this"
      " path may contain escape sequences )\n\nINSTRUMENT_NR - the instrument"
      " index number of the loaded instrument, \"-1\" if there's no instrumen"
      "t loaded for this sampler channel\n\nINSTRUMENT_NAME - the instrument"
      "name of the loaded instrument (note: since LSCP 1.2 this character str"
      "ing may contain escape sequences )\n\nINSTRUMENT_STATUS - Integer valu"
      "es 0 to 100 indicating loading progress percentage for the instrument."
      " Negative value indicates a loading exception (also returns \"-1\" in"
      "case no instrument was yet to be loaded on the sampler channel). Value"
      " of 100 indicates that the instrument is fully loaded.\n\nMIDI_INPUT_D"
      "EVICE - DEPRECATED: THIS FIELD WILL DISAPPEAR!\n\nnumerical ID of the"
      "MIDI input device which is currently connected to this sampler channel"
      " to deliver MIDI input commands, \"-1\" if there's no device connected"
      " to this sampler channel\n\nShould not be used anymore as of LSCP v1.6"
      " and younger. This field is currently only preserved for backward comp"
      "atibility.\n\nThis field a relict from times where only one MIDI input"
      " per sampler channel was allowed. Use \"GET CHANNEL MIDI_INPUTS\" inst"
      "ead.\n\nMIDI_INPUT_PORT - DEPRECATED: THIS FIELD WILL DISAPPEAR!\n\npo"
      "rt number of the MIDI input device (in case a MIDI device was already"
      "assigned to the sampler channel)\n\nShould not be used anymore as of L"
      "SCP v1.6 and younger. This field is currently only preserved for backw"
      "ard compatibility.\n\nThis field a relict from times where only one MI"
      "DI input per sampler channel was allowed. Use \"GET CHANNEL MIDI_INPUT"
      "S\" instead.\n\nMIDI_INPUT_CHANNEL - the MIDI input channel number thi"
      "s sampler channel should listen to or \"ALL\" to listen on all MIDI ch"
      "annels\n\nVOLUME - optionally dotted number for the channel volume fac"
      "tor (where a value < 1.0 means attenuation and a value > 1.0 means amp"
      "lification)\n\nMUTE - Determines whether the channel is muted, \"true"
      "\" if the channel is muted, \"false\" if the channel is not muted, and"
      "\"MUTED_BY_SOLO\" if the channel is muted because of the presence of a"
      " solo channel and will be unmuted when there are no solo channels left"
      "\n\nSOLO - Determines whether this is a solo channel, \"true\" if the"
      "channel is a solo channel; \"false\" otherwise\n\nMIDI_INSTRUMENT_MAP"
      "- Determines to which MIDI instrument map this sampler channel is assi"
      "gned to. Read chapter \"SET CHANNEL MIDI_INSTRUMENT_MAP\" for a list o"
      "f possible values.\n\nThe mentioned fields above don't have to be in p"
      "articular order.\n\nExample:\n\nC: \"GET CHANNEL INFO 34\"\n\nS: \"ENG"
      "INE_NAME: gig\"\n\n\"VOLUME: 1.0\"\n\n\"AUDIO_OUTPUT_DEVICE: 0\"\n\n\""
      "AUDIO_OUTPUT_CHANNELS: 2\"\n\n\"AUDIO_OUTPUT_ROUTING: 0,1\"\n\n\"INSTR"
      "UMENT_FILE: /home/joe/FazioliPiano.gig\"\n\n\"INSTRUMENT_NR: 0\"\n\n\""
      "INSTRUMENT_NAME: Fazioli Piano\"\n\n\"INSTRUMENT_STATUS: 100\"\n\n\"MI"
      "DI_INPUT_DEVICE: 0\"\n\n\"MIDI_INPUT_PORT: 0\"\n\n\"MIDI_INPUT_CHANNEL"
      ": 5\"\n\n\"VOLUME: 1.0\"\n\n\"MUTE: false\"\n\n\"SOLO: false\"\n\n\"MI"
      "DI_INSTRUMENT_MAP: NONE\"\n\n\".\"\n\n"
    },
    { "GET MIDI_INPUT_PORT INFO",
      "Use the following command to get information about a MIDI port:\n\nGET"
      " MIDI_INPUT_PORT INFO <device-id> <midi-port>\n\nWhere <device-id> is"
      "the numerical ID of the MIDI input device as returned by the \"CREATE"
      "MIDI_INPUT_DEVICE\" or \"LIST MIDI_INPUT_DEVICES\" command and <midi-p"
      "ort> the MIDI input port number.\n\nPossible Answers:\n\nLinuxSampler"
      "will answer by sending a <CRLF> separated list. Each answer line begin"
      "s with the information category name followed by a colon and then a sp"
      "ace character <SP> and finally the info character string to that info"
      "category. At the moment the following information categories are defin"
      "ed:\n\nNAME - arbitrary character string naming the port\n\nThe field"
      "above is only the one which is returned by all MIDI ports regardless o"
      "f the MIDI driver and port. Every MIDI port might have its own, additi"
      "onal driver and port specific parameters.\n\nExample:\n\nC: \"GET MIDI"
      "_INPUT_PORT INFO 0 0\"\n\nS: \"NAME: 'Masterkeyboard'\"\n\n\"ALSA_SEQ_"
      "BINDINGS: '64:0'\"\n\n\".\"\n\n"
    },
    { "GET EFFECT_INSTANCES",
      "The front-end can retrieve the current amount of effect instances by s"
      "ending the following command:\n\nGET EFFECT_INSTANCES\n\nPossible Answ"
      "ers:\n\nThe sampler will answer by returning the current number of eff"
      "ect instances created and not yet destroyed in the current sampler ses"
      "sion.\n\nExamples:\n\nC: \"GET EFFECT_INSTANCES\"\n\nS: \"14\"\n\n"
    },
    { "SUBSCRIBE MIDI_INPUT_DEVICE_COUNT",
      "Client may want to be notified when the total number of MIDI input dev"
      "ices on the back-end changes by issuing the following command:\n\nSUBS"
      "CRIBE MIDI_INPUT_DEVICE_COUNT\n\nServer will start sending the followi"
      "ng notification messages:\n\n\"NOTIFY:MIDI_INPUT_DEVICE_COUNT:<devices"
      ">\"\n\nwhere <devices> will be replaced by the new number of MIDI inpu"
      "t devices.\n\n"
    },
    { "SET CHANNEL MIDI_INSTRUMENT_MAP",
      "The front-end can assign a MIDI instrument map to a specific sampler c"
      "hannel by sending the following command:\n\nSET CHANNEL MIDI_INSTRUMEN"
      "T_MAP <sampler-channel> <map>\n\nWhere <sampler-channel> is the respec"
      "tive sampler channel number as returned by the \"ADD CHANNEL\" or \"LI"
      "ST CHANNELS\" command and <map> can have the following possibilites:\n"
      "\n\"NONE\" - This is the default setting. In this case the sampler cha"
      "nnel is not assigned any MIDI instrument map and thus will ignore all"
      "MIDI program change messages.\n\n\"DEFAULT\" - The sampler channel wil"
      "l always use the default MIDI instrument map to handle MIDI program ch"
      "ange messages.\n\nnumeric ID - You can assign a specific MIDI instrume"
      "nt map by replacing <map> with the respective numeric ID of the MIDI i"
      "nstrument map as returned by the \"LIST MIDI_INSTRUMENT_MAPS\" command"
      ". Once that map will be deleted, the sampler channel would fall back t"
      "o \"NONE\".\n\nRead chapter \"MIDI Instrument Mapping\" for details re"
      "garding MIDI instrument mapping.\n\nPossible Answers:\n\n\"OK\" - on s"
      "uccess\n\n\"ERR:<error-code>:<error-message>\" - in case it failed, pr"
      "oviding an appropriate error code and error message\n\nExamples:\n\n\n"
      "\n"
    },
    { "LIST SEND_EFFECT_CHAINS",
      "The front-end can retrieve the current list of send effect chains of a"
      "n audio output device by sending the following command:\n\nLIST SEND_E"
      "FFECT_CHAINS <audio-device>\n\nWhere <audio-device> should be replaced"
      " by the numerical ID of the audio output device as given by the \"CREA"
      "TE AUDIO_OUTPUT_DEVICE\" or \"LIST AUDIO_OUTPUT_DEVICES\" command.\n\n"
      "Possible Answers:\n\nThe sampler will answer by returning a comma sepa"
      "rated list with numerical IDs of send effect chains of the supplied au"
      "dio output device.\n\nExamples:\n\nC: \"LIST SEND_EFFECT_CHAINS 0\"\n"
      "\nS: \"3,4,7\"\n\n"
    },
    { "SET VOICES",
      "The client can alter the current global sampler-wide limit for maximum"
      " voices by sending the following command:\n\nSET VOICES <max-voices>\n"
      "\nWhere <max-voices> should be replaced by the integer value, reflecti"
      "ng the new global amount limit of maximum voices. This value has to be"
      " larger than 0.\n\nPossible Answers:\n\n\"OK\" - on success\n\n\"WRN:<"
      "warning-code>:<warning-message>\" - if the voice limit was set, but th"
      "ere are noteworthy issue(s) related, providing an appropriate warning"
      "code and warning message\n\n\"ERR:<error-code>:<error-message>\" - in"
      "case it failed, providing an appropriate error code and error message"
      "\n\nNote: the given value will be passed to all sampler engine instance"
      "s. The total amount of maximum voices on the running system might thus"
      " be as big as the given value multiplied by the current amount of engi"
      "ne instances.\n\nCaution: when adjusting the voice limit, you SHOULD a"
      "lso adjust the disk stream limit respectively and vice versa.\n\n"
    },
    { "GET MIDI_INPUT_DRIVER INFO",
      "Use the following command to get detailed information about a specific"
      " MIDI input driver:\n\nGET MIDI_INPUT_DRIVER INFO <midi-input-driver>"
      "\n\nWhere <midi-input-driver> is the name of the MIDI input driver as r"
      "eturned by the \"LIST AVAILABLE_MIDI_INPUT_DRIVERS\" command.\n\nPossi"
      "ble Answers:\n\nLinuxSampler will answer by sending a <CRLF> separated"
      " list. Each answer line begins with the information category name foll"
      "owed by a colon and then a space character <SP> and finally the info c"
      "haracter string to that info category. At the moment the following inf"
      "ormation categories are defined:\n\nDESCRIPTION - arbitrary descriptio"
      "n text about the MIDI input driver\n\nVERSION - arbitrary character st"
      "ring regarding the driver's version\n\nPARAMETERS - comma separated li"
      "st of all parameters available for the given MIDI input driver\n\nThe"
      "mentioned fields above don't have to be in particular order.\n\nExampl"
      "e:\n\nC: \"GET MIDI_INPUT_DRIVER INFO ALSA\"\n\nS: \"DESCRIPTION: Adva"
      "nced Linux Sound Architecture\"\n\n\"VERSION: 1.0\"\n\n\"PARAMETERS: D"
      "RIVER,ACTIVE\"\n\n\".\"\n\n"
    },
    { "SUBSCRIBE TOTAL_VOICE_COUNT",
      "Client may want to be notified when the total number of voices on the"
      "back-end changes by issuing the following command:\n\nSUBSCRIBE TOTAL_"
      "VOICE_COUNT\n\nServer will start sending the following notification me"
      "ssages:\n\n\"NOTIFY:TOTAL_VOICE_COUNT:<voices>\"\n\nwhere <voices> wil"
      "l be replaced by the new number of all currently active voices.\n\n"
    },
    { "GET TOTAL_VOICE_COUNT_MAX",
      "The front-end can ask for the maximum number of active voices by sendi"
      "ng the following command:\n\nGET TOTAL_VOICE_COUNT_MAX\n\nPossible Ans"
      "wers:\n\nLinuxSampler will answer by returning the maximum number of a"
      "ctive voices.\n\n"
    },
    { "LIST AVAILABLE_EFFECTS",
      "The set of available internal effects can change at runtime. The front"
      "-end can retrieve the list of internal effects, available to the sampl"
      "er by sending the following command:\n\nLIST AVAILABLE_EFFECTS\n\nPoss"
      "ible Answers:\n\nThe sampler will answer by returning a comma separate"
      "d list with numerical IDs of effects. Note: the numercial ID of an eff"
      "ect is generated by the sampler for the current moment. The numerical"
      "ID of the same effect can change at runtime, e.g. when the user reques"
      "ts a rescan of available effect plugins.\n\nExample:\n\nC: \"LIST AVAI"
      "LABLE_EFFECTS\"\n\nS: \"5,6,7,120,121,122,123,124\"\n\n"
    },
    { "LIST MIDI_INSTRUMENTS",
      "The front-end can query a list of all currently existing entries in a"
      "certain MIDI instrument map by sending the following command:\n\nLIST"
      "MIDI_INSTRUMENTS <map>\n\nWhere <map> is the numeric ID of the MIDI in"
      "strument map.\n\nThe front-end can query a list of all currently exist"
      "ing entries of all MIDI instrument maps by sending the following comma"
      "nd:\n\nLIST MIDI_INSTRUMENTS ALL\n\nPossible Answers:\n\nThe sampler w"
      "ill answer by sending a comma separated list of map ID - MIDI bank - M"
      "IDI program triples, where each triple is encapsulated into curly brac"
      "es. The list is returned in one single line. Each triple just reflects"
      " the key of the respective map entry, thus subsequent \"GET MIDI_INSTR"
      "UMENT INFO\" command(s) are necessary to retrieve detailed information"
      " about each entry.\n\nExample:\n\nC: \"LIST MIDI_INSTRUMENTS 0\"\n\nS:"
      " \"{0,0,0},{0,0,1},{0,0,3},{0,1,4},{1,127,127}\"\n\n"
    },
    { "LOAD INSTRUMENT",
      "An instrument file can be loaded and assigned to a sampler channel by"
      "one of the following commands:\n\nLOAD INSTRUMENT [NON_MODAL] '<filena"
      "me>' <instr-index> <sampler-channel>\n\nWhere <filename> is the name o"
      "f the instrument file on the LinuxSampler instance's host system, <ins"
      "tr-index> the index of the instrument in the instrument file and <samp"
      "ler-channel> is the number of the sampler channel the instrument shoul"
      "d be assigned to. Each sampler channel can only have one instrument.\n"
      "\nNotice: since LSCP 1.2 the <filename> argument supports escape chara"
      "cters for special characters (see chapter \" Character Set and Escape"
      "Sequences \" for details) and accordingly backslash characters in the"
      "filename MUST now be escaped as well!\n\nThe difference between regula"
      "r and NON_MODAL versions of the command is that the regular command re"
      "turns OK only after the instrument has been fully loaded and the chann"
      "el is ready to be used while NON_MODAL version returns immediately and"
      " a background process is launched to load the instrument on the channe"
      "l. The GET CHANNEL INFO command can be used to obtain loading progress"
      " from INSTRUMENT_STATUS field. LOAD command will perform sanity checks"
      " such as making sure that the file could be read and it is of a proper"
      " format and SHOULD return ERR and SHOULD not launch the background pro"
      "cess should any errors be detected at that point.\n\nPossible Answers:"
      "\n\n\"OK\" - in case the instrument was successfully loaded\n\n\"WRN:<"
      "warning-code>:<warning-message>\" - in case the instrument was loaded"
      "successfully, but there are noteworthy issue(s) related (e.g. Engine d"
      "oesn't support one or more patch parameters provided by the loaded ins"
      "trument file), providing an appropriate warning code and warning messa"
      "ge\n\n\"ERR:<error-code>:<error-message>\" - in case it failed, provid"
      "ing an appropriate error code and error message\n\nExample (Unix):\n\n"
      "C: LOAD INSTRUMENT '/home/joe/gigs/cello.gig' 0 0\n\nS: OK\n\nExample"
      "(Windows):\n\nC: LOAD INSTRUMENT 'D:/MySounds/cello.gig' 0 0\n\nS: OK"
      "\n\n"
    },
    { "SUBSCRIBE MIDI_INPUT_DEVICE_INFO",
      "Client may want to be notified when changes were made to MIDI input de"
      "vices on the back-end by issuing the following command:\n\nSUBSCRIBE M"
      "IDI_INPUT_DEVICE_INFO\n\nServer will start sending the following notif"
      "ication messages:\n\n\"NOTIFY:MIDI_INPUT_DEVICE_INFO:<device-id>\"\n\n"
      "where <device-id> will be replaced by the numerical ID of the MIDI inp"
      "ut device, which settings has been changed. The front-end will have to"
      " send the respective command to actually get the MIDI input device inf"
      "o. Because these messages will be triggered by LSCP commands issued by"
      " other clients rather than real time events happening on the server, i"
      "t is believed that an empty notification message is sufficient here.\n"
      "\n"
    },
    { "LIST FILE INSTRUMENTS",
      "The front-end can retrieve a list of all instruments within a given in"
      "strument file by sending the following command:\n\nLIST FILE INSTRUMEN"
      "TS <filename>\n\nWhere <filename> is the name of the instrument file ("
      "encapsulated into apostrophes, supporting escape sequences as describe"
      "d in chapter \" Character Set and Escape Sequences \").\n\nThe sampler"
      " will try to ask all sampler engines, whether they support the given f"
      "ile and ask the first engine with a positive answer for a list of IDs"
      "for the instruments in the given file.\n\nPossible Answers:\n\nOn succ"
      "ess, the sampler will answer by returning a comma separated list of in"
      "strument IDs.\n\n\"ERR:<error-code>:<error-message>\" - if the file co"
      "uld not be handled\n\nExamples:\n\nC: \"LIST FILE INSTRUMENTS 'D:/Soun"
      "ds/Foo.gig'\"\n\nS: \"0,1,2,3,4,5,6,7,8,9\"\n\n"
    },
    { "RESET CHANNEL",
      "The front-end can reset a particular sampler channel by sending the fo"
      "llowing command:\n\nRESET CHANNEL <sampler-channel>\n\nWhere <sampler-"
      "channel> defines the sampler channel to be reset. This will cause the"
      "engine on that sampler channel, its voices and eventually disk streams"
      " and all control and status variables to be reset.\n\nPossible Answers"
      ":\n\n\"OK\" - on success\n\n\"WRN:<warning-code>:<warning-message>\" -"
      " if channel was reset, but there are noteworthy issue(s) related, prov"
      "iding an appropriate warning code and warning message\n\n\"ERR:<error-"
      "code>:<error-message>\" - in case it failed, providing an appropriate"
      "error code and error message\n\nExamples:\n\n\n\n"
    },
    { "SET CHANNEL MIDI_INPUT_DEVICE",
      "DEPRECATED: THIS COMMAND WILL DISAPPEAR!\n\nThe front-end can set the"
      "MIDI input device on a specific sampler channel by sending the followi"
      "ng command:\n\nSET CHANNEL MIDI_INPUT_DEVICE <sampler-channel> <midi-d"
      "evice-id>\n\nWhere <sampler-channel> is the sampler channel number as"
      "returned by the \"ADD CHANNEL\" or \"LIST CHANNELS\" command and <midi"
      "-device-id> is the numerical ID of the MIDI input device as returned b"
      "y the \"CREATE MIDI_INPUT_DEVICE\" or \"LIST MIDI_INPUT_DEVICES\" comm"
      "and.\n\nIf more than 1 MIDI inputs are currently connected to this sam"
      "pler channel: Sending this command will disconnect ALL currently conne"
      "cted MIDI input ports connected to this sampler channel before establi"
      "shing the new MIDI input connection. So this command does NOT add the"
      "connection, it replaces all existing ones instead. This behavior is du"
      "e to preserving full behavior backward compatibility.\n\nPossible Answ"
      "ers:\n\n\"OK\" - on success\n\n\"WRN:<warning-code>:<warning-message>"
      "\" - if MIDI input device was set, but there are noteworthy issue(s) re"
      "lated, providing an appropriate warning code and warning message\n\n\""
      "ERR:<error-code>:<error-message>\" - in case it failed, providing an a"
      "ppropriate error code and error message\n\nExamples:\n\n\n\nDeprecated"
      ":\n\nShould not be used anymore as of LSCP v1.6 and younger. This comm"
      "and is currently only preserved for backward compatibility.\n\nThis co"
      "mmand is a relict from times where only one MIDI input per sampler cha"
      "nnel was allowed. Use \"ADD CHANNEL MIDI_INPUT\" and \"REMOVE CHANNEL"
      "MIDI_INPUT\" instead.\n\n"
    },
    { "LIST AVAILABLE_ENGINES",
      "The front-end can ask for a list of all available engines by sending t"
      "he following command:\n\nLIST AVAILABLE_ENGINES\n\nPossible Answers:\n"
      "\nLinuxSampler will answer by sending a comma separated list of the en"
      "gines' names encapsulated into apostrophes ('). Engine names can consi"
      "st of lower and upper cases, digits and underlines (\"_\" character)."
      "\n\nExample:\n\nC: \"LIST AVAILABLE_ENGINES\"\n\nS: \"'gig','sfz','sf2'"
      "\"\n\n"
    },
    { "SUBSCRIBE DB_INSTRUMENTS_JOB_INFO",
      "Client may want to be notified when the status of particular database"
      "instruments job is changed by issuing the following command:\n\nSUBSCR"
      "IBE DB_INSTRUMENTS_JOB_INFO\n\nServer will start sending the following"
      " notification messages:\n\n\"NOTIFY:DB_INSTRUMENTS_JOB_INFO:<job-id>\""
      "\n\nwhere <job-id> will be replaced by the numerical ID of the job, wh"
      "ich status is changed. The front-end will have to send the respective"
      "command to actually get the status info. Because these messages will b"
      "e triggered by LSCP commands issued by other clients rather than real"
      "time events happening on the server, it is believed that an empty noti"
      "fication message is sufficient here.\n\n"
    },
    { "ADD CHANNEL MIDI_INPUT",
      "The front-end can add a MIDI input on a specific sampler channel by se"
      "nding the following command:\n\nADD CHANNEL MIDI_INPUT <sampler-channe"
      "l> <midi-device-id> [<midi-input-port>]\n\nWhere <sampler-channel> is"
      "the sampler channel number as returned by the \"ADD CHANNEL\" or \"LIS"
      "T CHANNELS\" command and <midi-device-id> is the numerical ID of the M"
      "IDI input device as returned by the \"CREATE MIDI_INPUT_DEVICE\" or \""
      "LIST MIDI_INPUT_DEVICES\" command, and <midi-input-port> is an optiona"
      "l MIDI input port number of that MIDI input device. If <midi-input-por"
      "t> is omitted, then the MIDI input device's first port (port number 0)"
      " is used.\n\nPossible Answers:\n\n\"OK\" - on success\n\n\"WRN:<warnin"
      "g-code>:<warning-message>\" - if MIDI input port was connected, but th"
      "ere are noteworthy issue(s) related, providing an appropriate warning"
      "code and warning message\n\n\"ERR:<error-code>:<error-message>\" - in"
      "case it failed, providing an appropriate error code and error message"
      "\n\nExamples:\n\nC: \"ADD CHANNEL MIDI_INPUT 0 0\"\n\nS: \"OK\"\n\nC: "
      "\"ADD CHANNEL MIDI_INPUT 1 0\"\n\nS: \"OK\"\n\nC: \"ADD CHANNEL MIDI_IN"
      "PUT 1 1 1\"\n\nS: \"OK\"\n\nC: \"ADD CHANNEL MIDI_INPUT 1 2 0\"\n\nS:"
      "\"OK\"\n\nSince:\n\nIntroduced with LSCP v1.6\n\n"
    },
    { "GET MIDI_INSTRUMENT_MAP INFO",
      "The front-end can ask for the current settings of a MIDI instrument ma"
      "p by sending the following command:\n\nGET MIDI_INSTRUMENT_MAP INFO <m"
      "ap>\n\nWhere <map> is the numerical ID of the map the front-end is int"
      "erested in as returned by the \"LIST MIDI_INSTRUMENT_MAPS\" command.\n"
      "\nPossible Answers:\n\nLinuxSampler will answer by sending a <CRLF> se"
      "parated list. Each answer line begins with the settings category name"
      "followed by a colon and then a space character <SP> and finally the in"
      "fo character string to that setting category. At the moment the follow"
      "ing categories are defined:\n\nNAME - custom name of the given map, wh"
      "ich does not have to be unique (note that this character string may co"
      "ntain escape sequences )\n\nDEFAULT - either true or false, defines wh"
      "ether this map is the default map\n\nThe mentioned fields above don't"
      "have to be in particular order.\n\nExample:\n\nC: \"GET MIDI_INSTRUMEN"
      "T_MAP INFO 0\"\n\nS: \"NAME: Standard Map\"\n\n\"DEFAULT: true\"\n\n\""
      ".\"\n\n"
    },
    { "COPY DB_INSTRUMENT",
      "The front-end can copy a specific instrument to another directory by s"
      "ending the following command:\n\nCOPY DB_INSTRUMENT <instr> <dst>\n\nW"
      "here <instr> is the absolute path name of the instrument to copy and <"
      "dst> is the directory where the instrument will be copied to.\n\nPossi"
      "ble Answers:\n\n\"OK\" - on success\n\n\"ERR:<error-code>:<error-messa"
      "ge>\" - in case the given instrument does not exists, or if an instrum"
      "ent with name equal to the name of the specified instrument already ex"
      "ists in the destination directory.\n\nExample:\n\nC: \"COPY DB_INSTRUM"
      "ENT '/Piano Collection/Bosendorfer 290' '/Acoustic/Pianos/'\"\n\nS: \""
      "OK\"\n\n"
    },
    { "LIST FX_SENDS",
      "The front-end can ask for a list of effect sends on a specific sampler"
      " channel by sending the following command:\n\nLIST FX_SENDS <sampler-c"
      "hannel>\n\nWhere <sampler-channel> is the respective sampler channel n"
      "umber as returned by the \"ADD CHANNEL\" or \"LIST CHANNELS\" command."
      "\n\nPossible Answers:\n\nThe sampler will answer by returning a comma"
      "separated list with all effect sends' numerical IDs on the given sampl"
      "er channel.\n\nExamples:\n\nC: \"LIST FX_SENDS 0\"\n\nS: \"0,1\"\n\nC:"
      " \"LIST FX_SENDS 1\"\n\nS: \"\"\n\n"
    },
    { "SET EFFECT_INSTANCE_INPUT_CONTROL VALUE",
      "The front-end can alter the current value of an effect parameter by se"
      "nding the following command:\n\nSET EFFECT_INSTANCE_INPUT_CONTROL VALU"
      "E <effect-instance> <input-control> <value>\n\nWhere <effect-instance>"
      " is the numerical ID of the effect instance as returned by the \"CREAT"
      "E EFFECT_INSTANCE\" or \"LIST EFFECT_INSTANCES\" command, <input-contr"
      "ol> is the index of the input control within the numerical bounds as r"
      "eturned by the \"INPUT_CONTROLS\" field of the \"GET EFFECT_INSTANCE I"
      "NFO\" command and <value> is the new (optional dotted) floating point"
      "value for this effect parameter.\n\nPossible Answers:\n\n\"OK\" - in c"
      "ase the effect was altered successfully\n\n\"ERR:<error-code>:<error-m"
      "essage>\" - in case it failed, providing an appropriate error code and"
      " error message\n\nExamples:\n\nC: \"SET EFFECT_INSTANCE_INPUT_CONTROL"
      "VALUE 0 1 0.5\"\n\nS: \"OK\"\n\n"
    },
    { "ADD DB_INSTRUMENT_DIRECTORY",
      "The front-end can add a new instrument directory to the instruments da"
      "tabase by sending the following command:\n\nADD DB_INSTRUMENT_DIRECTOR"
      "Y <dir>\n\nWhere <dir> is the absolute path name of the directory to b"
      "e created (encapsulated into apostrophes).\n\nPossible Answers:\n\n\"O"
      "K\" - on success\n\n\"ERR:<error-code>:<error-message>\" - when the di"
      "rectory could not be created, which can happen if the directory alread"
      "y exists or the name contains not allowed symbols\n\nExamples:\n\nC: "
      "\"ADD DB_INSTRUMENT_DIRECTORY '/Piano Collection'\"\n\nS: \"OK\"\n\n"
    },
    { "REMOVE CHANNEL",
      "A sampler channel can be removed by sending the following command:\n\n"
      "REMOVE CHANNEL <sampler-channel>\n\nWhere <sampler-channel> should be"
      "replaced by the number of the sampler channel as given by the \"ADD CH"
      "ANNEL\" or \"LIST CHANNELS\" command. The channel numbers of all subse"
      "quent sampler channels remain the same.\n\nPossible Answers:\n\n\"OK\""
      " - in case the given sampler channel could be removed\n\n\"WRN:<warnin"
      "g-code>:<warning-message>\" - in case the given channel was removed, b"
      "ut there are noteworthy issue(s) related, providing an appropriate war"
      "ning code and warning message\n\n\"ERR:<error-code>:<error-message>\""
      "- in case it failed, providing an appropriate error code and error mes"
      "sage\n\nExample:\n\n\n\n"
    },
    { "SET CHANNEL AUDIO_OUTPUT_TYPE",
      "DEPRECATED: THIS COMMAND WILL DISAPPEAR!\n\nThe front-end can alter th"
      "e audio output type on a specific sampler channel by sending the follo"
      "wing command:\n\nSET CHANNEL AUDIO_OUTPUT_TYPE <sampler-channel> <audi"
      "o-output-type>\n\nWhere <audio-output-type> is currently either \"ALSA"
      "\" or \"JACK\" and <sampler-channel> is the respective sampler channel"
      " number.\n\nPossible Answers:\n\n\"OK\" - on success\n\n\"WRN:<warning"
      "-code>:<warning-message>\" - if audio output type was set, but there a"
      "re noteworthy issue(s) related, providing an appropriate warning code"
      "and warning message\n\n\"ERR:<error-code>:<error-message>\" - in case"
      "it failed, providing an appropriate error code and error message\n\nEx"
      "amples:\n\n\n\nDeprecated:\n\nShould not be used anymore. This command"
      " is currently only preserved for backward compatibility.\n\nThis comma"
      "nd is a relict from times where there was no sophisticated driver mana"
      "gement yet. Use \"CREATE AUDIO_OUTPUT_DEVICE\" and \"SET CHANNEL AUDIO"
      "_OUTPUT_DEVICE\" instead.\n\n"
    },
    { "GET VOLUME",
      "The client can ask for the current global sampler-wide volume attenuat"
      "ion by sending the following command:\n\nGET VOLUME\n\nPossible Answer"
      "s:\n\nThe sampler will always answer by returning the optional dotted"
      "floating point coefficient, reflecting the current global volume atten"
      "uation.\n\nNote: it is up to the respective sampler engine whether to"
      "obey that global volume parameter or not, but in general all engines S"
      "HOULD use this parameter.\n\n"
    },
    { "SET CHANNEL MIDI_INPUT_CHANNEL",
      "The front-end can alter the MIDI channel a sampler channel should list"
      "en to by sending the following command:\n\nSET CHANNEL MIDI_INPUT_CHAN"
      "NEL <sampler-channel> <midi-input-chan>\n\nWhere <midi-input-chan> is"
      "the number of the new MIDI input channel (zero indexed!) where <sample"
      "r-channel> should listen to, or \"ALL\" to listen on all 16 MIDI chann"
      "els.\n\nPossible Answers:\n\n\"OK\" - on success\n\n\"WRN:<warning-cod"
      "e>:<warning-message>\" - if MIDI input channel was set, but there are"
      "noteworthy issue(s) related, providing an appropriate warning code and"
      " warning message\n\n\"ERR:<error-code>:<error-message>\" - in case it"
      "failed, providing an appropriate error code and error message\n\nExamp"
      "les:\n\nC: \"SET CHANNEL MIDI_INPUT_CHANNEL 0 0\"\n\nS: \"OK\"\n\nC: "
      "\"SET CHANNEL MIDI_INPUT_CHANNEL 1 ALL\"\n\nS: \"OK\"\n\n"
    },
    { "CREATE FX_SEND",
      "The front-end can create an additional effect send on a specific sampl"
      "er channel by sending the following command:\n\nCREATE FX_SEND <sample"
      "r-channel> <midi-ctrl> [<name>]\n\nWhere <sampler-channel> is the resp"
      "ective sampler channel number as returned by the \"ADD CHANNEL\" or \""
      "LIST CHANNELS\" command, that is the sampler channel on which the effe"
      "ct send should be created on, <midi-ctrl> is a number between 0..127 d"
      "efining the MIDI controller which can alter the effect send level and"
      "<name> is an optional argument defining a name for the effect send ent"
      "ity. The name does not have to be unique, but MUST be encapsulated int"
      "o apostrophes and supports escape sequences as described in chapter \""
      " Character Set and Escape Sequences \".\n\nNote: there are two possibl"
      "e approaches to apply audio effects with FX sends: you can either use"
      "a) internal effects or b) external effects. By default, that is as ini"
      "tial routing, effect sends are automatically routed directly to the sa"
      "mpler channel's audio output device and the effect send's audio channe"
      "ls are by default automatically routed to the last audio channels of t"
      "hat audio output device (for the purpose of applying effects externall"
      "y that is, e.g. by using another application), that way you can i.e. f"
      "irst increase the amount of audio channels on the audio output device"
      "for having dedicated effect send output channels and when \"CREATE FX_"
      "SEND\" is called, those channels will automatically be picked. You can"
      " alter the destination channels however with \"SET FX_SEND AUDIO_OUTPU"
      "T_CHANNEL\" . If your intention is rather to use internal effects inst"
      "ead of external effects, then you first need to load those internal ef"
      "fects and then assign the FX sends to the desired internal effect by s"
      "ending \"SET FX_SEND EFFECT\" .\n\nNote: Create effect sends on a samp"
      "ler channel only when needed, because having effect sends on a sampler"
      " channel will decrease runtime performance, because for implementing c"
      "hannel effect sends, separate (sampler channel local) audio buffers ar"
      "e needed to render and mix the voices and route the audio signal after"
      "wards to the master outputs and effect send outputs (along with their"
      "respective effect send levels). A sampler channel without effect sends"
      " however can mix its voices directly into the audio output devices's a"
      "udio buffers and is thus faster.\n\nPossible Answers:\n\n\"OK[<fx-send"
      "-id>]\" - in case a new effect send could be added to the sampler chan"
      "nel, where <fx-send-id> reflects the unique ID of the newly created ef"
      "fect send entity\n\n\"ERR:<error-code>:<error-message>\" - when a new"
      "effect send could not be added, i.e. due to invalid parameters\n\nExam"
      "ples:\n\nC: \"CREATE FX_SEND 0 91 'Reverb Send'\"\n\nS: \"OK[0]\"\n\nC"
      ": \"CREATE FX_SEND 0 93\"\n\nS: \"OK[1]\"\n\n"
    },
    { "SUBSCRIBE DB_INSTRUMENT_INFO",
      "Client may want to be notified when changes were made to instruments i"
      "n the instruments database by issuing the following command:\n\nSUBSCR"
      "IBE DB_INSTRUMENT_INFO\n\nServer will start sending the following noti"
      "fication messages:\n\n\"NOTIFY:DB_INSTRUMENT_INFO:<instr-path>\"\n\nwh"
      "ere <instr-path> will be replaced by the absolute path name of the ins"
      "trument, which settings are changed. The front-end will have to send t"
      "he respective command to actually get the updated directory info. Beca"
      "use these messages will be triggered by LSCP commands issued by other"
      "clients rather than real time events happening on the server, it is be"
      "lieved that an empty notification message is sufficient here.\n\n\"NOT"
      "IFY:DB_INSTRUMENT_INFO:NAME <old-instr-path> <new-name>\"\n\nwhere <ol"
      "d-instr-path> is the old absolute path name of the instrument (encapsu"
      "lated into apostrophes), which name is changes and <new-name> is the n"
      "ew name of the instrument, encapsulated into apostrophes.\n\n"
    },
    { "REMOVE DB_INSTRUMENT_DIRECTORY",
      "The front-end can delete a particular instrument directory from the in"
      "struments database by sending the following command:\n\nREMOVE DB_INST"
      "RUMENT_DIRECTORY [FORCE] <dir>\n\nWhere <dir> is the absolute path nam"
      "e of the directory to delete. The optional FORCE argument can be used"
      "to force the deletion of a non-empty directory and all its content.\n"
      "\nPossible Answers:\n\n\"OK\" - if the directory is deleted successfull"
      "y\n\n\"ERR:<error-code>:<error-message>\" - if the given directory doe"
      "s not exist, or if trying to delete a non-empty directory, without usi"
      "ng the FORCE argument.\n\nExamples:\n\nC: \"REMOVE DB_INSTRUMENT_DIREC"
      "TORY FORCE '/Piano Collection'\"\n\nS: \"OK\"\n\n"
    },
    { "GET AVAILABLE_AUDIO_OUTPUT_DRIVERS",
      "Use the following command to get the number of audio output drivers cu"
      "rrently available for the LinuxSampler instance:\n\nGET AVAILABLE_AUDI"
      "O_OUTPUT_DRIVERS\n\nPossible Answers:\n\nLinuxSampler will answer by s"
      "ending the number of audio output drivers.\n\nExample:\n\nC: \"GET AVA"
      "ILABLE_AUDIO_OUTPUT_DRIVERS\"\n\nS: \"2\"\n\n"
    },
    { "GET CHANNELS",
      "The number of sampler channels can change on runtime. To get the curre"
      "nt amount of sampler channels, the front-end can send the following co"
      "mmand:\n\nGET CHANNELS\n\nPossible Answers:\n\nLinuxSampler will answe"
      "r by returning the current number of sampler channels.\n\nExample:\n\n"
      "C: \"GET CHANNELS\"\n\nS: \"12\"\n\n"
    },
    { "GET MIDI_INPUT_PORT_PARAMETER INFO",
      "Use the following command to get detailed information about specific M"
      "IDI port parameter:\n\nGET MIDI_INPUT_PORT_PARAMETER INFO <dev-id> <po"
      "rt> <param>\n\nWhere <dev-id> is the numerical ID of the MIDI input de"
      "vice as returned by the \"CREATE MIDI_INPUT_DEVICE\" or \"LIST MIDI_IN"
      "PUT_DEVICES\" command, <port> the MIDI port number and <param> a speci"
      "fic port parameter name for which information should be obtained (as r"
      "eturned by the \"GET MIDI_INPUT_PORT INFO\" command).\n\nPossible Answ"
      "ers:\n\nLinuxSampler will answer by sending a <CRLF> separated list. E"
      "ach answer line begins with the information category name followed by"
      "a colon and then a space character <SP> and finally the info character"
      " string to that info category. There is information which is always re"
      "turned, independently of the given channel parameter and there is opti"
      "onal information which are only shown dependently to the given MIDI po"
      "rt. At the moment the following information categories are defined:\n"
      "\nTYPE - either \"BOOL\" for boolean value(s) or \"INT\" for integer va"
      "lue(s) or \"FLOAT\" for dotted number(s) or \"STRING\" for character s"
      "tring(s) (always returned)\n\nDESCRIPTION - arbitrary text describing"
      "the purpose of the parameter (always returned)\n\nFIX - either true or"
      " false, if true then this parameter is read only, thus cannot be alter"
      "ed (always returned)\n\nMULTIPLICITY - either true or false, defines i"
      "f this parameter allows only one value or a list of values, where true"
      " means multiple values and false only a single value allowed (always r"
      "eturned)\n\nRANGE_MIN - defines lower limit of the allowed value range"
      " for this parameter, can be an integer value as well as a dotted numbe"
      "r, this parameter is usually used in conjunction with 'RANGE_MAX' but"
      "may also appear without (optionally returned, dependent to driver and"
      "port parameter)\n\nRANGE_MAX - defines upper limit of the allowed valu"
      "e range for this parameter, can be an integer value as well as a dotte"
      "d number, this parameter is usually used in conjunction with 'RANGE_MI"
      "N' but may also appear without (optionally returned, dependent to driv"
      "er and port parameter)\n\nPOSSIBILITIES - comma separated list of poss"
      "ible values for this parameter, character strings are encapsulated int"
      "o apostrophes (optionally returned, dependent to device and port param"
      "eter)\n\nThe mentioned fields above don't have to be in particular ord"
      "er.\n\nExample:\n\nC: \"GET MIDI_INPUT_PORT_PARAMETER INFO 0 0 ALSA_SE"
      "Q_BINDINGS\"\n\nS: \"DESCRIPTION: bindings to other ALSA sequencer cli"
      "ents\"\n\n\"TYPE: STRING\"\n\n\"FIX: false\"\n\n\"MULTIPLICITY: true\""
      "\n\n\"POSSIBILITIES: '64:0','68:0','68:1'\"\n\n\".\"\n\n"
    },
    { "SUBSCRIBE MIDI_INSTRUMENT_INFO",
      "Client may want to be notified when changes were made to MIDI instrume"
      "nts on the back-end by issuing the following command:\n\nSUBSCRIBE MID"
      "I_INSTRUMENT_INFO\n\nServer will start sending the following notificat"
      "ion messages:\n\n\"NOTIFY:MIDI_INSTRUMENT_INFO:<map-id> <bank> <progra"
      "m>\"\n\nwhere <map-id> will be replaced by the numerical ID of the MID"
      "I instrument map, in which a MIDI instrument is changed. <bank> and <p"
      "rogram> specifies the location of the changed MIDI instrument in the m"
      "ap. The front-end will have to send the respective command to actually"
      " get the MIDI instrument info. Because these messages will be triggere"
      "d by LSCP commands issued by other clients rather than real time event"
      "s happening on the server, it is believed that an empty notification m"
      "essage is sufficient here.\n\n"
    },
    { "SUBSCRIBE DB_INSTRUMENT_DIRECTORY_COUNT",
      "Client may want to be notified when the number of instrument directori"
      "es in a particular directory in the instruments database is changed by"
      " issuing the following command:\n\nSUBSCRIBE DB_INSTRUMENT_DIRECTORY_C"
      "OUNT\n\nServer will start sending the following notification messages:"
      "\n\n\"NOTIFY:DB_INSTRUMENT_DIRECTORY_COUNT:<dir-path>\"\n\nwhere <dir-"
      "path> will be replaced by the absolute path name of the directory in t"
      "he instruments database, in which the number of directories is changed"
      ".\n\nNote that when a non-empty directory is removed, this event is no"
      "t sent for the subdirectories in that directory.\n\n"
    },
    { "GET AUDIO_OUTPUT_DEVICE INFO",
      "Use the following command to get current settings of a specific, creat"
      "ed audio output device:\n\nGET AUDIO_OUTPUT_DEVICE INFO <device-id>\n"
      "\nWhere <device-id> should be replaced by numerical ID of the audio out"
      "put device as e.g. returned by the \"LIST AUDIO_OUTPUT_DEVICES\" comma"
      "nd.\n\nPossible Answers:\n\nLinuxSampler will answer by sending a <CRL"
      "F> separated list. Each answer line begins with the information catego"
      "ry name followed by a colon and then a space character <SP> and finall"
      "y the info character string to that info category. As some parameters"
      "might allow multiple values, character strings are encapsulated into a"
      "postrophes ('). At the moment the following information categories are"
      " defined (independently of device):\n\nDRIVER - identifier of the used"
      " audio output driver, as also returned by the \"LIST AVAILABLE_AUDIO_O"
      "UTPUT_DRIVERS\" command\n\nCHANNELS - amount of audio output channels"
      "this device currently offers\n\nSAMPLERATE - playback sample rate the"
      "device uses\n\nACTIVE - either true or false, if false then the audio"
      "device is inactive and doesn't output any sound, nor do the sampler ch"
      "annels connected to this audio device render any audio\n\nThe mentione"
      "d fields above don't have to be in particular order. The fields above"
      "are only those fields which are returned by all audio output devices."
      "Every audio output driver might have its own, additional driver specif"
      "ic parameters (see  ) which are also returned by this command.\n\nExam"
      "ple:\n\nC: \"GET AUDIO_OUTPUT_DEVICE INFO 0\"\n\nS: \"DRIVER: ALSA\"\n"
      "\n\"CHANNELS: 2\"\n\n\"SAMPLERATE: 44100\"\n\n\"ACTIVE: true\"\n\n\"FR"
      "AGMENTS: 2\"\n\n\"FRAGMENTSIZE: 128\"\n\n\"CARD: '0,0'\"\n\n\".\"\n\n"
    },
    { "GET STREAMS",
      "The client can ask for the current global sampler-wide limit for maxim"
      "um disk streams by sending the following command:\n\nGET STREAMS\n\nPo"
      "ssible Answers:\n\nLinuxSampler will answer by returning the number fo"
      "r the current limit of maximum disk streams.\n\nThe disk stream limit"
      "setting defines how many disk streams should maximum be processed by a"
      " sampler engine at the same time. The higher this value, the more memo"
      "ry (RAM) will be occupied, since every disk streams allocates a certai"
      "n buffer size for being able to perform its streaming operations.\n\n"
    },
    { "GET DB_INSTRUMENT_DIRECTORY INFO",
      "The front-end can ask for the current settings of an instrument direct"
      "ory by sending the following command:\n\nGET DB_INSTRUMENT_DIRECTORY I"
      "NFO <dir>\n\nWhere <dir> should be replaced by the absolute path name"
      "of the directory the front-end is interested in.\n\nPossible Answers:"
      "\n\nLinuxSampler will answer by sending a <CRLF> separated list. Each a"
      "nswer line begins with the settings category name followed by a colon"
      "and then a space character <SP> and finally the info character string"
      "to that setting category. At the moment the following categories are d"
      "efined:\n\nDESCRIPTION - A brief description of the directory content."
      " Note that the character string may contain escape sequences .\n\nCREA"
      "TED - The creation date and time of the directory, represented in \"YY"
      "YY-MM-DD HH:MM:SS\" format\n\nMODIFIED - The date and time of the last"
      " modification of the directory, represented in \"YYYY-MM-DD HH:MM:SS\""
      " format\n\nThe mentioned fields above don't have to be in particular o"
      "rder.\n\nExample:\n\nC: \"GET DB_INSTRUMENT_DIRECTORY INFO '/Piano Col"
      "lection'\"\n\nS: \"DESCRIPTION: Piano collection of instruments in Gig"
      "aSampler format.\"\n\n\"CREATED: 2007-02-05 10:23:12\"\n\n\"MODIFIED:"
      "2007-04-07 12:50:21\"\n\n\".\"\n\n"
    },
    { "GET TOTAL_VOICE_COUNT",
      "The front-end can ask for the current number of active voices on the s"
      "ampler by sending the following command:\n\nGET TOTAL_VOICE_COUNT\n\nP"
      "ossible Answers:\n\nLinuxSampler will answer by returning the number o"
      "f all active voices on the sampler.\n\n"
    },
    { "SET CHANNEL VOLUME",
      "The front-end can alter the volume of a sampler channel by sending the"
      " following command:\n\nSET CHANNEL VOLUME <sampler-channel> <volume>\n"
      "\nWhere <volume> is an optionally dotted positive number (a value smal"
      "ler than 1.0 means attenuation, whereas a value greater than 1.0 means"
      " amplification) and <sampler-channel> defines the sampler channel wher"
      "e this volume factor should be set.\n\nPossible Answers:\n\n\"OK\" - o"
      "n success\n\n\"WRN:<warning-code>:<warning-message>\" - if channel vol"
      "ume was set, but there are noteworthy issue(s) related, providing an a"
      "ppropriate warning code and warning message\n\n\"ERR:<error-code>:<err"
      "or-message>\" - in case it failed, providing an appropriate error code"
      " and error message\n\nExamples:\n\n\n\n"
    },
    { "SET FX_SEND NAME",
      "The front-end can alter the current name of an effect send entity by s"
      "ending the following command:\n\nSET FX_SEND NAME <sampler-chan> <fx-s"
      "end-id> <name>\n\nWhere <sampler-chan> is the sampler channel number a"
      "s returned by the \"ADD CHANNEL\" or \"LIST CHANNELS\" command, <fx-se"
      "nd-id> reflects the numerical ID of the effect send entity as returned"
      " by the \"CREATE FX_SEND\" or \"LIST FX_SENDS\" command and <name> is"
      "the new name of the effect send entity, which does not have to be uniq"
      "ue (name MUST be encapsulated into apostrophes and supports escape seq"
      "uences as described in chapter \" Character Set and Escape Sequences "
      "\").\n\nPossible Answers:\n\n\"OK\" - on success\n\n\"ERR:<error-code>:"
      "<error-message>\" - in case it failed, providing an appropriate error"
      "code and error message\n\nExample:\n\nC: \"SET FX_SEND NAME 0 0 'Fx Se"
      "nd 1'\"\n\nS: \"OK\"\n\n"
    },
    { "GET EFFECT_INSTANCE INFO",
      "The front-end can ask for the current information about a particular e"
      "ffect instance by sending the following command:\n\nGET EFFECT_INSTANC"
      "E INFO <effect-instance>\n\nWhere <effect-instance> is the numerical I"
      "D of an effect instance as returned by the \"CREATE EFFECT_INSTANCE\""
      "or \"LIST EFFECT_INSTANCES\" command.\n\nPossible Answers:\n\nLinuxSam"
      "pler will answer by sending a <CRLF> separated list. Each answer line"
      "begins with the information category name, followed by a colon and the"
      "n a space character <SP> and finally the info character string to that"
      " information category. At the moment the following categories are defi"
      "ned:\n\nSYSTEM - name of the effect plugin system the effect is based"
      "on (e.g. \"LADSPA\")\n\nMODULE - module of the effect plugin system th"
      "at contains this effect, the module is usually the dynamic-linked libr"
      "ary (DLL) filename of the effect plugin, including full path (note tha"
      "t this filename may contain escape sequences )\n\nNAME - character str"
      "ing defining the unique name of the effect within its module (note tha"
      "t the character string may contain escape sequences )\n\nDESCRIPTION -"
      " human readable name of the effect, intended to be displayed in user i"
      "nterfaces (note that the character string may contain escape sequences"
      " )\n\nINPUT_CONTROLS - amount of input controls the effect instance pr"
      "ovides, to allow controlling the effect parameters in realtime\n\nThe"
      "mentioned fields above don't have to be in particular order.\n\nExampl"
      "e:\n\nC: \"GET EFFECT_INSTANCE INFO 3\"\n\nS: \"SYSTEM: LADSPA\"\n\n\""
      "MODULE: /usr/lib/ladspa/mod_delay_1419.so\"\n\n\"NAME: modDelay\"\n\n"
      "\"DESCRIPTION: Modulatable delay\"\n\n\"INPUT_CONTROLS: 1\"\n\n\".\"\n"
      "\n"
    },
    { "SET DB_INSTRUMENT FILE_PATH",
      "The front-end can substitute all occurrences of an instrument file in"
      "the instruments database with a new one by sending the following comma"
      "nd:\n\nSET DB_INSTRUMENT FILE_PATH <old_path> <new_path>\n\nWhere <old"
      "_path> is the absolute path name of the instrument file to substitute"
      "with <new_path>.\n\nPossible Answers:\n\n\"OK\" - on success\n\n\"ERR:"
      "<error-code>:<error-message>\" - in case it failed, providing an appro"
      "priate error code and error message.\n\nExample:\n\nC: \"SET DB_INSTRU"
      "MENT FILE_PATH '/gigs/Bosendorfer 290.gig' '/gigs/pianos/Bosendorfer 2"
      "90.gig'\"\n\nS: \"OK\"\n\n"
    },
    { "SUBSCRIBE CHANNEL_MIDI",
      "Client may want to be notified when MIDI data arrive on sampler channe"
      "ls on back-end side, by issuing the following command:\n\nSUBSCRIBE CH"
      "ANNEL_MIDI\n\nServer will start sending one of the the following notif"
      "ication messages:\n\n\"NOTIFY:CHANNEL_MIDI:<channel-id> NOTE_ON <note>"
      " <velocity>\"\n\n\"NOTIFY:CHANNEL_MIDI:<channel-id> NOTE_OFF <note> <v"
      "elocity>\"\n\nwhere <channel-id> will be replaced by the ID of the sam"
      "pler channel where the MIDI data arrived. <note> and <velocity> are in"
      "teger values in the range between 0 .. 127, reflecting the analog mean"
      "ing of the MIDI specification.\n\nCAUTION: no guarantee whatsoever wil"
      "l be made that MIDI events are actually all delivered by this mechanis"
      "m! With other words: events could be lost at any time! This restrictio"
      "n was made to keep the RT-safeness of the backend's MIDI and audio thr"
      "ead unaffected by this feature.\n\n"
    },
    { "REMOVE CHANNEL MIDI_INPUT",
      "The front-end can remove one ore more MIDI input(s) on a specific samp"
      "ler channel by sending the following command:\n\nREMOVE CHANNEL MIDI_I"
      "NPUT <sampler-channel> [<midi-device-id> [<midi-input-port>]]\n\nWhere"
      " <sampler-channel> is the sampler channel number as returned by the \""
      "ADD CHANNEL\" or \"LIST CHANNELS\" command and <midi-device-id> and <m"
      "idi-input-port> are optional numerical IDs defining the MIDI input dev"
      "ice and one of its MIDI ports as returned by the \"LIST CHANNEL MIDI_I"
      "NPUTS\" command.\n\nIf <midi-input-port> is omitted, then all MIDI inp"
      "ut ports of <midi-device-id> are disconnected from this sampler channe"
      "l.\n\nIf both, <midi-device-id> and <midi-input-port> are omitted, the"
      "n all MIDI input ports currently connected to this sampler channel are"
      " disconnected from this sampler channel.\n\nPossible Answers:\n\n\"OK"
      "\" - on success\n\n\"WRN:<warning-code>:<warning-message>\" - if MIDI i"
      "nput porst were disconnected, but there are noteworthy issue(s) relate"
      "d, providing an appropriate warning code and warning message\n\n\"ERR:"
      "<error-code>:<error-message>\" - in case it failed, providing an appro"
      "priate error code and error message\n\nExamples:\n\nC: \"REMOVE CHANNE"
      "L MIDI_INPUT 0\"\n\nS: \"OK\"\n\nC: \"REMOVE CHANNEL MIDI_INPUT 1\"\n"
      "\nS: \"OK\"\n\nC: \"REMOVE CHANNEL MIDI_INPUT 1 2 0\"\n\nS: \"OK\"\n\nS"
      "ince:\n\nIntroduced with LSCP v1.6\n\n"
    },
    { "GET AVAILABLE_MIDI_INPUT_DRIVERS",
      "Use the following command to get the number of MIDI input drivers curr"
      "ently available for the LinuxSampler instance:\n\nGET AVAILABLE_MIDI_I"
      "NPUT_DRIVERS\n\nPossible Answers:\n\nLinuxSampler will answer by sendi"
      "ng the number of available MIDI input drivers.\n\nExample:\n\nC: \"GET"
      " AVAILABLE_MIDI_INPUT_DRIVERS\"\n\nS: \"2\"\n\n"
    },
    { "GET FILE INSTRUMENTS",
      "The front-end can retrieve the amount of instruments within a given in"
      "strument file by sending the following command:\n\nGET FILE INSTRUMENT"
      "S <filename>\n\nWhere <filename> is the name of the instrument file (e"
      "ncapsulated into apostrophes, supporting escape sequences as described"
      " in chapter \" Character Set and Escape Sequences \").\n\nThe sampler"
      "will try to ask all sampler engines, whether they support the given fi"
      "le and ask the first engine with a positive answer for the amount of i"
      "nstruments.\n\nPossible Answers:\n\nOn success, the sampler will answe"
      "r by returning the amount of instruments.\n\n\"ERR:<error-code>:<error"
      "-message>\" - if the file could not be handled\n\nExamples:\n\nC: \"GE"
      "T FILE INSTRUMENTS 'D:/Sounds/Foo.gig'\"\n\nS: \"10\"\n\n"
    },
    { "GET TOTAL_STREAM_COUNT",
      "The front-end can ask for the current number of active disk streams on"
      " the sampler by sending the following command:\n\nGET TOTAL_STREAM_COU"
      "NT\n\nPossible Answers:\n\nLinuxSampler will answer by returning the n"
      "umber of all active disk streams on the sampler.\n\n"
    },
    { "SUBSCRIBE MIDI_INSTRUMENT_MAP_COUNT",
      "Client may want to be notified when the number of MIDI instrument maps"
      " on the back-end changes by issuing the following command:\n\nSUBSCRIB"
      "E MIDI_INSTRUMENT_MAP_COUNT\n\nServer will start sending the following"
      " notification messages:\n\n\"NOTIFY:MIDI_INSTRUMENT_MAP_COUNT:<maps>\""
      "\n\nwhere <maps> will be replaced by the new number of MIDI instrument"
      " maps.\n\n"
    },
    { "GET AUDIO_OUTPUT_DRIVER INFO",
      "Use the following command to get detailed information about a specific"
      " audio output driver:\n\nGET AUDIO_OUTPUT_DRIVER INFO <audio-output-dr"
      "iver>\n\nWhere <audio-output-driver> is the name of the audio output d"
      "river, returned by the \"LIST AVAILABLE_AUDIO_OUTPUT_DRIVERS\" command"
      ".\n\nPossible Answers:\n\nLinuxSampler will answer by sending a <CRLF>"
      " separated list. Each answer line begins with the information category"
      " name followed by a colon and then a space character <SP> and finally"
      "the info character string to that info category. At the moment the fol"
      "lowing information categories are defined:\n\nDESCRIPTION - character"
      "string describing the audio output driver\n\nVERSION - character strin"
      "g reflecting the driver's version\n\nPARAMETERS - comma separated list"
      " of all parameters available for the given audio output driver, at lea"
      "st parameters 'channels', 'samplerate' and 'active' are offered by all"
      " audio output drivers\n\nThe mentioned fields above don't have to be i"
      "n particular order.\n\nExample:\n\nC: \"GET AUDIO_OUTPUT_DRIVER INFO A"
      "LSA\"\n\nS: \"DESCRIPTION: Advanced Linux Sound Architecture\"\n\n\"VE"
      "RSION: 1.0\"\n\n\"PARAMETERS: DRIVER,CHANNELS,SAMPLERATE,ACTIVE,FRAGME"
      "NTS, FRAGMENTSIZE,CARD\"\n\n\".\"\n\n"
    },
    { "SUBSCRIBE FX_SEND_INFO",
      "Client may want to be notified when changes were made to effect sends"
      "on a a particular sampler channel by issuing the following command:\n"
      "\nSUBSCRIBE FX_SEND_INFO\n\nServer will start sending the following not"
      "ification messages:\n\n\"NOTIFY:FX_SEND_INFO:<channel-id> <fx-send-id>"
      "\"\n\nwhere <channel-id> will be replaced by the numerical ID of the s"
      "ampler channel, on which an effect send entity is changed and <fx-send"
      "-id> will be replaced by the numerical ID of the changed effect send."
      "\n\n"
    },
    { "SUBSCRIBE DEVICE_MIDI",
      "Client may want to be notified when MIDI data arrive on MIDI input dev"
      "ices by issuing the following command:\n\nSUBSCRIBE DEVICE_MIDI\n\nSer"
      "ver will start sending one of the the following notification messages:"
      "\n\n\"NOTIFY:DEVICE_MIDI:<device-id> <port-id> NOTE_ON <note> <velocit"
      "y>\"\n\n\"NOTIFY:DEVICE_MIDI:<device-id> <port-id> NOTE_OFF <note> <ve"
      "locity>\"\n\nwhere <device-id> <port-id> will be replaced by the IDs o"
      "f the respective MIDI input device and the device's MIDI port where th"
      "e MIDI data arrived. <note> and <velocity> are integer values in the r"
      "ange between 0 .. 127, reflecting the analog meaning of the MIDI speci"
      "fication.\n\nCAUTION: no guarantee whatsoever will be made that MIDI e"
      "vents are actually all delivered by this mechanism! With other words:"
      "events could be lost at any time! This restriction was made to keep th"
      "e RT-safeness of the backend's MIDI and audio thread unaffected by thi"
      "s feature.\n\n"
    },
    { "SUBSCRIBE FX_SEND_COUNT",
      "Client may want to be notified when the number of effect sends on a pa"
      "rticular sampler channel is changed by issuing the following command:"
      "\n\nSUBSCRIBE FX_SEND_COUNT\n\nServer will start sending the following"
      "notification messages:\n\n\"NOTIFY:FX_SEND_COUNT:<channel-id> <fx-send"
      "s>\"\n\nwhere <channel-id> will be replaced by the numerical ID of the"
      " sampler channel, on which the effect sends number is changed and <fx-"
      "sends> will be replaced by the new number of effect sends on that chan"
      "nel.\n\n"
    },
    { "SUBSCRIBE MIDI_INSTRUMENT_MAP_INFO",
      "Client may want to be notified when changes were made to MIDI instrume"
      "nt maps on the back-end by issuing the following command:\n\nSUBSCRIBE"
      " MIDI_INSTRUMENT_MAP_INFO\n\nServer will start sending the following n"
      "otification messages:\n\n\"NOTIFY:MIDI_INSTRUMENT_MAP_INFO:<map-id>\""
      "\n\nwhere <map-id> will be replaced by the numerical ID of the MIDI ins"
      "trument map, for which information changes occurred. The front-end wil"
      "l have to send the respective command to actually get the MIDI instrum"
      "ent map info. Because these messages will be triggered by LSCP command"
      "s issued by other clients rather than real time events happening on th"
      "e server, it is believed that an empty notification message is suffici"
      "ent here.\n\n"
    },
    { "GET CHANNEL BUFFER_FILL",
      "The front-end can ask for the current fill state of all disk streams o"
      "n a sampler channel by sending the following command:\n\nGET CHANNEL B"
      "UFFER_FILL BYTES <sampler-channel>\n\nto get the fill state in bytes o"
      "r\n\nGET CHANNEL BUFFER_FILL PERCENTAGE <sampler-channel>\n\nto get th"
      "e fill state in percent, where <sampler-channel> is the sampler channe"
      "l number the front-end is interested in as returned by the \"ADD CHANN"
      "EL\" or \"LIST CHANNELS\" command.\n\nPossible Answers:\n\nLinuxSample"
      "r will either answer by returning a comma separated string with the fi"
      "ll state of all disk stream buffers on that channel or an empty line i"
      "f there are no active disk streams or \"NA\" for *not available* in ca"
      "se the engine which is deployed doesn't support disk streaming. Each e"
      "ntry in the answer list will begin with the stream's ID in brackets fo"
      "llowed by the numerical representation of the fill size (either in byt"
      "es or percentage). Note: due to efficiency reasons the fill states in"
      "the response are not in particular order, thus the front-end has to so"
      "rt them by itself if necessary.\n\nExamples:\n\nC: \"GET CHANNEL BUFFE"
      "R_FILL BYTES 4\"\n\nS: \"[115]420500,[116]510300,[75]110000,[120]23070"
      "0\"\n\nC: \"GET CHANNEL BUFFER_FILL PERCENTAGE 4\"\n\nS: \"[115]90%,[1"
      "16]98%,[75]40%,[120]62%\"\n\nC: \"GET CHANNEL BUFFER_FILL PERCENTAGE 4"
      "\"\n\nS: \"\"\n\n"
    },
    { "SUBSCRIBE DB_INSTRUMENT_DIRECTORY_INFO",
      "Client may want to be notified when changes were made to directories i"
      "n the instruments database by issuing the following command:\n\nSUBSCR"
      "IBE DB_INSTRUMENT_DIRECTORY_INFO\n\nServer will start sending the foll"
      "owing notification messages:\n\n\"NOTIFY:DB_INSTRUMENT_DIRECTORY_INFO:"
      "<dir-path>\"\n\nwhere <dir-path> will be replaced by the absolute path"
      " name of the directory, for which information changes occurred. The fr"
      "ont-end will have to send the respective command to actually get the u"
      "pdated directory info. Because these messages will be triggered by LSC"
      "P commands issued by other clients rather than real time events happen"
      "ing on the server, it is believed that an empty notification message i"
      "s sufficient here.\n\n\"NOTIFY:DB_INSTRUMENT_DIRECTORY_INFO:NAME <old-"
      "dir-path> <new-name>\"\n\nwhere <old-dir-path> is the old absolute pat"
      "h name of the directory (encapsulated into apostrophes), which name is"
      " changes and <new-name> is the new name of the directory, encapsulated"
      " into apostrophes.\n\n"
    },
    { "LIST DB_INSTRUMENT_DIRECTORIES",
      "The front-end can retrieve the current list of directories in specific"
      " directory by sending the following command:\n\nLIST DB_INSTRUMENT_DIR"
      "ECTORIES [RECURSIVE] <dir>\n\nWhere <dir> should be replaced by the ab"
      "solute path name of the directory. If RECURSIVE is specified, the abso"
      "lute path names of all directories, including those located in subdire"
      "ctories of the specified directory, will be returned.\n\nPossible Answ"
      "ers:\n\nA comma separated list of all instrument directories (encapsul"
      "ated into apostrophes) in the specified directory.\n\n\"ERR:<error-cod"
      "e>:<error-message>\" - if the given directory does not exist.\n\nExamp"
      "le:\n\nC: \"LIST DB_INSTRUMENT_DIRECTORIES '/'\"\n\nS: \"'Piano Collec"
      "tion','Percussion Collection'\"\n\nC: \"LIST DB_INSTRUMENT_DIRECTORIES"
      " RECURSIVE '/'\"\n\nS: \"'/Piano Collection','/Piano Collection/Acoust"
      "ic','/Piano Collection/Acoustic/New','/Percussion Collection'\"\n\n"
    },
    { "FIND DB_INSTRUMENTS",
      "The front-end can search for instruments in specific directory by send"
      "ing the following command:\n\nFIND DB_INSTRUMENTS [NON_RECURSIVE] <dir"
      "> <criteria-list>\n\nWhere <dir> should be replaced by the absolute pa"
      "th name of the directory to search in. If NON_RECURSIVE is specified,"
      "the directories located in subdirectories of the specified directory w"
      "ill not be searched. <criteria-list> is a list of search criterias in"
      "form of \"key1=val1 key2=val2 ...\". The following criterias are allow"
      "ed:\n\nNAME='<search-string>' Restricts the search to instruments, whi"
      "ch names satisfy the supplied search string (encapsulated into apostro"
      "phes, supporting escape sequences as described in chapter \" Character"
      " Set and Escape Sequences \").\n\nSIZE=[<min>]..[<max>] Restricts the"
      "search to instruments, which size is in the specified range. If <min>"
      "is omitted, the search results are restricted to instruments with size"
      " less then or equal to <max>. If <max> is omitted, the search is restr"
      "icted to instruments with size greater then or equal to <min>.\n\nCREA"
      "TED='[<date-after>]..[<date-before>]' Restricts the search to instrume"
      "nts, which creation date satisfies the specified period, where <date-a"
      "fter> and <date-before> are in \"YYYY-MM-DD HH:MM:SS\" format. If <dat"
      "e-after> is omitted the search is restricted to instruments created be"
      "fore <date-before>. If <date-before> is omitted, the search is restric"
      "ted to instruments created after <date-after>.\n\nMODIFIED='[<date-aft"
      "er>]..[<date-before>]' Restricts the search to instruments, which date"
      " of last modification satisfies the specified period, where <date-afte"
      "r> and <date-before> are in \"YYYY-MM-DD HH:MM:SS\" format. If <date-a"
      "fter> is omitted the search is restricted to instruments, which are la"
      "st modified before <date-before>. If <date-before> is omitted, the sea"
      "rch is restricted to instruments, which are last modified after <date-"
      "after>.\n\nDESCRIPTION='<search-string>' Restricts the search to instr"
      "uments with description that satisfies the supplied search string (enc"
      "apsulated into apostrophes, supporting escape sequences as described i"
      "n chapter \" Character Set and Escape Sequences \").\n\nPRODUCT='<sear"
      "ch-string>' Restricts the search to instruments with product info that"
      " satisfies the supplied search string (encapsulated into apostrophes,"
      "supporting escape sequences as described in chapter \" Character Set a"
      "nd Escape Sequences \").\n\nARTISTS='<search-string>' Restricts the se"
      "arch to instruments with artists info that satisfies the supplied sear"
      "ch string (encapsulated into apostrophes, supporting escape sequences"
      "as described in chapter \" Character Set and Escape Sequences \").\n\n"
      "KEYWORDS='<search-string>' Restricts the search to instruments with ke"
      "yword list that satisfies the supplied search string (encapsulated int"
      "o apostrophes, supporting escape sequences as described in chapter \""
      "Character Set and Escape Sequences \").\n\nIS_DRUM=true | false Either"
      " true or false. Restricts the search to drum kits or chromatic instrum"
      "ents.\n\nFORMAT_FAMILIES='<format-list>' Restricts the search to instr"
      "uments of the supplied format families, where <format-list> is a comma"
      " separated list of format families.\n\nWhere <search-string> is either"
      " a regular expression, or a word list separated with spaces for OR sea"
      "rch and with '+' for AND search.\n\nPossible Answers:\n\nA comma separ"
      "ated list with the absolute path names (encapsulated into apostrophes)"
      " of all instruments in the specified directory that satisfy the suppli"
      "ed search criterias.\n\n\"ERR:<error-code>:<error-message>\" - if the"
      "given directory does not exist.\n\nExample:\n\nC: \"FIND DB_INSTRUMENT"
      "S '/Piano Collection' NAME='bosendorfer+290'\"\n\nS: \"'/Piano Collect"
      "ion/Bosendorfer 290'\"\n\nC: \"FIND DB_INSTRUMENTS '/Piano Collection'"
      " CREATED='2007-04-01 09:30:13..'\"\n\nS: \"'/Piano Collection/Bosendor"
      "fer 290','/Piano Collection/Steinway D'\"\n\n"
    },
    { "DESTROY MIDI_INPUT_DEVICE",
      "Use the following command to destroy a created MIDI input device:\n\nD"
      "ESTROY MIDI_INPUT_DEVICE <device-id>\n\nWhere <device-id> should be re"
      "placed by the device's numerical ID as returned by the \"CREATE MIDI_I"
      "NPUT_DEVICE\" or \"LIST MIDI_INPUT_DEVICES\" command.\n\nPossible Answ"
      "ers:\n\n\"OK\" - in case the device was successfully destroyed\n\n\"WR"
      "N:<warning-code>:<warning-message>\" - in case the device was destroye"
      "d, but there are noteworthy issue(s) related, providing an appropriate"
      " warning code and warning message\n\n\"ERR:<error-code>:<error-message"
      ">\" - in case it failed, providing an appropriate error code and error"
      " message\n\nExample:\n\nC: \"DESTROY MIDI_INPUT_DEVICE 0\"\n\nS: \"OK"
      "\"\n\n"
    },
    { "DESTROY FX_SEND",
      "The front-end can remove an existing effect send on a specific sampler"
      " channel by sending the following command:\n\nDESTROY FX_SEND <sampler"
      "-channel> <fx-send-id>\n\nWhere <sampler-channel> is the respective sa"
      "mpler channel number as returned by the \"ADD CHANNEL\" or \"LIST CHAN"
      "NELS\" command, that is the sampler channel from which the effect send"
      " should be removed from and <fx-send-id> is the respective effect send"
      " number as returned by the \"CREATE FX_SEND\" or \"LIST FX_SENDS\" com"
      "mand.\n\nPossible Answers:\n\n\"OK\" - on success\n\n\"ERR:<error-code"
      ">:<error-message>\" - in case it failed, providing an appropriate erro"
      "r code and error message\n\nExample:\n\nC: \"DESTROY FX_SEND 0 0\"\n\n"
      "S: \"OK\"\n\n"
    },
    { "SUBSCRIBE SEND_EFFECT_CHAIN_INFO",
      "Client may want to be notified when changes were made to send effect c"
      "hains on the back-end by issuing the following command:\n\nSUBSCRIBE S"
      "END_EFFECT_CHAIN_INFO\n\nServer will start sending the following notif"
      "ication messages:\n\n\"SEND_EFFECT_CHAIN_INFO:<device-id> <chain-id> <"
      "instances>\" - Notifies that the number of effect instances in a parti"
      "cular send effect chain is changed, where <device-id> will be replaced"
      " by the numerical ID of the audio output device the send effect chain"
      "belongs to, <chain-id> will be replaced by the numerical ID of the sen"
      "d effect chain in which the number of effect instances has changed and"
      " <instances> will be replaced by the new number of effect instances in"
      " the specified send effect chain.\n\n"
    },
    { "GET SEND_EFFECT_CHAINS",
      "The front-end can retrieve the current amount of send effect chains of"
      " an audio output device by sending the following command:\n\nGET SEND_"
      "EFFECT_CHAINS <audio-device>\n\nWhere <audio-device> should be replace"
      "d by the numerical ID of the audio output device as given by the \"CRE"
      "ATE AUDIO_OUTPUT_DEVICE\" or \"LIST AUDIO_OUTPUT_DEVICES\" command.\n"
      "\nPossible Answers:\n\nThe sampler will answer by returning the current"
      " number of send effect chains of the supplied audio output device.\n\n"
      "Examples:\n\nC: \"GET SEND_EFFECT_CHAINS 0\"\n\nS: \"4\"\n\n"
    },
    { "SET CHANNEL MIDI_INPUT_PORT",
      "DEPRECATED: THIS COMMAND WILL DISAPPEAR!\n\nThe front-end can alter th"
      "e MIDI input port on a specific sampler channel by sending the followi"
      "ng command:\n\nSET CHANNEL MIDI_INPUT_PORT <sampler-channel> <midi-inp"
      "ut-port>\n\nWhere <midi-input-port> is a MIDI input port number of the"
      " MIDI input device connected to the sampler channel given by <sampler-"
      "channel>.\n\nIf more than 1 MIDI inputs are currently connected to thi"
      "s sampler channel: Sending this command will switch the connection of"
      "the first (and only the first) MIDI input port currently being connect"
      "ed to this sampler channel, to another port of the same MIDI input dev"
      "ice. Or in other words: the first MIDI input port currently connected"
      "to this sampler channel will be disconnected, and the requested other"
      "port of its MIDI input device will be connected to this sampler channe"
      "l instead. This behavior is due to preserving full behavior backward c"
      "ompatibility.\n\nPossible Answers:\n\n\"OK\" - on success\n\n\"WRN:<wa"
      "rning-code>:<warning-message>\" - if MIDI input port was set, but ther"
      "e are noteworthy issue(s) related, providing an appropriate warning co"
      "de and warning message\n\n\"ERR:<error-code>:<error-message>\" - in ca"
      "se it failed, providing an appropriate error code and error message\n"
      "\nExamples:\n\n\n\nDeprecated:\n\nShould not be used anymore. This comm"
      "and is currently only preserved for backward compatibility.\n\nThis co"
      "mmand is a relict from times where only one MIDI input per sampler cha"
      "nnel was allowed. Use \"ADD CHANNEL MIDI_INPUT\" and \"REMOVE CHANNEL"
      "MIDI_INPUT\" instead.\n\n"
    },
    { "GET MIDI_INPUT_DEVICE INFO",
      "Use the following command to get current settings of a specific, creat"
      "ed MIDI input device:\n\nGET MIDI_INPUT_DEVICE INFO <device-id>\n\nWhe"
      "re <device-id> is the numerical ID of the MIDI input device as returne"
      "d by the \"CREATE MIDI_INPUT_DEVICE\" or \"LIST MIDI_INPUT_DEVICES\" c"
      "ommand.\n\nPossible Answers:\n\nLinuxSampler will answer by sending a"
      "<CRLF> separated list. Each answer line begins with the information ca"
      "tegory name followed by a colon and then a space character <SP> and fi"
      "nally the info character string to that info category. As some paramet"
      "ers might allow multiple values, character strings are encapsulated in"
      "to apostrophes ('). At the moment the following information categories"
      " are defined (independent of driver):\n\nDRIVER - identifier of the us"
      "ed MIDI input driver, as e.g. returned by the \"LIST AVAILABLE_MIDI_IN"
      "PUT_DRIVERS\" command\n\nACTIVE - either true or false, if false then"
      "the MIDI device is inactive and doesn't listen to any incoming MIDI ev"
      "ents and thus doesn't forward them to connected sampler channels\n\nTh"
      "e mentioned fields above don't have to be in particular order. The fie"
      "lds above are only those fields which are returned by all MIDI input d"
      "evices. Every MIDI input driver might have its own, additional driver"
      "specific parameters (see \"GET MIDI_INPUT_DRIVER INFO\" command) which"
      " are also returned by this command.\n\nExample:\n\nC: \"GET MIDI_INPUT"
      "_DEVICE INFO 0\"\n\nS: \"DRIVER: ALSA\"\n\n\"ACTIVE: true\"\n\n\".\"\n"
      "\n"
    },
    { "SET MIDI_INPUT_DEVICE_PARAMETER",
      "Use the following command to alter a specific setting of a created MID"
      "I input device:\n\nSET MIDI_INPUT_DEVICE_PARAMETER <device-id> <key>=<"
      "value>\n\nWhere <device-id> should be replaced by the numerical ID of"
      "the MIDI input device as returned by the \"CREATE MIDI_INPUT_DEVICE\""
      "or \"LIST MIDI_INPUT_DEVICES\" command, <key> by the name of the param"
      "eter to change and <value> by the new value for this parameter.\n\nPos"
      "sible Answers:\n\n\"OK\" - in case setting was successfully changed\n"
      "\n\"WRN:<warning-code>:<warning-message>\" - in case setting was change"
      "d successfully, but there are noteworthy issue(s) related, providing a"
      "n appropriate warning code and warning message\n\n\"ERR:<error-code>:<"
      "error-message>\" - in case it failed, providing an appropriate error c"
      "ode and error message\n\nExample:\n\nC: \"SET MIDI_INPUT_DEVICE_PARAME"
      "TER 0 ACTIVE=false\"\n\nS: \"OK\"\n\n"
    },
    { "SUBSCRIBE EFFECT_INSTANCE_COUNT",
      "Client may want to be notified when the number of effect instances is"
      "changed by issuing the following command:\n\nSUBSCRIBE EFFECT_INSTANCE"
      "_COUNT\n\nServer will start sending the following notification message"
      "s:\n\n\"EFFECT_INSTANCE_COUNT:<instances>\"\n\nwhere <instances> will"
      "be replaced by the new number of effect instances.\n\n"
    },
    { "LIST EFFECT_INSTANCES",
      "The front-end can retrieve the current list of effect instances by sen"
      "ding the following command:\n\nLIST EFFECT_INSTANCES\n\nPossible Answe"
      "rs:\n\nThe sampler will answer by returning a comma separated list wit"
      "h numerical IDs of effects instances.\n\nExample:\n\nC: \"LIST EFFECT_"
      "INSTANCES\"\n\nS: \"9,11,14,15,16,17,25\"\n\n"
    },
    { "GET MIDI_INPUT_DRIVER_PARAMETER INFO",
      "Use the following command to get detailed information about a specific"
      " parameter of a specific MIDI input driver:\n\nGET MIDI_INPUT_DRIVER_P"
      "ARAMETER INFO <midit> <param> [<deplist>]\n\nWhere <midit> is the name"
      " of the MIDI input driver as returned by the \"LIST AVAILABLE_MIDI_INP"
      "UT_DRIVERS\" command, <param> a specific parameter name for which info"
      "rmation should be obtained (as returned by the \"GET MIDI_INPUT_DRIVER"
      " INFO\" command) and <deplist> is an optional list of parameters on wh"
      "ich the sought parameter <param> depends on, <deplist> is a key-value"
      "pair list in form of \"key1=val1 key2=val2 ...\", where character stri"
      "ng values are encapsulated into apostrophes ('). Arguments given with"
      "<deplist> which are not dependency parameters of <param> will be ignor"
      "ed, means the front-end application can simply put all parameters in <"
      "deplist> with the values selected by the user.\n\nPossible Answers:\n"
      "\nLinuxSampler will answer by sending a <CRLF> separated list. Each ans"
      "wer line begins with the information category name followed by a colon"
      " and then a space character <SP> and finally the info character string"
      " to that info category. There is information which is always returned,"
      " independent of the given driver parameter and there is optional infor"
      "mation which is only shown dependent to given driver parameter. At the"
      " moment the following information categories are defined:\n\nTYPE - ei"
      "ther \"BOOL\" for boolean value(s) or \"INT\" for integer value(s) or"
      "\"FLOAT\" for dotted number(s) or \"STRING\" for character string(s) ("
      "always returned, no matter which driver parameter)\n\nDESCRIPTION - ar"
      "bitrary text describing the purpose of the parameter (always returned,"
      " no matter which driver parameter)\n\nMANDATORY - either true or false"
      ", defines if this parameter must be given when the device is to be cre"
      "ated with the 'CREATE MIDI_INPUT_DEVICE' command (always returned, no"
      "matter which driver parameter)\n\nFIX - either true or false, if false"
      " then this parameter can be changed at any time, once the device is cr"
      "eated by the 'CREATE MIDI_INPUT_DEVICE' command (always returned, no m"
      "atter which driver parameter)\n\nMULTIPLICITY - either true or false,"
      "defines if this parameter allows only one value or a list of values, w"
      "here true means multiple values and false only a single value allowed"
      "(always returned, no matter which driver parameter)\n\nDEPENDS - comma"
      " separated list of parameters this parameter depends on, means the val"
      "ues for fields 'DEFAULT', 'RANGE_MIN', 'RANGE_MAX' and 'POSSIBILITIES'"
      " might depend on these listed parameters, for example assuming that an"
      " audio driver (like the ALSA driver) offers parameters 'card' and 'sam"
      "plerate' then parameter 'samplerate' would depend on 'card' because th"
      "e possible values for 'samplerate' depends on the sound card which can"
      " be chosen by the 'card' parameter (optionally returned, dependent to"
      "driver parameter)\n\nDEFAULT - reflects the default value for this par"
      "ameter which is used when the device is created and not explicitly giv"
      "en with the 'CREATE MIDI_INPUT_DEVICE' command, in case of MULTIPLCITY"
      "=true, this is a comma separated list, that's why character strings ar"
      "e encapsulated into apostrophes (') (optionally returned, dependent to"
      " driver parameter)\n\nRANGE_MIN - defines lower limit of the allowed v"
      "alue range for this parameter, can be an integer value as well as a do"
      "tted number, this parameter is often used in conjunction with RANGE_MA"
      "X, but may also appear without (optionally returned, dependent to driv"
      "er parameter)\n\nRANGE_MAX - defines upper limit of the allowed value"
      "range for this parameter, can be an integer value as well as a dotted"
      "number, this parameter is often used in conjunction with RANGE_MIN, bu"
      "t may also appear without (optionally returned, dependent to driver pa"
      "rameter)\n\nPOSSIBILITIES - comma separated list of possible values fo"
      "r this parameter, character strings are encapsulated into apostrophes"
      "(optionally returned, dependent to driver parameter)\n\nThe mentioned"
      "fields above don't have to be in particular order.\n\nExample:\n\nC: "
      "\"GET MIDI_INPUT_DRIVER_PARAMETER INFO ALSA ACTIVE\"\n\nS: \"DESCRIPTIO"
      "N: Whether device is enabled\"\n\n\"TYPE: BOOL\"\n\n\"MANDATORY: false"
      "\"\n\n\"FIX: false\"\n\n\"MULTIPLICITY: false\"\n\n\"DEFAULT: true\"\n"
      "\n\".\"\n\n"
    },
};

lscp_ref_entry_t* lscp_reference_for_command(const char* cmd) {
    const int n1 = (int)strlen(cmd);
    if (!n1) return NULL;
    int foundLength = 0;
    lscp_ref_entry_t* foundEntry = NULL;
    for (int i = 0; i < sizeof(lscp_reference) / sizeof(lscp_ref_entry_t); ++i) {
        const int n2 = (int)strlen(lscp_reference[i].name);
        const int n = n1 < n2 ? n1 : n2;
        if (!strncmp(cmd, lscp_reference[i].name, n)) {
            if (foundEntry) {
                if (n1 < foundLength && n1 < n2) return NULL;
                if (n2 == foundLength) return NULL;
                if (n2 < foundLength) continue;
            }
            foundEntry  = &lscp_reference[i];
            foundLength = n2;
        }
    }
    return foundEntry;
}
