/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.protocol.util;

import com.google.common.base.Strings;
import com.velocitypowered.proxy.protocol.netty.MinecraftDecoder;
import com.velocitypowered.proxy.util.except.QuietDecoderException;
import io.netty.handler.codec.CorruptedFrameException;

public final class NettyPreconditions {
    private static final QuietDecoderException BAD = new QuietDecoderException("Invalid packet received. Launch Velocity with -Dvelocity.packet-decode-logging=true to see more.");

    private NettyPreconditions() {
        throw new AssertionError();
    }

    public static void checkFrame(boolean b, String message) {
        if (!b) {
            throw MinecraftDecoder.DEBUG ? new CorruptedFrameException(message) : BAD;
        }
    }

    public static void checkFrame(boolean b, String message, Object arg1) {
        if (!b) {
            if (MinecraftDecoder.DEBUG) {
                throw new CorruptedFrameException(Strings.lenientFormat(message, arg1));
            }
            throw BAD;
        }
    }

    public static void checkFrame(boolean b, String message, Object arg1, Object arg2) {
        if (!b) {
            if (MinecraftDecoder.DEBUG) {
                throw new CorruptedFrameException(Strings.lenientFormat(message, arg1, arg2));
            }
            throw BAD;
        }
    }

    public static void checkFrame(boolean b, String message, Object ... args) {
        if (!b) {
            if (MinecraftDecoder.DEBUG) {
                throw new CorruptedFrameException(Strings.lenientFormat(message, args));
            }
            throw BAD;
        }
    }
}

