/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.protocol.packet;

import com.velocitypowered.api.network.ProtocolVersion;
import com.velocitypowered.proxy.connection.MinecraftSessionHandler;
import com.velocitypowered.proxy.protocol.MinecraftPacket;
import com.velocitypowered.proxy.protocol.ProtocolUtils;
import io.netty.buffer.ByteBuf;
import org.checkerframework.checker.nullness.qual.Nullable;

public class ClientSettings
implements MinecraftPacket {
    private @Nullable String locale;
    private byte viewDistance;
    private int chatVisibility;
    private boolean chatColors;
    private byte difficulty;
    private short skinParts;
    private int mainHand;
    private boolean chatFilteringEnabled;

    public ClientSettings() {
    }

    public ClientSettings(String locale, byte viewDistance, int chatVisibility, boolean chatColors, short skinParts, int mainHand, boolean chatFilteringEnabled) {
        this.locale = locale;
        this.viewDistance = viewDistance;
        this.chatVisibility = chatVisibility;
        this.chatColors = chatColors;
        this.skinParts = skinParts;
        this.mainHand = mainHand;
    }

    public String getLocale() {
        if (this.locale == null) {
            throw new IllegalStateException("No locale specified");
        }
        return this.locale;
    }

    public void setLocale(String locale) {
        this.locale = locale;
    }

    public byte getViewDistance() {
        return this.viewDistance;
    }

    public void setViewDistance(byte viewDistance) {
        this.viewDistance = viewDistance;
    }

    public int getChatVisibility() {
        return this.chatVisibility;
    }

    public void setChatVisibility(int chatVisibility) {
        this.chatVisibility = chatVisibility;
    }

    public boolean isChatColors() {
        return this.chatColors;
    }

    public void setChatColors(boolean chatColors) {
        this.chatColors = chatColors;
    }

    public short getSkinParts() {
        return this.skinParts;
    }

    public void setSkinParts(short skinParts) {
        this.skinParts = skinParts;
    }

    public int getMainHand() {
        return this.mainHand;
    }

    public void setMainHand(int mainHand) {
        this.mainHand = mainHand;
    }

    public boolean isChatFilteringEnabled() {
        return this.chatFilteringEnabled;
    }

    public void setChatFilteringEnabled(boolean chatFilteringEnabled) {
        this.chatFilteringEnabled = chatFilteringEnabled;
    }

    public String toString() {
        return "ClientSettings{locale='" + this.locale + '\'' + ", viewDistance=" + this.viewDistance + ", chatVisibility=" + this.chatVisibility + ", chatColors=" + this.chatColors + ", skinParts=" + this.skinParts + ", mainHand=" + this.mainHand + ", chatFilteringEnabled=" + this.chatFilteringEnabled + '}';
    }

    @Override
    public void decode(ByteBuf buf, ProtocolUtils.Direction direction, ProtocolVersion version) {
        this.locale = ProtocolUtils.readString(buf, 16);
        this.viewDistance = buf.readByte();
        this.chatVisibility = ProtocolUtils.readVarInt(buf);
        this.chatColors = buf.readBoolean();
        if (version.compareTo(ProtocolVersion.MINECRAFT_1_7_6) <= 0) {
            this.difficulty = buf.readByte();
        }
        this.skinParts = buf.readUnsignedByte();
        if (version.compareTo(ProtocolVersion.MINECRAFT_1_9) >= 0) {
            this.mainHand = ProtocolUtils.readVarInt(buf);
            if (version.compareTo(ProtocolVersion.MINECRAFT_1_17) >= 0) {
                this.chatFilteringEnabled = buf.readBoolean();
            }
        }
    }

    @Override
    public void encode(ByteBuf buf, ProtocolUtils.Direction direction, ProtocolVersion version) {
        if (this.locale == null) {
            throw new IllegalStateException("No locale specified");
        }
        ProtocolUtils.writeString(buf, this.locale);
        buf.writeByte(this.viewDistance);
        ProtocolUtils.writeVarInt(buf, this.chatVisibility);
        buf.writeBoolean(this.chatColors);
        if (version.compareTo(ProtocolVersion.MINECRAFT_1_7_6) <= 0) {
            buf.writeByte(this.difficulty);
        }
        buf.writeByte(this.skinParts);
        if (version.compareTo(ProtocolVersion.MINECRAFT_1_9) >= 0) {
            ProtocolUtils.writeVarInt(buf, this.mainHand);
            if (version.compareTo(ProtocolVersion.MINECRAFT_1_17) >= 0) {
                buf.writeBoolean(this.chatFilteringEnabled);
            }
        }
    }

    @Override
    public boolean handle(MinecraftSessionHandler handler) {
        return handler.handle(this);
    }
}

