/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.command.builtin;

import com.google.common.collect.ImmutableList;
import com.velocitypowered.api.command.CommandSource;
import com.velocitypowered.api.command.SimpleCommand;
import com.velocitypowered.api.permission.Tristate;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.ProxyServer;
import com.velocitypowered.api.proxy.ServerConnection;
import com.velocitypowered.api.proxy.server.RegisteredServer;
import com.velocitypowered.api.proxy.server.ServerInfo;
import com.velocitypowered.proxy.command.builtin.BuiltinCommandUtil;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.kyori.adventure.identity.Identity;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;

public class ServerCommand
implements SimpleCommand {
    public static final int MAX_SERVERS_TO_LIST = 50;
    private final ProxyServer server;

    public ServerCommand(ProxyServer server) {
        this.server = server;
    }

    @Override
    public void execute(SimpleCommand.Invocation invocation) {
        CommandSource source = invocation.source();
        String[] args = (String[])invocation.arguments();
        if (!(source instanceof Player)) {
            source.sendMessage(Identity.nil(), (Component)Component.text("Only players may run this command.", (TextColor)NamedTextColor.RED));
            return;
        }
        Player player = (Player)source;
        if (args.length == 1) {
            String serverName = args[0];
            Optional<RegisteredServer> toConnect = this.server.getServer(serverName);
            if (!toConnect.isPresent()) {
                player.sendMessage(Identity.nil(), (Component)Component.text("Server " + serverName + " doesn't exist.", (TextColor)NamedTextColor.RED));
                return;
            }
            player.createConnectionRequest(toConnect.get()).fireAndForget();
        } else {
            this.outputServerInformation(player);
        }
    }

    private void outputServerInformation(Player executor) {
        String currentServer = executor.getCurrentServer().map(ServerConnection::getServerInfo).map(ServerInfo::getName).orElse("<unknown>");
        executor.sendMessage(Identity.nil(), (Component)Component.text("You are currently connected to " + currentServer + ".", (TextColor)NamedTextColor.YELLOW));
        List<RegisteredServer> servers = BuiltinCommandUtil.sortedServerList(this.server);
        if (servers.size() > 50) {
            executor.sendMessage(Identity.nil(), (Component)Component.text("Too many servers to list. Tab-complete to show all servers.", (TextColor)NamedTextColor.RED));
            return;
        }
        TextComponent.Builder serverListBuilder = (TextComponent.Builder)Component.text().content("Available servers: ").color(NamedTextColor.YELLOW);
        for (int i = 0; i < servers.size(); ++i) {
            RegisteredServer rs = servers.get(i);
            serverListBuilder.append((Component)this.formatServerComponent(currentServer, rs));
            if (i == servers.size() - 1) continue;
            serverListBuilder.append((Component)Component.text(", ", (TextColor)NamedTextColor.GRAY));
        }
        executor.sendMessage(Identity.nil(), (Component)serverListBuilder.build());
    }

    private TextComponent formatServerComponent(String currentPlayerServer, RegisteredServer server) {
        ServerInfo serverInfo = server.getServerInfo();
        TextComponent serverTextComponent = Component.text(serverInfo.getName());
        String playersText = server.getPlayersConnected().size() + " player(s) online";
        serverTextComponent = serverInfo.getName().equals(currentPlayerServer) ? (TextComponent)((TextComponent)serverTextComponent.color(NamedTextColor.GREEN)).hoverEvent(HoverEvent.showText(Component.text("Currently connected to this server\n" + playersText))) : (TextComponent)((TextComponent)((TextComponent)serverTextComponent.color(NamedTextColor.GRAY)).clickEvent(ClickEvent.runCommand("/server " + serverInfo.getName()))).hoverEvent(HoverEvent.showText(Component.text("Click to connect to this server\n" + playersText)));
        return serverTextComponent;
    }

    @Override
    public List<String> suggest(SimpleCommand.Invocation invocation) {
        String[] currentArgs = (String[])invocation.arguments();
        Stream<String> possibilities = this.server.getAllServers().stream().map(rs -> rs.getServerInfo().getName());
        if (currentArgs.length == 0) {
            return possibilities.collect(Collectors.toList());
        }
        if (currentArgs.length == 1) {
            return possibilities.filter(name -> name.regionMatches(true, 0, currentArgs[0], 0, currentArgs[0].length())).collect(Collectors.toList());
        }
        return ImmutableList.of();
    }

    @Override
    public boolean hasPermission(SimpleCommand.Invocation invocation) {
        return invocation.source().getPermissionValue("velocity.command.server") != Tristate.FALSE;
    }
}

