/*
 * Decompiled with CFR 0.152.
 */
package com.vladium.util.version;

import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class VersionStampTool {
    public static boolean USE_EXIT = true;
    private Calendar m_start;
    private Calendar m_end;
    private String m_format = "~Md.h~";
    private SimpleDateFormat m_formatter_D = new SimpleDateFormat("yyyy/MM/dd");
    private SimpleDateFormat m_formatter_T = new SimpleDateFormat("HH:mm:ss");
    private SimpleDateFormat m_formatter_d = new SimpleDateFormat("dd");
    private SimpleDateFormat m_formatter_h = new SimpleDateFormat("HH");
    private SimpleDateFormat m_formatter_m = new SimpleDateFormat("mm");
    private static final int S = 0;
    private static final int S1 = 1;
    private static final int S2 = 2;
    private static final int E = 3;
    private static final String s_escaped_chars = "nrtfb\\\"'";
    private static final String s_escaped_char_values = "\n\r\t\f\b\\\"'";
    private static final String EOL;
    private static final String s_usage;

    static {
        String _separator = System.getProperty("line.separator");
        EOL = _separator != null && _separator.length() > 0 ? _separator : "\n";
        s_usage = "usage: VersionStampTool options," + EOL + "where options are:" + EOL + EOL + "-format \"string\"" + EOL + " specifies output format string. Special tokens D, T, F, M, d, h and m are" + EOL + " processed inside ~-delimiters, everything else is passed through to" + EOL + " stdout. The token meanings are:" + EOL + "   D: full end date," + EOL + "   T: full end time," + EOL + "   F: end timestamp in format suitable for persisting in a file," + EOL + "   M: number of months between end and start date + 1," + EOL + "   d: day in month for the end date [1-31]," + EOL + "   h: hour in day for the end date [0-23]," + EOL + "   m: minute in hour for the end date [0-59]" + EOL + EOL + "-start \"yyyy/mm/dd\" | -fstart \"file\" | -istart" + EOL + "-end   \"yyyy/mm/dd\" | -fend   \"file\" | -iend" + EOL + " these specify respectively start and end timestamps in one of three" + EOL + " possible ways:" + EOL + " - via an explicit date string," + EOL + " - via reading the timestamp from a specified file [previously saved" + EOL + "   using 'F' token]," + EOL + " - via reading the timestamp from stdin [can be done for either start" + EOL + "   or end, but not for both]" + EOL;
    }

    public static void main(String[] args) {
        block3: {
            try {
                VersionStampTool _this = new VersionStampTool();
                _this.parseArgs(args);
                System.out.println(_this.format(_this.m_format));
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable t) {
                t.printStackTrace();
                if (!USE_EXIT) break block3;
                System.exit(1);
            }
        }
    }

    private synchronized void parseArgs(String[] args) throws Exception {
        if (args == null || args.length == 0) {
            throw new Exception(s_usage);
        }
        try {
            int a = 0;
            while (a < args.length) {
                String arg = args[a];
                if (arg != null) {
                    Object var8_9;
                    char ps;
                    String pathname;
                    String startTime;
                    String endTime;
                    InputStreamReader in;
                    if ("-format".equalsIgnoreCase(arg)) {
                        this.m_format = args[++a];
                    } else if ("-start".equalsIgnoreCase(arg)) {
                        this.setStartTime(args[++a]);
                    } else if ("-end".equalsIgnoreCase(arg)) {
                        this.setEndTime(args[++a]);
                    } else if ("-iend".equalsIgnoreCase(arg)) {
                        in = new InputStreamReader(System.in);
                        endTime = this.readFully(in).trim();
                        System.out.println("[" + endTime + "]");
                        this.setEndTime(Long.parseLong(endTime));
                    } else if ("-istart".equalsIgnoreCase(arg)) {
                        in = new InputStreamReader(System.in);
                        startTime = this.readFully(in).trim();
                        this.setStartTime(Long.parseLong(startTime));
                    } else if ("-fend".equalsIgnoreCase(arg)) {
                        in = null;
                        pathname = args[++a];
                        ps = File.separatorChar;
                        pathname = ps != '/' ? pathname.replace('/', ps) : pathname.replace('\\', ps);
                        try {
                            in = new FileReader(pathname);
                            endTime = this.readFully(in).trim();
                            this.setEndTime(Long.parseLong(endTime));
                        }
                        catch (Throwable throwable) {
                            var8_9 = null;
                            if (in != null) {
                                in.close();
                            }
                            throw throwable;
                        }
                        var8_9 = null;
                        if (in != null) {
                            in.close();
                        }
                    } else if ("-fstart".equalsIgnoreCase(arg)) {
                        in = null;
                        pathname = args[++a];
                        ps = File.separatorChar;
                        pathname = ps != '/' ? pathname.replace('/', ps) : pathname.replace('\\', ps);
                        try {
                            in = new FileReader(pathname);
                            startTime = this.readFully(in).trim();
                            this.setStartTime(Long.parseLong(startTime));
                        }
                        catch (Throwable throwable) {
                            var8_9 = null;
                            if (in != null) {
                                in.close();
                            }
                            throw throwable;
                        }
                        var8_9 = null;
                        if (in != null) {
                            in.close();
                        }
                    } else {
                        throw new Exception(s_usage);
                    }
                }
                ++a;
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new Exception(s_usage);
        }
        if (this.m_end == null) {
            this.setEndTime();
        }
    }

    private String readFully(Reader in) throws IOException {
        if (in == null) {
            return "";
        }
        CharArrayWriter out = new CharArrayWriter(32);
        char[] buf = new char[8192];
        int read = 0;
        while ((read = in.read(buf, 0, buf.length)) >= 0) {
            out.write(buf, 0, read);
            out.flush();
        }
        out.close();
        return out.toString();
    }

    private synchronized void setStartTime(String date) throws ParseException {
        if (this.m_start == null && date != null) {
            date = date.trim();
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy/MM/dd");
            Date start = formatter.parse(date);
            this.m_start = Calendar.getInstance(TimeZone.getTimeZone("CST"));
            this.m_start.setTime(start);
        }
    }

    private synchronized void setStartTime(long time) {
        if (this.m_start == null) {
            this.m_start = Calendar.getInstance(TimeZone.getTimeZone("CST"));
            this.m_start.setTime(new Date(time));
        }
    }

    private synchronized void setEndTime(String date) throws ParseException {
        if (this.m_end == null && date != null) {
            date = date.trim();
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy/MM/dd");
            Date end = formatter.parse(date);
            this.m_end = Calendar.getInstance(TimeZone.getTimeZone("CST"));
            this.m_end.setTime(end);
        }
    }

    private synchronized void setEndTime() {
        if (this.m_end == null) {
            this.m_end = Calendar.getInstance(TimeZone.getTimeZone("CST"));
            this.m_end.setTime(new Date());
        }
    }

    private synchronized void setEndTime(long time) {
        if (this.m_end == null) {
            this.m_end = Calendar.getInstance(TimeZone.getTimeZone("CST"));
            this.m_end.setTime(new Date(time));
        }
    }

    private String format(String input) throws Exception {
        if (input == null) {
            return "";
        }
        StringBuffer result = new StringBuffer();
        StringBuffer token = new StringBuffer();
        int return_state = -1;
        int scan = 0;
        int state = 0;
        block12: while (state != 3) {
            try {
                switch (state) {
                    case 0: {
                        char c = input.charAt(scan++);
                        if (c == '~') {
                            state = 1;
                            continue block12;
                        }
                        if (c == '\\') {
                            return_state = state;
                            state = 2;
                            continue block12;
                        }
                        result.append(c);
                        continue block12;
                    }
                    case 1: {
                        char c = input.charAt(scan++);
                        if (c == '~') {
                            state = 0;
                            result.append(this.formatLabel(token.toString()));
                            token.setLength(0);
                            continue block12;
                        }
                        if (c == '\\') {
                            return_state = state;
                            state = 2;
                            continue block12;
                        }
                        token.append(c);
                        continue block12;
                    }
                    case 2: {
                        StringBuffer b = return_state == 0 ? result : token;
                        char c = input.charAt(scan++);
                        int ei = s_escaped_chars.indexOf(c);
                        if (ei >= 0) {
                            b.append(s_escaped_char_values.charAt(ei));
                            state = return_state;
                            continue block12;
                        }
                        throw new Exception("index " + (scan - 1) + ": invalid escape char " + c);
                    }
                    default: {
                        throw new Exception("invalid parser state");
                    }
                }
            }
            catch (StringIndexOutOfBoundsException e) {
                switch (state) {
                    case 0: {
                        state = 3;
                        break;
                    }
                    case 1: {
                        throw new Exception("index " + (scan - 1) + ": unterminated token [" + token.toString() + "]");
                    }
                    case 2: {
                        throw new Exception("index " + (scan - 1) + ": unterminated escape sequence [" + token.toString() + "]");
                    }
                    default: {
                        throw new Exception("invalid parser state");
                    }
                }
            }
        }
        return result.toString();
    }

    private String formatLabel(String labelInput) throws Exception {
        if (labelInput == null || labelInput.length() == 0) {
            return "";
        }
        StringBuffer result = new StringBuffer("");
        int ci = 0;
        while (ci < labelInput.length()) {
            char c = labelInput.charAt(ci);
            switch (c) {
                case 'D': {
                    if (this.m_end != null) {
                        result.append(this.m_formatter_D.format(this.m_end.getTime()));
                        break;
                    }
                    throw new Exception("end date/time hasn't been set");
                }
                case 'T': {
                    if (this.m_end != null) {
                        result.append(this.m_formatter_T.format(this.m_end.getTime()));
                        break;
                    }
                    throw new Exception("end date/time hasn't been set");
                }
                case 'F': {
                    if (this.m_end != null) {
                        result.append(this.m_end.getTime().getTime());
                        break;
                    }
                    throw new Exception("end date/time hasn't been set");
                }
                case 'M': {
                    if (this.m_start != null && this.m_end != null) {
                        int months = 12 * (this.m_end.get(1) - this.m_start.get(1)) + (this.m_end.get(2) - this.m_start.get(2)) + 1;
                        result.append(months);
                        break;
                    }
                    throw new Exception("start or end date/time hasn't been set");
                }
                case 'd': {
                    if (this.m_end != null) {
                        result.append(this.m_formatter_d.format(this.m_end.getTime()));
                        break;
                    }
                    throw new Exception("end date/time hasn't been set");
                }
                case 'h': {
                    if (this.m_end != null) {
                        result.append(this.m_formatter_h.format(this.m_end.getTime()));
                        break;
                    }
                    throw new Exception("end date/time hasn't been set");
                }
                case 'm': {
                    if (this.m_end != null) {
                        result.append(this.m_formatter_m.format(this.m_end.getTime()));
                        break;
                    }
                    throw new Exception("end date/time hasn't been set");
                }
                default: {
                    result.append(c);
                }
            }
            ++ci;
        }
        return result.toString();
    }
}

