/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import proguard.AppView;
import proguard.ClassSpecificationVisitorFactory;
import proguard.Configuration;
import proguard.classfile.ClassPool;
import proguard.classfile.attribute.visitor.AllAttributeVisitor;
import proguard.classfile.attribute.visitor.AllBootstrapMethodInfoVisitor;
import proguard.classfile.attribute.visitor.AllExceptionInfoVisitor;
import proguard.classfile.attribute.visitor.AllInnerClassesInfoVisitor;
import proguard.classfile.attribute.visitor.AttributeNameFilter;
import proguard.classfile.attribute.visitor.AttributeProcessingFlagFilter;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.attribute.visitor.CodeAttributeToMethodVisitor;
import proguard.classfile.attribute.visitor.DebugAttributeVisitor;
import proguard.classfile.attribute.visitor.MultiAttributeVisitor;
import proguard.classfile.attribute.visitor.StackSizeComputer;
import proguard.classfile.constant.visitor.AllBootstrapMethodArgumentVisitor;
import proguard.classfile.constant.visitor.AllConstantVisitor;
import proguard.classfile.constant.visitor.BootstrapMethodHandleTraveler;
import proguard.classfile.constant.visitor.ConstantTagFilter;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.constant.visitor.MethodrefTraveler;
import proguard.classfile.editor.AccessFixer;
import proguard.classfile.editor.ClassReferenceFixer;
import proguard.classfile.editor.CodeAttributeEditor;
import proguard.classfile.editor.ConstantPoolShrinker;
import proguard.classfile.editor.InnerClassesAccessFixer;
import proguard.classfile.editor.InstructionSequencesReplacer;
import proguard.classfile.editor.MemberReferenceFixer;
import proguard.classfile.editor.MethodInvocationFixer;
import proguard.classfile.editor.PeepholeEditor;
import proguard.classfile.editor.StackSizeUpdater;
import proguard.classfile.instruction.visitor.AllInstructionVisitor;
import proguard.classfile.instruction.visitor.InstructionConstantVisitor;
import proguard.classfile.instruction.visitor.InstructionCounter;
import proguard.classfile.instruction.visitor.InstructionVisitor;
import proguard.classfile.instruction.visitor.MultiInstructionVisitor;
import proguard.classfile.util.BranchTargetFinder;
import proguard.classfile.util.MethodLinker;
import proguard.classfile.visitor.AllClassVisitor;
import proguard.classfile.visitor.AllFieldVisitor;
import proguard.classfile.visitor.AllMemberVisitor;
import proguard.classfile.visitor.AllMethodVisitor;
import proguard.classfile.visitor.BottomClassFilter;
import proguard.classfile.visitor.ClassAccessFilter;
import proguard.classfile.visitor.ClassCleaner;
import proguard.classfile.visitor.ClassCounter;
import proguard.classfile.visitor.ClassHierarchyTraveler;
import proguard.classfile.visitor.ClassPoolVisitor;
import proguard.classfile.visitor.ClassProcessingFlagFilter;
import proguard.classfile.visitor.ClassVersionFilter;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.DotClassClassVisitor;
import proguard.classfile.visitor.DynamicReturnedClassVisitor;
import proguard.classfile.visitor.ExceptionCounter;
import proguard.classfile.visitor.ExceptionHandlerConstantVisitor;
import proguard.classfile.visitor.FunctionalInterfaceFilter;
import proguard.classfile.visitor.InjectedClassFilter;
import proguard.classfile.visitor.MemberAccessFilter;
import proguard.classfile.visitor.MemberAccessFlagCleaner;
import proguard.classfile.visitor.MemberCounter;
import proguard.classfile.visitor.MemberDescriptorReferencedClassVisitor;
import proguard.classfile.visitor.MemberProcessingFlagFilter;
import proguard.classfile.visitor.MemberVisitor;
import proguard.classfile.visitor.MultiClassVisitor;
import proguard.classfile.visitor.MultiConstantVisitor;
import proguard.classfile.visitor.MultiMemberVisitor;
import proguard.classfile.visitor.ParallelAllClassVisitor;
import proguard.classfile.visitor.ReferencedClassVisitor;
import proguard.classfile.visitor.ReferencedMemberVisitor;
import proguard.evaluation.AssumeClassSpecificationVisitorFactory;
import proguard.evaluation.PartialEvaluator;
import proguard.evaluation.ReferenceTracingValueFactory;
import proguard.evaluation.value.BasicRangeValueFactory;
import proguard.evaluation.value.DetailedArrayValueFactory;
import proguard.evaluation.value.IdentifiedValueFactory;
import proguard.evaluation.value.ParticularValueFactory;
import proguard.io.ExtraDataEntryNameMap;
import proguard.optimize.BootstrapMethodArgumentShrinker;
import proguard.optimize.ConstantMemberFilter;
import proguard.optimize.ConstantParameterFilter;
import proguard.optimize.DuplicateInitializerFixer;
import proguard.optimize.DuplicateInitializerInvocationFixer;
import proguard.optimize.InfluenceFixpointVisitor;
import proguard.optimize.KeepMarker;
import proguard.optimize.KeptClassFilter;
import proguard.optimize.KeptMemberFilter;
import proguard.optimize.MemberDescriptorSpecializer;
import proguard.optimize.MemberReferenceGeneralizer;
import proguard.optimize.MethodDescriptorShrinker;
import proguard.optimize.MethodStaticizer;
import proguard.optimize.OptimizationInfoClassFilter;
import proguard.optimize.OptimizationInfoMemberFilter;
import proguard.optimize.ParameterShrinker;
import proguard.optimize.SideEffectVisitorMarkerFactory;
import proguard.optimize.TailRecursionSimplifier;
import proguard.optimize.TimedClassPoolVisitor;
import proguard.optimize.WriteOnlyFieldFilter;
import proguard.optimize.evaluation.EvaluationShrinker;
import proguard.optimize.evaluation.EvaluationSimplifier;
import proguard.optimize.evaluation.InstructionUsageMarker;
import proguard.optimize.evaluation.LoadingInvocationUnit;
import proguard.optimize.evaluation.ParameterTracingInvocationUnit;
import proguard.optimize.evaluation.SimpleEnumArrayPropagator;
import proguard.optimize.evaluation.SimpleEnumClassChecker;
import proguard.optimize.evaluation.SimpleEnumClassSimplifier;
import proguard.optimize.evaluation.SimpleEnumDescriptorSimplifier;
import proguard.optimize.evaluation.SimpleEnumUseChecker;
import proguard.optimize.evaluation.SimpleEnumUseSimplifier;
import proguard.optimize.evaluation.StoringInvocationUnit;
import proguard.optimize.evaluation.VariableOptimizer;
import proguard.optimize.info.AccessMethodMarker;
import proguard.optimize.info.BackwardBranchMarker;
import proguard.optimize.info.CatchExceptionMarker;
import proguard.optimize.info.CaughtClassMarker;
import proguard.optimize.info.ContainsConstructorsMarker;
import proguard.optimize.info.DotClassMarker;
import proguard.optimize.info.DynamicInvocationMarker;
import proguard.optimize.info.EscapingClassFilter;
import proguard.optimize.info.EscapingClassMarker;
import proguard.optimize.info.FinalFieldAssignmentMarker;
import proguard.optimize.info.InstanceofClassMarker;
import proguard.optimize.info.InstantiationClassMarker;
import proguard.optimize.info.MethodInvocationMarker;
import proguard.optimize.info.MutableBoolean;
import proguard.optimize.info.NoEscapingParametersMethodMarker;
import proguard.optimize.info.NoExternalReturnValuesMethodMarker;
import proguard.optimize.info.NoExternalSideEffectMethodMarker;
import proguard.optimize.info.NoSideEffectClassMarker;
import proguard.optimize.info.NoSideEffectMethodMarker;
import proguard.optimize.info.NonEmptyStackReturnMarker;
import proguard.optimize.info.NonPrivateMemberMarker;
import proguard.optimize.info.OptimizationCodeAttributeFilter;
import proguard.optimize.info.PackageVisibleMemberContainingClassMarker;
import proguard.optimize.info.PackageVisibleMemberInvokingClassMarker;
import proguard.optimize.info.ParameterEscapeMarker;
import proguard.optimize.info.ParameterUsageMarker;
import proguard.optimize.info.ProgramClassOptimizationInfoSetter;
import proguard.optimize.info.ProgramMemberOptimizationInfoSetter;
import proguard.optimize.info.ReadWriteFieldMarker;
import proguard.optimize.info.SideEffectMethodMarker;
import proguard.optimize.info.SimpleEnumFilter;
import proguard.optimize.info.SimpleEnumMarker;
import proguard.optimize.info.SuperInvocationMarker;
import proguard.optimize.info.SynchronizedBlockMethodMarker;
import proguard.optimize.info.UnusedParameterMethodFilter;
import proguard.optimize.info.UnusedParameterOptimizationInfoUpdater;
import proguard.optimize.info.WrapperClassMarker;
import proguard.optimize.peephole.ClassFinalizer;
import proguard.optimize.peephole.GotoCommonCodeReplacer;
import proguard.optimize.peephole.GotoGotoReplacer;
import proguard.optimize.peephole.GotoReturnReplacer;
import proguard.optimize.peephole.HorizontalClassMerger;
import proguard.optimize.peephole.InstructionSequenceConstants;
import proguard.optimize.peephole.MemberPrivatizer;
import proguard.optimize.peephole.MethodFinalizer;
import proguard.optimize.peephole.NoConstructorReferenceReplacer;
import proguard.optimize.peephole.RetargetedClassFilter;
import proguard.optimize.peephole.RetargetedInnerClassAttributeRemover;
import proguard.optimize.peephole.ShortMethodInliner;
import proguard.optimize.peephole.SingleInvocationMethodInliner;
import proguard.optimize.peephole.TargetClassChanger;
import proguard.optimize.peephole.UnreachableCodeRemover;
import proguard.optimize.peephole.UnreachableExceptionRemover;
import proguard.optimize.peephole.VariableShrinker;
import proguard.optimize.peephole.VerticalClassMerger;
import proguard.optimize.peephole.WrapperClassMerger;
import proguard.optimize.peephole.WrapperClassUseSimplifier;
import proguard.pass.Pass;
import proguard.util.ConstantMatcher;
import proguard.util.ListParser;
import proguard.util.NameParser;
import proguard.util.ProcessingFlagSetter;

public class Optimizer
implements Pass {
    private static final Logger logger = LogManager.getLogger(Optimizer.class);
    public static final String LIBRARY_GSON = "library/gson";
    private static final String CLASS_MARKING_FINAL = "class/marking/final";
    private static final String CLASS_UNBOXING_ENUM = "class/unboxing/enum";
    private static final String CLASS_MERGING_VERTICAL = "class/merging/vertical";
    private static final String CLASS_MERGING_HORIZONTAL = "class/merging/horizontal";
    private static final String CLASS_MERGING_WRAPPER = "class/merging/wrapper";
    private static final String FIELD_REMOVAL_WRITEONLY = "field/removal/writeonly";
    private static final String FIELD_MARKING_PRIVATE = "field/marking/private";
    private static final String FIELD_GENERALIZATION_CLASS = "field/generalization/class";
    private static final String FIELD_SPECIALIZATION_TYPE = "field/specialization/type";
    private static final String FIELD_PROPAGATION_VALUE = "field/propagation/value";
    private static final String METHOD_MARKING_PRIVATE = "method/marking/private";
    private static final String METHOD_MARKING_STATIC = "method/marking/static";
    private static final String METHOD_MARKING_FINAL = "method/marking/final";
    private static final String METHOD_MARKING_SYNCHRONIZED = "method/marking/synchronized";
    private static final String METHOD_REMOVAL_PARAMETER = "method/removal/parameter";
    private static final String METHOD_GENERALIZATION_CLASS = "method/generalization/class";
    private static final String METHOD_SPECIALIZATION_PARAMETER_TYPE = "method/specialization/parametertype";
    private static final String METHOD_SPECIALIZATION_RETURN_TYPE = "method/specialization/returntype";
    private static final String METHOD_PROPAGATION_PARAMETER = "method/propagation/parameter";
    private static final String METHOD_PROPAGATION_RETURNVALUE = "method/propagation/returnvalue";
    private static final String METHOD_INLINING_SHORT = "method/inlining/short";
    private static final String METHOD_INLINING_UNIQUE = "method/inlining/unique";
    private static final String METHOD_INLINING_TAILRECURSION = "method/inlining/tailrecursion";
    private static final String CODE_MERGING = "code/merging";
    private static final String CODE_SIMPLIFICATION_VARIABLE = "code/simplification/variable";
    private static final String CODE_SIMPLIFICATION_ARITHMETIC = "code/simplification/arithmetic";
    private static final String CODE_SIMPLIFICATION_CAST = "code/simplification/cast";
    private static final String CODE_SIMPLIFICATION_FIELD = "code/simplification/field";
    private static final String CODE_SIMPLIFICATION_BRANCH = "code/simplification/branch";
    private static final String CODE_SIMPLIFICATION_OBJECT = "code/simplification/object";
    private static final String CODE_SIMPLIFICATION_STRING = "code/simplification/string";
    private static final String CODE_SIMPLIFICATION_MATH = "code/simplification/math";
    private static final String CODE_SIMPLIFICATION_ADVANCED = "code/simplification/advanced";
    private static final String CODE_REMOVAL_ADVANCED = "code/removal/advanced";
    private static final String CODE_REMOVAL_SIMPLE = "code/removal/simple";
    private static final String CODE_REMOVAL_VARIABLE = "code/removal/variable";
    private static final String CODE_REMOVAL_EXCEPTION = "code/removal/exception";
    private static final String CODE_ALLOCATION_VARIABLE = "code/allocation/variable";
    public static final String[] OPTIMIZATION_NAMES = new String[]{"library/gson", "class/marking/final", "class/merging/vertical", "class/merging/horizontal", "field/removal/writeonly", "field/marking/private", "field/generalization/class", "field/specialization/type", "field/propagation/value", "method/marking/private", "method/marking/static", "method/marking/final", "method/marking/synchronized", "method/removal/parameter", "method/generalization/class", "method/specialization/parametertype", "method/specialization/returntype", "method/propagation/parameter", "method/propagation/returnvalue", "method/inlining/short", "method/inlining/unique", "method/inlining/tailrecursion", "code/merging", "code/simplification/variable", "code/simplification/arithmetic", "code/simplification/cast", "code/simplification/field", "code/simplification/branch", "code/simplification/string", "code/simplification/math", "code/simplification/advanced", "code/removal/advanced", "code/removal/simple", "code/removal/variable", "code/removal/exception", "code/allocation/variable"};
    private boolean libraryGson;
    private boolean classMarkingFinal;
    private boolean classUnboxingEnum;
    private boolean classMergingVertical;
    private boolean classMergingHorizontal;
    private boolean classMergingWrapper;
    private boolean fieldRemovalWriteonly;
    private boolean fieldMarkingPrivate;
    private boolean fieldGeneralizationClass;
    private boolean fieldSpecializationType;
    private boolean fieldPropagationValue;
    private boolean methodMarkingPrivate;
    private boolean methodMarkingStatic;
    private boolean methodMarkingFinal;
    private boolean methodMarkingSynchronized;
    private boolean methodRemovalParameter;
    private boolean methodGeneralizationClass;
    private boolean methodSpecializationParametertype;
    private boolean methodSpecializationReturntype;
    private boolean methodPropagationParameter;
    private boolean methodPropagationReturnvalue;
    private boolean methodInliningShort;
    private boolean methodInliningUnique;
    private boolean methodInliningTailrecursion;
    private boolean codeMerging;
    private boolean codeSimplificationVariable;
    private boolean codeSimplificationArithmetic;
    private boolean codeSimplificationCast;
    private boolean codeSimplificationField;
    private boolean codeSimplificationBranch;
    private boolean codeSimplificationObject;
    private boolean codeSimplificationString;
    private boolean codeSimplificationMath;
    private boolean codeSimplificationPeephole;
    private boolean codeSimplificationAdvanced;
    private boolean codeRemovalAdvanced;
    private boolean codeRemovalSimple;
    private boolean codeRemovalVariable;
    private boolean codeRemovalException;
    private boolean codeAllocationVariable;
    private boolean moreOptimizationsPossible = true;
    private int passIndex = 0;
    private final Configuration configuration;

    public Optimizer(Configuration configuration) {
        this.configuration = configuration;
    }

    @Override
    public void execute(AppView appView) throws IOException {
        if (!this.moreOptimizationsPossible) {
            return;
        }
        ConstantMatcher filter = this.configuration.optimizations != null ? new ListParser(new NameParser()).parse(this.configuration.optimizations) : new ConstantMatcher(true);
        this.libraryGson = filter.matches(LIBRARY_GSON);
        this.classMarkingFinal = filter.matches(CLASS_MARKING_FINAL);
        this.classUnboxingEnum = filter.matches(CLASS_UNBOXING_ENUM);
        this.classMergingVertical = filter.matches(CLASS_MERGING_VERTICAL);
        this.classMergingHorizontal = filter.matches(CLASS_MERGING_HORIZONTAL);
        this.classMergingWrapper = filter.matches(CLASS_MERGING_WRAPPER);
        this.fieldRemovalWriteonly = filter.matches(FIELD_REMOVAL_WRITEONLY);
        this.fieldMarkingPrivate = filter.matches(FIELD_MARKING_PRIVATE);
        this.fieldGeneralizationClass = filter.matches(FIELD_GENERALIZATION_CLASS);
        this.fieldSpecializationType = filter.matches(FIELD_SPECIALIZATION_TYPE);
        this.fieldPropagationValue = filter.matches(FIELD_PROPAGATION_VALUE);
        this.methodMarkingPrivate = filter.matches(METHOD_MARKING_PRIVATE);
        this.methodMarkingStatic = filter.matches(METHOD_MARKING_STATIC);
        this.methodMarkingFinal = filter.matches(METHOD_MARKING_FINAL);
        this.methodMarkingSynchronized = filter.matches(METHOD_MARKING_SYNCHRONIZED);
        this.methodRemovalParameter = filter.matches(METHOD_REMOVAL_PARAMETER);
        this.methodGeneralizationClass = filter.matches(METHOD_GENERALIZATION_CLASS);
        this.methodSpecializationParametertype = filter.matches(METHOD_SPECIALIZATION_PARAMETER_TYPE);
        this.methodSpecializationReturntype = filter.matches(METHOD_SPECIALIZATION_RETURN_TYPE);
        this.methodPropagationParameter = filter.matches(METHOD_PROPAGATION_PARAMETER);
        this.methodPropagationReturnvalue = filter.matches(METHOD_PROPAGATION_RETURNVALUE);
        this.methodInliningShort = filter.matches(METHOD_INLINING_SHORT);
        this.methodInliningUnique = filter.matches(METHOD_INLINING_UNIQUE);
        this.methodInliningTailrecursion = filter.matches(METHOD_INLINING_TAILRECURSION);
        this.codeMerging = filter.matches(CODE_MERGING);
        this.codeSimplificationVariable = filter.matches(CODE_SIMPLIFICATION_VARIABLE);
        this.codeSimplificationArithmetic = filter.matches(CODE_SIMPLIFICATION_ARITHMETIC);
        this.codeSimplificationCast = filter.matches(CODE_SIMPLIFICATION_CAST);
        this.codeSimplificationField = filter.matches(CODE_SIMPLIFICATION_FIELD);
        this.codeSimplificationBranch = filter.matches(CODE_SIMPLIFICATION_BRANCH);
        this.codeSimplificationObject = filter.matches(CODE_SIMPLIFICATION_OBJECT);
        this.codeSimplificationString = filter.matches(CODE_SIMPLIFICATION_STRING);
        this.codeSimplificationMath = filter.matches(CODE_SIMPLIFICATION_MATH);
        this.codeSimplificationAdvanced = filter.matches(CODE_SIMPLIFICATION_ADVANCED);
        this.codeRemovalAdvanced = filter.matches(CODE_REMOVAL_ADVANCED);
        this.codeRemovalSimple = filter.matches(CODE_REMOVAL_SIMPLE);
        this.codeRemovalVariable = filter.matches(CODE_REMOVAL_VARIABLE);
        this.codeRemovalException = filter.matches(CODE_REMOVAL_EXCEPTION);
        this.codeAllocationVariable = filter.matches(CODE_ALLOCATION_VARIABLE);
        this.codeSimplificationAdvanced = this.codeSimplificationAdvanced || this.fieldPropagationValue || this.methodPropagationParameter || this.methodPropagationReturnvalue;
        this.codeRemovalAdvanced = this.codeRemovalAdvanced || this.fieldRemovalWriteonly || this.methodMarkingStatic || this.methodRemovalParameter;
        this.codeRemovalSimple = this.codeRemovalSimple || this.codeSimplificationBranch;
        this.codeRemovalException = this.codeRemovalException || this.codeRemovalAdvanced || this.codeRemovalSimple;
        this.codeSimplificationPeephole = this.codeSimplificationVariable || this.codeSimplificationArithmetic || this.codeSimplificationCast || this.codeSimplificationField || this.codeSimplificationBranch || this.codeSimplificationObject || this.codeSimplificationString || this.codeSimplificationMath || this.fieldGeneralizationClass || this.methodGeneralizationClass;
        logger.info("Optimizing (pass {}/{})...", (Object)(this.passIndex + 1), (Object)this.configuration.optimizationPasses);
        this.optimize(this.configuration, appView.programClassPool, appView.libraryClassPool, appView.extraDataEntryNameMap);
        ++this.passIndex;
    }

    private void optimize(final Configuration configuration, final ClassPool programClassPool, final ClassPool libraryClassPool, ExtraDataEntryNameMap extraDataEntryNameMap) throws IOException {
        ClassPoolVisitor classPoolVisitor;
        ClassPoolVisitor classPoolVisitor2;
        MemberVisitor noSideEffectMethodMarker;
        NoSideEffectClassMarker noSideEffectClassMarker;
        if (configuration.keep == null && configuration.applyMapping == null && configuration.printMapping == null) {
            throw new IOException("You have to specify '-keep' options for the optimization step.");
        }
        ClassCounter classMarkingFinalCounter = new ClassCounter();
        ClassCounter classUnboxingEnumCounter = new ClassCounter();
        ClassCounter classMergingVerticalCounter = new ClassCounter();
        ClassCounter classMergingHorizontalCounter = new ClassCounter();
        ClassCounter classMergingWrapperCounter = new ClassCounter();
        MemberCounter fieldRemovalWriteonlyCounter = new MemberCounter();
        MemberCounter fieldMarkingPrivateCounter = new MemberCounter();
        final InstructionCounter fieldGeneralizationClassCounter = new InstructionCounter();
        MemberCounter fieldSpecializationTypeCounter = new MemberCounter();
        MemberCounter fieldPropagationValueCounter = new MemberCounter();
        MemberCounter methodMarkingPrivateCounter = new MemberCounter();
        MemberCounter methodMarkingStaticCounter = new MemberCounter();
        MemberCounter methodMarkingFinalCounter = new MemberCounter();
        MemberCounter methodMarkingSynchronizedCounter = new MemberCounter();
        MemberCounter methodRemovalParameterCounter1 = new MemberCounter();
        MemberCounter methodRemovalParameterCounter2 = new MemberCounter();
        final InstructionCounter methodGeneralizationClassCounter = new InstructionCounter();
        MemberCounter methodSpecializationParametertypeCounter = new MemberCounter();
        MemberCounter methodSpecializationReturntypeCounter = new MemberCounter();
        MemberCounter methodPropagationParameterCounter = new MemberCounter();
        MemberCounter methodPropagationReturnvalueCounter = new MemberCounter();
        InstructionCounter methodInliningShortCounter = new InstructionCounter();
        InstructionCounter methodInliningUniqueCounter = new InstructionCounter();
        InstructionCounter methodInliningTailrecursionCounter = new InstructionCounter();
        InstructionCounter codeMergingCounter = new InstructionCounter();
        final InstructionCounter codeSimplificationVariableCounter = new InstructionCounter();
        final InstructionCounter codeSimplificationArithmeticCounter = new InstructionCounter();
        final InstructionCounter codeSimplificationCastCounter = new InstructionCounter();
        final InstructionCounter codeSimplificationFieldCounter = new InstructionCounter();
        final InstructionCounter codeSimplificationBranchCounter = new InstructionCounter();
        final InstructionCounter codeSimplificationObjectCounter = new InstructionCounter();
        final InstructionCounter codeSimplificationStringCounter = new InstructionCounter();
        final InstructionCounter codeSimplificationMathCounter = new InstructionCounter();
        final InstructionCounter codeSimplificationAndroidMathCounter = new InstructionCounter();
        final InstructionCounter codeSimplificationAdvancedCounter = new InstructionCounter();
        final InstructionCounter deletedCounter = new InstructionCounter();
        final InstructionCounter addedCounter = new InstructionCounter();
        MemberCounter codeRemovalVariableCounter = new MemberCounter();
        ExceptionCounter codeRemovalExceptionCounter = new ExceptionCounter();
        final MemberCounter codeAllocationVariableCounter = new MemberCounter();
        MemberCounter initializerFixCounter1 = new MemberCounter();
        MemberCounter initializerFixCounter2 = new MemberCounter();
        programClassPool.classesAccept(new ClassCleaner());
        libraryClassPool.classesAccept(new ClassCleaner());
        programClassPool.classesAccept(new BottomClassFilter(new MethodLinker()));
        libraryClassPool.classesAccept(new BottomClassFilter(new MethodLinker()));
        KeepMarker keepMarker = new KeepMarker();
        libraryClassPool.classesAccept(keepMarker);
        libraryClassPool.classesAccept(new AllMemberVisitor(keepMarker));
        programClassPool.classesAccept(new MultiClassVisitor(new ClassProcessingFlagFilter(0x200000, 0, keepMarker), new AllMemberVisitor(new MultiMemberVisitor(new MemberProcessingFlagFilter(0x200000, 0, keepMarker), new AllAttributeVisitor(new AttributeProcessingFlagFilter(0x200000, 0, keepMarker))))));
        programClassPool.classesAccept(new AllMemberVisitor(new AllAttributeVisitor(new AttributeNameFilter("Code", (AttributeVisitor)new AttributeProcessingFlagFilter(0x200000, 0, new CodeAttributeToMethodVisitor(keepMarker))))));
        programClassPool.classesAccept(new ClassAccessFilter(0, 16384, new AllMethodVisitor(new AllAttributeVisitor(new AllInstructionVisitor(new DotClassClassVisitor(keepMarker))))));
        programClassPool.classesAccept(new AllConstantVisitor(new ConstantTagFilter(8, (ConstantVisitor)new ReferencedClassVisitor(keepMarker))));
        programClassPool.classesAccept(new AllConstantVisitor(new ConstantTagFilter(8, (ConstantVisitor)new ReferencedMemberVisitor(keepMarker))));
        programClassPool.classesAccept(new ClassVersionFilter(0x330000, new AllAttributeVisitor(new AttributeNameFilter("BootstrapMethods", (AttributeVisitor)new AllBootstrapMethodInfoVisitor(new BootstrapMethodHandleTraveler(new MethodrefTraveler(new ReferencedMemberVisitor(keepMarker))))))));
        programClassPool.classesAccept(new ClassVersionFilter(0x330000, new AllAttributeVisitor(new AttributeNameFilter("BootstrapMethods", (AttributeVisitor)new AllBootstrapMethodInfoVisitor(new AllBootstrapMethodArgumentVisitor(new MultiConstantVisitor(new ConstantTagFilter(7, (ConstantVisitor)new ReferencedClassVisitor(new FunctionalInterfaceFilter(new ClassHierarchyTraveler(true, false, true, false, new MultiClassVisitor(keepMarker, new AllMethodVisitor(new MemberAccessFilter(1024, 0, keepMarker))))))), new MethodrefTraveler(new ReferencedMemberVisitor(keepMarker)))))))));
        programClassPool.classesAccept(new ClassVersionFilter(0x330000, new AllConstantVisitor(new DynamicReturnedClassVisitor(new FunctionalInterfaceFilter(new ClassHierarchyTraveler(true, false, true, false, new MultiClassVisitor(keepMarker, new AllMethodVisitor(new MemberAccessFilter(1024, 0, keepMarker)))))))));
        programClassPool.classesAccept(new ProgramClassOptimizationInfoSetter());
        programClassPool.classesAccept(new AllMemberVisitor(new ProgramMemberOptimizationInfoSetter()));
        if (configuration.assumeNoSideEffects != null) {
            noSideEffectClassMarker = new NoSideEffectClassMarker();
            noSideEffectMethodMarker = new NoSideEffectMethodMarker();
            classPoolVisitor2 = new ClassSpecificationVisitorFactory().createClassPoolVisitor(configuration.assumeNoSideEffects, noSideEffectClassMarker, noSideEffectMethodMarker);
            programClassPool.accept(classPoolVisitor2);
            libraryClassPool.accept(classPoolVisitor2);
        }
        if (configuration.assumeNoExternalSideEffects != null) {
            noSideEffectClassMarker = new NoSideEffectClassMarker();
            noSideEffectMethodMarker = new NoExternalSideEffectMethodMarker();
            classPoolVisitor2 = new ClassSpecificationVisitorFactory().createClassPoolVisitor(configuration.assumeNoExternalSideEffects, noSideEffectClassMarker, noSideEffectMethodMarker);
            programClassPool.accept(classPoolVisitor2);
            libraryClassPool.accept(classPoolVisitor2);
        }
        if (configuration.assumeNoEscapingParameters != null) {
            NoEscapingParametersMethodMarker noEscapingParametersMethodMarker = new NoEscapingParametersMethodMarker();
            classPoolVisitor = new ClassSpecificationVisitorFactory().createClassPoolVisitor(configuration.assumeNoEscapingParameters, null, noEscapingParametersMethodMarker);
            programClassPool.accept(classPoolVisitor);
            libraryClassPool.accept(classPoolVisitor);
        }
        if (configuration.assumeNoExternalReturnValues != null) {
            NoExternalReturnValuesMethodMarker noExternalReturnValuesMethodMarker = new NoExternalReturnValuesMethodMarker();
            classPoolVisitor = new ClassSpecificationVisitorFactory().createClassPoolVisitor(configuration.assumeNoExternalReturnValues, null, noExternalReturnValuesMethodMarker);
            programClassPool.accept(classPoolVisitor);
            libraryClassPool.accept(classPoolVisitor);
        }
        if (this.classMarkingFinal) {
            programClassPool.classesAccept(new ClassFinalizer(classMarkingFinalCounter));
        }
        if (this.methodMarkingFinal) {
            programClassPool.classesAccept(new ClassAccessFilter(0, 512, new AllMethodVisitor(new MethodFinalizer(methodMarkingFinalCounter))));
        }
        MutableBoolean mutableBoolean = new MutableBoolean();
        if (this.fieldRemovalWriteonly) {
            programClassPool.classesAccept(new AllMethodVisitor(new AllAttributeVisitor(new AllInstructionVisitor(new ReadWriteFieldMarker(mutableBoolean)))));
        } else {
            programClassPool.classesAccept(new AllFieldVisitor(new ReadWriteFieldMarker(mutableBoolean)));
        }
        programClassPool.classesAccept(new AllMethodVisitor(new OptimizationInfoMemberFilter(new MultiMemberVisitor(new SideEffectMethodMarker(), new ParameterEscapeMarker()))));
        programClassPool.accept(new InfluenceFixpointVisitor(new SideEffectVisitorMarkerFactory()));
        if (this.methodMarkingSynchronized) {
            programClassPool.classesAccept(new EscapingClassFilter(new ClassHierarchyTraveler(false, true, true, false, new EscapingClassMarker())));
            ParallelAllClassVisitor.ClassVisitorFactory markingEscapingClassVisitor = new ParallelAllClassVisitor.ClassVisitorFactory(){

                @Override
                public ClassVisitor createClassVisitor() {
                    return new AllMethodVisitor(new AllAttributeVisitor(new EscapingClassMarker()));
                }
            };
            programClassPool.accept(new TimedClassPoolVisitor("Marking escaping classes", new ParallelAllClassVisitor(markingEscapingClassVisitor)));
            programClassPool.classesAccept(new EscapingClassFilter(null, new AllMethodVisitor(new OptimizationInfoMemberFilter(new MemberAccessFilter(32, 8, new MultiMemberVisitor(new MemberAccessFlagCleaner(32), methodMarkingSynchronizedCounter))))));
        }
        if (this.fieldRemovalWriteonly) {
            programClassPool.classesAccept(new AllFieldVisitor(new WriteOnlyFieldFilter(fieldRemovalWriteonlyCounter)));
        }
        if (this.classUnboxingEnum) {
            ClassCounter counter = new ClassCounter();
            programClassPool.classesAccept(new ClassAccessFilter(16400, 0, new OptimizationInfoClassFilter(new SimpleEnumClassChecker())));
            programClassPool.classesAccept(new SimpleEnumFilter(counter));
            if (counter.getCount() > 0) {
                programClassPool.classesAccept(new SimpleEnumUseChecker());
                programClassPool.classesAccept(new SimpleEnumFilter(null, new AllMemberVisitor(new KeptMemberFilter(new MemberDescriptorReferencedClassVisitor(new OptimizationInfoClassFilter(new SimpleEnumMarker(false)))))));
                programClassPool.classesAccept(new SimpleEnumFilter(classUnboxingEnumCounter));
                if (classUnboxingEnumCounter.getCount() > 0) {
                    programClassPool.accept(new TimedClassPoolVisitor("Simplify use of simple enums", new AllMethodVisitor(new AllAttributeVisitor(new SimpleEnumUseSimplifier()))));
                    programClassPool.classesAccept(new SimpleEnumFilter(new SimpleEnumClassSimplifier()));
                    programClassPool.classesAccept(new SimpleEnumDescriptorSimplifier());
                    programClassPool.classesAccept(new MemberReferenceFixer(configuration.android));
                }
            }
        }
        ParallelAllClassVisitor.ClassVisitorFactory markingUsedParametersClassVisitor = new ParallelAllClassVisitor.ClassVisitorFactory(){

            @Override
            public ClassVisitor createClassVisitor() {
                return new AllMethodVisitor(new OptimizationInfoMemberFilter(new ParameterUsageMarker(!Optimizer.this.methodMarkingStatic, !Optimizer.this.methodRemovalParameter)));
            }
        };
        programClassPool.accept(new TimedClassPoolVisitor("Marking used parameters", new ParallelAllClassVisitor(markingUsedParametersClassVisitor)));
        programClassPool.accept(new TimedClassPoolVisitor("Marking used parameters in kept code attributes", new AllClassVisitor(new AllMethodVisitor(new OptimizationInfoMemberFilter(null, new AllAttributeVisitor(new OptimizationCodeAttributeFilter(null, new AllInstructionVisitor(new InstructionConstantVisitor(new ConstantTagFilter(new int[]{10, 11}, (ConstantVisitor)new ReferencedMemberVisitor(new OptimizationInfoMemberFilter(new ParameterUsageMarker(true, true, false)))))))))))));
        if (this.fieldSpecializationType || this.methodSpecializationParametertype || this.methodSpecializationReturntype || this.fieldPropagationValue || this.methodPropagationParameter || this.methodPropagationReturnvalue || this.classMergingWrapper) {
            BasicRangeValueFactory valueFactory = new BasicRangeValueFactory();
            DetailedArrayValueFactory detailedValueFactory = new DetailedArrayValueFactory();
            StoringInvocationUnit storingInvocationUnit = new StoringInvocationUnit(valueFactory, this.fieldSpecializationType || this.fieldPropagationValue, this.methodSpecializationParametertype || this.methodPropagationParameter || this.classMergingWrapper, this.methodSpecializationReturntype || this.methodPropagationReturnvalue);
            programClassPool.classesAccept(new ClassAccessFilter(4096, 0, new AllMethodVisitor(new AllAttributeVisitor(new DebugAttributeVisitor("Filling out fields, method parameters, and return values in synthetic classes", new PartialEvaluator(detailedValueFactory, storingInvocationUnit, false))))));
            ParallelAllClassVisitor.ClassVisitorFactory fillingOutValuesClassVisitor = new ParallelAllClassVisitor.ClassVisitorFactory(){

                @Override
                public ClassVisitor createClassVisitor() {
                    ParticularValueFactory valueFactory = new ParticularValueFactory();
                    StoringInvocationUnit storingInvocationUnit = new StoringInvocationUnit(valueFactory, Optimizer.this.fieldSpecializationType || Optimizer.this.fieldPropagationValue, Optimizer.this.methodSpecializationParametertype || Optimizer.this.methodPropagationParameter || Optimizer.this.classMergingWrapper, Optimizer.this.methodSpecializationReturntype || Optimizer.this.methodPropagationReturnvalue);
                    return new ClassAccessFilter(0, 4096, new AllMethodVisitor(new AllAttributeVisitor(new DebugAttributeVisitor("Filling out fields, method parameters, and return values", new PartialEvaluator(valueFactory, storingInvocationUnit, Optimizer.this.fieldSpecializationType || Optimizer.this.methodSpecializationParametertype || Optimizer.this.methodSpecializationReturntype)))));
                }
            };
            programClassPool.accept(new TimedClassPoolVisitor("Filling out values in non-synthetic classes", new ParallelAllClassVisitor(fillingOutValuesClassVisitor)));
            if (this.fieldSpecializationType || this.methodSpecializationParametertype || this.methodSpecializationReturntype) {
                programClassPool.classesAccept(new AllMemberVisitor(new OptimizationInfoMemberFilter(new MemberDescriptorSpecializer(this.fieldSpecializationType, this.methodSpecializationParametertype, this.methodSpecializationReturntype, fieldSpecializationTypeCounter, methodSpecializationParametertypeCounter, methodSpecializationReturntypeCounter))));
                if (fieldSpecializationTypeCounter.getCount() > 0 || methodSpecializationParametertypeCounter.getCount() > 0 || methodSpecializationReturntypeCounter.getCount() > 0) {
                    programClassPool.classesAccept(new MemberReferenceFixer(configuration.android));
                }
            }
            if (configuration.assumeValues != null) {
                ClassPoolVisitor classPoolVisitor3 = new AssumeClassSpecificationVisitorFactory(valueFactory).createClassPoolVisitor(configuration.assumeValues, null, new MultiMemberVisitor());
                programClassPool.accept(classPoolVisitor3);
                libraryClassPool.accept(classPoolVisitor3);
            }
            if (this.fieldPropagationValue) {
                programClassPool.classesAccept(new AllFieldVisitor(new ConstantMemberFilter(fieldPropagationValueCounter)));
            }
            if (this.methodPropagationParameter) {
                programClassPool.classesAccept(new AllMethodVisitor(new ConstantParameterFilter(methodPropagationParameterCounter)));
            }
            if (this.methodPropagationReturnvalue) {
                programClassPool.classesAccept(new AllMethodVisitor(new ConstantMemberFilter(methodPropagationReturnvalueCounter)));
            }
            if (classUnboxingEnumCounter.getCount() > 0) {
                programClassPool.classesAccept(new SimpleEnumFilter(new SimpleEnumArrayPropagator()));
            }
            if (this.codeSimplificationAdvanced) {
                LoadingInvocationUnit loadingInvocationUnit = new LoadingInvocationUnit(valueFactory, this.fieldPropagationValue, this.methodPropagationParameter, this.methodPropagationReturnvalue);
                programClassPool.classesAccept(new ClassAccessFilter(4096, 0, new AllMethodVisitor(new AllAttributeVisitor(new PartialEvaluator(valueFactory, loadingInvocationUnit, false)))));
            }
        }
        if (this.codeSimplificationAdvanced) {
            ParallelAllClassVisitor.ClassVisitorFactory simplifyingCodeVisitor = new ParallelAllClassVisitor.ClassVisitorFactory(){

                @Override
                public ClassVisitor createClassVisitor() {
                    IdentifiedValueFactory valueFactory = new IdentifiedValueFactory();
                    LoadingInvocationUnit loadingInvocationUnit = new LoadingInvocationUnit(valueFactory, Optimizer.this.fieldPropagationValue, Optimizer.this.methodPropagationParameter, Optimizer.this.methodPropagationReturnvalue);
                    return new AllMethodVisitor(new AllAttributeVisitor(new DebugAttributeVisitor("Simplifying code", new OptimizationCodeAttributeFilter(new EvaluationSimplifier(new PartialEvaluator(valueFactory, loadingInvocationUnit, false), codeSimplificationAdvancedCounter)))));
                }
            };
            programClassPool.accept(new TimedClassPoolVisitor("Simplifying code", new ParallelAllClassVisitor(simplifyingCodeVisitor)));
        }
        if (this.codeRemovalAdvanced) {
            ParallelAllClassVisitor.ClassVisitorFactory shrinkingCodeVisitor = new ParallelAllClassVisitor.ClassVisitorFactory(){

                @Override
                public ClassVisitor createClassVisitor() {
                    IdentifiedValueFactory valueFactory = new IdentifiedValueFactory();
                    LoadingInvocationUnit loadingInvocationUnit = new LoadingInvocationUnit(valueFactory, Optimizer.this.fieldPropagationValue, Optimizer.this.methodPropagationParameter, Optimizer.this.methodPropagationReturnvalue);
                    ReferenceTracingValueFactory referenceTracingValueFactory = new ReferenceTracingValueFactory(valueFactory);
                    return new AllMethodVisitor(new AllAttributeVisitor(new DebugAttributeVisitor("Shrinking code", new OptimizationCodeAttributeFilter(new EvaluationShrinker(new InstructionUsageMarker(new PartialEvaluator(referenceTracingValueFactory, new ParameterTracingInvocationUnit(loadingInvocationUnit), !Optimizer.this.codeSimplificationAdvanced, referenceTracingValueFactory), true), true, (InstructionVisitor)deletedCounter, (InstructionVisitor)addedCounter)))));
                }
            };
            programClassPool.accept(new TimedClassPoolVisitor("Shrinking code", new ParallelAllClassVisitor(shrinkingCodeVisitor)));
        }
        if (this.methodRemovalParameter) {
            programClassPool.classesAccept(new AllMethodVisitor(new UnusedParameterMethodFilter(new OptimizationInfoMemberFilter(new MethodDescriptorShrinker(methodRemovalParameterCounter1)))));
        }
        if (this.methodMarkingStatic) {
            programClassPool.classesAccept(new AllMethodVisitor(new OptimizationInfoMemberFilter(new MemberAccessFilter(0, 8, new MethodStaticizer(methodMarkingStaticCounter)))));
        }
        if (methodRemovalParameterCounter1.getCount() > 0) {
            programClassPool.classesAccept(new MemberReferenceFixer(configuration.android));
            programClassPool.classesAccept(new AllAttributeVisitor(new AllBootstrapMethodInfoVisitor(new BootstrapMethodArgumentShrinker())));
        }
        if (methodRemovalParameterCounter1.getCount() > 0 || this.methodMarkingPrivate || methodMarkingStaticCounter.getCount() > 0) {
            programClassPool.classesAccept(new AllMethodVisitor(new UnusedParameterMethodFilter(new AllAttributeVisitor(new ParameterShrinker(methodRemovalParameterCounter2)))));
            programClassPool.classesAccept(new AllMethodVisitor(new UnusedParameterMethodFilter(new AllAttributeVisitor(new UnusedParameterOptimizationInfoUpdater(new ProcessingFlagSetter(16384))))));
        } else if (this.codeRemovalAdvanced) {
            programClassPool.classesAccept(new AllMethodVisitor(new AllAttributeVisitor(new OptimizationCodeAttributeFilter(new StackSizeUpdater()))));
        }
        if (this.methodRemovalParameter && methodRemovalParameterCounter2.getCount() > 0) {
            programClassPool.classesAccept(new AllMethodVisitor(new DuplicateInitializerFixer(initializerFixCounter1)));
            if (initializerFixCounter1.getCount() > 0) {
                programClassPool.classesAccept(new AllMethodVisitor(new AllAttributeVisitor(new DuplicateInitializerInvocationFixer(addedCounter))));
                programClassPool.classesAccept(new MemberReferenceFixer(configuration.android));
            }
        }
        StackSizeComputer stackSizeComputer = new StackSizeComputer();
        programClassPool.accept(new TimedClassPoolVisitor("Marking method and referenced class properties", new MultiClassVisitor(new OptimizationInfoClassFilter(new MultiClassVisitor(new PackageVisibleMemberContainingClassMarker(), new WrapperClassMarker(), new AllConstantVisitor(new PackageVisibleMemberInvokingClassMarker()), new AllMemberVisitor(new ContainsConstructorsMarker()))), new AllMethodVisitor(new OptimizationInfoMemberFilter(new AllAttributeVisitor(new DebugAttributeVisitor("Marking method properties", new MultiAttributeVisitor(stackSizeComputer, new CatchExceptionMarker(), new AllInstructionVisitor(new MultiInstructionVisitor(new SuperInvocationMarker(), new DynamicInvocationMarker(), new BackwardBranchMarker(), new AccessMethodMarker(), new SynchronizedBlockMethodMarker(), new FinalFieldAssignmentMarker(), new NonEmptyStackReturnMarker(stackSizeComputer)))))))), new AllMethodVisitor(new AllAttributeVisitor(new DebugAttributeVisitor("Marking referenced class properties", new MultiAttributeVisitor(new AllExceptionInfoVisitor(new ExceptionHandlerConstantVisitor(new ReferencedClassVisitor(new OptimizationInfoClassFilter(new CaughtClassMarker())))), new AllInstructionVisitor(new MultiInstructionVisitor(new InstantiationClassMarker(), new InstanceofClassMarker(), new DotClassMarker(), new MethodInvocationMarker())))))))));
        if (this.classMergingWrapper) {
            programClassPool.accept(new TimedClassPoolVisitor("Merging wrapper classes", new InjectedClassFilter(null, new WrapperClassMerger(configuration.allowAccessModification, classMergingWrapperCounter))));
            if (classMergingWrapperCounter.getCount() > 0) {
                programClassPool.classesAccept(new RetargetedClassFilter(null, new AllMethodVisitor(new AllAttributeVisitor(new WrapperClassUseSimplifier()))));
            }
        }
        if (this.classMergingVertical) {
            programClassPool.accept(new TimedClassPoolVisitor("Merging classes vertically", new InjectedClassFilter(null, new VerticalClassMerger(configuration.allowAccessModification, configuration.mergeInterfacesAggressively, classMergingVerticalCounter))));
        }
        if (this.classMergingHorizontal) {
            long start = System.currentTimeMillis();
            HashSet<String> forbiddenClassNames = new HashSet<String>();
            extraDataEntryNameMap.getAllExtraDataEntryNames().stream().filter(s -> s.endsWith(".class")).map(s -> s.substring(0, s.length() - 6)).forEachOrdered(forbiddenClassNames::add);
            programClassPool.accept(new HorizontalClassMerger(configuration.allowAccessModification, configuration.mergeInterfacesAggressively, forbiddenClassNames, classMergingHorizontalCounter));
            long end = System.currentTimeMillis();
            logger.trace("Merging classes horizontally.................... took: %6d ms", (Object)(end - start));
        }
        if (classMergingVerticalCounter.getCount() > 0 || classMergingHorizontalCounter.getCount() > 0 || classMergingWrapperCounter.getCount() > 0) {
            programClassPool.classesAccept(new RetargetedInnerClassAttributeRemover());
            programClassPool.classesAccept(new RetargetedClassFilter(null, new TargetClassChanger()));
            programClassPool.classesAccept(new RetargetedClassFilter(null, new ClassReferenceFixer(true)));
            programClassPool.classesAccept(new RetargetedClassFilter(null, new MemberReferenceFixer(configuration.android)));
            if (configuration.allowAccessModification) {
                programClassPool.classesAccept(new AccessFixer());
            }
            programClassPool.classesAccept(new KeptClassFilter(null, new AllAttributeVisitor(new AllInnerClassesInfoVisitor(new InnerClassesAccessFixer()))));
            programClassPool.classesAccept(new AllMethodVisitor(new DuplicateInitializerFixer(initializerFixCounter2)));
            if (initializerFixCounter2.getCount() > 0) {
                programClassPool.classesAccept(new AllMethodVisitor(new AllAttributeVisitor(new DuplicateInitializerInvocationFixer(addedCounter))));
                programClassPool.classesAccept(new MemberReferenceFixer(configuration.android));
            }
        }
        if (this.methodInliningUnique) {
            programClassPool.accept(new TimedClassPoolVisitor("Inlining single methods", new AllMethodVisitor(new AllAttributeVisitor(new DebugAttributeVisitor("Inlining single methods", new OptimizationCodeAttributeFilter(new SingleInvocationMethodInliner(configuration.microEdition, configuration.android, configuration.allowAccessModification, methodInliningUniqueCounter)))))));
        }
        if (this.methodInliningShort) {
            programClassPool.accept(new TimedClassPoolVisitor("Inlining short methods", new AllMethodVisitor(new AllAttributeVisitor(new DebugAttributeVisitor("Inlining short methods", new OptimizationCodeAttributeFilter(new ShortMethodInliner(configuration.microEdition, configuration.android, configuration.allowAccessModification, methodInliningShortCounter)))))));
        }
        if (this.methodInliningTailrecursion) {
            programClassPool.accept(new TimedClassPoolVisitor("Simplifying tail recursion", new AllMethodVisitor(new AllAttributeVisitor(new DebugAttributeVisitor("Simplifying tail recursion", new OptimizationCodeAttributeFilter(new TailRecursionSimplifier(methodInliningTailrecursionCounter)))))));
        }
        if (this.fieldMarkingPrivate || this.methodMarkingPrivate) {
            programClassPool.classesAccept(new NonPrivateMemberMarker());
        }
        if (this.fieldMarkingPrivate) {
            programClassPool.classesAccept(new ClassAccessFilter(0, 512, new AllFieldVisitor(new MemberAccessFilter(0, 2, new MemberPrivatizer(fieldMarkingPrivateCounter)))));
        }
        if (this.methodMarkingPrivate) {
            programClassPool.classesAccept(new ClassAccessFilter(0, 512, new AllMethodVisitor(new MemberAccessFilter(0, 2, new MemberPrivatizer(methodMarkingPrivateCounter)))));
        }
        if ((methodInliningUniqueCounter.getCount() > 0 || methodInliningShortCounter.getCount() > 0 || methodInliningTailrecursionCounter.getCount() > 0) && configuration.allowAccessModification) {
            programClassPool.classesAccept(new AccessFixer());
        }
        if (methodRemovalParameterCounter2.getCount() > 0 || classMergingVerticalCounter.getCount() > 0 || classMergingHorizontalCounter.getCount() > 0 || classMergingWrapperCounter.getCount() > 0 || methodMarkingPrivateCounter.getCount() > 0 || (methodInliningUniqueCounter.getCount() > 0 || methodInliningShortCounter.getCount() > 0 || methodInliningTailrecursionCounter.getCount() > 0) && configuration.allowAccessModification) {
            programClassPool.classesAccept(new AllMemberVisitor(new AllAttributeVisitor(new MethodInvocationFixer())));
        }
        if (this.codeMerging) {
            programClassPool.accept(new TimedClassPoolVisitor("Sharing common code", new AllMethodVisitor(new AllAttributeVisitor(new DebugAttributeVisitor("Sharing common code", new OptimizationCodeAttributeFilter(new GotoCommonCodeReplacer(codeMergingCounter)))))));
        }
        if (this.codeSimplificationPeephole) {
            ParallelAllClassVisitor.ClassVisitorFactory peepHoleOptimizer = new ParallelAllClassVisitor.ClassVisitorFactory(){

                @Override
                public ClassVisitor createClassVisitor() {
                    BranchTargetFinder branchTargetFinder = new BranchTargetFinder();
                    CodeAttributeEditor codeAttributeEditor = new CodeAttributeEditor();
                    InstructionSequenceConstants sequences = new InstructionSequenceConstants(programClassPool, libraryClassPool);
                    List peepholeOptimizations = Optimizer.this.createPeepholeOptimizations(configuration, sequences, branchTargetFinder, codeAttributeEditor, codeSimplificationVariableCounter, codeSimplificationArithmeticCounter, codeSimplificationCastCounter, codeSimplificationFieldCounter, codeSimplificationBranchCounter, codeSimplificationObjectCounter, codeSimplificationStringCounter, codeSimplificationMathCounter, codeSimplificationAndroidMathCounter, fieldGeneralizationClassCounter, methodGeneralizationClassCounter);
                    InstructionVisitor[] peepholeOptimizationsArray = new InstructionVisitor[peepholeOptimizations.size()];
                    peepholeOptimizations.toArray(peepholeOptimizationsArray);
                    return new AllMethodVisitor(new AllAttributeVisitor(new DebugAttributeVisitor("Peephole optimizations", new OptimizationCodeAttributeFilter(new PeepholeEditor(branchTargetFinder, codeAttributeEditor, new MultiInstructionVisitor(peepholeOptimizationsArray))))));
                }
            };
            programClassPool.accept(new TimedClassPoolVisitor("Peephole optimizations", new ParallelAllClassVisitor(peepHoleOptimizer)));
        }
        if (this.codeRemovalException) {
            programClassPool.accept(new TimedClassPoolVisitor("Unreachable exception removal", new AllMethodVisitor(new AllAttributeVisitor(new DebugAttributeVisitor("Unreachable exception removal", new OptimizationCodeAttributeFilter(new UnreachableExceptionRemover(codeRemovalExceptionCounter)))))));
        }
        if (this.codeRemovalSimple) {
            programClassPool.accept(new TimedClassPoolVisitor("Unreachable code removal", new AllMethodVisitor(new AllAttributeVisitor(new DebugAttributeVisitor("Unreachable code removal", new OptimizationCodeAttributeFilter(new UnreachableCodeRemover(deletedCounter)))))));
        }
        if (this.codeRemovalVariable) {
            programClassPool.accept(new TimedClassPoolVisitor("Variable shrinking", new AllMethodVisitor(new AllAttributeVisitor(new DebugAttributeVisitor("Variable shrinking", new OptimizationCodeAttributeFilter(new VariableShrinker(codeRemovalVariableCounter)))))));
        }
        if (this.codeAllocationVariable) {
            ParallelAllClassVisitor.ClassVisitorFactory optimizingVariablesVisitor = new ParallelAllClassVisitor.ClassVisitorFactory(){

                @Override
                public ClassVisitor createClassVisitor() {
                    return new AllMethodVisitor(new AllAttributeVisitor(new DebugAttributeVisitor("Variable optimizations", new OptimizationCodeAttributeFilter(new VariableOptimizer(false, codeAllocationVariableCounter)))));
                }
            };
            programClassPool.accept(new TimedClassPoolVisitor("Variable optimizations", new ParallelAllClassVisitor(optimizingVariablesVisitor)));
        }
        programClassPool.accept(new TimedClassPoolVisitor("Shrinking constant pool", new ConstantPoolShrinker()));
        int classMarkingFinalCount = classMarkingFinalCounter.getCount();
        int classUnboxingEnumCount = classUnboxingEnumCounter.getCount();
        int classMergingVerticalCount = classMergingVerticalCounter.getCount();
        int classMergingHorizontalCount = classMergingHorizontalCounter.getCount();
        int classMergingWrapperCount = classMergingWrapperCounter.getCount();
        int fieldRemovalWriteonlyCount = fieldRemovalWriteonlyCounter.getCount();
        int fieldMarkingPrivateCount = fieldMarkingPrivateCounter.getCount();
        int fieldGeneralizationClassCount = fieldGeneralizationClassCounter.getCount();
        int fieldSpecializationTypeCount = fieldSpecializationTypeCounter.getCount();
        int fieldPropagationValueCount = fieldPropagationValueCounter.getCount();
        int methodMarkingPrivateCount = methodMarkingPrivateCounter.getCount();
        int methodMarkingStaticCount = methodMarkingStaticCounter.getCount();
        int methodMarkingFinalCount = methodMarkingFinalCounter.getCount();
        int methodMarkingSynchronizedCount = methodMarkingSynchronizedCounter.getCount();
        int methodRemovalParameterCount1 = methodRemovalParameterCounter1.getCount() - initializerFixCounter1.getCount() - initializerFixCounter2.getCount();
        int methodRemovalParameterCount2 = methodRemovalParameterCounter2.getCount() - methodMarkingStaticCounter.getCount() - initializerFixCounter1.getCount() - initializerFixCounter2.getCount();
        int methodGeneralizationClassCount = methodGeneralizationClassCounter.getCount();
        int methodSpecializationParametertypeCount = methodSpecializationParametertypeCounter.getCount();
        int methodSpecializationReturntypeCount = methodSpecializationReturntypeCounter.getCount();
        int methodPropagationParameterCount = methodPropagationParameterCounter.getCount();
        int methodPropagationReturnvalueCount = methodPropagationReturnvalueCounter.getCount();
        int methodInliningShortCount = methodInliningShortCounter.getCount();
        int methodInliningUniqueCount = methodInliningUniqueCounter.getCount();
        int methodInliningTailrecursionCount = methodInliningTailrecursionCounter.getCount();
        int codeMergingCount = codeMergingCounter.getCount();
        int codeSimplificationVariableCount = codeSimplificationVariableCounter.getCount();
        int codeSimplificationArithmeticCount = codeSimplificationArithmeticCounter.getCount();
        int codeSimplificationCastCount = codeSimplificationCastCounter.getCount();
        int codeSimplificationFieldCount = codeSimplificationFieldCounter.getCount();
        int codeSimplificationBranchCount = codeSimplificationBranchCounter.getCount();
        int codeSimplificationObjectCount = codeSimplificationObjectCounter.getCount();
        int codeSimplificationStringCount = codeSimplificationStringCounter.getCount();
        int codeSimplificationMathCount = codeSimplificationMathCounter.getCount();
        int codeSimplificationAndroidMathCount = codeSimplificationAndroidMathCounter.getCount();
        int codeSimplificationAdvancedCount = codeSimplificationAdvancedCounter.getCount();
        int codeRemovalCount = deletedCounter.getCount() - addedCounter.getCount();
        int codeRemovalVariableCount = codeRemovalVariableCounter.getCount();
        int codeRemovalExceptionCount = codeRemovalExceptionCounter.getCount();
        int codeAllocationVariableCount = codeAllocationVariableCounter.getCount();
        if (codeSimplificationAdvancedCount == 0) {
            fieldPropagationValueCount = 0;
            methodPropagationParameterCount = 0;
            methodPropagationReturnvalueCount = 0;
        }
        logger.info("  Number of finalized classes:                   {}{}", (Object)classMarkingFinalCount, (Object)this.disabled(this.classMarkingFinal));
        logger.info("  Number of unboxed enum classes:                {}{}", (Object)classUnboxingEnumCount, (Object)this.disabled(this.classUnboxingEnum));
        logger.info("  Number of vertically merged classes:           {}{}", (Object)classMergingVerticalCount, (Object)this.disabled(this.classMergingVertical));
        logger.info("  Number of horizontally merged classes:         {}{}", (Object)classMergingHorizontalCount, (Object)this.disabled(this.classMergingHorizontal));
        logger.info("  Number of merged wrapper classes:              {}{}", (Object)classMergingWrapperCount, (Object)this.disabled(this.classMergingWrapper));
        logger.info("  Number of removed write-only fields:           {}{}", (Object)fieldRemovalWriteonlyCount, (Object)this.disabled(this.fieldRemovalWriteonly));
        logger.info("  Number of privatized fields:                   {}{}", (Object)fieldMarkingPrivateCount, (Object)this.disabled(this.fieldMarkingPrivate));
        logger.info("  Number of generalized field accesses:          {}{}", (Object)fieldGeneralizationClassCount, (Object)this.disabled(this.fieldGeneralizationClass));
        logger.info("  Number of specialized field types:             {}{}", (Object)fieldSpecializationTypeCount, (Object)this.disabled(this.fieldSpecializationType));
        logger.info("  Number of inlined constant fields:             {}{}", (Object)fieldPropagationValueCount, (Object)this.disabled(this.fieldPropagationValue));
        logger.info("  Number of privatized methods:                  {}{}", (Object)methodMarkingPrivateCount, (Object)this.disabled(this.methodMarkingPrivate));
        logger.info("  Number of staticized methods:                  {}{}", (Object)methodMarkingStaticCount, (Object)this.disabled(this.methodMarkingStatic));
        logger.info("  Number of finalized methods:                   {}{}", (Object)methodMarkingFinalCount, (Object)this.disabled(this.methodMarkingFinal));
        logger.info("  Number of desynchronized methods:              {}{}", (Object)methodMarkingSynchronizedCount, (Object)this.disabled(this.methodMarkingSynchronized));
        logger.info("  Number of simplified method signatures:        {}{}", (Object)methodRemovalParameterCount1, (Object)this.disabled(this.methodRemovalParameter));
        logger.info("  Number of removed method parameters:           {}{}", (Object)methodRemovalParameterCount2, (Object)this.disabled(this.methodRemovalParameter));
        logger.info("  Number of generalized method invocations:      {}{}", (Object)methodGeneralizationClassCount, (Object)this.disabled(this.methodGeneralizationClass));
        logger.info("  Number of specialized method parameter types:  {}{}", (Object)methodSpecializationParametertypeCount, (Object)this.disabled(this.methodSpecializationParametertype));
        logger.info("  Number of specialized method return types:     {}{}", (Object)methodSpecializationReturntypeCount, (Object)this.disabled(this.methodSpecializationReturntype));
        logger.info("  Number of inlined constant parameters:         {}{}", (Object)methodPropagationParameterCount, (Object)this.disabled(this.methodPropagationParameter));
        logger.info("  Number of inlined constant return values:      {}{}", (Object)methodPropagationReturnvalueCount, (Object)this.disabled(this.methodPropagationReturnvalue));
        logger.info("  Number of inlined short method calls:          {}{}", (Object)methodInliningShortCount, (Object)this.disabled(this.methodInliningShort));
        logger.info("  Number of inlined unique method calls:         {}{}", (Object)methodInliningUniqueCount, (Object)this.disabled(this.methodInliningUnique));
        logger.info("  Number of inlined tail recursion calls:        {}{}", (Object)methodInliningTailrecursionCount, (Object)this.disabled(this.methodInliningTailrecursion));
        logger.info("  Number of merged code blocks:                  {}{}", (Object)codeMergingCount, (Object)this.disabled(this.codeMerging));
        logger.info("  Number of variable peephole optimizations:     {}{}", (Object)codeSimplificationVariableCount, (Object)this.disabled(this.codeSimplificationVariable));
        logger.info("  Number of arithmetic peephole optimizations:   {}{}", (Object)codeSimplificationArithmeticCount, (Object)this.disabled(this.codeSimplificationArithmetic));
        logger.info("  Number of cast peephole optimizations:         {}{}", (Object)codeSimplificationCastCount, (Object)this.disabled(this.codeSimplificationCast));
        logger.info("  Number of field peephole optimizations:        {}{}", (Object)codeSimplificationFieldCount, (Object)this.disabled(this.codeSimplificationField));
        logger.info("  Number of branch peephole optimizations:       {}{}", (Object)codeSimplificationBranchCount, (Object)this.disabled(this.codeSimplificationBranch));
        logger.info("  Number of object peephole optimizations:       {}{}", (Object)codeSimplificationObjectCount, (Object)this.disabled(this.codeSimplificationObject));
        logger.info("  Number of string peephole optimizations:       {}{}", (Object)codeSimplificationStringCount, (Object)this.disabled(this.codeSimplificationString));
        logger.info("  Number of math peephole optimizations:         {}{}", (Object)codeSimplificationMathCount, (Object)this.disabled(this.codeSimplificationMath));
        if (configuration.android) {
            logger.info("  Number of Android math peephole optimizations: {}{}", (Object)codeSimplificationAndroidMathCount, (Object)this.disabled(this.codeSimplificationMath));
        }
        logger.info("  Number of simplified instructions:             {}{}", (Object)codeSimplificationAdvancedCount, (Object)this.disabled(this.codeSimplificationAdvanced));
        logger.info("  Number of removed instructions:                {}{}", (Object)codeRemovalCount, (Object)this.disabled(this.codeRemovalAdvanced));
        logger.info("  Number of removed local variables:             {}{}", (Object)codeRemovalVariableCount, (Object)this.disabled(this.codeRemovalVariable));
        logger.info("  Number of removed exception blocks:            {}{}", (Object)codeRemovalExceptionCount, (Object)this.disabled(this.codeRemovalException));
        logger.info("  Number of optimized local variable frames:     {}{}", (Object)codeAllocationVariableCount, (Object)this.disabled(this.codeAllocationVariable));
        this.moreOptimizationsPossible = classMarkingFinalCount > 0 || classUnboxingEnumCount > 0 || classMergingVerticalCount > 0 || classMergingHorizontalCount > 0 || classMergingWrapperCount > 0 || fieldRemovalWriteonlyCount > 0 || fieldMarkingPrivateCount > 0 || methodMarkingPrivateCount > 0 || methodMarkingStaticCount > 0 || methodMarkingFinalCount > 0 || fieldGeneralizationClassCount > 0 || fieldSpecializationTypeCount > 0 || fieldPropagationValueCount > 0 || methodRemovalParameterCount1 > 0 || methodRemovalParameterCount2 > 0 || methodGeneralizationClassCount > 0 || methodSpecializationParametertypeCount > 0 || methodSpecializationReturntypeCount > 0 || methodPropagationParameterCount > 0 || methodPropagationReturnvalueCount > 0 || methodInliningShortCount > 0 || methodInliningUniqueCount > 0 || methodInliningTailrecursionCount > 0 || codeMergingCount > 0 || codeSimplificationVariableCount > 0 || codeSimplificationArithmeticCount > 0 || codeSimplificationCastCount > 0 || codeSimplificationFieldCount > 0 || codeSimplificationBranchCount > 0 || codeSimplificationObjectCount > 0 || codeSimplificationStringCount > 0 || codeSimplificationMathCount > 0 || codeSimplificationAndroidMathCount > 0 || codeSimplificationAdvancedCount > 0 || codeRemovalCount > 0 || codeRemovalVariableCount > 0 || codeRemovalExceptionCount > 0 || codeAllocationVariableCount > 0;
    }

    private List<InstructionVisitor> createPeepholeOptimizations(Configuration configuration, InstructionSequenceConstants sequences, BranchTargetFinder branchTargetFinder, CodeAttributeEditor codeAttributeEditor, InstructionCounter codeSimplificationVariableCounter, InstructionCounter codeSimplificationArithmeticCounter, InstructionCounter codeSimplificationCastCounter, InstructionCounter codeSimplificationFieldCounter, InstructionCounter codeSimplificationBranchCounter, InstructionCounter codeSimplificationObjectCounter, InstructionCounter codeSimplificationStringCounter, InstructionCounter codeSimplificationMathCounter, InstructionCounter codeSimplificationAndroidMathCounter, InstructionCounter fieldGeneralizationClassCounter, InstructionCounter methodGeneralizationClassCounter) {
        ArrayList<InstructionVisitor> peepholeOptimizations = new ArrayList<InstructionVisitor>();
        if (this.codeSimplificationVariable) {
            peepholeOptimizations.add(new InstructionSequencesReplacer(sequences.CONSTANTS, sequences.VARIABLE_SEQUENCES, branchTargetFinder, codeAttributeEditor, (InstructionVisitor)codeSimplificationVariableCounter));
        }
        if (this.codeSimplificationArithmetic) {
            peepholeOptimizations.add(new InstructionSequencesReplacer(sequences.CONSTANTS, sequences.ARITHMETIC_SEQUENCES, branchTargetFinder, codeAttributeEditor, (InstructionVisitor)codeSimplificationArithmeticCounter));
        }
        if (this.codeSimplificationCast) {
            peepholeOptimizations.add(new InstructionSequencesReplacer(sequences.CONSTANTS, sequences.CAST_SEQUENCES, branchTargetFinder, codeAttributeEditor, (InstructionVisitor)codeSimplificationCastCounter));
        }
        if (this.codeSimplificationField) {
            peepholeOptimizations.add(new InstructionSequencesReplacer(sequences.CONSTANTS, sequences.FIELD_SEQUENCES, branchTargetFinder, codeAttributeEditor, (InstructionVisitor)codeSimplificationFieldCounter));
        }
        if (this.codeSimplificationBranch) {
            peepholeOptimizations.add(new InstructionSequencesReplacer(sequences.CONSTANTS, sequences.BRANCH_SEQUENCES, branchTargetFinder, codeAttributeEditor, (InstructionVisitor)codeSimplificationBranchCounter));
        }
        if (this.codeSimplificationObject) {
            peepholeOptimizations.add(new InstructionSequencesReplacer(sequences.CONSTANTS, sequences.OBJECT_SEQUENCES, branchTargetFinder, codeAttributeEditor, (InstructionVisitor)codeSimplificationObjectCounter));
            peepholeOptimizations.add(new NoConstructorReferenceReplacer(codeAttributeEditor, codeSimplificationObjectCounter));
        }
        if (this.codeSimplificationString) {
            peepholeOptimizations.add(new InstructionSequencesReplacer(sequences.CONSTANTS, sequences.STRING_SEQUENCES, branchTargetFinder, codeAttributeEditor, (InstructionVisitor)codeSimplificationStringCounter));
        }
        if (this.codeSimplificationMath) {
            peepholeOptimizations.add(new InstructionSequencesReplacer(sequences.CONSTANTS, sequences.MATH_SEQUENCES, branchTargetFinder, codeAttributeEditor, (InstructionVisitor)codeSimplificationMathCounter));
            if (configuration.android) {
                peepholeOptimizations.add(new InstructionSequencesReplacer(sequences.CONSTANTS, sequences.MATH_ANDROID_SEQUENCES, branchTargetFinder, codeAttributeEditor, (InstructionVisitor)codeSimplificationAndroidMathCounter));
            }
        }
        if (this.codeSimplificationBranch) {
            peepholeOptimizations.add(new GotoGotoReplacer(codeAttributeEditor, codeSimplificationBranchCounter));
            peepholeOptimizations.add(new GotoReturnReplacer(codeAttributeEditor, codeSimplificationBranchCounter));
        }
        if (this.fieldGeneralizationClass || this.methodGeneralizationClass) {
            peepholeOptimizations.add(new MemberReferenceGeneralizer(this.fieldGeneralizationClass, this.methodGeneralizationClass, codeAttributeEditor, fieldGeneralizationClassCounter, methodGeneralizationClassCounter));
        }
        return peepholeOptimizations;
    }

    private String disabled(boolean flag) {
        return flag ? "" : "   (disabled)";
    }

    private String disabled(boolean flag1, boolean flag2) {
        return flag1 && flag2 ? "" : (flag1 || flag2 ? "   (partially disabled)" : "   (disabled)");
    }
}

