/*
 * Decompiled with CFR 0.152.
 */
package proguard.configuration;

import java.io.IOException;
import proguard.AppView;
import proguard.classfile.ClassPool;
import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.visitor.AllAttributeVisitor;
import proguard.classfile.editor.CodeAttributeEditor;
import proguard.classfile.editor.PeepholeEditor;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.visitor.InstructionVisitor;
import proguard.classfile.util.BranchTargetFinder;
import proguard.classfile.util.ClassReferenceInitializer;
import proguard.classfile.util.ClassSubHierarchyInitializer;
import proguard.classfile.visitor.AllMethodVisitor;
import proguard.classfile.visitor.ClassPoolFiller;
import proguard.classfile.visitor.ClassProcessingFlagFilter;
import proguard.classfile.visitor.MultiClassVisitor;
import proguard.configuration.ConfigurationLogger;
import proguard.configuration.ConfigurationLoggingInstructionSequenceConstants;
import proguard.configuration.ConfigurationLoggingInstructionSequencesReplacer;
import proguard.io.ClassPathDataEntry;
import proguard.io.ClassReader;
import proguard.io.ExtraDataEntryNameMap;
import proguard.pass.Pass;
import proguard.util.ProcessingFlagSetter;

public class ConfigurationLoggingAdder
implements Pass {
    @Override
    public void execute(AppView appView) throws IOException {
        ClassReader classReader = new ClassReader(false, false, false, false, null, new MultiClassVisitor(new ClassPoolFiller(appView.programClassPool), new ClassReferenceInitializer(appView.programClassPool, appView.libraryClassPool), new ClassSubHierarchyInitializer(), new ProcessingFlagSetter(512)));
        classReader.read(new ClassPathDataEntry(ConfigurationLogger.ClassInfo.class));
        classReader.read(new ClassPathDataEntry(ConfigurationLogger.MemberInfo.class));
        classReader.read(new ClassPathDataEntry(ConfigurationLogger.class));
        this.initializeConfigurationLogger(appView.programClassPool);
        ConfigurationLoggingInstructionSequenceConstants constants = new ConfigurationLoggingInstructionSequenceConstants(appView.programClassPool, appView.libraryClassPool);
        BranchTargetFinder branchTargetFinder = new BranchTargetFinder();
        CodeAttributeEditor codeAttributeEditor = new CodeAttributeEditor();
        appView.programClassPool.classesAccept(new ClassProcessingFlagFilter(0, 512, new AllMethodVisitor(new AllAttributeVisitor(new PeepholeEditor(branchTargetFinder, codeAttributeEditor, new ConfigurationLoggingInstructionSequencesReplacer(constants.CONSTANTS, constants.RESOURCE, branchTargetFinder, codeAttributeEditor, (InstructionVisitor)new ExtraClassAdder(appView.extraDataEntryNameMap)))))));
    }

    private void initializeConfigurationLogger(ClassPool programClassPool) {
        ProgramClass configurationLoggerClass = (ProgramClass)programClassPool.getClass(ConfigurationLoggingInstructionSequenceConstants.LOGGER_CLASS_NAME);
        if (configurationLoggerClass == null) {
            throw new RuntimeException("ConfigurationLogger class could not be found in the program classpool.");
        }
    }

    private static class ExtraClassAdder
    implements InstructionVisitor {
        private final ExtraDataEntryNameMap extraDataEntryNameMap;

        ExtraClassAdder(ExtraDataEntryNameMap extraDataEntryNameMap) {
            this.extraDataEntryNameMap = extraDataEntryNameMap;
        }

        @Override
        public void visitAnyInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, Instruction instruction) {
            this.extraDataEntryNameMap.addExtraClassToClass(clazz, ConfigurationLogger.class);
            this.extraDataEntryNameMap.addExtraClassToClass(clazz, ConfigurationLogger.ClassInfo.class);
            this.extraDataEntryNameMap.addExtraClassToClass(clazz, ConfigurationLogger.MemberInfo.class);
        }
    }
}

