/* big parts taken from cdfs (C) 1999, 2000, 2001 by Michiel Ronsse
 * relesed under the GPL v.2
 * more parts taken from isoinfo/isodump (W) 1993 Eric Youngdale,
 * (C) 1993 Yggdrasil Computing, Incorporated, also released
 * under the GPL v.2
 *
 * Cut down for fast detection if disc inserted only. BK may 2008
 */

#ifndef lint
static char vcid[] = "$Id: cddetect.c,v 2.0 2005/05/10 14:48:26 bodo Exp $";
#endif

#include <sys/ioctl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/wait.h>
#include <fcntl.h>
#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>
#include <string.h>
#include <errno.h>
#include <linux/cdrom.h>
#include <linux/iso_fs.h>


#define CDDEVICE "/dev/cdrom"


static struct {
	unsigned int verbose;
	unsigned int quiet;
	unsigned char device[255];
} opts = { 0, 0, CDDEVICE };


void usage(const char *progname)
{
	fprintf(stderr,"usage: cddetect_quick -d/dev/sr0");
	exit(0);
}


int main(int argc, char *const *argv)
{
	int fd;
	int status;
	int optchar;

	while ((optchar = getopt(argc, argv, "hVd:vq")) != EOF)
		switch (optchar) {
			case 'V': fprintf(stderr, "%s\n", vcid); exit(0); break;
			case 'd': strncpy(opts.device, optarg, sizeof(opts.device)); break;
			case 'v': opts.verbose++; break;
			case 'q': opts.quiet++; break;
			case 'h':
			default: usage(argv[0]);
		}
	if (optind < argc)
		usage(argv[0]);

	if (opts.verbose > 0 && opts.quiet > 0)
		usage(argv[0]);

	fd = open(opts.device, O_RDONLY | O_NONBLOCK);
	if (fd < 0)
		exit(-1);

	// read the drive status info
	status = ioctl(fd, CDROM_DRIVE_STATUS, CDSL_CURRENT);

	// CDS_NO_INFO: function not implemented
	// CDS_NO_DISC: no disc
	// CDS_TRAY_OPEN: tray open
	// CDS_DRIVE_NOT_READY: drive not ready
	// CDS_DISC_OK: disk OK

	switch(status) {
		case CDS_NO_DISC:
			close(fd);
			printf("no disc\n");
			return -1;
			break;
		case CDS_TRAY_OPEN:
			close(fd);
			printf("tray open\n");
			return -1;
			break;
		case CDS_DRIVE_NOT_READY:
			close(fd);
			printf("drive not ready\n");
			return -1;
			break;
		case CDS_DISC_OK:
			close(fd);
			printf("disc inserted\n");
			return 0;
			break;
		default: // unidentified problem
			close(fd);
			printf("unidentified error\n");
			return -1;
			break;
	}


}
