/*
  This file is licensed to You under the Apache License, Version 2.0
  (the "License"); you may not use this file except in compliance with
  the License.  You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  See the License for the specific language governing permissions and
  limitations under the License.
*/
package org.xmlunit.diff;

import static org.hamcrest.Matchers.containsString;
import static org.junit.Assert.assertThat;

import org.junit.Test;
import org.xmlunit.NullNode;

public class DifferenceTest {

    @Test
    public void trivialToStringTest() {
        Difference d = new Difference(new Comparison(ComparisonType.NODE_TYPE,
                                                     new NullNode(), "/", new Short("2"), "",
                                                     new NullNode(), "/", new Short("2"), ""),
                                      ComparisonResult.EQUAL);
        assertThat(d.toString(), containsString(" (EQUAL)"));
    }
}
