/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.jdiskreport.gui.application;

import com.jgoodies.app.gui.basics.icon.windows.WindowsIcon;
import com.jgoodies.common.swing.focus.FocusTraversalUtils;
import com.jgoodies.components.JGComponentFactory;
import com.jgoodies.components.JGSearchField;
import com.jgoodies.fluent.appbar.CommandBar;
import com.jgoodies.fluent.internal.FluentButtonFactory;
import com.jgoodies.fluent.resources.WindowsThemes;
import com.jgoodies.framework.osx.OSXApplicationMenu;
import com.jgoodies.jdiskreport.gui.application.JDApplicationModel;
import com.jgoodies.jdiskreport.gui.application.JDResultModel;
import com.jgoodies.layout.builder.FormBuilder;
import com.jgoodies.search.CompletionManager;
import com.jgoodies.search.CompletionProcessor;
import java.awt.Color;
import java.awt.Insets;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;

final class JDResultAppBar
extends FluentButtonFactory {
    private final JDApplicationModel applicationModel;
    private final JDResultModel resultModel;
    private AbstractButton backButton;
    private AbstractButton nextButton;
    private AbstractButton upButton;
    private AbstractButton refreshButton;
    private JGSearchField searchField;

    JDResultAppBar(JDApplicationModel applicationModel) {
        super(null);
        this.applicationModel = applicationModel;
        this.resultModel = applicationModel.getResultModel();
        this.initComponents();
    }

    private void initComponents() {
        this.backButton = this.createButton(this.resultModel.getHistory().getBackAction(), WindowsIcon.BACK);
        this.nextButton = this.createButton(this.resultModel.getHistory().getNextAction(), WindowsIcon.FORWARD);
        this.upButton = this.createButton(this.resultModel.getAction("Up"), WindowsIcon.UP);
        this.refreshButton = this.createButton(this.applicationModel.getAction("Refresh"), null);
        JGComponentFactory factory = JGComponentFactory.getCurrent();
        this.searchField = factory.createSearchField(JGSearchField.SearchMode.INSTANT);
        this.searchField.setMargin(new Insets(0, 5, 0, 0));
        this.searchField.setPrompt("Search folders");
        this.searchField.setPromptVisibleWhenFocused(true);
        FocusTraversalUtils.markAsPoorDefaultFocusOwner(this.searchField);
        CompletionProcessor processor = this.resultModel.getNavigationModel().getSearchProcessor();
        CompletionManager manager = new CompletionManager(processor);
        manager.setCompletionPrototypeDisplayValue("012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789");
        manager.setAutoCompletionEnabled(false);
        manager.install(this.searchField);
        manager.addCompletionApplicationListener(this.resultModel::onCompletionApplied);
    }

    private JButton createButton(Action action, WindowsIcon disabledIcon) {
        JButton button = this.createButton(action);
        if (disabledIcon != null) {
            button.setDisabledIcon(disabledIcon.toIcon(Color.GRAY));
        }
        button.setHideActionText(true);
        return button;
    }

    JComponent buildAll() {
        return ((FormBuilder)((FormBuilder)((FormBuilder)((FormBuilder)((FormBuilder)((FormBuilder)((FormBuilder)((FormBuilder)((FormBuilder)new FormBuilder().columns("pref, pref, pref, pref, 24epx, fill:100dlu:grow, 0epx, right:default", new Object[0])).rows("f:p", new Object[0])).background(WindowsThemes.light().background())).add(this.backButton).xy(1, 1)).add(this.nextButton).xy(2, 1)).add(this.upButton).xy(3, 1)).add(this.refreshButton).xy(4, 1)).add(this.buildDecoratedSearchField()).xy(6, 1)).add(this.buildPresentationBar()).xy(8, 1)).build();
    }

    private JComponent buildPresentationBar() {
        CommandBar.Builder builder = new CommandBar.Builder().actionTextsHidden(true).primary(this.applicationModel.getAction("Scan"), this.applicationModel.getAction("OpenScan"), this.applicationModel.getAction("SaveScan")).primarySeparator().primary(this.resultModel.getAction("ShowSizePie")).primary(this.resultModel.getAction("ShowLargestTable")).secondary(this.resultModel.getAction("ShowSizeRing"), this.resultModel.getAction("ShowSizeMap")).secondarySeparator().secondary(this.resultModel.getAction("ShowDistributionBar"), this.resultModel.getAction("ShowAccessBar"), this.resultModel.getAction("ShowModifiedBar"), this.resultModel.getAction("ShowTypesPie")).secondarySeparator().secondary(this.resultModel.getAction("ShowDetails"));
        if (!OSXApplicationMenu.isRegistered()) {
            builder.secondarySeparator().secondary(this.applicationModel.getAction("Preferences")).secondary(this.applicationModel.getAction("About"));
        }
        return builder.buildPanel();
    }

    private JComponent buildDecoratedSearchField() {
        return ((FormBuilder)((FormBuilder)((FormBuilder)new FormBuilder().columns("0, 75dlu:grow", new Object[0])).rows("9epx, f:30epx, 9epx", new Object[0])).add(this.searchField).xy(2, 2)).build();
    }
}

