/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.chart;

import com.jgoodies.chart.AbstractTreeChart;
import com.jgoodies.chart.TreeChartModel;
import java.awt.Color;
import java.awt.Graphics2D;

public final class TreeMapChart<T>
extends AbstractTreeChart<T> {
    private static final int MAX_LEVEL = 35;

    public TreeMapChart(TreeChartModel<T> model) {
        super(model);
    }

    @Override
    protected void render(Graphics2D g2, T root) {
        int level = 0;
        float startHue = 0.0f;
        float stopHue = 1.0f;
        float saturation = 0.5f;
        float brightness = 0.9f;
        this.render(g2, root, level, 0, 0, this.getWidth(), this.getHeight(), startHue, stopHue, saturation, brightness);
    }

    private void render(Graphics2D g2, T node, int level, int x, int y, int width, int height, float startHue, float stopHue, float saturation, float brightness) {
        int childCount = this.model.getChildCount(node);
        if (this.model.isLeaf(node)) {
            Color fillColor = Color.getHSBColor(startHue, saturation, brightness);
            g2.setColor(fillColor);
            g2.fillRect(x, y, width - 1, height - 1);
        }
        if (level < 35) {
            boolean isEven = level % 2 == 0;
            int extent = isEven ? width : height;
            int[] extents = this.computePartitions(node, extent);
            int start = isEven ? x : y;
            double totalHue = stopHue - startHue;
            for (int i = 0; i < childCount; ++i) {
                T childNode = this.model.getChild(node, i);
                int childExtent = extents[i];
                double nextChildStartHue = (double)startHue + totalHue * (double)((float)i / 14.0f);
                double nextChildStopHue = (double)startHue + totalHue * (double)((float)(i + 1) / 14.0f);
                this.render(g2, childNode, level + 1, isEven ? start : x, isEven ? y : start, isEven ? childExtent : width, isEven ? height : childExtent, (float)nextChildStartHue, (float)nextChildStopHue, saturation * 0.9f, brightness);
                start += childExtent;
            }
        }
    }
}

