/*
 * Decompiled with CFR 0.152.
 */
package org.dbuml.base.database;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;
import org.apache.log4j.Logger;

public abstract class QueryTransaction {
    private static final Logger LOG = Logger.getLogger(QueryTransaction.class);
    protected Connection connection;
    protected Statement statement;
    protected ResultSet resultSet;
    protected int maxRowCount = 20;
    protected boolean bHasRecords = false;
    protected String[] colNames;

    public abstract Vector getRows(Connection var1, String var2) throws SQLException;

    public abstract Vector getNextRows() throws SQLException;

    public abstract boolean hasRecords();

    public void setMaxRowCount(int maxRow) {
        this.maxRowCount = maxRow;
    }

    protected abstract void initializeColumnNames() throws SQLException;

    public String[] getColumnNames() {
        String[] names = new String[this.colNames.length];
        System.arraycopy(this.colNames, 0, names, 0, this.colNames.length);
        return names;
    }

    public int getColumnCount() {
        return this.colNames == null ? 0 : this.colNames.length;
    }

    public void close() {
        try {
            try {
                if (this.resultSet != null) {
                    this.resultSet.close();
                }
            }
            catch (SQLException se) {
                LOG.info((Object)se.getMessage());
            }
            if (this.statement != null) {
                this.statement.close();
            }
        }
        catch (SQLException e) {
            LOG.info((Object)e.getMessage());
        }
    }
}

