/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.rules.strings;

import net.sourceforge.pmd.AbstractRule;
import net.sourceforge.pmd.ast.ASTName;
import net.sourceforge.pmd.ast.ASTVariableDeclaratorId;
import net.sourceforge.pmd.symboltable.NameOccurrence;

public class StringToStringRule
extends AbstractRule {
    public Object visit(ASTVariableDeclaratorId node, Object data) {
        if (!node.getNameDeclaration().getTypeImage().equals("String")) {
            return data;
        }
        boolean isArray = node.isArray();
        for (NameOccurrence occ : node.getUsages()) {
            NameOccurrence qualifier = occ.getNameForWhichThisIsAQualifier();
            if (qualifier == null) continue;
            if (!isArray && qualifier.getImage().indexOf("toString") != -1) {
                this.addViolation(data, occ.getLocation());
                continue;
            }
            if (!isArray || qualifier.getLocation() == null || ASTName.class.equals(qualifier.getLocation().getClass()) || !qualifier.getImage().equals("toString")) continue;
            this.addViolation(data, occ.getLocation());
        }
        return data;
    }
}

