/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.rules;

import java.util.Stack;
import net.sourceforge.pmd.AbstractRule;
import net.sourceforge.pmd.ast.ASTBlockStatement;
import net.sourceforge.pmd.ast.ASTCatchStatement;
import net.sourceforge.pmd.ast.ASTClassOrInterfaceDeclaration;
import net.sourceforge.pmd.ast.ASTCompilationUnit;
import net.sourceforge.pmd.ast.ASTConditionalExpression;
import net.sourceforge.pmd.ast.ASTConstructorDeclaration;
import net.sourceforge.pmd.ast.ASTDoStatement;
import net.sourceforge.pmd.ast.ASTEnumDeclaration;
import net.sourceforge.pmd.ast.ASTExpression;
import net.sourceforge.pmd.ast.ASTForStatement;
import net.sourceforge.pmd.ast.ASTIfStatement;
import net.sourceforge.pmd.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.ast.ASTMethodDeclarator;
import net.sourceforge.pmd.ast.ASTSwitchLabel;
import net.sourceforge.pmd.ast.ASTSwitchStatement;
import net.sourceforge.pmd.ast.ASTWhileStatement;
import net.sourceforge.pmd.ast.Node;
import net.sourceforge.pmd.ast.SimpleNode;
import net.sourceforge.pmd.rules.design.NpathComplexity;

public class CyclomaticComplexity
extends AbstractRule {
    private int reportLevel;
    private Stack<Entry> entryStack = new Stack();

    public Object visit(ASTCompilationUnit node, Object data) {
        this.reportLevel = this.getIntProperty("reportLevel");
        super.visit(node, data);
        return data;
    }

    public Object visit(ASTIfStatement node, Object data) {
        int boolCompIf = NpathComplexity.sumExpressionComplexity(node.getFirstChildOfType(ASTExpression.class));
        this.entryStack.peek().bumpDecisionPoints(++boolCompIf);
        super.visit(node, data);
        return data;
    }

    public Object visit(ASTCatchStatement node, Object data) {
        this.entryStack.peek().bumpDecisionPoints();
        super.visit(node, data);
        return data;
    }

    public Object visit(ASTForStatement node, Object data) {
        int boolCompFor = NpathComplexity.sumExpressionComplexity(node.getFirstChildOfType(ASTExpression.class));
        this.entryStack.peek().bumpDecisionPoints(++boolCompFor);
        super.visit(node, data);
        return data;
    }

    public Object visit(ASTDoStatement node, Object data) {
        int boolCompDo = NpathComplexity.sumExpressionComplexity(node.getFirstChildOfType(ASTExpression.class));
        this.entryStack.peek().bumpDecisionPoints(++boolCompDo);
        super.visit(node, data);
        return data;
    }

    public Object visit(ASTSwitchStatement node, Object data) {
        Entry entry = this.entryStack.peek();
        int boolCompSwitch = NpathComplexity.sumExpressionComplexity(node.getFirstChildOfType(ASTExpression.class));
        entry.bumpDecisionPoints(boolCompSwitch);
        int childCount = node.jjtGetNumChildren();
        int lastIndex = childCount - 1;
        for (int n = 0; n < lastIndex; ++n) {
            ASTSwitchLabel sl;
            Node childNode = node.jjtGetChild(n);
            if (!(childNode instanceof ASTSwitchLabel) || (sl = (ASTSwitchLabel)childNode).isDefault() || !((childNode = node.jjtGetChild(n + 1)) instanceof ASTBlockStatement)) continue;
            entry.bumpDecisionPoints();
        }
        super.visit(node, data);
        return data;
    }

    public Object visit(ASTWhileStatement node, Object data) {
        int boolCompWhile = NpathComplexity.sumExpressionComplexity(node.getFirstChildOfType(ASTExpression.class));
        this.entryStack.peek().bumpDecisionPoints(++boolCompWhile);
        super.visit(node, data);
        return data;
    }

    public Object visit(ASTConditionalExpression node, Object data) {
        if (node.isTernary()) {
            int boolCompTern = NpathComplexity.sumExpressionComplexity(node.getFirstChildOfType(ASTExpression.class));
            this.entryStack.peek().bumpDecisionPoints(++boolCompTern);
            super.visit(node, data);
        }
        return data;
    }

    public Object visit(ASTClassOrInterfaceDeclaration node, Object data) {
        if (node.isInterface()) {
            return data;
        }
        this.entryStack.push(new Entry(node));
        super.visit(node, data);
        Entry classEntry = this.entryStack.pop();
        if (classEntry.getComplexityAverage() >= this.reportLevel || classEntry.highestDecisionPoints >= this.reportLevel) {
            this.addViolation(data, (Node)node, new String[]{"class", node.getImage(), classEntry.getComplexityAverage() + " (Highest = " + classEntry.highestDecisionPoints + ')'});
        }
        return data;
    }

    public Object visit(ASTMethodDeclaration node, Object data) {
        this.entryStack.push(new Entry(node));
        super.visit(node, data);
        Entry methodEntry = this.entryStack.pop();
        int methodDecisionPoints = methodEntry.decisionPoints;
        Entry classEntry = this.entryStack.peek();
        ++classEntry.methodCount;
        classEntry.bumpDecisionPoints(methodDecisionPoints);
        if (methodDecisionPoints > classEntry.highestDecisionPoints) {
            classEntry.highestDecisionPoints = methodDecisionPoints;
        }
        ASTMethodDeclarator methodDeclarator = null;
        for (int n = 0; n < node.jjtGetNumChildren(); ++n) {
            Node childNode = node.jjtGetChild(n);
            if (!(childNode instanceof ASTMethodDeclarator)) continue;
            methodDeclarator = (ASTMethodDeclarator)childNode;
            break;
        }
        if (methodEntry.decisionPoints >= this.reportLevel) {
            this.addViolation(data, (Node)node, new String[]{"method", methodDeclarator == null ? "" : methodDeclarator.getImage(), String.valueOf(methodEntry.decisionPoints)});
        }
        return data;
    }

    public Object visit(ASTEnumDeclaration node, Object data) {
        this.entryStack.push(new Entry(node));
        super.visit(node, data);
        Entry classEntry = this.entryStack.pop();
        if (classEntry.getComplexityAverage() >= this.reportLevel || classEntry.highestDecisionPoints >= this.reportLevel) {
            this.addViolation(data, (Node)node, new String[]{"class", node.getImage(), classEntry.getComplexityAverage() + "(Highest = " + classEntry.highestDecisionPoints + ')'});
        }
        return data;
    }

    public Object visit(ASTConstructorDeclaration node, Object data) {
        this.entryStack.push(new Entry(node));
        super.visit(node, data);
        Entry constructorEntry = this.entryStack.pop();
        int constructorDecisionPointCount = constructorEntry.decisionPoints;
        Entry classEntry = this.entryStack.peek();
        ++classEntry.methodCount;
        classEntry.decisionPoints += constructorDecisionPointCount;
        if (constructorDecisionPointCount > classEntry.highestDecisionPoints) {
            classEntry.highestDecisionPoints = constructorDecisionPointCount;
        }
        if (constructorEntry.decisionPoints >= this.reportLevel) {
            this.addViolation(data, (Node)node, new String[]{"constructor", classEntry.node.getImage(), String.valueOf(constructorDecisionPointCount)});
        }
        return data;
    }

    private static class Entry {
        private SimpleNode node;
        private int decisionPoints = 1;
        public int highestDecisionPoints;
        public int methodCount;

        private Entry(SimpleNode node) {
            this.node = node;
        }

        public void bumpDecisionPoints() {
            ++this.decisionPoints;
        }

        public void bumpDecisionPoints(int size) {
            this.decisionPoints += size;
        }

        public int getComplexityAverage() {
            return (double)this.methodCount == 0.0 ? 1 : (int)Math.rint((double)this.decisionPoints / (double)this.methodCount);
        }
    }
}

