Unless otherwise noted, the `*.gz`files were generated by the `gzip` command
line tool and the `*.deflate` and `*.zlib` versions were then generated by
`script/extract-deflate-offsets.go`. Similarly, the `*.giflzw` files were
generated by `script/extract-giflzw.go` and the `*.palette` and `*.indexes`
files were generated by `script/extract-palette-indexes.go`. The `*.tokens`
files were generated by `script/print-json-token-debug-format.c`.

The `*.jpeg` files are usually the canonical versions of the test/data images,
and other versions (`*.bmp`, `*.gif`, `*.png` etc) were usually generated by
ImageMagick's `convert` command line tool. The `*.wbmp` versions were generated
by the `script/convert-png-to-wbmp.go` command line tool. The `*.webp` versions
were generated by the cwebp command line tool. The `*.no-ancillary.png` files
were generated by the `script/strip-png-ancillary-chunks.go` command line tool.
The `*.qoi` files were generated by the qoiconv command line tool. The `*.pkm`
files were generated by the ETCPACK command line tool, except the `*.etc1s.pkm`
files were generated by a [custom
etc1tool](https://github.com/nigeltao/etc1tool).

The `*.apng` files were generated by `gif2apng`. Those with finite animation
loop counts were manually patched to correct for a `gif2apng` bug.
https://bugs.chromium.org/p/chromium/issues/detail?id=592735 argues that GIF
and APNG/WEBP have different semantics but `gif2apng` does not cater for that.

---

The `artificial-*` directories hold artificially generated test data, often to
explicitly test corner cases of various file formats. The files there usually
come in families whose names have a common prefix, such as three files
`foo.bar`, `foo.bar.qux`, `foo.bar.commentary.txt` all prefixed by `foo.bar`.
The file whose name is that prefix is usually the canonical (typically
hand-crafted) file, and the other files are then derived from that. Outside of
the `artificial-*` directories, the other files in this directory are typically
real world examples of various file formats, or deriviations of them.

---

The non-ascii directory holds trivial UTF-8 (but not ASCII) text files.

---

`DCI-P3-D65.icc` comes from
[color.org](https://www.color.org/chardata/rgb/DCIP3.xalter).
`DCI-P3-D65.icc.zlib` is a zlib-compresion of that, created by Go's standard
library.

`archive.*` archives a subset of other files in this directory.

`animated-red-blue.gif` is an original animation by Nigel Tao
<nigeltao@golang.org>. `animated-red-blue.nia` and `animated-red-blue.*.nie`
were then generated by `example/convert-to-nia` and
`script/extract-nia-frames.go`.

`australian-abc-local-stations.json` was crawled from
[data.gov.au](http://data.gov.au/geoserver/abc-local-stations/wfs?request=GetFeature&typeName=ckan_d534c0e9_a9bf_487b_ac8f_b7877a09d162&outputFormat=json).

`bricks-*` are various encodings of an original photo by Nigel Tao
<nigeltao@golang.org>.

`cbor-rfc-7049-examples.cbor` is the concatenated examples from RFC 7049. The
`cbor-rfc-7049-examples.*.json` files were then generated by
`example/cbor-to-json`.

`checkerboard.*.png` was generated by `script/make-red-blue-gradient.go`.

`crude-flag.*` is an original animation by Nigel Tao
<nigeltao@golang.org>. See the `lib/nie` documentation.

`enwik5` is the first 1e5 bytes of the [enwik8 or
enwik9](https://mattmahoney.net/dc/textdata.html) data, derived from the
English Wikipedia as of 2006.

`file-sizes.json` was created by running `script/print-file-sizes-json.go` in
this repository's root directory.

`gifplayer-muybridge.gif` is an original animation by Nigel Tao
<nigeltao@golang.org>.

`harvesters.*` are various encodings of a photo of "The Harvesters" by Pieter
Bruegel the Elder, held by the Metropolitan Museum of Art.
[www.metmuseum.org](http://www.metmuseum.org/art/collection/search/435809)
lists that image as in the public domain.

`github-tags.json` was crawled from
[api.github.com](https://api.github.com/repos/google/wuffs/tags).

`hat.*` are various encodings of a photo of "Self-Portrait with a Straw Hat
(obverse: The Potato Peeler)" by Vincent van Gogh, held by the Metropolitan
Museum of art.
[www.metmuseum.org](http://www.metmuseum.org/art/collection/search/436532)
lists that image as in the public domain.

`hello.sh` is a trivial shell script.

`hibiscus.regular.*` are various encodings of a photo of "Hibiscus and Parrots"
by Louis Comfort Tiffany, held by the Metropolitan Museum of Art.
[www.metmuseum.org](http://www.metmuseum.org/art/collection/search/13503) lists
that image as in the public domain.

`hibiscus.primitive.*` is the result of running the `hibiscus.regular.png`
image through `github.com/fogleman/primitive` and other programs:
  - `primitive -i hibiscus.regular.png -o hibiscus.primitive.svg -s 442 -n 32`
  - `inkscape -z -e hibiscus.primitive.png hibiscus.primitive.svg`
  - Various invocations of `convert` and `cwebp`

`hippopotamus.*` are various encodings of a cropping of a photo of
"Hippopotamus (William)", held by the Metropolitan Museum of Art.
[www.metmuseum.org](http://www.metmuseum.org/art/collection/search/544227)
lists that image as in the public domain.

[www.metmuseum.org](http://www.metmuseum.org/about-the-met/policies-and-documents/image-resources)
says that "You are welcome to use images of artworks in The Met collection that
the Museum believes to be in the public domain, or those to which the Museum
waives any copyright it might have, for any purpose, including commercial and
noncommercial use, free of charge and without requiring permission from the
Museum."

`json-things.*` are original JSON objects by Nigel Tao <nigeltao@golang.org>.

`midsummer.txt` is an excerpt of Shakespeare's "A Midsummer Night's Dream",
copied from
[shakespeare.mit.edu](http://shakespeare.mit.edu/midsummer/midsummer.1.1.html).

`mona-lisa.*` is derived from a Wikimedia Commons [photo of the Mona
Lisa](https://en.wikipedia.org/wiki/File:Mona_Lisa,_by_Leonardo_da_Vinci,_from_C2RMF_retouched.jpg).

`muybridge.gif` is derived from
[en.wikipedia.org](https://en.wikipedia.org/wiki/File:Muybridge_race_horse_animated.gif)
which is in the public domain.

`nobel-prizes.json` was crawled from
[api.nobelprize.org](http://api.nobelprize.org/v1/prize.json).

`peacock.*` is derived from this [peacock (pavo cristatus)
image](https://commons.wikimedia.org/wiki/File:Pavo_Real_Venezolano.jpg),
"available under the Creative Commons CC0 1.0 Universal Public Domain
Dedication":
  - `wget --quiet https://upload.wikimedia.org/wikipedia/commons/thumb/6/6f/Pavo_Real_Venezolano.jpg/1024px-Pavo_Real_Venezolano.jpg`
  - `convert 1024px-Pavo_Real_Venezolano.jpg -resize 100x75 peacock.ppm`
  - `convert peacock.ppm peacock.png`
  - `rm 1024px-Pavo_Real_Venezolano.jpg`
  - `cjpeg peacock.ppm > peacock.default.jpeg`
  - `cjpeg -optimize peacock.ppm > peacock.optimize.jpeg`
  - `cjpeg -grayscale peacock.ppm > peacock.grayscale.jpeg`
  - `cjpeg -progressive peacock.ppm > peacock.progressive.jpeg`
  - `cjpeg -quality 30 peacock.ppm > peacock.q30.jpeg`
  - `cjpeg -quality 99 peacock.ppm > peacock.q99.jpeg`
  - `cjpeg -sample 2x2 peacock.ppm > peacock.s2x2-420.jpeg`
  - `cjpeg -sample 2x1 peacock.ppm > peacock.s2x1-422.jpeg`
  - `cjpeg -sample 1x1 peacock.ppm > peacock.s1x1-444.jpeg`
  - `cjpeg -sample 1x3 peacock.ppm > peacock.s1x3.jpeg`
  - `cjpeg -sample 2x2,2x1,1x1 peacock.ppm > peacock.s-weird.jpeg`
  - `cjpeg -sample 4x1,2x1,2x2 peacock.ppm > peacock.s-very-weird.jpeg`
  - `go run ../../script/truncate-progressive-jpeg.go peacock.progressive.jpeg`

`pi.txt` contains the digits of pi.

`pjw-thumbnail.*` are various encodings of an image derived from an iconic,
original photo of Peter J. Weinberger by Rob Pike <r@golang.org>.

`red-blue-gradient.*.png` was generated by `script/make-red-blue-gradient.go`.

`rfc-6901-json-pointer.json` is the example JSON document given in the [RFC
6901 "JavaScript Object Notation (JSON)
Pointer"](https://tools.ietf.org/rfc/rfc6901.txt) specification.

`rgb24png.bmp` comes from [BMP Suite](https://github.com/jsummers/bmpsuite),
which states that its generated images "are in the public domain".

`ridiculously-fast.png` is a screenshot of a [Richard Geldreich
tweet](https://twitter.com/richgel999/status/1481027198530248714) from January
2022. It was lightly edited to darken the non-text areas.

`romeo.txt` is an excerpt of Shakespeare's "Romeo and Juliet", copied from
[shakespeare.mit.edu](http://shakespeare.mit.edu/romeo_juliet/romeo_juliet.2.2.html).

`romeo.txt.fixed-huff.deflate` was derived from `romeo.txt` by a custom program
to use fixed (not dynamic) Huffman tables for the deflate encoding.

`sheep-more.rac` is a RAC-compression of original text by Nigel Tao
<nigeltao@golang.org>.
