// $Id$

// Fish Supper
// Copyright 2006, 2007, 2009, 2010 Matthew Clarke <mafferyew@googlemail.com>
//
// This file is part of Fish Supper.
//
// Fish Supper is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Fish Supper is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Fish Supper.  If not, see <http://www.gnu.org/licenses/>.




#include "Useful_gl.h"




// **************************************************

GLuint Mafferyew::Useful_gl::create_opengl_texture_rgba(const std::string& image_file,
                                                        int* w,
                                                        int* h)
{
    SDL_Surface* image = IMG_Load( image_file.c_str() );
    SDL_SetAlpha(image, 0, 0);
    
    int tex_w = power_of_two( image->w );
    int tex_h = power_of_two( image->h );
    
    // Record texture dimensions in 'w' and 'h' (for client).
    *w = tex_w;
    *h = tex_h;
    
#if SDL_BYTEORDER == SDL_BIG_ENDIAN
    SDL_Surface* conv = SDL_CreateRGBSurface(
            SDL_SWSURFACE,
            tex_w, tex_h,
            image->format->BitsPerPixel,   // should be 32 
            0xff000000, 0x00ff0000, 0x0000ff00, 0x000000ff);
#else
    SDL_Surface* conv = SDL_CreateRGBSurface(
            SDL_SWSURFACE,
            tex_w, tex_h,
            image->format->BitsPerPixel,   // should be 32 
            0x000000ff, 0x0000ff00, 0x00ff0000, 0xff000000);
#endif
    
    SDL_BlitSurface(image, 0, conv, 0);
    
    GLuint tex; // our texture handle
    glGenTextures(1, &tex);
    glBindTexture(GL_TEXTURE_2D, tex);
    glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_NEAREST);
    glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_NEAREST);
    glTexImage2D(GL_TEXTURE_2D, 
            0, // level - 0 unless multiple resolutions 
            conv->format->BytesPerPixel, 
            conv->w, conv->h, 
            0, // border 
            GL_RGBA, 
            GL_UNSIGNED_BYTE, 
            conv->pixels);
    
    // clean up
    SDL_FreeSurface(conv);
    SDL_FreeSurface(image);
    
    return tex;
    
} // Mafferyew::Useful_gl::create_opengl_texture_rgba

// **************************************************

// Thanks, Super Tux! (http://supertux.lethargik.org/)
int Mafferyew::Useful_gl::power_of_two(int input)
{
    int value = 1;

    while ( value < input )
    {
        value <<= 1;
    } // while

    return value;
  
} // Mafferyew::Useful_gl::power_of_two

// **************************************************

Uint32 Mafferyew::Useful_gl::get_pixel(SDL_Surface* surface, int x, int y)
{
    int bpp = surface->format->BytesPerPixel;
    // Here p is the address to the pixel we want to retrieve. 
    Uint8* p = (Uint8*)surface->pixels + y * surface->pitch + x * bpp;

    switch (bpp) 
    {
        case 1:
            return *p;

        case 2:
            return *(Uint16*)p;

        case 3:
            if(SDL_BYTEORDER == SDL_BIG_ENDIAN)
            {
                return p[0] << 16 | p[1] << 8 | p[2];
            }
            else
            {
                return p[0] | p[1] << 8 | p[2] << 16;
            } // if ... else

        case 4:
            return *(Uint32*)p;

        default:
            return 0;       // shouldn't happen, but avoids warnings 
    } // switch

} // Mafferyew::Useful_gl::get_pixel

// **************************************************
