// $Id$

// Fish Supper
// Copyright 2006, 2007, 2009, 2010 Matthew Clarke <mafferyew@googlemail.com>
//
// This file is part of Fish Supper.
//
// Fish Supper is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Fish Supper is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Fish Supper.  If not, see <http://www.gnu.org/licenses/>.




#ifndef Title_screen_h
#define Title_screen_h




#include "User_input.h"
#include <iostream>
#include <string>
#include "FS_gfx.h"
#include <tr1/memory>




extern std::tr1::shared_ptr<FS::User_input> input_ptr;
extern std::tr1::shared_ptr<FS::FS_gfx> gfx_ptr;




namespace FS
{
    
class Title_screen
{
    public:

        static const int num_selections = 5;
        enum Selection { play, tutorial, settings, hi_scores, quit, none };
    
        Title_screen();
        ~Title_screen();  
        
        void draw();  
        Selection update();

    private:

        static const int selection_x = 450;
        static const int selection_ys[];
        static const std::string selection_names[];
        
        // Of type 'int' because you can't ++/-- an 'enum' type.
        int current_selection;
        
}; // class Title_screen
        
} // namespace FS




#endif
     
