// Copyright (c) 2012 Ecma International.  All rights reserved.
// Ecma International makes this code available under the terms and conditions set
// forth on http://hg.ecmascript.org/tests/test262/raw-file/tip/LICENSE (the
// "Use Terms").   Any redistribution of this code must retain the above
// copyright and this notice and otherwise comply with the Use Terms.

/*---
es5id: 15.2.3.6-4-354-8
description: >
    ES5 Attributes - property 'P' with attributes [[Writable]]: false,
    [[Enumerable]]: true, [[Configurable]]: true is non-writable using
    simple assignment, 'O' is the global object
includes:
    - runTestCase.js
    - fnGlobalObject.js
---*/

function testcase() {
        var obj = fnGlobalObject();
        try {
            Object.defineProperty(obj, "prop", {
                value: 2010,
                writable: false,
                enumerable: true,
                configurable: true
            });
            var valueVerify = (obj.prop === 2010);
            obj.prop = 1001;

            return valueVerify && obj.prop === 2010;
        } finally {
            delete obj.prop;
        }
    }
runTestCase(testcase);
