// Copyright (c) 2012 Ecma International.  All rights reserved.
// Ecma International makes this code available under the terms and conditions set
// forth on http://hg.ecmascript.org/tests/test262/raw-file/tip/LICENSE (the
// "Use Terms").   Any redistribution of this code must retain the above
// copyright and this notice and otherwise comply with the Use Terms.

/*---
es5id: 15.2.3.6-2-45
description: >
    Object.defineProperty - argument 'P' is an object whose toString
    method returns an object and whose valueOf method returns a
    primitive value
includes: [runTestCase.js]
---*/

function testcase() {
        var obj = {};
        var toStringAccessed = false;
        var valueOfAccessed = false;

        var ownProp = {
            toString: function () {
                toStringAccessed = true;
                return {};
            },
            valueOf: function () {
                valueOfAccessed = true;
                return "abc";
            }
        };

        Object.defineProperty(obj, ownProp, {});

        return obj.hasOwnProperty("abc") && valueOfAccessed && toStringAccessed;
    }
runTestCase(testcase);
