// CD_GUI.cc for BBCD - a CD player for X11 / BlackBox
// Copyright (c) 2002 Bertrand Duret <bertrand.duret at libertysurf.fr>
//
// Permission is hereby granted, free of charge, to any person obtaining a
// copy of this software and associated documentation files (the "Software"),
// to deal in the Software without restriction, including without limitation
// the rights to use, copy, modify, merge, publish, distribute, sublicense,
// and/or sell copies of the Software, and to permit persons to whom the
// Software is furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
// THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
// FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
// DEALINGS IN THE SOFTWARE.

#include "Button.hh"

Button::Button(unsigned int bw, unsigned int bh, int bx, int by,
               Display* disp, Window parentW, ButtonDrawer* bd)
  : display(disp), buttonW(0), width(bw), height(bh), x(bx), y(by),
    bDrawer(bd), pressed(true) // That is not an error !
{
  GC dfltGC = DefaultGC(display, DefaultScreen(display));
  XGCValues xgcv;
  unsigned long xgcmask = GCBackground;
  XGetGCValues(display, dfltGC, xgcmask, &xgcv);

  buttonW = XCreateSimpleWindow(display, parentW, x, y, width, height, 0,
    xgcv.background, xgcv.background);

  draw(); // Press state changes to false, so pixmap is rendered...
}

Button::~Button() {
  XFreePixmap(display, background);
  XDestroyWindow(display, buttonW);
}


void Button::draw(bool isPressed, bool force) {
  bDrawer->draw(this, isPressed, force);
  pressed = isPressed;
}



ButtonDrawer::ButtonDrawer(Display* d, GC* _gc, GC* _gca,
                           BTexture* tr, BTexture* tp)
  : display(d), gc(_gc), gca(_gca), releasedT(tr), pressedT(tp)
{ }

ButtonDrawer::~ButtonDrawer() {
}

void ButtonDrawer::draw(Button* b, bool p, bool f) const {
  // If state has changed or redraw forced, set a new background pixmap/color
  if(p != b->isPressed() || f) {
    Pixmap pm;
    unsigned long c;
    if(p) {
      pm = pressedT->render(b->getWidth(), b->getHeight(), b->getPixmap());
      c = pressedT->color().pixel();
    } else {
      pm = releasedT->render(b->getWidth(), b->getHeight(), b->getPixmap());
      c = releasedT->color().pixel();
    }
    b->setPixmap(pm);
    if(pm == None) {
      XSetWindowBackground(display, b->getXWindow(), c);
    }
  }
  // basic behaviour: clear window
  XClearWindow(display, b->getXWindow());
}


