// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package server

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// CreateServerRingCreatedCode is the HTTP code returned for type CreateServerRingCreated
const CreateServerRingCreatedCode int = 201

/*
CreateServerRingCreated Server created

swagger:response createServerRingCreated
*/
type CreateServerRingCreated struct {

	/*
	  In: Body
	*/
	Payload *models.Server `json:"body,omitempty"`
}

// NewCreateServerRingCreated creates CreateServerRingCreated with default headers values
func NewCreateServerRingCreated() *CreateServerRingCreated {

	return &CreateServerRingCreated{}
}

// WithPayload adds the payload to the create server ring created response
func (o *CreateServerRingCreated) WithPayload(payload *models.Server) *CreateServerRingCreated {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the create server ring created response
func (o *CreateServerRingCreated) SetPayload(payload *models.Server) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *CreateServerRingCreated) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(201)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// CreateServerRingAcceptedCode is the HTTP code returned for type CreateServerRingAccepted
const CreateServerRingAcceptedCode int = 202

/*
CreateServerRingAccepted Configuration change accepted and reload requested

swagger:response createServerRingAccepted
*/
type CreateServerRingAccepted struct {
	/*ID of the requested reload

	 */
	ReloadID string `json:"Reload-ID"`

	/*
	  In: Body
	*/
	Payload *models.Server `json:"body,omitempty"`
}

// NewCreateServerRingAccepted creates CreateServerRingAccepted with default headers values
func NewCreateServerRingAccepted() *CreateServerRingAccepted {

	return &CreateServerRingAccepted{}
}

// WithReloadID adds the reloadId to the create server ring accepted response
func (o *CreateServerRingAccepted) WithReloadID(reloadID string) *CreateServerRingAccepted {
	o.ReloadID = reloadID
	return o
}

// SetReloadID sets the reloadId to the create server ring accepted response
func (o *CreateServerRingAccepted) SetReloadID(reloadID string) {
	o.ReloadID = reloadID
}

// WithPayload adds the payload to the create server ring accepted response
func (o *CreateServerRingAccepted) WithPayload(payload *models.Server) *CreateServerRingAccepted {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the create server ring accepted response
func (o *CreateServerRingAccepted) SetPayload(payload *models.Server) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *CreateServerRingAccepted) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Reload-ID

	reloadID := o.ReloadID
	if reloadID != "" {
		rw.Header().Set("Reload-ID", reloadID)
	}

	rw.WriteHeader(202)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// CreateServerRingBadRequestCode is the HTTP code returned for type CreateServerRingBadRequest
const CreateServerRingBadRequestCode int = 400

/*
CreateServerRingBadRequest Bad request

swagger:response createServerRingBadRequest
*/
type CreateServerRingBadRequest struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewCreateServerRingBadRequest creates CreateServerRingBadRequest with default headers values
func NewCreateServerRingBadRequest() *CreateServerRingBadRequest {

	return &CreateServerRingBadRequest{}
}

// WithConfigurationVersion adds the configurationVersion to the create server ring bad request response
func (o *CreateServerRingBadRequest) WithConfigurationVersion(configurationVersion string) *CreateServerRingBadRequest {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the create server ring bad request response
func (o *CreateServerRingBadRequest) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the create server ring bad request response
func (o *CreateServerRingBadRequest) WithPayload(payload *models.Error) *CreateServerRingBadRequest {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the create server ring bad request response
func (o *CreateServerRingBadRequest) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *CreateServerRingBadRequest) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(400)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// CreateServerRingConflictCode is the HTTP code returned for type CreateServerRingConflict
const CreateServerRingConflictCode int = 409

/*
CreateServerRingConflict The specified resource already exists

swagger:response createServerRingConflict
*/
type CreateServerRingConflict struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewCreateServerRingConflict creates CreateServerRingConflict with default headers values
func NewCreateServerRingConflict() *CreateServerRingConflict {

	return &CreateServerRingConflict{}
}

// WithConfigurationVersion adds the configurationVersion to the create server ring conflict response
func (o *CreateServerRingConflict) WithConfigurationVersion(configurationVersion string) *CreateServerRingConflict {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the create server ring conflict response
func (o *CreateServerRingConflict) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the create server ring conflict response
func (o *CreateServerRingConflict) WithPayload(payload *models.Error) *CreateServerRingConflict {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the create server ring conflict response
func (o *CreateServerRingConflict) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *CreateServerRingConflict) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(409)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

/*
CreateServerRingDefault General Error

swagger:response createServerRingDefault
*/
type CreateServerRingDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewCreateServerRingDefault creates CreateServerRingDefault with default headers values
func NewCreateServerRingDefault(code int) *CreateServerRingDefault {
	if code <= 0 {
		code = 500
	}

	return &CreateServerRingDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the create server ring default response
func (o *CreateServerRingDefault) WithStatusCode(code int) *CreateServerRingDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the create server ring default response
func (o *CreateServerRingDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the create server ring default response
func (o *CreateServerRingDefault) WithConfigurationVersion(configurationVersion string) *CreateServerRingDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the create server ring default response
func (o *CreateServerRingDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the create server ring default response
func (o *CreateServerRingDefault) WithPayload(payload *models.Error) *CreateServerRingDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the create server ring default response
func (o *CreateServerRingDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *CreateServerRingDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
