// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package log_target

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// GetLogTargetGlobalOKCode is the HTTP code returned for type GetLogTargetGlobalOK
const GetLogTargetGlobalOKCode int = 200

/*
GetLogTargetGlobalOK Successful operation

swagger:response getLogTargetGlobalOK
*/
type GetLogTargetGlobalOK struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.LogTarget `json:"body,omitempty"`
}

// NewGetLogTargetGlobalOK creates GetLogTargetGlobalOK with default headers values
func NewGetLogTargetGlobalOK() *GetLogTargetGlobalOK {

	return &GetLogTargetGlobalOK{}
}

// WithConfigurationVersion adds the configurationVersion to the get log target global o k response
func (o *GetLogTargetGlobalOK) WithConfigurationVersion(configurationVersion string) *GetLogTargetGlobalOK {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the get log target global o k response
func (o *GetLogTargetGlobalOK) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the get log target global o k response
func (o *GetLogTargetGlobalOK) WithPayload(payload *models.LogTarget) *GetLogTargetGlobalOK {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get log target global o k response
func (o *GetLogTargetGlobalOK) SetPayload(payload *models.LogTarget) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetLogTargetGlobalOK) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(200)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// GetLogTargetGlobalNotFoundCode is the HTTP code returned for type GetLogTargetGlobalNotFound
const GetLogTargetGlobalNotFoundCode int = 404

/*
GetLogTargetGlobalNotFound The specified resource was not found

swagger:response getLogTargetGlobalNotFound
*/
type GetLogTargetGlobalNotFound struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewGetLogTargetGlobalNotFound creates GetLogTargetGlobalNotFound with default headers values
func NewGetLogTargetGlobalNotFound() *GetLogTargetGlobalNotFound {

	return &GetLogTargetGlobalNotFound{}
}

// WithConfigurationVersion adds the configurationVersion to the get log target global not found response
func (o *GetLogTargetGlobalNotFound) WithConfigurationVersion(configurationVersion string) *GetLogTargetGlobalNotFound {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the get log target global not found response
func (o *GetLogTargetGlobalNotFound) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the get log target global not found response
func (o *GetLogTargetGlobalNotFound) WithPayload(payload *models.Error) *GetLogTargetGlobalNotFound {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get log target global not found response
func (o *GetLogTargetGlobalNotFound) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetLogTargetGlobalNotFound) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(404)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

/*
GetLogTargetGlobalDefault General Error

swagger:response getLogTargetGlobalDefault
*/
type GetLogTargetGlobalDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewGetLogTargetGlobalDefault creates GetLogTargetGlobalDefault with default headers values
func NewGetLogTargetGlobalDefault(code int) *GetLogTargetGlobalDefault {
	if code <= 0 {
		code = 500
	}

	return &GetLogTargetGlobalDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the get log target global default response
func (o *GetLogTargetGlobalDefault) WithStatusCode(code int) *GetLogTargetGlobalDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the get log target global default response
func (o *GetLogTargetGlobalDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the get log target global default response
func (o *GetLogTargetGlobalDefault) WithConfigurationVersion(configurationVersion string) *GetLogTargetGlobalDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the get log target global default response
func (o *GetLogTargetGlobalDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the get log target global default response
func (o *GetLogTargetGlobalDefault) WithPayload(payload *models.Error) *GetLogTargetGlobalDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get log target global default response
func (o *GetLogTargetGlobalDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetLogTargetGlobalDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
