/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.shorts;

import it.unimi.dsi.fastutil.shorts.ShortArrays;
import it.unimi.dsi.fastutil.shorts.ShortCollection;
import it.unimi.dsi.fastutil.shorts.ShortConsumer;
import it.unimi.dsi.fastutil.shorts.ShortImmutableList;
import it.unimi.dsi.fastutil.shorts.ShortIterator;
import it.unimi.dsi.fastutil.shorts.ShortIterators;
import it.unimi.dsi.fastutil.shorts.ShortList;
import it.unimi.dsi.fastutil.shorts.ShortListIterator;
import it.unimi.dsi.fastutil.shorts.ShortLists;
import it.unimi.dsi.fastutil.shorts.ShortSpliterator;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.RandomAccess;

public class ShortImmutableList
extends ShortLists.ImmutableListBase
implements ShortList,
RandomAccess,
Cloneable,
Serializable {
    private static final long serialVersionUID = 0L;
    static final ShortImmutableList EMPTY = new ShortImmutableList(ShortArrays.EMPTY_ARRAY);
    private final short[] a;

    public ShortImmutableList(short[] a) {
        this.a = a;
    }

    public ShortImmutableList(Collection<? extends Short> c) {
        this(c.isEmpty() ? ShortArrays.EMPTY_ARRAY : ShortIterators.unwrap(ShortIterators.asShortIterator(c.iterator())));
    }

    public ShortImmutableList(ShortCollection c) {
        this(c.isEmpty() ? ShortArrays.EMPTY_ARRAY : ShortIterators.unwrap(c.iterator()));
    }

    public ShortImmutableList(ShortList l) {
        this(l.isEmpty() ? ShortArrays.EMPTY_ARRAY : new short[l.size()]);
        l.getElements(0, this.a, 0, l.size());
    }

    public ShortImmutableList(short[] a, int offset, int length) {
        this(length == 0 ? ShortArrays.EMPTY_ARRAY : new short[length]);
        System.arraycopy(a, offset, this.a, 0, length);
    }

    public ShortImmutableList(ShortIterator i) {
        this(i.hasNext() ? ShortIterators.unwrap(i) : ShortArrays.EMPTY_ARRAY);
    }

    public static ShortImmutableList of() {
        return EMPTY;
    }

    public static ShortImmutableList of(short ... init) {
        return init.length == 0 ? ShortImmutableList.of() : new ShortImmutableList(init);
    }

    @Override
    public short getShort(int index) {
        if (index >= this.a.length) {
            throw new IndexOutOfBoundsException("Index (" + index + ") is greater than or equal to list size (" + this.a.length + ")");
        }
        return this.a[index];
    }

    @Override
    public int indexOf(short k) {
        short[] a = this.a;
        int size = a.length;
        for (int i = 0; i < size; ++i) {
            if (k != a[i]) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(short k) {
        short[] a = this.a;
        int i = a.length;
        while (i-- != 0) {
            if (k != a[i]) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int size() {
        return this.a.length;
    }

    @Override
    public boolean isEmpty() {
        return this.a.length == 0;
    }

    @Override
    public void getElements(int from, short[] a, int offset, int length) {
        ShortArrays.ensureOffsetLength(a, offset, length);
        System.arraycopy(this.a, from, a, offset, length);
    }

    @Override
    public void forEach(ShortConsumer action) {
        short[] a = this.a;
        for (int i = 0; i < a.length; ++i) {
            action.accept(a[i]);
        }
    }

    @Override
    public short[] toShortArray() {
        if (this.a.length == 0) {
            return ShortArrays.EMPTY_ARRAY;
        }
        return (short[])this.a.clone();
    }

    @Override
    public short[] toArray(short[] a) {
        if (a == null || a.length < this.size()) {
            a = new short[this.a.length];
        }
        System.arraycopy(this.a, 0, a, 0, a.length);
        return a;
    }

    @Override
    public ShortListIterator listIterator(int index) {
        this.ensureIndex(index);
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    @Override
    public ShortSpliterator spliterator() {
        return new Spliterator(this);
    }

    @Override
    public ShortList subList(int from, int to) {
        if (from == 0 && to == this.size()) {
            return this;
        }
        this.ensureIndex(from);
        this.ensureIndex(to);
        if (from == to) {
            return EMPTY;
        }
        if (from > to) {
            throw new IllegalArgumentException("Start index (" + from + ") is greater than end index (" + to + ")");
        }
        return new ImmutableSubList(this, from, to);
    }

    public ShortImmutableList clone() {
        return this;
    }

    public boolean equals(ShortImmutableList l) {
        if (l == this) {
            return true;
        }
        if (this.a == l.a) {
            return true;
        }
        int s = this.size();
        if (s != l.size()) {
            return false;
        }
        short[] a1 = this.a;
        short[] a2 = l.a;
        return Arrays.equals(a1, a2);
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!(o instanceof List)) {
            return false;
        }
        if (o instanceof ShortImmutableList) {
            return this.equals((ShortImmutableList)o);
        }
        if (o instanceof ImmutableSubList) {
            return ((ImmutableSubList)o).equals((Object)this);
        }
        return super.equals(o);
    }

    @Override
    public int compareTo(ShortImmutableList l) {
        int i;
        if (this.a == l.a) {
            return 0;
        }
        int s1 = this.size();
        int s2 = l.size();
        short[] a1 = this.a;
        short[] a2 = l.a;
        for (i = 0; i < s1 && i < s2; ++i) {
            short e1 = a1[i];
            short e2 = a2[i];
            int r = Short.compare(e1, e2);
            if (r == 0) continue;
            return r;
        }
        return i < s2 ? -1 : (i < s1 ? 1 : 0);
    }

    @Override
    public int compareTo(List<? extends Short> l) {
        if (l instanceof ShortImmutableList) {
            return this.compareTo((ShortImmutableList)l);
        }
        if (l instanceof ImmutableSubList) {
            ImmutableSubList other = (ImmutableSubList)l;
            return -other.compareTo((List)this);
        }
        return super.compareTo(l);
    }

    static /* synthetic */ short[] access$000(ShortImmutableList x0) {
        return x0.a;
    }
}

