/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.jdiskreport.gui.node;

import com.jgoodies.chart.AbstractTreeChartModel;
import com.jgoodies.jdiskreport.gui.node.AbstractNode;
import com.jgoodies.jdiskreport.gui.node.DirectoryNode;
import com.jgoodies.jdiskreport.gui.settings.GUISettings;

public final class FileTreeChartModel
extends AbstractTreeChartModel<AbstractNode> {
    private final DirectoryNode root;
    private final GUISettings.SortMode sortMode;
    private final GUISettings.SizeMode sizeMode;
    private final boolean showFiles;

    public FileTreeChartModel(DirectoryNode root, GUISettings.SortMode sortMode, GUISettings.SizeMode sizeMode, boolean showFiles) {
        this.root = root;
        this.sortMode = sortMode;
        this.sizeMode = sizeMode;
        this.showFiles = showFiles;
    }

    @Override
    public DirectoryNode getRoot() {
        return this.root;
    }

    @Override
    public int getChildCount(AbstractNode node) {
        if (node instanceof DirectoryNode) {
            DirectoryNode directoryNode = (DirectoryNode)node;
            return directoryNode.getSortedChildren(this.sortMode, this.sizeMode, this.showFiles).size();
        }
        return 0;
    }

    @Override
    public AbstractNode getChild(AbstractNode node, int index) {
        if (!(node instanceof DirectoryNode)) {
            throw new UnsupportedOperationException("In FileTreeChartModel only DirectoryNodes have children.");
        }
        DirectoryNode directoryNode = (DirectoryNode)node;
        return directoryNode.getSortedChildren(this.sortMode, this.sizeMode, this.showFiles).get(index);
    }

    @Override
    public long getSize(AbstractNode node) {
        return node.getSize();
    }

    @Override
    public boolean isLeaf(AbstractNode node) {
        return node.isFileLeaf();
    }
}

