/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.chart;

import com.jgoodies.chart.AbstractChart;
import com.jgoodies.chart.PieChartLabels;
import com.jgoodies.common.base.Preconditions;
import com.jgoodies.common.swing.internal.RenderingUtils;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.text.Format;
import java.text.NumberFormat;

public final class PieChart<T>
extends AbstractChart<T> {
    public static final String PROPERTY_SHOW_TOTAL = "showTotal";
    public static final String PROPERTY_TOTAL_TEXT = "totalText";
    private static final int MINIMUM_RADIUS = 50;
    private static final int PREFERRED_TEXT_WIDTH = 80;
    private static final int PREFERRED_TEXT_HEIGHT = 40;
    private static final float RADIUS_TEXT_GROWTH_WEIGHT = 0.94f;
    private static final double RADIAN_TO_DEGREE = 57.29577951308232;
    private static final double EPSILON = 1.0E-7;
    private static final NumberFormat PERCENT_FORMATTER = PieChart.createPercentFormatter();
    private boolean showTotal;
    private String totalText;
    private long sizeTotal;
    private String[] percentString;
    private int[] angle;
    private PieChartLabels chartLabels;
    private int xCenter;
    private int yCenter;
    private int radius;

    public PieChart(Format format, String totalText) {
        super(format);
        this.totalText = totalText;
        this.showTotal = true;
    }

    public boolean getShowTotal() {
        return this.showTotal;
    }

    public void setShowTotal(boolean newValue) {
        boolean oldValue = this.getShowTotal();
        this.showTotal = newValue;
        this.firePropertyChange(PROPERTY_SHOW_TOTAL, oldValue, newValue);
        this.invalidateCache();
        this.repaint();
    }

    public String getTotalText() {
        return this.totalText;
    }

    public void setTotalText(String newText) {
        this.totalText = Preconditions.checkNotNull(newText, "The total text must not be null.");
    }

    @Override
    public int getIndexAt(Point position) {
        if (this.hasEmptyModel()) {
            return -1;
        }
        this.ensureValidCache();
        int positionAngle = this.getAngleAt(position);
        if (positionAngle == -1) {
            return -1;
        }
        int itemCount = this.model.getItemCount();
        for (int index = 1; index < itemCount; ++index) {
            if (positionAngle >= this.angle[index]) continue;
            return index - 1;
        }
        return itemCount - 1;
    }

    private static NumberFormat createPercentFormatter() {
        NumberFormat formatter = NumberFormat.getPercentInstance();
        formatter.setMaximumFractionDigits(1);
        formatter.setMinimumFractionDigits(1);
        formatter.setMinimumIntegerDigits(1);
        return formatter;
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        this.xCenter = width / 2;
        this.yCenter = height / 2;
        int xRadius = Math.round((float)(width / 2 - 80 - 50) * 0.94f);
        int yRadius = Math.round((float)(height / 2 - 40 - 50) * 0.94f);
        this.radius = 50 + Math.max(0, Math.min(xRadius, yRadius));
    }

    private int getAngleAt(Point position) {
        double dX = position.x - this.xCenter;
        double dY = this.yCenter - position.y;
        double r = Math.sqrt(dX * dX + dY * dY);
        if (r > (double)this.radius) {
            return -1;
        }
        double theta = Math.atan2(dX, dY);
        int rawDegrees = (int)Math.round(theta * 57.29577951308232);
        int positiveDegrees = (rawDegrees + 360) % 360;
        return positiveDegrees;
    }

    @Override
    protected void render(Graphics2D g2) {
        this.chartLabels.doLayout(g2.getFontMetrics(), this.getWidth(), this.getHeight(), this.radius);
        Object newAAHint = RenderingHints.VALUE_ANTIALIAS_ON;
        Object oldAAHint = g2.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        if (newAAHint != oldAAHint) {
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, newAAHint);
        } else {
            oldAAHint = null;
        }
        int cXOrigin = this.xCenter - this.radius;
        int cYOrigin = this.yCenter - this.radius;
        int cWidth = 2 * this.radius - 1;
        int startAngle = 0;
        int itemCount = this.model.getItemCount();
        for (int pieNo = 0; pieNo < itemCount; ++pieNo) {
            startAngle = this.angle[pieNo];
            int stopAngle = pieNo < itemCount - 1 ? this.angle[pieNo + 1] : 360;
            int arcAngle = stopAngle - startAngle;
            g2.setColor(this.model.getColor(pieNo));
            this.renderArc(g2, startAngle, arcAngle);
            g2.setColor(Color.GRAY);
            if (itemCount <= 1) continue;
            this.renderRadialLine(g2, startAngle);
        }
        g2.drawOval(cXOrigin, cYOrigin, cWidth, cWidth);
        if (oldAAHint != null) {
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, oldAAHint);
        }
        if (this.getShowTotal()) {
            this.renderTotal(g2);
        }
        this.chartLabels.paint(this, g2);
    }

    private void renderArc(Graphics2D g2, int startAngle, int arcAngle) {
        g2.fillArc(this.xCenter - this.radius, this.yCenter - this.radius, 2 * this.radius - 1, 2 * this.radius - 1, -startAngle + 90, -arcAngle);
    }

    private void renderRadialLine(Graphics2D g2, int anAngle) {
        double radian = Math.toRadians(anAngle);
        int x = this.xCenter + (int)((float)Math.sin(radian) * ((float)this.radius - 0.5f));
        int y = this.yCenter - (int)((float)Math.cos(radian) * ((float)this.radius - 0.5f));
        g2.drawLine(this.xCenter - 1, this.yCenter - 1, x - 1, y - 1);
    }

    private void renderTotal(Graphics2D g2) {
        FontMetrics fm = g2.getFontMetrics();
        String sizeStr = this.formatSize(this.sizeTotal);
        int width1 = fm.stringWidth(this.totalText);
        int width2 = fm.stringWidth(sizeStr);
        int width3 = fm.stringWidth("123,1 MB");
        int height1 = fm.getHeight();
        int hpad = 6;
        int vpad = 2;
        int width = 12 + Math.max(width3, Math.max(width1, width2));
        int height = 4 + height1 * 2;
        if (width > this.radius) {
            return;
        }
        int x0 = this.xCenter - width / 2;
        int y0 = this.yCenter - height / 2;
        g2.setColor(Color.WHITE);
        g2.fillRect(x0, y0, width, height);
        g2.setColor(Color.DARK_GRAY);
        g2.drawRect(x0, y0, width, height);
        g2.setColor(Color.BLACK);
        RenderingUtils.drawString(this, g2, this.totalText, this.xCenter - width1 / 2, this.yCenter - 2);
        RenderingUtils.drawString(this, g2, sizeStr, this.xCenter - width2 / 2, this.yCenter + height1 - 2);
    }

    @Override
    protected void validateCache() {
        this.sizeTotal = 0L;
        int itemCount = this.model.getItemCount();
        for (int i = 0; i < itemCount; ++i) {
            this.sizeTotal += this.model.getSize(i);
        }
        this.cacheStringsAndAngles();
    }

    private void cacheStringsAndAngles() {
        int itemCount = this.model.getItemCount();
        this.percentString = new String[itemCount];
        this.angle = new int[itemCount];
        this.chartLabels = new PieChartLabels();
        int startAngle = 0;
        for (int i = 0; i < itemCount; ++i) {
            long size = this.model.getSize(i);
            float percent = (double)this.sizeTotal < 1.0E-7 ? 1.0f / (float)itemCount : (float)size / (float)this.sizeTotal;
            this.percentString[i] = PERCENT_FORMATTER.format(percent);
            int arcAngle = Math.round(360.0f * percent);
            int stopAngle = startAngle + arcAngle;
            this.angle[i] = startAngle;
            String formattedSize = this.getShowSize() ? this.formatSize(size) : null;
            this.chartLabels.add(this.model.getText(i), formattedSize, startAngle, stopAngle);
            startAngle = stopAngle;
        }
    }
}

