/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.rules.imports;

import java.util.HashSet;
import java.util.Set;
import net.sourceforge.pmd.AbstractRule;
import net.sourceforge.pmd.ast.ASTClassOrInterfaceType;
import net.sourceforge.pmd.ast.ASTCompilationUnit;
import net.sourceforge.pmd.ast.ASTImportDeclaration;
import net.sourceforge.pmd.ast.ASTName;
import net.sourceforge.pmd.ast.SimpleJavaNode;
import net.sourceforge.pmd.ast.SimpleNode;
import net.sourceforge.pmd.rules.ImportWrapper;

public class UnusedImportsRule
extends AbstractRule {
    protected Set<ImportWrapper> imports = new HashSet<ImportWrapper>();

    public Object visit(ASTCompilationUnit node, Object data) {
        this.imports.clear();
        super.visit(node, data);
        for (ImportWrapper wrapper : this.imports) {
            this.addViolation(data, wrapper.getNode(), wrapper.getFullName());
        }
        return data;
    }

    public Object visit(ASTImportDeclaration node, Object data) {
        if (!node.isImportOnDemand()) {
            String className;
            ASTName importedType = (ASTName)node.jjtGetChild(0);
            if (UnusedImportsRule.isQualifiedName(importedType)) {
                int lastDot = importedType.getImage().lastIndexOf(46) + 1;
                className = importedType.getImage().substring(lastDot);
            } else {
                className = importedType.getImage();
            }
            this.imports.add(new ImportWrapper(importedType.getImage(), className, node));
        }
        return data;
    }

    public Object visit(ASTClassOrInterfaceType node, Object data) {
        this.check(node);
        return super.visit(node, data);
    }

    public Object visit(ASTName node, Object data) {
        this.check(node);
        return data;
    }

    protected void check(SimpleNode node) {
        if (this.imports.isEmpty()) {
            return;
        }
        ImportWrapper candidate = this.getImportWrapper(node);
        if (this.imports.contains(candidate)) {
            this.imports.remove(candidate);
        }
    }

    protected ImportWrapper getImportWrapper(SimpleNode node) {
        String name = !UnusedImportsRule.isQualifiedName(node) ? node.getImage() : node.getImage().substring(0, node.getImage().indexOf(46));
        ImportWrapper candidate = new ImportWrapper(node.getImage(), name, new SimpleJavaNode(-1));
        return candidate;
    }
}

