/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.report.log;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.spockframework.util.IoUtil;
import spock.config.ConfigurationObject;

@ConfigurationObject(value="report")
public class ReportLogConfiguration {
    public boolean enabled = Boolean.getBoolean(System.getProperty("spock.logEnabled", "false"));
    public String logFileDir = System.getProperty("spock.logFileDir");
    public String logFileName = System.getProperty("spock.logFileName");
    public String logFileSuffix = System.getProperty("spock.logFileSuffix");
    public String issueNamePrefix = "";
    public String issueUrlPrefix = "";
    public String reportServerAddress = System.getProperty("spock.reportServerAddress");
    public int reportServerPort = Integer.valueOf(System.getProperty("spock.reportServerPort", "4242"));

    public String getLogFileSuffix() {
        if (this.logFileSuffix != null && this.logFileSuffix.contains("#timestamp")) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
            dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
            String timestamp = dateFormat.format(new Date());
            this.logFileSuffix = this.logFileSuffix.replace("#timestamp", timestamp);
        }
        return this.logFileSuffix;
    }

    public File getLogFile() {
        if (this.logFileDir == null) {
            return null;
        }
        String fullName = this.logFileName;
        String suffix = this.getLogFileSuffix();
        if (suffix != null && suffix.length() > 0) {
            String extension = IoUtil.getFileExtension(this.logFileName);
            fullName = extension == null ? this.logFileName + "-" + suffix : this.logFileName.substring(0, this.logFileName.length() - extension.length() - 1) + "-" + suffix + "." + extension;
        }
        return new File(this.logFileDir, fullName);
    }
}

