/*
 * Decompiled with CFR 0.152.
 */
package jrm.profile.report;

import java.util.List;
import java.util.stream.Collectors;
import jrm.locale.Messages;
import jrm.profile.data.AnywareBase;
import jrm.profile.report.EntryMissing;
import jrm.profile.report.EntryOK;
import jrm.profile.report.EntryWrongHash;
import jrm.profile.report.FilterOptions;
import jrm.profile.report.Note;
import jrm.profile.report.Subject;
import org.apache.commons.text.StringEscapeUtils;

public class SubjectSet
extends Subject {
    private Status status = Status.UNKNOWN;

    public SubjectSet(AnywareBase machine) {
        super(machine);
    }

    private SubjectSet(AnywareBase machine, List<Note> notes) {
        super(machine, notes);
    }

    @Override
    public Subject clone(List<FilterOptions> filterOptions) {
        SubjectSet clone = new SubjectSet(this.ware, this.filter(filterOptions));
        clone.status = this.status;
        return clone;
    }

    public List<Note> filter(List<FilterOptions> filterOptions) {
        return this.notes.stream().filter((? super T n) -> filterOptions.contains((Object)FilterOptions.SHOWOK) || !(n instanceof EntryOK)).collect(Collectors.toList());
    }

    public void setMissing() {
        this.status = Status.MISSING;
    }

    public void setFound() {
        this.status = Status.FOUND;
    }

    public void setUnneeded() {
        this.status = Status.UNNEEDED;
    }

    public void setCreate() {
        this.status = Status.CREATE;
    }

    public void setCreateFull() {
        this.status = Status.CREATEFULL;
    }

    public Status getStatus() {
        return this.status;
    }

    public boolean hasNotes() {
        return this.notes.stream().filter((? super T n) -> !(n instanceof EntryOK)).count() > 0L;
    }

    public boolean isFixable() {
        return this.notes.stream().filter((? super T n) -> n instanceof EntryMissing || n instanceof EntryWrongHash).count() == 0L;
    }

    public boolean hasFix() {
        return this.notes.stream().filter((? super T n) -> !(n instanceof EntryOK) && !(n instanceof EntryMissing) && !(n instanceof EntryWrongHash)).count() > 0L;
    }

    public boolean isFound() {
        return this.status == Status.FOUND;
    }

    public boolean isMissing() {
        return this.status == Status.MISSING;
    }

    public boolean isUnneeded() {
        return this.status == Status.UNNEEDED;
    }

    public boolean isOK() {
        return this.isFound() && !this.hasNotes();
    }

    @Override
    public String toString() {
        switch (this.status) {
            case MISSING: {
                return String.format(Messages.getString("SubjectSet.Missing"), this.ware.getFullName(), this.ware.getDescription());
            }
            case UNNEEDED: {
                return String.format(Messages.getString("SubjectSet.Unneeded"), this.ware.getFullName(), this.ware.getDescription());
            }
            case FOUND: {
                if (this.hasNotes()) {
                    if (this.isFixable()) {
                        return String.format(Messages.getString("SubjectSet.FoundNeedFixes"), this.ware.getFullName(), this.ware.getDescription());
                    }
                    return String.format(Messages.getString("SubjectSet.FoundIncomplete"), this.ware.getFullName(), this.ware.getDescription());
                }
                return String.format(Messages.getString("SubjectSet.Found"), this.ware.getFullName(), this.ware.getDescription());
            }
            case CREATE: 
            case CREATEFULL: {
                if (this.isFixable()) {
                    return String.format(Messages.getString("SubjectSet.MissingTotallyCreated"), this.ware.getFullName(), this.ware.getDescription());
                }
                return String.format(Messages.getString("SubjectSet.MissingPartiallyCreated"), this.ware.getFullName(), this.ware.getDescription());
            }
        }
        return String.format(Messages.getString("SubjectSet.Unknown"), this.ware.getFullName(), this.ware.getDescription());
    }

    @Override
    public String getHTML() {
        String machine_name = this.toBlue(this.ware.getFullName());
        String machine_description = this.toPurple(this.ware.getDescription());
        switch (this.status) {
            case MISSING: {
                return this.toHTML(String.format(StringEscapeUtils.escapeHtml4((String)Messages.getString("SubjectSet.Missing")), machine_name, machine_description));
            }
            case UNNEEDED: {
                return this.toHTML(String.format(StringEscapeUtils.escapeHtml4((String)Messages.getString("SubjectSet.Unneeded")), machine_name, machine_description));
            }
            case FOUND: {
                if (this.hasNotes()) {
                    if (this.isFixable()) {
                        return this.toHTML(String.format(StringEscapeUtils.escapeHtml4((String)Messages.getString("SubjectSet.FoundNeedFixes")), machine_name, machine_description));
                    }
                    return this.toHTML(String.format(StringEscapeUtils.escapeHtml4((String)Messages.getString("SubjectSet.FoundIncomplete")), machine_name, machine_description));
                }
                return this.toHTML(String.format(StringEscapeUtils.escapeHtml4((String)Messages.getString("SubjectSet.Found")), machine_name, machine_description));
            }
            case CREATE: 
            case CREATEFULL: {
                if (this.isFixable()) {
                    return this.toHTML(String.format(StringEscapeUtils.escapeHtml4((String)Messages.getString("SubjectSet.MissingTotallyCreated")), machine_name, machine_description));
                }
                return this.toHTML(String.format(StringEscapeUtils.escapeHtml4((String)Messages.getString("SubjectSet.MissingPartiallyCreated")), machine_name, machine_description));
            }
        }
        return this.toHTML(String.format(StringEscapeUtils.escapeHtml4((String)Messages.getString("SubjectSet.Unknown")), machine_name, machine_description));
    }

    @Override
    public void updateStats() {
        switch (this.status) {
            case MISSING: {
                ++this.parent.stats.set_missing;
                break;
            }
            case UNNEEDED: {
                ++this.parent.stats.set_unneeded;
                break;
            }
            case FOUND: {
                ++this.parent.stats.set_found;
                if (this.hasNotes()) {
                    if (this.isFixable()) {
                        ++this.parent.stats.set_found_fixcomplete;
                        break;
                    }
                    ++this.parent.stats.set_found_fixpartial;
                    break;
                }
                ++this.parent.stats.set_found_ok;
                break;
            }
            case CREATE: 
            case CREATEFULL: {
                ++this.parent.stats.set_create;
                if (this.isFixable()) {
                    ++this.parent.stats.set_create_complete;
                    break;
                }
                ++this.parent.stats.set_create_partial;
                break;
            }
        }
    }

    public static enum Status {
        UNKNOWN,
        FOUND,
        CREATE,
        CREATEFULL,
        UNNEEDED,
        MISSING;

    }
}

