/*
 * Decompiled with CFR 0.152.
 */
package com.xsb.interprolog;

import com.declarativa.interprolog.PrologImplementationPeer;
import com.declarativa.interprolog.XSBPeer;
import com.declarativa.interprolog.util.IPException;
import com.xsb.interprolog.AbstractNativeEngine;

public class NativeEngine
extends AbstractNativeEngine {
    protected static int numberOfInstances;

    static {
        System.loadLibrary("xsb");
        numberOfInstances = 0;
    }

    private native void xsb_setDebug(boolean var1);

    protected native int xsb_init_internal(String var1);

    protected native int xsb_init_internal_arg(String var1, String[] var2);

    protected native int xsb_command_string(String var1);

    protected native int xsb_close_query();

    protected native int put_bytes(byte[] var1, int var2, int var3, String var4);

    protected native void xsb_interrupt();

    protected boolean commandWithArray(String string, byte[] byArray, int n) {
        int n2 = this.put_bytes(byArray, n, 1, string);
        this.xsb_close_query();
        return n2 == 0;
    }

    protected PrologImplementationPeer makeImplementationPeer() {
        return new XSBPeer(this);
    }

    public NativeEngine() {
        this(null, false);
    }

    public NativeEngine(String string) {
        this(string, false);
    }

    public NativeEngine(String string, boolean bl) {
        this(string, null, bl, true);
    }

    public NativeEngine(String string, boolean bl, boolean bl2) {
        this(string, null, bl, bl2);
    }

    public NativeEngine(String string, String[] stringArray, boolean bl, boolean bl2) {
        super(string, bl, bl2);
        this.xsb_setDebug(bl);
        if (++numberOfInstances > 1) {
            throw new IPException("Can't have more than one instance of NativeEngine");
        }
        this.progressMessage("Initializing XSB dll engine with XSB_ARGS==" + stringArray + " and base directory " + this.getPrologBaseDirectory());
        int n = stringArray != null ? this.xsb_init_internal_arg(this.getPrologBaseDirectory(), stringArray) : this.xsb_init_internal(this.getPrologBaseDirectory());
        if (n != 0) {
            throw new IPException("XSB Initialization error");
        }
        this.progressMessage("Moving on...");
        this.setupPrologSide();
        this.startTopGoal();
    }

    public void setDebug(boolean bl) {
        super.setDebug(bl);
        this.xsb_setDebug(bl);
    }

    public void shutdown() {
        super.shutdown();
        System.err.println("NO REAL SHUTDOWN in NativeEngine YET!!!");
    }

    protected void doInterrupt() {
        this.xsb_interrupt();
    }

    public boolean realCommand(String string) {
        int n = this.xsb_command_string(String.valueOf(string) + ".");
        if (n == 0) {
            return true;
        }
        if (n == 1) {
            return false;
        }
        throw new IPException("Problem executing Prolog command");
    }
}

