/*
 * Decompiled with CFR 0.152.
 */
package megamek.common.weapons;

import java.util.Vector;
import megamek.common.BattleArmor;
import megamek.common.Compute;
import megamek.common.IGame;
import megamek.common.Infantry;
import megamek.common.Report;
import megamek.common.ToHitData;
import megamek.common.actions.WeaponAttackAction;
import megamek.common.weapons.LBXHandler;
import megamek.server.Server;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrototypeLBXHandler
extends LBXHandler {
    private static final long serialVersionUID = -5200908977142584431L;

    public PrototypeLBXHandler(ToHitData toHitData, WeaponAttackAction weaponAttackAction, IGame iGame, Server server) {
        super(toHitData, weaponAttackAction, iGame, server);
    }

    @Override
    protected int calcHits(Vector<Report> vector) {
        if (this.target instanceof Infantry && !(this.target instanceof BattleArmor)) {
            return 1;
        }
        int n = -1;
        if (this.bGlancing) {
            n -= 4;
        }
        if (this.game.getPlanetaryConditions().hasEMI()) {
            n -= 2;
        }
        int n2 = this.allShotsHit() ? this.wtype.getRackSize() : Compute.missilesHit(this.wtype.getRackSize(), n);
        this.r = new Report(3325);
        this.r.subject = this.subjectId;
        this.r.add(n2);
        this.r.add(" shot(s) ");
        this.r.add(this.toHit.getTableDesc());
        this.r.newlines = 0;
        vector.addElement(this.r);
        this.r = new Report(3345);
        this.r.subject = this.subjectId;
        this.r.newlines = 0;
        vector.addElement(this.r);
        this.bSalvo = true;
        return n2;
    }

    @Override
    protected boolean doChecks(Vector<Report> vector) {
        if (this.roll == 2) {
            this.r = new Report(3165);
            this.r.subject = this.subjectId;
            this.weapon.setJammed(true);
            this.weapon.setHit(true);
            vector.addElement(this.r);
            return true;
        }
        return false;
    }
}

