/*
 * Decompiled with CFR 0.152.
 */
package megamek.common.util;

import megamek.debug.Assert;

public abstract class AbstractCommandLineParser {
    protected String OPTION_PREFIX = "-";
    protected static final int TOK_EOF = -1;
    protected static final int TOK_OPTION = 0;
    protected static final int TOK_LITERAL = 3;
    private String[] args;
    private int argsLen;
    private int position;
    private int token;
    private String argValue;
    private String tokenValue;

    public AbstractCommandLineParser(String[] stringArray) {
        Assert.assertTrue(stringArray != null, "args must be non null");
        this.args = stringArray;
        this.argsLen = stringArray.length;
    }

    public void parse() throws ParseException {
        this.nextToken();
        this.start();
    }

    protected String getArgValue() {
        return this.argValue;
    }

    protected int getToken() {
        return this.token;
    }

    protected void setToken(int n) {
        this.token = n;
    }

    protected String getTokenValue() {
        return this.tokenValue;
    }

    protected void setTokenValue(String string) {
        this.tokenValue = string;
    }

    protected int getPosition() {
        return this.position;
    }

    protected abstract void start() throws ParseException;

    protected void nextToken() {
        this.nextArg();
        if (this.argValue != null) {
            if (this.argValue.startsWith(this.OPTION_PREFIX)) {
                this.token = 0;
                this.tokenValue = this.argValue.substring(this.OPTION_PREFIX.length());
            } else {
                this.token = 3;
                this.tokenValue = this.argValue;
            }
        } else {
            this.tokenValue = null;
            this.token = -1;
        }
    }

    protected void nextArg() {
        this.argValue = this.position < this.argsLen ? this.args[this.position++] : null;
    }

    protected void error(String string) throws ParseException {
        throw new ParseException(string);
    }

    public static class ParseException
    extends Exception {
        private static final long serialVersionUID = -3077985683676777509L;

        ParseException(String string) {
            super(string);
        }
    }
}

