/*
 * Decompiled with CFR 0.152.
 */
package megamek.common.actions;

import megamek.common.Building;
import megamek.common.Compute;
import megamek.common.Coords;
import megamek.common.Entity;
import megamek.common.IGame;
import megamek.common.IHex;
import megamek.common.Mech;
import megamek.common.Targetable;
import megamek.common.ToHitData;
import megamek.common.actions.DisplacementAttackAction;
import megamek.common.actions.PhysicalAttackAction;

public class PushAttackAction
extends DisplacementAttackAction {
    private static final long serialVersionUID = 6878038939232914083L;

    public PushAttackAction(int n, int n2, Coords coords) {
        super(n, n2, coords);
    }

    public PushAttackAction(int n, int n2, int n3, Coords coords) {
        super(n, n2, n3, coords);
    }

    public ToHitData toHit(IGame iGame) {
        return PushAttackAction.toHit(iGame, this.getEntityId(), iGame.getTarget(this.getTargetType(), this.getTargetId()));
    }

    protected static String toHitIsImpossible(IGame iGame, Entity entity, Targetable targetable) {
        String string = PhysicalAttackAction.toHitIsImpossible(iGame, entity, targetable);
        String string2 = null;
        if (entity instanceof Mech && ((Mech)entity).hasExtendedRetractableBlade()) {
            string2 = "Extended retractable blade";
        }
        if (string != null) {
            return string;
        }
        if (entity.getGrappled() != -1) {
            return "Unit Grappled";
        }
        if (entity.isEvading()) {
            return "attacker is evading.";
        }
        if (!iGame.getOptions().booleanOption("friendly_fire") && targetable.getTargetType() == 0 && (((Entity)targetable).getOwnerId() == entity.getOwnerId() || ((Entity)targetable).getOwner().getTeam() != 0 && entity.getOwner().getTeam() != 0 && entity.getOwner().getTeam() == ((Entity)targetable).getOwner().getTeam())) {
            return "A friendly unit can never be the target of a direct attack.";
        }
        return string2;
    }

    public static ToHitData toHit(IGame iGame, int n, Targetable targetable) {
        Entity entity = iGame.getEntity(n);
        int n2 = -1;
        Entity entity2 = null;
        if (targetable.getTargetType() == 0) {
            entity2 = (Entity)targetable;
            n2 = targetable.getTargetId();
        }
        if (entity == null) {
            return new ToHitData(Integer.MAX_VALUE, "You can't attack from a null entity!");
        }
        if (entity2 == null) {
            return new ToHitData(Integer.MAX_VALUE, "You can't target a null entity!");
        }
        IHex iHex = iGame.getBoard().getHex(entity.getPosition());
        IHex iHex2 = iGame.getBoard().getHex(entity2.getPosition());
        int n3 = entity.getElevation() + iHex.getElevation();
        int n4 = targetable.getElevation() + iHex2.getElevation();
        boolean bl = Compute.isInSameBuilding(iGame, entity, entity2);
        boolean bl2 = Compute.isInBuilding(iGame, entity2);
        Building building = null;
        if (bl2) {
            building = iGame.getBoard().getBuildingAt(entity2.getPosition());
        }
        ToHitData toHitData = null;
        if (entity.equals(entity2)) {
            return new ToHitData(Integer.MAX_VALUE, "You can't target yourself");
        }
        if (!(entity instanceof Mech)) {
            return new ToHitData(Integer.MAX_VALUE, "Non-mechs can't push");
        }
        if (entity.entityIsQuad()) {
            return new ToHitData(Integer.MAX_VALUE, "Attacker is a quad");
        }
        if (!(entity2 instanceof Mech)) {
            return new ToHitData(Integer.MAX_VALUE, "Target is not a mech");
        }
        if (entity.getArmsFlipped()) {
            return new ToHitData(Integer.MAX_VALUE, "Arms are flipped to the rear. Can not push.");
        }
        if (-1 != entity2.getTransportId()) {
            return new ToHitData(Integer.MAX_VALUE, "Target is a passenger.");
        }
        if (-1 != entity2.getSwarmTargetId()) {
            return new ToHitData(Integer.MAX_VALUE, "Target is swarming a Mek.");
        }
        if (entity.isLocationBad(4) || entity.isLocationBad(5)) {
            return new ToHitData(Integer.MAX_VALUE, "Arm missing");
        }
        if (entity.weaponFiredFrom(4) || entity.weaponFiredFrom(5)) {
            return new ToHitData(Integer.MAX_VALUE, "Weapons fired from arm this turn");
        }
        if (entity.getPosition().distance(targetable.getPosition()) > 1) {
            return new ToHitData(Integer.MAX_VALUE, "Target not in range");
        }
        if (n3 != n4) {
            return new ToHitData(Integer.MAX_VALUE, "Target not at same elevation");
        }
        if (entity2.hasDisplacementAttack() && !entity2.isPushing()) {
            return new ToHitData(Integer.MAX_VALUE, "Target is making a charge/DFA attack");
        }
        if (entity2.isPushing() && entity2.getDisplacementAttack().getTargetId() != entity.getId()) {
            return new ToHitData(Integer.MAX_VALUE, "Target is pushing another mech");
        }
        if (entity.isTargetOfDisplacementAttack() && entity.findTargetedDisplacement().getEntityId() != targetable.getTargetId()) {
            return new ToHitData(Integer.MAX_VALUE, "Attacker is the target of another push/charge/DFA");
        }
        if (entity2.isTargetOfDisplacementAttack() && entity2.findTargetedDisplacement().getEntityId() != entity.getId()) {
            return new ToHitData(Integer.MAX_VALUE, "Target is the target of another push/charge/DFA");
        }
        if (!targetable.getPosition().equals(entity.getPosition().translated(entity.getFacing()))) {
            return new ToHitData(Integer.MAX_VALUE, "Target not directly ahead of feet");
        }
        if (entity.isProne()) {
            return new ToHitData(Integer.MAX_VALUE, "Attacker is prone");
        }
        if (entity2.isProne()) {
            return new ToHitData(Integer.MAX_VALUE, "Target is prone");
        }
        if (bl2) {
            if (!Compute.isInBuilding(iGame, entity)) {
                return new ToHitData(Integer.MAX_VALUE, "Target is inside building");
            }
            if (!iGame.getBoard().getBuildingAt(entity.getPosition()).equals(building)) {
                return new ToHitData(Integer.MAX_VALUE, "Target is inside differnt building");
            }
        }
        if (targetable.getTargetType() == 3 || targetable.getTargetType() == 15) {
            return new ToHitData(Integer.MAX_VALUE, "You can not push a building (well, you can, but it won't do anything).");
        }
        if (targetable.getTargetType() == 4 || targetable.getTargetType() == 1 || targetable.getTargetType() == 2) {
            return new ToHitData(Integer.MAX_VALUE, "Invalid attack");
        }
        int n5 = entity.getCrew().getPiloting() - 1;
        toHitData = new ToHitData(n5, "base");
        toHitData.append(Compute.getAttackerMovementModifier(iGame, n));
        toHitData.append(Compute.getTargetMovementModifier(iGame, n2));
        toHitData.append(Compute.getAttackerTerrainModifier(iGame, n));
        toHitData.append(Compute.getTargetTerrainModifier(iGame, entity2, 0, bl));
        if (!entity.hasWorkingSystem(7, 4)) {
            toHitData.addModifier(2, "Right Shoulder destroyed");
        }
        if (!entity.hasWorkingSystem(7, 5)) {
            toHitData.addModifier(2, "Left Shoulder destroyed");
        }
        if (entity.isSpotting()) {
            toHitData.addModifier(1, "attacker is spotting");
        }
        if (entity2.height() > 0 && entity2.getElevation() == -1 && iHex2.terrainLevel(2) == entity2.height()) {
            toHitData.addModifier(3, "target has partial cover");
        }
        toHitData.append(Compute.getImmobileMod(entity2));
        Compute.modifyPhysicalBTHForAdvantages(entity, entity2, toHitData, iGame);
        if (entity2.isEvading()) {
            toHitData.addModifier(entity2.getEvasionBonus(), "target is evading");
        }
        toHitData.append(PushAttackAction.nightModifiers(iGame, targetable, null, entity, false));
        if (((Mech)entity).getCockpitType() == 1) {
            int n6;
            int n7 = entity.getBadCriticals(0, 1, 0);
            if (n7 + (n6 = entity.getBadCriticals(0, 1, 1)) == 3) {
                return new ToHitData(Integer.MAX_VALUE, "Sensors Completely Destroyed for Torso-Mounted Cockpit");
            }
            if (n7 == 2) {
                toHitData.addModifier(4, "Head Sensors Destroyed for Torso-Mounted Cockpit");
            }
        }
        if (iGame.getOptions().booleanOption("tacops_attack_physical_psr")) {
            if (entity.getWeightClass() == 0) {
                toHitData.addModifier(-2, "Weight Class Attack Modifier");
            } else if (entity.getWeightClass() == 1) {
                toHitData.addModifier(-1, "Weight Class Attack Modifier");
            }
        }
        if (((Mech)entity).hasIndustrialTSM()) {
            toHitData.addModifier(2, "industrial TSM");
        }
        return toHitData;
    }
}

