# PySNMP SMI module. Autogenerated from smidump -f python ADSL-LINE-MIB
# by libsmi2pysnmp-0.1.3 at Mon Apr  2 20:38:38 2012,
# Python version sys.version_info(major=2, minor=7, micro=2, releaselevel='final', serial=0)

# Imports

( AdslLineCodingType, AdslPerfCurrDayCount, AdslPerfPrevDayCount, AdslPerfTimeElapsed, ) = mibBuilder.importSymbols("ADSL-TC-MIB", "AdslLineCodingType", "AdslPerfCurrDayCount", "AdslPerfPrevDayCount", "AdslPerfTimeElapsed")
( Integer, ObjectIdentifier, OctetString, ) = mibBuilder.importSymbols("ASN1", "Integer", "ObjectIdentifier", "OctetString")
( NamedValues, ) = mibBuilder.importSymbols("ASN1-ENUMERATION", "NamedValues")
( ConstraintsIntersection, ConstraintsUnion, SingleValueConstraint, ValueRangeConstraint, ValueSizeConstraint, ) = mibBuilder.importSymbols("ASN1-REFINEMENT", "ConstraintsIntersection", "ConstraintsUnion", "SingleValueConstraint", "ValueRangeConstraint", "ValueSizeConstraint")
( ifIndex, ) = mibBuilder.importSymbols("IF-MIB", "ifIndex")
( PerfCurrentCount, PerfIntervalCount, ) = mibBuilder.importSymbols("PerfHist-TC-MIB", "PerfCurrentCount", "PerfIntervalCount")
( SnmpAdminString, ) = mibBuilder.importSymbols("SNMP-FRAMEWORK-MIB", "SnmpAdminString")
( ModuleCompliance, NotificationGroup, ObjectGroup, ) = mibBuilder.importSymbols("SNMPv2-CONF", "ModuleCompliance", "NotificationGroup", "ObjectGroup")
( Bits, Counter32, Gauge32, Integer32, ModuleIdentity, MibIdentifier, NotificationType, MibScalar, MibTable, MibTableRow, MibTableColumn, TimeTicks, Unsigned32, transmission, ) = mibBuilder.importSymbols("SNMPv2-SMI", "Bits", "Counter32", "Gauge32", "Integer32", "ModuleIdentity", "MibIdentifier", "NotificationType", "MibScalar", "MibTable", "MibTableRow", "MibTableColumn", "TimeTicks", "Unsigned32", "transmission")
( RowStatus, TruthValue, VariablePointer, ) = mibBuilder.importSymbols("SNMPv2-TC", "RowStatus", "TruthValue", "VariablePointer")

# Objects

adslMIB = ModuleIdentity((1, 3, 6, 1, 2, 1, 10, 94)).setRevisions(("1999-08-19 00:00",))
if mibBuilder.loadTexts: adslMIB.setOrganization("IETF ADSL MIB Working Group")
if mibBuilder.loadTexts: adslMIB.setContactInfo("\nGregory Bathrick\nAG Communication Systems\nA Subsidiary of Lucent Technologies\n2500 W Utopia Rd.\nPhoenix, AZ 85027 USA\nTel: +1 602-582-7679\nFax: +1 602-582-7697\nE-mail: bathricg@agcs.com\n\nFaye Ly\nCopper Mountain Networks\nNorcal Office\n2470 Embarcadero Way\nPalo Alto, CA 94303\nTel: +1 650-858-8500\nFax: +1 650-858-8085\nE-Mail: faye@coppermountain.com\n\n(ADSL Forum input only)\nJohn Burgess\nPredictive Systems, Inc.\n25A Vreeland Rd.\nFlorham Park, NJ 07932 USA\nTel: +1 973-301-5610\nFax: +1 973-301-5699\nE-mail: jtburgess@predictive.com\n\nIETF ADSL MIB Working Group (adsl@xlist.agcs.com)")
if mibBuilder.loadTexts: adslMIB.setDescription("The MIB module defining objects for the management of a pair of\nADSL modems at each end of the ADSL line.  Each such line has\nan entry in an ifTable which may include multiple modem lines.\nAn agent may reside at either end of the ADSL line however the\nMIB is designed to require no management communication between\nthem beyond that inherent in the low-level ADSL line protocol.\nThe agent may monitor and control this protocol for its needs.\n\nADSL lines may support optional Fast or Interleaved channels.\nIf these are supported, additional entries corresponding to the\nsupported channels must be created in the ifTable. Thus an ADSL\nline that supports both channels will have three entries in the\nifTable, one for each physical, fast, and interleaved, whose\nifType values are equal to adsl(94), fast(125), and\ninterleaved(124), respectively. The ifStackTable is used to\nrepresent the relationship between the entries.\n\nNaming Conventions:\n          Atuc -- (ATUC) modem at near (Central) end of line\n          Atur -- (ATUR) modem at Remote end of line\n          Curr -- Current\n          Prev -- Previous\n          Atn -- Attenuation\n          ES  -- Errored Second.\n          LCS -- Line Code Specific\n          Lof -- Loss of Frame\n          Lol -- Loss of Link\n          Los -- Loss of Signal\n          Lpr -- Loss of Power\n          xxxs-- interval of Seconds in which xxx occurs\n                  (e.g., xxx=Lof, Los, Lpr)\n          Max -- Maximum\n          Mgn -- Margin\n          Min -- Minimum\n          Psd -- Power Spectral Density\n          Snr -- Signal to Noise Ratio\n          Tx  -- Transmit\n          Blks-- Blocks, a data unit, see\n                 adslAtuXChanCrcBlockLength\n  ")
adslLineMib = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 94, 1))
adslMibObjects = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 94, 1, 1))
adslLineTable = MibTable((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 1))
if mibBuilder.loadTexts: adslLineTable.setDescription("This table includes common attributes describing\nboth ends of the line.  It is required for all ADSL\nphysical interfaces.  ADSL physical interfaces are\nthose ifEntries where ifType is equal to adsl(94).")
adslLineEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 1, 1)).setIndexNames((0, "IF-MIB", "ifIndex"))
if mibBuilder.loadTexts: adslLineEntry.setDescription("An entry in adslLineTable.")
adslLineCoding = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 1, 1, 1), AdslLineCodingType()).setMaxAccess("readonly")
if mibBuilder.loadTexts: adslLineCoding.setDescription("Specifies the ADSL coding type used on this\nline.")
adslLineType = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 1, 1, 2), Integer().subtype(subtypeSpec=SingleValueConstraint(2,1,3,4,5,)).subtype(namedValues=NamedValues(("noChannel", 1), ("fastOnly", 2), ("interleavedOnly", 3), ("fastOrInterleaved", 4), ("fastAndInterleaved", 5), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: adslLineType.setDescription("Defines the type of ADSL physical line\nentity that exists, by defining whether and how\nthe line is channelized.  If the line is channelized,\nthe value will be other than noChannel(1).  This\nobject defines which channel type(s) are supported.\n\nIn the case that the line is channelized, the manager\ncan use the ifStackTable to determine the ifIndex for\nthe associated channel(s).")
adslLineSpecific = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 1, 1, 3), VariablePointer()).setMaxAccess("readonly")
if mibBuilder.loadTexts: adslLineSpecific.setDescription("OID instance in vendor-specific MIB. The Instance may\nbe used to determine shelf/slot/port of the ATUC\ninterface in a DSLAM.")
adslLineConfProfile = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 1, 1, 4), SnmpAdminString().subtype(subtypeSpec=ValueSizeConstraint(1, 32))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: adslLineConfProfile.setDescription("The value of this object identifies the row\nin the ADSL Line Configuration Profile Table,\n(adslLineConfProfileTable), which applies for this\nADSL line, and channels if applicable.\n\nFor `dynamic' mode, in the case which the\nconfiguration profile has not been set, the\nvalue will be set to `DEFVAL'.\n\nIf the implementator of this MIB has chosen not\nto implement `dynamic assignment' of profiles, this\nobject's MIN-ACCESS is read-only.")
adslLineAlarmConfProfile = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 1, 1, 5), SnmpAdminString().subtype(subtypeSpec=ValueSizeConstraint(1, 32))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: adslLineAlarmConfProfile.setDescription("The value of this object identifies the row\nin the ADSL Line Alarm Configuration Profile Table,\n(adslLineAlarmConfProfileTable), which applies to this\nADSL line, and channels if applicable.\n\nFor `dynamic' mode, in the case which the\nalarm profile has not been set, the\nvalue will be set to `DEFVAL'.\n\nIf the implementator of this MIB has chosen not\nto implement `dynamic assignment' of profiles, this\nobject's MIN-ACCESS is read-only.")
adslAtucPhysTable = MibTable((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 2))
if mibBuilder.loadTexts: adslAtucPhysTable.setDescription("This table provides one row for each ATUC.\nEach row contains the Physical Layer Parameters\ntable for that ATUC. ADSL physical interfaces are\nthose ifEntries where ifType is equal to adsl(94).")
adslAtucPhysEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 2, 1)).setIndexNames((0, "IF-MIB", "ifIndex"))
if mibBuilder.loadTexts: adslAtucPhysEntry.setDescription("An entry in the adslAtucPhysTable.")
adslAtucInvSerialNumber = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 2, 1, 1), SnmpAdminString().subtype(subtypeSpec=ValueSizeConstraint(0, 32))).setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAtucInvSerialNumber.setDescription("The vendor specific string that identifies the\nvendor equipment.")
adslAtucInvVendorID = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 2, 1, 2), SnmpAdminString().subtype(subtypeSpec=ValueSizeConstraint(0, 16))).setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAtucInvVendorID.setDescription("The vendor ID code is a copy of the binary\nvendor identification field defined by the\nPHY[10] and expressed as readable characters.")
adslAtucInvVersionNumber = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 2, 1, 3), SnmpAdminString().subtype(subtypeSpec=ValueSizeConstraint(0, 16))).setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAtucInvVersionNumber.setDescription("The vendor specific version number sent by this ATU\nas part of the initialization messages.  It is a copy\nof the binary version number field defined by the\nPHY[10] and expressed as readable characters.")
adslAtucCurrSnrMgn = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 2, 1, 4), Integer32().subtype(subtypeSpec=ValueRangeConstraint(-640, 640))).setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAtucCurrSnrMgn.setDescription("Noise Margin as seen by this ATU with respect to its\nreceived signal in tenth dB.")
adslAtucCurrAtn = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 2, 1, 5), Gauge32().subtype(subtypeSpec=ValueRangeConstraint(0, 630))).setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAtucCurrAtn.setDescription("Measured difference in the total power transmitted by\nthe peer ATU and the total power received by this ATU.")
adslAtucCurrStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 2, 1, 6), Bits().subtype(namedValues=NamedValues(("noDefect", 0), ("lossOfFraming", 1), ("lossOfSignal", 2), ("lossOfPower", 3), ("lossOfSignalQuality", 4), ("lossOfLink", 5), ("dataInitFailure", 6), ("configInitFailure", 7), ("protocolInitFailure", 8), ("noPeerAtuPresent", 9), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAtucCurrStatus.setDescription("Indicates current state of the ATUC line.  This is a\nbit-map of possible conditions.  The various bit\npositions are:\n\n0      noDefect             There no defects on the line\n\n1      lossOfFraming        ATUC failure due to not\n                     receiving valid frame.\n\n2      lossOfSignal         ATUC failure due to not\n                     receiving signal.\n\n3      lossOfPower          ATUC failure due to loss of\n                     power.\n                     Note: the Agent may still\n                     function.\n\n4      lossOfSignalQuality  Loss of Signal Quality is\n                     declared when the Noise Margin\n                     falls below the Minimum Noise\n                     Margin, or the bit-error-rate\n                     exceeds 10^-7.\n\n5      lossOfLink           ATUC failure due to inability\n                     to link with ATUR.\n\n6      dataInitFailure      ATUC failure during\n                     initialization due to bit\n                     errors corrupting startup\n                     exchange data.\n\n7      configInitFailure    ATUC failure during\n                     initialization due to peer\n                     ATU not able to support\n                     requested configuration\n\n8      protocolInitFailure  ATUC failure during\n                     initialization due to\n                     incompatible protocol used by\n                     the peer ATU.\n\n9      noPeerAtuPresent     ATUC failure during\n                     initialization due to no\n                     activation sequence detected\n                     from peer ATU.\n\nThis is intended to supplement ifOperStatus.")
adslAtucCurrOutputPwr = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 2, 1, 7), Integer32().subtype(subtypeSpec=ValueRangeConstraint(-310, 310))).setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAtucCurrOutputPwr.setDescription("Measured total output power transmitted by this ATU.\nThis is the measurement that was reported during\nthe last activation sequence.")
adslAtucCurrAttainableRate = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 2, 1, 8), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAtucCurrAttainableRate.setDescription("Indicates the maximum currently attainable data rate\nby the ATU.  This value will be equal or greater than\nthe current line rate.")
adslAturPhysTable = MibTable((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 3))
if mibBuilder.loadTexts: adslAturPhysTable.setDescription("This table provides one row for each ATUR\nEach row contains the Physical Layer Parameters\ntable for that ATUR. ADSL physical interfaces are\nthose ifEntries where ifType is equal to adsl(94).")
adslAturPhysEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 3, 1)).setIndexNames((0, "IF-MIB", "ifIndex"))
if mibBuilder.loadTexts: adslAturPhysEntry.setDescription("An entry in the adslAturPhysTable.")
adslAturInvSerialNumber = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 3, 1, 1), SnmpAdminString().subtype(subtypeSpec=ValueSizeConstraint(0, 32))).setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAturInvSerialNumber.setDescription("The vendor specific string that identifies the\nvendor equipment.")
adslAturInvVendorID = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 3, 1, 2), SnmpAdminString().subtype(subtypeSpec=ValueSizeConstraint(0, 16))).setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAturInvVendorID.setDescription("The vendor ID code is a copy of the binary\nvendor identification field defined by the\nPHY[10] and expressed as readable characters.")
adslAturInvVersionNumber = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 3, 1, 3), SnmpAdminString().subtype(subtypeSpec=ValueSizeConstraint(0, 16))).setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAturInvVersionNumber.setDescription("The vendor specific version number sent by this ATU\nas part of the initialization messages.  It is a copy\nof the binary version number field defined by the\nPHY[10] and expressed as readable characters.")
adslAturCurrSnrMgn = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 3, 1, 4), Integer32().subtype(subtypeSpec=ValueRangeConstraint(-640, 640))).setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAturCurrSnrMgn.setDescription("Noise Margin as seen by this ATU with respect to its\nreceived signal in tenth dB.")
adslAturCurrAtn = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 3, 1, 5), Gauge32().subtype(subtypeSpec=ValueRangeConstraint(0, 630))).setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAturCurrAtn.setDescription("Measured difference in the total power transmitted by\nthe peer ATU and the total power received by this ATU.")
adslAturCurrStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 3, 1, 6), Bits().subtype(namedValues=NamedValues(("noDefect", 0), ("lossOfFraming", 1), ("lossOfSignal", 2), ("lossOfPower", 3), ("lossOfSignalQuality", 4), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAturCurrStatus.setDescription("Indicates current state of the ATUR line.  This is a\nbit-map of possible conditions.  Due to the isolation\nof the ATUR when line problems occur, many state\nconditions like loss of power, loss of quality signal,\nand initialization errors,  can not be determined.\nWhile trouble shooting ATUR, also use object,\nadslAtucCurrStatus.  The various bit positions are:\n\n0      noDefect             There no defects on the line\n\n1      lossOfFraming        ATUR failure due to not\n                     receiving valid frame\n\n2      lossOfSignal         ATUR failure due to not\n                     receiving signal\n\n3      lossOfPower          ATUR failure due to loss of\n                     power\n\n4      lossOfSignalQuality  Loss of Signal Quality is\n                     declared when the Noise Margin\n                     falls below the Minimum Noise\n                     Margin, or the\n                     bit-error-rate exceeds 10^-7.\n\nThis is intended to supplement ifOperStatus.")
adslAturCurrOutputPwr = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 3, 1, 7), Integer32().subtype(subtypeSpec=ValueRangeConstraint(-310, 310))).setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAturCurrOutputPwr.setDescription("Measured total output power transmitted by this ATU.\nThis is the measurement that was reported during\nthe last activation sequence.")
adslAturCurrAttainableRate = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 3, 1, 8), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAturCurrAttainableRate.setDescription("Indicates the maximum currently attainable data rate\nby the ATU.  This value will be equal or greater than\nthe current line rate.")
adslAtucChanTable = MibTable((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 4))
if mibBuilder.loadTexts: adslAtucChanTable.setDescription("This table provides one row for each ATUC channel.\nADSL channel interfaces are those ifEntries\nwhere ifType is equal to adslInterleave(124)\nor adslFast(125).")
adslAtucChanEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 4, 1)).setIndexNames((0, "IF-MIB", "ifIndex"))
if mibBuilder.loadTexts: adslAtucChanEntry.setDescription("An entry in the adslAtucChanTable.")
adslAtucChanInterleaveDelay = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 4, 1, 1), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAtucChanInterleaveDelay.setDescription("Interleave Delay for this channel.\n\nInterleave delay applies only to the\ninterleave channel and defines the mapping\n(relative spacing) between subsequent input\nbytes at the interleaver input and their placement\nin the bit stream at the interleaver output.\nLarger numbers provide greater separation between\nconsecutive input bytes in the output bit stream\nallowing for improved impulse noise immunity at\nthe expense of payload latency.\n\nIn the case where the ifType is Fast(125), use\nnoSuchObject.")
adslAtucChanCurrTxRate = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 4, 1, 2), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAtucChanCurrTxRate.setDescription("Actual transmit rate on this channel.")
adslAtucChanPrevTxRate = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 4, 1, 3), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAtucChanPrevTxRate.setDescription("The rate at the time of the last\nadslAtucRateChangeTrap event. It is also set at\ninitialization to prevent a trap being sent.\n\nRate changes less than adslAtucThresh(*)RateDown\nor less than adslAtucThresh(*)RateUp will not\ncause a trap or cause this object to change.\n(*) == Fast or Interleave.\nSee AdslLineAlarmConfProfileEntry.")
adslAtucChanCrcBlockLength = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 4, 1, 4), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAtucChanCrcBlockLength.setDescription("Indicates the length of the channel data-block\non which the CRC operates.  Refer to Line Code\nSpecific MIBs, [11] and [12] for more\ninformation.")
adslAturChanTable = MibTable((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 5))
if mibBuilder.loadTexts: adslAturChanTable.setDescription("This table provides one row for each ATUR channel.\nADSL channel interfaces are those ifEntries\nwhere ifType is equal to adslInterleave(124)\nor adslFast(125).")
adslAturChanEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 5, 1)).setIndexNames((0, "IF-MIB", "ifIndex"))
if mibBuilder.loadTexts: adslAturChanEntry.setDescription("An entry in the adslAturChanTable.")
adslAturChanInterleaveDelay = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 5, 1, 1), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAturChanInterleaveDelay.setDescription("Interleave Delay for this channel.\n\nInterleave delay applies only to the\ninterleave channel and defines the mapping\n(relative spacing) between subsequent input\nbytes at the interleaver input and their placement\nin the bit stream at the interleaver output.\nLarger numbers provide greater separation between\nconsecutive input bytes in the output bit stream\nallowing for improved impulse noise immunity at\nthe expense of payload latency.\n\nIn the case where the ifType is Fast(125), use\nnoSuchObject.")
adslAturChanCurrTxRate = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 5, 1, 2), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAturChanCurrTxRate.setDescription("Actual transmit rate on this channel.")
adslAturChanPrevTxRate = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 5, 1, 3), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAturChanPrevTxRate.setDescription("The rate at the time of the last\nadslAturRateChangeTrap event. It is also set at\ninitialization to prevent a trap being sent.\nRate changes less than adslAturThresh(*)RateDown\nor less than adslAturThresh(*)RateUp will not\ncause a trap or cause this object to change.\n(*) == Fast or Interleave.\nSee AdslLineAlarmConfProfileEntry.")
adslAturChanCrcBlockLength = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 5, 1, 4), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAturChanCrcBlockLength.setDescription("Indicates the length of the channel data-block\non which the CRC operates.  Refer to Line Code\nSpecific MIBs, [11] and [12] for more\ninformation.")
adslAtucPerfDataTable = MibTable((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 6))
if mibBuilder.loadTexts: adslAtucPerfDataTable.setDescription("This table provides one row for each ATUC.\nADSL physical interfaces are\nthose ifEntries where ifType is equal to adsl(94).")
adslAtucPerfDataEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 6, 1)).setIndexNames((0, "IF-MIB", "ifIndex"))
if mibBuilder.loadTexts: adslAtucPerfDataEntry.setDescription("An entry in adslAtucPerfDataTable.")
adslAtucPerfLofs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 6, 1, 1), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAtucPerfLofs.setDescription("Count of the number of Loss of Framing failures since\nagent reset.")
adslAtucPerfLoss = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 6, 1, 2), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAtucPerfLoss.setDescription("Count of the number of Loss of Signal failures since\nagent reset.")
adslAtucPerfLols = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 6, 1, 3), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAtucPerfLols.setDescription("Count of the number of Loss of Link failures since\nagent reset.")
adslAtucPerfLprs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 6, 1, 4), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAtucPerfLprs.setDescription("Count of the number of Loss of Power failures since\nagent reset.")
adslAtucPerfESs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 6, 1, 5), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAtucPerfESs.setDescription("Count of the number of Errored Seconds since agent\nreset.  The errored second parameter is a count of\none-second intervals containing one or more crc\nanomalies, or one or more los or sef defects.")
adslAtucPerfInits = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 6, 1, 6), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAtucPerfInits.setDescription("Count of the line initialization attempts since\nagent reset. Includes both successful and failed\nattempts.")
adslAtucPerfValidIntervals = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 6, 1, 7), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 96))).setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAtucPerfValidIntervals.setDescription("The number of previous 15-minute intervals in the\ninterval table for which data was collected.  Given\nthat <n> is the maximum # of intervals supported.\nThe value will be <n> unless the measurement was\n(re-)started within the last (<n>*15) minutes, in which\ncase the value will be the number of complete 15\nminute intervals for which the agent has at least\nsome data. In certain cases (e.g., in the case\nwhere the agent is a proxy) it is possible that some\nintervals are unavailable.  In this case, this\ninterval is the maximum interval number for\nwhich data is available.")
adslAtucPerfInvalidIntervals = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 6, 1, 8), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 96))).setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAtucPerfInvalidIntervals.setDescription("The number of intervals in the range from\n0 to the value of adslAtucPerfValidIntervals\nfor which no data is available. This object\nwill typically be zero except in cases where\nthe data for some intervals are not available\n(e.g., in proxy situations).")
adslAtucPerfCurr15MinTimeElapsed = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 6, 1, 9), AdslPerfTimeElapsed().subtype(subtypeSpec=ValueRangeConstraint(0, 899))).setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAtucPerfCurr15MinTimeElapsed.setDescription("Total elapsed seconds in this interval.")
adslAtucPerfCurr15MinLofs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 6, 1, 10), PerfCurrentCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAtucPerfCurr15MinLofs.setDescription("Count of seconds in the current 15 minute interval\nwhen there was Loss of Framing.")
adslAtucPerfCurr15MinLoss = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 6, 1, 11), PerfCurrentCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAtucPerfCurr15MinLoss.setDescription("Count of seconds in the current 15 minute interval\nwhen there was Loss of Signal.")
adslAtucPerfCurr15MinLols = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 6, 1, 12), PerfCurrentCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAtucPerfCurr15MinLols.setDescription("Count of seconds in the current 15 minute interval\nwhen there was Loss of Link.")
adslAtucPerfCurr15MinLprs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 6, 1, 13), PerfCurrentCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAtucPerfCurr15MinLprs.setDescription("Count of seconds in the current 15 minute interval\nwhen there was Loss of Power.")
adslAtucPerfCurr15MinESs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 6, 1, 14), PerfCurrentCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAtucPerfCurr15MinESs.setDescription("Count of Errored Seconds in the current 15 minute\ninterval.  The errored second parameter is a count of\none-second intervals containing one or more crc\nanomalies, or one or more los or sef defects.")
adslAtucPerfCurr15MinInits = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 6, 1, 15), PerfCurrentCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAtucPerfCurr15MinInits.setDescription("Count of the line initialization attempts in the\ncurrent 15 minute interval. Includes both successful\nand failed attempts.")
adslAtucPerfCurr1DayTimeElapsed = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 6, 1, 16), AdslPerfTimeElapsed().subtype(subtypeSpec=ValueRangeConstraint(0, 86399))).setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAtucPerfCurr1DayTimeElapsed.setDescription("Number of seconds that have elapsed since the\nbeginning of the current 1-day interval.")
adslAtucPerfCurr1DayLofs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 6, 1, 17), AdslPerfCurrDayCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAtucPerfCurr1DayLofs.setDescription("Count of the number of seconds when there was Loss of\nFraming during the current day as measured by\nadslAtucPerfCurr1DayTimeElapsed.")
adslAtucPerfCurr1DayLoss = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 6, 1, 18), AdslPerfCurrDayCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAtucPerfCurr1DayLoss.setDescription("Count of the number of seconds when there was Loss of\nSignal during the current day as measured by\nadslAtucPerfCurr1DayTimeElapsed.")
adslAtucPerfCurr1DayLols = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 6, 1, 19), AdslPerfCurrDayCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAtucPerfCurr1DayLols.setDescription("Count of the number of seconds when there was Loss of\nLink during the current day as measured by\nadslAtucPerfCurr1DayTimeElapsed.")
adslAtucPerfCurr1DayLprs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 6, 1, 20), AdslPerfCurrDayCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAtucPerfCurr1DayLprs.setDescription("Count of the number of seconds when there was Loss of\nPower during the current day as measured by\nadslAtucPerfCurr1DayTimeElapsed.")
adslAtucPerfCurr1DayESs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 6, 1, 21), AdslPerfCurrDayCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAtucPerfCurr1DayESs.setDescription("Count of Errored Seconds during the current day as\nmeasured by adslAtucPerfCurr1DayTimeElapsed.\nThe errored second parameter is a count of\none-second intervals containing one or more crc\nanomalies, or one or more los or sef defects.")
adslAtucPerfCurr1DayInits = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 6, 1, 22), AdslPerfCurrDayCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAtucPerfCurr1DayInits.setDescription("Count of the line initialization attempts in the\nday as measured by adslAtucPerfCurr1DayTimeElapsed.\nIncludes both successful and failed attempts.")
adslAtucPerfPrev1DayMoniSecs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 6, 1, 23), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 86400))).setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAtucPerfPrev1DayMoniSecs.setDescription("The amount of time in the previous 1-day interval\nover which the performance monitoring information\nis actually counted. This value will be the same as\nthe interval duration except in a situation where\nperformance monitoring data could not be collected\nfor any reason.")
adslAtucPerfPrev1DayLofs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 6, 1, 24), AdslPerfPrevDayCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAtucPerfPrev1DayLofs.setDescription("Count of seconds in the interval when there was\nLoss of Framing within the most recent previous\n1-day period.")
adslAtucPerfPrev1DayLoss = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 6, 1, 25), AdslPerfPrevDayCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAtucPerfPrev1DayLoss.setDescription("Count of seconds in the interval when there was\nLoss of Signal within the most recent previous\n1-day period.")
adslAtucPerfPrev1DayLols = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 6, 1, 26), AdslPerfPrevDayCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAtucPerfPrev1DayLols.setDescription("Count of seconds in the interval when there was\nLoss of Link within the most recent previous\n1-day period.")
adslAtucPerfPrev1DayLprs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 6, 1, 27), AdslPerfPrevDayCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAtucPerfPrev1DayLprs.setDescription("Count of seconds in the interval when there was\nLoss of Power within the most recent previous\n1-day period.")
adslAtucPerfPrev1DayESs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 6, 1, 28), AdslPerfPrevDayCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAtucPerfPrev1DayESs.setDescription("Count of Errored Seconds within the most recent\nprevious 1-day period. The errored second parameter is\na count of one-second intervals containing one or more\ncrc anomalies, or one or more los or sef defects.")
adslAtucPerfPrev1DayInits = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 6, 1, 29), AdslPerfPrevDayCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAtucPerfPrev1DayInits.setDescription("Count of the line initialization attempts in the most\nrecent previous 1-day period. Includes both successful\nand failed attempts.")
adslAturPerfDataTable = MibTable((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 7))
if mibBuilder.loadTexts: adslAturPerfDataTable.setDescription("This table provides one row for each ATUR.\nADSL physical interfaces are\nthose ifEntries where ifType is equal to adsl(94).")
adslAturPerfDataEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 7, 1)).setIndexNames((0, "IF-MIB", "ifIndex"))
if mibBuilder.loadTexts: adslAturPerfDataEntry.setDescription("An entry in adslAturPerfDataTable.")
adslAturPerfLofs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 7, 1, 1), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAturPerfLofs.setDescription("Count of the number of Loss of Framing failures since\nagent reset.")
adslAturPerfLoss = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 7, 1, 2), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAturPerfLoss.setDescription("Count of the number of Loss of Signal failures since\nagent reset.")
adslAturPerfLprs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 7, 1, 3), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAturPerfLprs.setDescription("Count of the number of Loss of Power failures since\nagent reset.")
adslAturPerfESs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 7, 1, 4), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAturPerfESs.setDescription("Count of the number of Errored Seconds since agent\nreset.  The errored second parameter is a count of\none-second intervals containing one or more crc\nanomalies, or one or more los or sef defects.")
adslAturPerfValidIntervals = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 7, 1, 5), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 96))).setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAturPerfValidIntervals.setDescription("The number of previous 15-minute intervals in the\ninterval table for which data was collected.  Given\nthat <n> is the maximum # of intervals supported.\nThe value will be <n> unless the measurement was\n(re-)started within the last (<n>*15) minutes, in which\ncase the value will be the number of complete 15\nminute intervals for which the agent has at least\nsome data. In certain cases (e.g., in the case\nwhere the agent is a proxy) it is possible that some\nintervals are unavailable.  In this case, this\ninterval is the maximum interval number for\nwhich data is available.")
adslAturPerfInvalidIntervals = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 7, 1, 6), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 96))).setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAturPerfInvalidIntervals.setDescription("The number of intervals in the range from\n0 to the value of adslAturPerfValidIntervals\nfor which no data is available. This object\nwill typically be zero except in cases where\nthe data for some intervals are not available\n(e.g., in proxy situations).")
adslAturPerfCurr15MinTimeElapsed = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 7, 1, 7), AdslPerfTimeElapsed().subtype(subtypeSpec=ValueRangeConstraint(0, 899))).setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAturPerfCurr15MinTimeElapsed.setDescription("Total elapsed seconds in this interval.")
adslAturPerfCurr15MinLofs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 7, 1, 8), PerfCurrentCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAturPerfCurr15MinLofs.setDescription("Count of seconds in the current 15 minute interval\nwhen there was Loss of Framing.")
adslAturPerfCurr15MinLoss = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 7, 1, 9), PerfCurrentCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAturPerfCurr15MinLoss.setDescription("Count of seconds in the current 15 minute interval\nwhen there was Loss of Signal.")
adslAturPerfCurr15MinLprs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 7, 1, 10), PerfCurrentCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAturPerfCurr15MinLprs.setDescription("Count of seconds in the current 15 minute interval\nwhen there was Loss of Power.")
adslAturPerfCurr15MinESs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 7, 1, 11), PerfCurrentCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAturPerfCurr15MinESs.setDescription("Count of Errored Seconds in the current 15 minute\ninterval.  The errored second parameter is a count of\none-second intervals containing one or more crc\nanomalies, or one or more los or sef defects.")
adslAturPerfCurr1DayTimeElapsed = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 7, 1, 12), AdslPerfTimeElapsed().subtype(subtypeSpec=ValueRangeConstraint(0, 86399))).setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAturPerfCurr1DayTimeElapsed.setDescription("Number of seconds that have elapsed since the\nbeginning of the current 1-day interval.")
adslAturPerfCurr1DayLofs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 7, 1, 13), AdslPerfCurrDayCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAturPerfCurr1DayLofs.setDescription("Count of the number of seconds when there was Loss\nof Framing during the current day as measured by\nadslAturPerfCurr1DayTimeElapsed.")
adslAturPerfCurr1DayLoss = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 7, 1, 14), AdslPerfCurrDayCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAturPerfCurr1DayLoss.setDescription("Count of the number of seconds when there was Loss\nof Signal during the current day as measured by\nadslAturPerfCurr1DayTimeElapsed.")
adslAturPerfCurr1DayLprs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 7, 1, 15), AdslPerfCurrDayCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAturPerfCurr1DayLprs.setDescription("Count of the number of seconds when there was Loss\nof Power during the current day as measured by\nadslAturPerfCurr1DayTimeElapsed.")
adslAturPerfCurr1DayESs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 7, 1, 16), AdslPerfCurrDayCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAturPerfCurr1DayESs.setDescription("Count of Errored Seconds during the current day as\nmeasured by adslAturPerfCurr1DayTimeElapsed.\nThe errored second parameter is a count of\none-second intervals containing one or more crc\nanomalies, or one or more los or sef defects.")
adslAturPerfPrev1DayMoniSecs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 7, 1, 17), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 86400))).setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAturPerfPrev1DayMoniSecs.setDescription("The amount of time in the previous 1-day interval\nover which the performance monitoring information\nis actually counted. This value will be the same as\nthe interval duration except in a situation where\nperformance monitoring data could not be collected\nfor any reason.")
adslAturPerfPrev1DayLofs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 7, 1, 18), AdslPerfPrevDayCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAturPerfPrev1DayLofs.setDescription("Count of seconds in the interval when there was\nLoss of Framing within the most recent previous\n1-day period.")
adslAturPerfPrev1DayLoss = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 7, 1, 19), AdslPerfPrevDayCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAturPerfPrev1DayLoss.setDescription("Count of seconds in the interval when there was\nLoss of Signal within the most recent previous\n1-day period.")
adslAturPerfPrev1DayLprs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 7, 1, 20), AdslPerfPrevDayCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAturPerfPrev1DayLprs.setDescription("Count of seconds in the interval when there was\nLoss of Power within the most recent previous\n1-day period.")
adslAturPerfPrev1DayESs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 7, 1, 21), AdslPerfPrevDayCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAturPerfPrev1DayESs.setDescription("Count of Errored Seconds within the most recent\nprevious 1-day period. The errored second parameter is\na count of one-second intervals containing one or more\ncrc anomalies, or one or more los or sef defects.")
adslAtucIntervalTable = MibTable((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 8))
if mibBuilder.loadTexts: adslAtucIntervalTable.setDescription("This table provides one row for each ATUC\nperformance data collection interval.\nADSL physical interfaces are\nthose ifEntries where ifType is equal to adsl(94).")
adslAtucIntervalEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 8, 1)).setIndexNames((0, "IF-MIB", "ifIndex"), (0, "ADSL-LINE-MIB", "adslAtucIntervalNumber"))
if mibBuilder.loadTexts: adslAtucIntervalEntry.setDescription("An entry in the adslAtucIntervalTable.")
adslAtucIntervalNumber = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 8, 1, 1), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1, 96))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: adslAtucIntervalNumber.setDescription("Performance Data Interval number 1 is the\nthe most recent previous interval; interval\n96 is 24 hours ago.  Intervals 2..96 are\noptional.")
adslAtucIntervalLofs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 8, 1, 2), PerfIntervalCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAtucIntervalLofs.setDescription("Count of seconds in the interval when there was Loss\nof Framing.")
adslAtucIntervalLoss = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 8, 1, 3), PerfIntervalCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAtucIntervalLoss.setDescription("Count of seconds in the interval when there was Loss\nof Signal.")
adslAtucIntervalLols = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 8, 1, 4), PerfIntervalCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAtucIntervalLols.setDescription("Count of seconds in the interval when there was Loss\nof Link.")
adslAtucIntervalLprs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 8, 1, 5), PerfIntervalCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAtucIntervalLprs.setDescription("Count of seconds in the interval when there was Loss\nof Power.")
adslAtucIntervalESs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 8, 1, 6), PerfIntervalCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAtucIntervalESs.setDescription("Count of Errored Seconds in the interval.\nThe errored second parameter is a count of\none-second intervals containing one or more crc\nanomalies, or one or more los or sef defects.")
adslAtucIntervalInits = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 8, 1, 7), PerfIntervalCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAtucIntervalInits.setDescription("Count of the line initialization attempts\nduring the interval. Includes both successful\nand failed attempts.")
adslAtucIntervalValidData = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 8, 1, 8), TruthValue()).setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAtucIntervalValidData.setDescription("This variable indicates if the data for this\ninterval is valid.")
adslAturIntervalTable = MibTable((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 9))
if mibBuilder.loadTexts: adslAturIntervalTable.setDescription("This table provides one row for each ATUR\nperformance data collection interval.\nADSL physical interfaces are those\nifEntries where ifType is equal to adsl(94).")
adslAturIntervalEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 9, 1)).setIndexNames((0, "IF-MIB", "ifIndex"), (0, "ADSL-LINE-MIB", "adslAturIntervalNumber"))
if mibBuilder.loadTexts: adslAturIntervalEntry.setDescription("An entry in the adslAturIntervalTable.")
adslAturIntervalNumber = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 9, 1, 1), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1, 96))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: adslAturIntervalNumber.setDescription("Performance Data Interval number 1 is the\nthe most recent previous interval; interval\n96 is 24 hours ago.  Intervals 2..96 are\noptional.")
adslAturIntervalLofs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 9, 1, 2), PerfIntervalCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAturIntervalLofs.setDescription("Count of seconds in the interval when there was\nLoss of Framing.")
adslAturIntervalLoss = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 9, 1, 3), PerfIntervalCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAturIntervalLoss.setDescription("Count of seconds in the interval when there was\nLoss of Signal.")
adslAturIntervalLprs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 9, 1, 4), PerfIntervalCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAturIntervalLprs.setDescription("Count of seconds in the interval when there was\nLoss of Power.")
adslAturIntervalESs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 9, 1, 5), PerfIntervalCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAturIntervalESs.setDescription("Count of Errored Seconds in the interval.\nThe errored second parameter is a count of\none-second intervals containing one or more crc\nanomalies, or one or more los or sef defects.")
adslAturIntervalValidData = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 9, 1, 6), TruthValue()).setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAturIntervalValidData.setDescription("This variable indicates if the data for this\ninterval is valid.")
adslAtucChanPerfDataTable = MibTable((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 10))
if mibBuilder.loadTexts: adslAtucChanPerfDataTable.setDescription("This table provides one row for each ATUC channel.\nADSL channel interfaces are those ifEntries\nwhere ifType is equal to adslInterleave(124)\nor adslFast(125).")
adslAtucChanPerfDataEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 10, 1)).setIndexNames((0, "IF-MIB", "ifIndex"))
if mibBuilder.loadTexts: adslAtucChanPerfDataEntry.setDescription("An entry in adslAtucChanPerfDataTable.")
adslAtucChanReceivedBlks = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 10, 1, 1), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAtucChanReceivedBlks.setDescription("Count of all encoded blocks received on this channel\nsince agent reset.")
adslAtucChanTransmittedBlks = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 10, 1, 2), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAtucChanTransmittedBlks.setDescription("Count of all encoded blocks transmitted on this\nchannel since agent reset.")
adslAtucChanCorrectedBlks = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 10, 1, 3), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAtucChanCorrectedBlks.setDescription("Count of all blocks received with errors that were\ncorrected since agent reset.  These blocks are passed\non as good data.")
adslAtucChanUncorrectBlks = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 10, 1, 4), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAtucChanUncorrectBlks.setDescription("Count of all blocks received with uncorrectable\nerrors since agent reset.")
adslAtucChanPerfValidIntervals = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 10, 1, 5), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 96))).setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAtucChanPerfValidIntervals.setDescription("The number of previous 15-minute intervals in the\ninterval table for which data was collected.  Given\nthat <n> is the maximum # of intervals supported.\nThe value will be <n> unless the measurement was\n(re-)started within the last (<n>*15) minutes, in which\ncase the value will be the number of complete 15\nminute intervals for which the agent has at least\nsome data. In certain cases (e.g., in the case\nwhere the agent is a proxy) it is possible that some\nintervals are unavailable.  In this case, this\ninterval is the maximum interval number for\nwhich data is available.")
adslAtucChanPerfInvalidIntervals = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 10, 1, 6), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 96))).setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAtucChanPerfInvalidIntervals.setDescription("The number of intervals in the range from\n0 to the value of adslAtucChanPerfValidIntervals\nfor which no data is available. This object\nwill typically be zero except in cases where\nthe data for some intervals are not available\n(e.g., in proxy situations).")
adslAtucChanPerfCurr15MinTimeElapsed = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 10, 1, 7), AdslPerfTimeElapsed().subtype(subtypeSpec=ValueRangeConstraint(0, 899))).setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAtucChanPerfCurr15MinTimeElapsed.setDescription("Total elapsed seconds in this interval.")
adslAtucChanPerfCurr15MinReceivedBlks = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 10, 1, 8), PerfCurrentCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAtucChanPerfCurr15MinReceivedBlks.setDescription("Count of all encoded blocks received on this channel\nwithin the current 15 minute interval.")
adslAtucChanPerfCurr15MinTransmittedBlks = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 10, 1, 9), PerfCurrentCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAtucChanPerfCurr15MinTransmittedBlks.setDescription("Count of all encoded blocks transmitted on this\nchannel within the current 15 minute interval.")
adslAtucChanPerfCurr15MinCorrectedBlks = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 10, 1, 10), PerfCurrentCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAtucChanPerfCurr15MinCorrectedBlks.setDescription("Count of all blocks received with errors that were\ncorrected on this channel within the current 15 minute\ninterval.")
adslAtucChanPerfCurr15MinUncorrectBlks = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 10, 1, 11), PerfCurrentCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAtucChanPerfCurr15MinUncorrectBlks.setDescription("Count of all blocks received with uncorrectable\nerrors on this channel within the current 15 minute\ninterval.")
adslAtucChanPerfCurr1DayTimeElapsed = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 10, 1, 12), AdslPerfTimeElapsed().subtype(subtypeSpec=ValueRangeConstraint(0, 86399))).setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAtucChanPerfCurr1DayTimeElapsed.setDescription("Number of seconds that have elapsed since the\nbeginning of the current 1-day interval.")
adslAtucChanPerfCurr1DayReceivedBlks = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 10, 1, 13), AdslPerfCurrDayCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAtucChanPerfCurr1DayReceivedBlks.setDescription("Count of all encoded blocks received on this\nchannel during the current day as measured by\nadslAtucChanPerfCurr1DayTimeElapsed.")
adslAtucChanPerfCurr1DayTransmittedBlks = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 10, 1, 14), AdslPerfCurrDayCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAtucChanPerfCurr1DayTransmittedBlks.setDescription("Count of all encoded blocks transmitted on this\nchannel during the current day as measured by\nadslAtucChanPerfCurr1DayTimeElapsed.")
adslAtucChanPerfCurr1DayCorrectedBlks = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 10, 1, 15), AdslPerfCurrDayCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAtucChanPerfCurr1DayCorrectedBlks.setDescription("Count of all blocks received with errors that were\ncorrected on this channel during the current day as\nmeasured by adslAtucChanPerfCurr1DayTimeElapsed.")
adslAtucChanPerfCurr1DayUncorrectBlks = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 10, 1, 16), AdslPerfCurrDayCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAtucChanPerfCurr1DayUncorrectBlks.setDescription("Count of all blocks received with uncorrectable\nerrors on this channel during the current day as\nmeasured by adslAtucChanPerfCurr1DayTimeElapsed.")
adslAtucChanPerfPrev1DayMoniSecs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 10, 1, 17), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 86400))).setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAtucChanPerfPrev1DayMoniSecs.setDescription("The amount of time in the previous 1-day interval\nover which the performance monitoring information\nis actually counted. This value will be the same as\nthe interval duration except in a situation where\nperformance monitoring data could not be collected\nfor any reason.")
adslAtucChanPerfPrev1DayReceivedBlks = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 10, 1, 18), AdslPerfPrevDayCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAtucChanPerfPrev1DayReceivedBlks.setDescription("Count of all encoded blocks received on this\nchannel within the most recent previous 1-day\nperiod.")
adslAtucChanPerfPrev1DayTransmittedBlks = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 10, 1, 19), AdslPerfPrevDayCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAtucChanPerfPrev1DayTransmittedBlks.setDescription("Count of all encoded blocks transmitted on this\nchannel within the most recent previous 1-day\nperiod.")
adslAtucChanPerfPrev1DayCorrectedBlks = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 10, 1, 20), AdslPerfPrevDayCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAtucChanPerfPrev1DayCorrectedBlks.setDescription("Count of all blocks received with errors that were\ncorrected on this channel within the most recent\nprevious 1-day period.")
adslAtucChanPerfPrev1DayUncorrectBlks = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 10, 1, 21), AdslPerfPrevDayCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAtucChanPerfPrev1DayUncorrectBlks.setDescription("Count of all blocks received with uncorrectable\nerrors on this channel within the most recent previous\n1-day period.")
adslAturChanPerfDataTable = MibTable((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 11))
if mibBuilder.loadTexts: adslAturChanPerfDataTable.setDescription("This table provides one row for each ATUR channel.\nADSL channel interfaces are those ifEntries\nwhere ifType is equal to adslInterleave(124)\nor adslFast(125).")
adslAturChanPerfDataEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 11, 1)).setIndexNames((0, "IF-MIB", "ifIndex"))
if mibBuilder.loadTexts: adslAturChanPerfDataEntry.setDescription("An entry in adslAturChanPerfDataTable.")
adslAturChanReceivedBlks = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 11, 1, 1), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAturChanReceivedBlks.setDescription("Count of all encoded blocks received on this channel\nsince agent reset.")
adslAturChanTransmittedBlks = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 11, 1, 2), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAturChanTransmittedBlks.setDescription("Count of all encoded blocks transmitted on this\nchannel since agent reset.")
adslAturChanCorrectedBlks = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 11, 1, 3), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAturChanCorrectedBlks.setDescription("Count of all blocks received with errors that were\ncorrected since agent reset.  These blocks are passed\non as good data.")
adslAturChanUncorrectBlks = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 11, 1, 4), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAturChanUncorrectBlks.setDescription("Count of all blocks received with uncorrectable\nerrors since agent reset.")
adslAturChanPerfValidIntervals = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 11, 1, 5), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 96))).setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAturChanPerfValidIntervals.setDescription("The number of previous 15-minute intervals in the\ninterval table for which data was collected.  Given\nthat <n> is the maximum # of intervals supported.\nThe value will be <n> unless the measurement was\n(re-)started within the last (<n>*15) minutes, in which\ncase the value will be the number of complete 15\nminute intervals for which the agent has at least\nsome data. In certain cases (e.g., in the case\nwhere the agent is a proxy) it is possible that some\nintervals are unavailable.  In this case, this\ninterval is the maximum interval number for\nwhich data is available.")
adslAturChanPerfInvalidIntervals = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 11, 1, 6), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 96))).setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAturChanPerfInvalidIntervals.setDescription("The number of intervals in the range from\n0 to the value of adslAturChanPerfValidIntervals\nfor which no data is available. This object\nwill typically be zero except in cases where\nthe data for some intervals are not available\n(e.g., in proxy situations).")
adslAturChanPerfCurr15MinTimeElapsed = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 11, 1, 7), AdslPerfTimeElapsed().subtype(subtypeSpec=ValueRangeConstraint(0, 899))).setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAturChanPerfCurr15MinTimeElapsed.setDescription("Total elapsed seconds in this interval.\nA full interval is 900 seconds.")
adslAturChanPerfCurr15MinReceivedBlks = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 11, 1, 8), PerfCurrentCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAturChanPerfCurr15MinReceivedBlks.setDescription("Count of all encoded blocks received on this\nchannel within the current 15 minute interval.")
adslAturChanPerfCurr15MinTransmittedBlks = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 11, 1, 9), PerfCurrentCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAturChanPerfCurr15MinTransmittedBlks.setDescription("Count of all encoded blocks transmitted on this\nchannel within the current 15 minute interval.")
adslAturChanPerfCurr15MinCorrectedBlks = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 11, 1, 10), PerfCurrentCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAturChanPerfCurr15MinCorrectedBlks.setDescription("Count of all blocks received with errors that were\ncorrected on this channel within the current 15 minute\ninterval.")
adslAturChanPerfCurr15MinUncorrectBlks = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 11, 1, 11), PerfCurrentCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAturChanPerfCurr15MinUncorrectBlks.setDescription("Count of all blocks received with uncorrectable\nerrors on this channel within the current 15 minute\ninterval.")
adslAturChanPerfCurr1DayTimeElapsed = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 11, 1, 12), AdslPerfTimeElapsed().subtype(subtypeSpec=ValueRangeConstraint(0, 86399))).setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAturChanPerfCurr1DayTimeElapsed.setDescription("Number of seconds that have elapsed since the\nbeginning of the current 1-day interval.")
adslAturChanPerfCurr1DayReceivedBlks = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 11, 1, 13), AdslPerfCurrDayCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAturChanPerfCurr1DayReceivedBlks.setDescription("Count of all encoded blocks received on this\nchannel during the current day as measured by\nadslAturChanPerfCurr1DayTimeElapsed.")
adslAturChanPerfCurr1DayTransmittedBlks = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 11, 1, 14), AdslPerfCurrDayCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAturChanPerfCurr1DayTransmittedBlks.setDescription("Count of all encoded blocks transmitted on this\nchannel during the current day as measured by\nadslAturChanPerfCurr1DayTimeElapsed.")
adslAturChanPerfCurr1DayCorrectedBlks = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 11, 1, 15), AdslPerfCurrDayCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAturChanPerfCurr1DayCorrectedBlks.setDescription("Count of all blocks received with errors that were\ncorrected on this channel during the current day as\nmeasured by adslAturChanPerfCurr1DayTimeElapsed.")
adslAturChanPerfCurr1DayUncorrectBlks = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 11, 1, 16), AdslPerfCurrDayCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAturChanPerfCurr1DayUncorrectBlks.setDescription("Count of all blocks received with uncorrectable\nerrors on this channel during the current day as\nmeasured by adslAturChanPerfCurr1DayTimeElapsed.")
adslAturChanPerfPrev1DayMoniSecs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 11, 1, 17), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 86400))).setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAturChanPerfPrev1DayMoniSecs.setDescription("The amount of time in the previous 1-day interval\nover which the performance monitoring information\nis actually counted. This value will be the same as\nthe interval duration except in a situation where\nperformance monitoring data could not be collected\nfor any reason.")
adslAturChanPerfPrev1DayReceivedBlks = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 11, 1, 18), AdslPerfPrevDayCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAturChanPerfPrev1DayReceivedBlks.setDescription("Count of all encoded blocks received on this\nchannel within the most recent previous 1-day\nperiod.")
adslAturChanPerfPrev1DayTransmittedBlks = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 11, 1, 19), AdslPerfPrevDayCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAturChanPerfPrev1DayTransmittedBlks.setDescription("Count of all encoded blocks transmitted on this\nchannel within the most recent previous 1-day\nperiod.")
adslAturChanPerfPrev1DayCorrectedBlks = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 11, 1, 20), AdslPerfPrevDayCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAturChanPerfPrev1DayCorrectedBlks.setDescription("Count of all blocks received with errors that were\ncorrected on this channel within the most recent\nprevious 1-day period.")
adslAturChanPerfPrev1DayUncorrectBlks = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 11, 1, 21), AdslPerfPrevDayCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAturChanPerfPrev1DayUncorrectBlks.setDescription("Count of all blocks received with uncorrectable\nerrors on this channel within the most recent previous\n1-day period.")
adslAtucChanIntervalTable = MibTable((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 12))
if mibBuilder.loadTexts: adslAtucChanIntervalTable.setDescription("This table provides one row for each ATUC channel's\nperformance data collection interval.\nADSL channel interfaces are those ifEntries\nwhere ifType is equal to adslInterleave(124)\nor adslFast(125).")
adslAtucChanIntervalEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 12, 1)).setIndexNames((0, "IF-MIB", "ifIndex"), (0, "ADSL-LINE-MIB", "adslAtucChanIntervalNumber"))
if mibBuilder.loadTexts: adslAtucChanIntervalEntry.setDescription("An entry in the adslAtucIntervalTable.")
adslAtucChanIntervalNumber = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 12, 1, 1), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1, 96))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: adslAtucChanIntervalNumber.setDescription("Performance Data Interval number 1 is the\nthe most recent previous interval; interval\n96 is 24 hours ago.  Intervals 2..96 are\noptional.")
adslAtucChanIntervalReceivedBlks = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 12, 1, 2), PerfIntervalCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAtucChanIntervalReceivedBlks.setDescription("Count of all encoded blocks received on this channel\nduring this interval.")
adslAtucChanIntervalTransmittedBlks = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 12, 1, 3), PerfIntervalCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAtucChanIntervalTransmittedBlks.setDescription("Count of all encoded blocks transmitted on this\nchannel during this interval.")
adslAtucChanIntervalCorrectedBlks = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 12, 1, 4), PerfIntervalCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAtucChanIntervalCorrectedBlks.setDescription("Count of all blocks received with errors that were\ncorrected on this channel during this interval.")
adslAtucChanIntervalUncorrectBlks = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 12, 1, 5), PerfIntervalCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAtucChanIntervalUncorrectBlks.setDescription("Count of all blocks received with uncorrectable\nerrors on this channel during this interval.")
adslAtucChanIntervalValidData = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 12, 1, 6), TruthValue()).setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAtucChanIntervalValidData.setDescription("This variable indicates if the data for this\ninterval is valid.")
adslAturChanIntervalTable = MibTable((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 13))
if mibBuilder.loadTexts: adslAturChanIntervalTable.setDescription("This table provides one row for each ATUR channel's\nperformance data collection interval.\nADSL channel interfaces are those ifEntries\nwhere ifType is equal to adslInterleave(124)\nor adslFast(125).")
adslAturChanIntervalEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 13, 1)).setIndexNames((0, "IF-MIB", "ifIndex"), (0, "ADSL-LINE-MIB", "adslAturChanIntervalNumber"))
if mibBuilder.loadTexts: adslAturChanIntervalEntry.setDescription("An entry in the adslAturIntervalTable.")
adslAturChanIntervalNumber = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 13, 1, 1), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1, 96))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: adslAturChanIntervalNumber.setDescription("Performance Data Interval number 1 is the\nthe most recent previous interval; interval\n96 is 24 hours ago.  Intervals 2..96 are\noptional.")
adslAturChanIntervalReceivedBlks = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 13, 1, 2), PerfIntervalCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAturChanIntervalReceivedBlks.setDescription("Count of all encoded blocks received on this channel\nduring this interval.")
adslAturChanIntervalTransmittedBlks = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 13, 1, 3), PerfIntervalCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAturChanIntervalTransmittedBlks.setDescription("Count of all encoded blocks transmitted on this\nchannel during this interval.")
adslAturChanIntervalCorrectedBlks = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 13, 1, 4), PerfIntervalCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAturChanIntervalCorrectedBlks.setDescription("Count of all blocks received with errors that were\ncorrected on this channel during this interval.")
adslAturChanIntervalUncorrectBlks = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 13, 1, 5), PerfIntervalCount()).setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAturChanIntervalUncorrectBlks.setDescription("Count of all blocks received with uncorrectable\nerrors on this channel during this interval.")
adslAturChanIntervalValidData = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 13, 1, 6), TruthValue()).setMaxAccess("readonly")
if mibBuilder.loadTexts: adslAturChanIntervalValidData.setDescription("This variable indicates if the data for this\ninterval is valid.")
adslLineConfProfileTable = MibTable((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 14))
if mibBuilder.loadTexts: adslLineConfProfileTable.setDescription("This table contains information on the ADSL line\nconfiguration.  One entry in this table reflects a\nprofile defined by a manager which can be used to\nconfigure the ADSL line.")
adslLineConfProfileEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 14, 1)).setIndexNames((1, "ADSL-LINE-MIB", "adslLineConfProfileName"))
if mibBuilder.loadTexts: adslLineConfProfileEntry.setDescription("Each entry consists of a list of parameters that\nrepresents the configuration of an ADSL modem.\n\nWhen `dynamic' profiles are implemented, a default\nprofile will always exist.  This profile's name will\nbe set to `DEFVAL' and its parameters will be set\nto vendor specific values, unless otherwise specified\nin this document.\n\nWhen `static' profiles are implemented, profiles\nare automaticly created or destroyed as ADSL\nphysical lines are discovered and removed by\nthe system.  The name of the profile will be\nequivalent to the decimal value of the line's\ninterface index.")
adslLineConfProfileName = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 14, 1, 1), SnmpAdminString().subtype(subtypeSpec=ValueSizeConstraint(1, 32))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: adslLineConfProfileName.setDescription("This object is used by the line configuration table\nin order to identify a row of this table.\n\nWhen `dynamic' profiles are implemented, the profile\nname is user specified.  Also, the system will always\nprovide a default profile whose name is `DEFVAL'.\n\nWhen `static' profiles are implemented, there is an\none-to-one relationship between each line and its\nprofile.  In which case, the profile name will\nneed to algorithmicly represent the Line's ifIndex.\nTherefore, the profile's name is a decimalized string\nof the ifIndex that is fixed-length (i.e., 10) with\nleading zero(s).  For example, the profile name for\nifIndex which equals '15' will be '0000000015'.")
adslAtucConfRateMode = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 14, 1, 2), Integer().subtype(subtypeSpec=SingleValueConstraint(2,1,3,)).subtype(namedValues=NamedValues(("fixed", 1), ("adaptAtStartup", 2), ("adaptAtRuntime", 3), ))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: adslAtucConfRateMode.setDescription("Defines what form of transmit rate adaptation is\nconfigured on this modem.  See ADSL Forum TR-005 [3]\nfor more information.")
adslAtucConfRateChanRatio = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 14, 1, 3), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 100))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: adslAtucConfRateChanRatio.setDescription("Configured allocation ratio of excess transmit\nbandwidth between fast and interleaved channels.  Only\napplies when two channel mode and RADSL are supported.\nDistribute bandwidth on each channel in excess of the\ncorresponding ChanConfMinTxRate so that:\nadslAtucConfRateChanRatio =\n\n        [Fast / (Fast + Interleaved)] * 100\n\nIn other words this value is the fast channel\npercentage.")
adslAtucConfTargetSnrMgn = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 14, 1, 4), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 310))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: adslAtucConfTargetSnrMgn.setDescription("Configured Target Signal/Noise Margin.\nThis is the Noise Margin the modem must achieve\nwith a BER of 10-7 or better to successfully complete\ninitialization.")
adslAtucConfMaxSnrMgn = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 14, 1, 5), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 310))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: adslAtucConfMaxSnrMgn.setDescription("Configured Maximum acceptable Signal/Noise Margin.\nIf the Noise Margin is above this the modem should\nattempt to reduce its power output to optimize its\noperation.")
adslAtucConfMinSnrMgn = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 14, 1, 6), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 310))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: adslAtucConfMinSnrMgn.setDescription("Configured Minimum acceptable Signal/Noise Margin.\nIf the noise margin falls below this level, the modem\nshould attempt to increase its power output.  If that\nis not possible the modem will attempt to\nre-initialize or shut down.")
adslAtucConfDownshiftSnrMgn = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 14, 1, 7), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 310))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: adslAtucConfDownshiftSnrMgn.setDescription("Configured Signal/Noise Margin for rate downshift.\nIf the noise margin falls below this level, the modem\nshould attempt to decrease its transmit rate.  In\nthe case that RADSL mode is not present,\nthe value will be `0'.")
adslAtucConfUpshiftSnrMgn = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 14, 1, 8), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 310))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: adslAtucConfUpshiftSnrMgn.setDescription("Configured Signal/Noise Margin for rate upshift.\nIf the noise margin rises above this level, the modem\nshould attempt to increase its transmit rate.    In\nthe case that RADSL is not present, the value will\nbe `0'.")
adslAtucConfMinUpshiftTime = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 14, 1, 9), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 16383))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: adslAtucConfMinUpshiftTime.setDescription("Minimum time that the current margin is above\nUpshiftSnrMgn before an upshift occurs.\nIn the case that RADSL is not present, the value will\nbe `0'.")
adslAtucConfMinDownshiftTime = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 14, 1, 10), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 16383))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: adslAtucConfMinDownshiftTime.setDescription("Minimum time that the current margin is below\nDownshiftSnrMgn before a downshift occurs.\nIn the case that RADSL mode is not present,\nthe value will be `0'.")
adslAtucChanConfFastMinTxRate = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 14, 1, 11), Unsigned32()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: adslAtucChanConfFastMinTxRate.setDescription("Configured Minimum Transmit rate for `Fast' channels,\nin bps.  See adslAtucConfRateChanRatio for information\nregarding RADSL mode and ATUR transmit rate for\nATUC receive rates.")
adslAtucChanConfInterleaveMinTxRate = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 14, 1, 12), Unsigned32()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: adslAtucChanConfInterleaveMinTxRate.setDescription("Configured Minimum Transmit rate for `Interleave'\nchannels, in bps.  See adslAtucConfRateChanRatio for\ninformation regarding RADSL mode and see\nATUR transmit rate for receive rates.")
adslAtucChanConfFastMaxTxRate = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 14, 1, 13), Unsigned32()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: adslAtucChanConfFastMaxTxRate.setDescription("Configured Maximum Transmit rate for `Fast' channels,\nin bps.  See adslAtucConfRateChanRatio for information\nregarding RADSL mode and see ATUR transmit rate for\nATUC receive rates.")
adslAtucChanConfInterleaveMaxTxRate = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 14, 1, 14), Unsigned32()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: adslAtucChanConfInterleaveMaxTxRate.setDescription("Configured Maximum Transmit rate for `Interleave'\nchannels, in bps.  See adslAtucConfRateChanRatio for\ninformation regarding RADSL mode and ATUR transmit\nrate for ATUC receive rates.")
adslAtucChanConfMaxInterleaveDelay = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 14, 1, 15), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 255))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: adslAtucChanConfMaxInterleaveDelay.setDescription("Configured maximum Interleave Delay for this channel.\n\nInterleave delay applies only to the interleave channel\nand defines the mapping (relative spacing) between\nsubsequent input bytes at the interleaver input and\ntheir placement in the bit stream at the interleaver\noutput.  Larger numbers provide greater separation\nbetween consecutive input bytes in the output bit\nstream allowing for improved impulse noise immunity\nat the expense of payload latency.")
adslAturConfRateMode = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 14, 1, 16), Integer().subtype(subtypeSpec=SingleValueConstraint(2,1,3,)).subtype(namedValues=NamedValues(("fixed", 1), ("adaptAtStartup", 2), ("adaptAtRuntime", 3), ))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: adslAturConfRateMode.setDescription("Defines what form of transmit rate adaptation is\nconfigured on this modem.  See ADSL Forum TR-005 [3]\nfor more information.")
adslAturConfRateChanRatio = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 14, 1, 17), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 100))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: adslAturConfRateChanRatio.setDescription("Configured allocation ratio of excess transmit\nbandwidth between fast and interleaved channels.  Only\napplies when two channel mode and RADSL are supported.\nDistribute bandwidth on each channel in excess of the\ncorresponding ChanConfMinTxRate so that:\nadslAturConfRateChanRatio =\n\n        [Fast / (Fast + Interleaved)] * 100\n\nIn other words this value is the fast channel\npercentage.")
adslAturConfTargetSnrMgn = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 14, 1, 18), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 310))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: adslAturConfTargetSnrMgn.setDescription("Configured Target Signal/Noise Margin.\nThis is the Noise Margin the modem must achieve\nwith a BER of 10-7 or better to successfully complete\ninitialization.")
adslAturConfMaxSnrMgn = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 14, 1, 19), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 310))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: adslAturConfMaxSnrMgn.setDescription("Configured Maximum acceptable Signal/Noise Margin.\nIf the Noise Margin is above this the modem should\nattempt to reduce its power output to optimize its\noperation.")
adslAturConfMinSnrMgn = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 14, 1, 20), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 310))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: adslAturConfMinSnrMgn.setDescription("Configured Minimum acceptable Signal/Noise Margin.\nIf the noise margin falls below this level, the modem\nshould attempt to increase its power output.  If that\nis not possible the modem will attempt to\nre-initialize or shut down.")
adslAturConfDownshiftSnrMgn = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 14, 1, 21), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 310))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: adslAturConfDownshiftSnrMgn.setDescription("Configured Signal/Noise Margin for rate downshift.\nIf the noise margin falls below this level, the modem\nshould attempt to decrease its transmit rate.\nIn the case that RADSL mode is not present,\nthe value will be `0'.")
adslAturConfUpshiftSnrMgn = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 14, 1, 22), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 310))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: adslAturConfUpshiftSnrMgn.setDescription("Configured Signal/Noise Margin for rate upshift.\nIf the noise margin rises above this level, the modem\nshould attempt to increase its transmit rate.\nIn the case that RADSL is not present,\nthe value will be `0'.")
adslAturConfMinUpshiftTime = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 14, 1, 23), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 16383))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: adslAturConfMinUpshiftTime.setDescription("Minimum time that the current margin is above\nUpshiftSnrMgn before an upshift occurs.\nIn the case that RADSL is not present, the value will\nbe `0'.")
adslAturConfMinDownshiftTime = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 14, 1, 24), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 16383))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: adslAturConfMinDownshiftTime.setDescription("Minimum time that the current margin is below\nDownshiftSnrMgn before a downshift occurs.\nIn the case that RADSL mode is not present,\nthe value will be `0'.")
adslAturChanConfFastMinTxRate = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 14, 1, 25), Unsigned32()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: adslAturChanConfFastMinTxRate.setDescription("Configured Minimum Transmit rate for `Fast' channels,\nin bps.  See adslAturConfRateChanRatio for information\nregarding RADSL mode and ATUC transmit rate\nfor ATUR receive rates.")
adslAturChanConfInterleaveMinTxRate = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 14, 1, 26), Unsigned32()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: adslAturChanConfInterleaveMinTxRate.setDescription("Configured Minimum Transmit rate for `Interleave'\nchannels, in bps.  See adslAturConfRateChanRatio for\ninformation regarding RADSL mode and ATUC transmit rate\nfor ATUR receive rates.")
adslAturChanConfFastMaxTxRate = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 14, 1, 27), Unsigned32()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: adslAturChanConfFastMaxTxRate.setDescription("Configured Maximum Transmit rate for `Fast' channels,\nin bps.  See adslAturConfRateChanRatio for information\nregarding RADSL mode and ATUC transmit rate\nfor ATUR receive rates.")
adslAturChanConfInterleaveMaxTxRate = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 14, 1, 28), Unsigned32()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: adslAturChanConfInterleaveMaxTxRate.setDescription("Configured Maximum Transmit rate for `Interleave'\nchannels, in bps.  See adslAturConfRateChanRatio for\ninformation regarding RADSL mode and see\nATUC transmit rate for ATUR receive rates.")
adslAturChanConfMaxInterleaveDelay = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 14, 1, 29), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 255))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: adslAturChanConfMaxInterleaveDelay.setDescription("Configured maximum Interleave Delay for this channel.\n\nInterleave delay applies only to the interleave channel\nand defines the mapping (relative spacing) between\nsubsequent input bytes at the interleaver input and\ntheir placement in the bit stream at the interleaver\noutput.  Larger numbers provide greater separation\nbetween consecutive input bytes in the output bit\nstream allowing for improved impulse noise immunity\nat the expense of payload latency.")
adslLineConfProfileRowStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 14, 1, 30), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: adslLineConfProfileRowStatus.setDescription("This object is used to create a new row or modify or\ndelete an existing row in this table.\nA profile activated by setting this object to\n`active'.  When `active' is set, the system\nwill validate the profile.\n\nBefore a profile can be deleted or taken out of\nservice, (by setting this object to `destroy' or\n`outOfService') it must be first unreferenced\nfrom all associated lines.\n\nIf the implementator of this MIB has chosen not\nto implement `dynamic assignment' of profiles, this\nobject's MIN-ACCESS is read-only and its value\nis always to be `active'.")
adslLineAlarmConfProfileTable = MibTable((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 15))
if mibBuilder.loadTexts: adslLineAlarmConfProfileTable.setDescription("This table contains information on the ADSL line\nconfiguration.  One entry in this table reflects a\nprofile defined by a manager which can be used to\nconfigure the modem for a physical line")
adslLineAlarmConfProfileEntry = MibTableRow((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 15, 1)).setIndexNames((1, "ADSL-LINE-MIB", "adslLineAlarmConfProfileName"))
if mibBuilder.loadTexts: adslLineAlarmConfProfileEntry.setDescription("Each entry consists of a list of parameters that\nrepresents the configuration of an ADSL modem.\n\nWhen `dynamic' profiles are implemented, a default\nprofile will always exist.  This profile's name will\nbe set to `DEFVAL' and its parameters will be set to\nvendor specific values, unless otherwise specified\nin this document.\n\nWhen `static' profiles are implemented, profiles\nare automaticly created or destroyed as ADSL\nphysical lines are discovered and removed by\nthe system.  The name of the profile will be\nequivalent to the decimal value of the line's\ninterface index.")
adslLineAlarmConfProfileName = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 15, 1, 1), SnmpAdminString().subtype(subtypeSpec=ValueSizeConstraint(1, 32))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: adslLineAlarmConfProfileName.setDescription("This object is used by the line alarm configuration\ntable in order to identify a row of this table.\n\nWhen `dynamic' profiles are implemented, the profile\nname is user specified.  Also, the system will always\nprovide a default profile whose name is `DEFVAL'.\n\nWhen `static' profiles are implemented, there is an\none-to-one relationship between each line and its\nprofile.  In which case, the profile name will\nneed to algorithmicly represent the Line's ifIndex.\nTherefore, the profile's name is a decimalized string\nof the ifIndex that is fixed-length (i.e., 10) with\nleading zero(s).  For example, the profile name for\nifIndex which equals '15' will be '0000000015'.")
adslAtucThresh15MinLofs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 15, 1, 2), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 900))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: adslAtucThresh15MinLofs.setDescription("The number of Loss of Frame Seconds\nencountered by an ADSL interface within any given 15\nminutes performance data collection period, which\ncauses the SNMP agent to send an\nadslAtucPerfLofsThreshTrap.\nOne trap will be sent per interval per interface.\nA value of `0' will disable the trap.")
adslAtucThresh15MinLoss = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 15, 1, 3), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 900))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: adslAtucThresh15MinLoss.setDescription("The number of Loss of Signal Seconds\nencountered by an ADSL interface within any given 15\nminutes performance data collection period, which\ncauses the SNMP agent to send an\nadslAtucPerfLossThreshTrap.\nOne trap will be sent per interval per interface.\nA value of `0' will disable the trap.")
adslAtucThresh15MinLols = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 15, 1, 4), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 900))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: adslAtucThresh15MinLols.setDescription("The number of Loss of Link Seconds\nencountered by an ADSL interface within any given 15\nminutes performance data collection period, which\ncauses the SNMP agent to send an\nadslAtucPerfLolsThreshTrap.\nOne trap will be sent per interval per interface.\nA value of `0' will disable the trap.")
adslAtucThresh15MinLprs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 15, 1, 5), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 900))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: adslAtucThresh15MinLprs.setDescription("The number of Loss of Power Seconds\nencountered by an ADSL interface within any given 15\nminutes performance data collection period, which\ncauses the SNMP agent to send an\nadslAtucPerfLprsThreshTrap.\nOne trap will be sent per interval per interface.\nA value of `0' will disable the trap.")
adslAtucThresh15MinESs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 15, 1, 6), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 900))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: adslAtucThresh15MinESs.setDescription("The number of Errored Seconds\nencountered by an ADSL interface within any given 15\nminutes performance data collection period, which\ncauses the SNMP agent to send an\nadslAtucPerfESsThreshTrap.\nOne trap will be sent per interval per interface.\nA value of `0' will disable the trap.")
adslAtucThreshFastRateUp = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 15, 1, 7), Unsigned32()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: adslAtucThreshFastRateUp.setDescription("Applies to `Fast' channels only.\nConfigured change in rate causing an\nadslAtucRateChangeTrap. A trap is produced when:\nChanCurrTxRate >= ChanPrevTxRate plus the value of\nthis object. A value of `0' will disable the trap.")
adslAtucThreshInterleaveRateUp = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 15, 1, 8), Unsigned32()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: adslAtucThreshInterleaveRateUp.setDescription("Applies to `Interleave' channels only.\nConfigured change in rate causing an\nadslAtucRateChangeTrap.  A trap is produced when:\nChanCurrTxRate >= ChanPrevTxRate plus the value of\nthis object. A value of `0' will disable the trap.")
adslAtucThreshFastRateDown = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 15, 1, 9), Unsigned32()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: adslAtucThreshFastRateDown.setDescription("Applies to `Fast' channels only.\nConfigured change in rate causing an\nadslAtucRateChangeTrap.  A trap is produced when:\nChanCurrTxRate <= ChanPrevTxRate minus the value of\nthis object. A value of `0' will disable the trap.")
adslAtucThreshInterleaveRateDown = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 15, 1, 10), Unsigned32()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: adslAtucThreshInterleaveRateDown.setDescription("Applies to `Interleave' channels only.\nConfigured change in rate causing an\nadslAtucRateChangeTrap.  A trap is produced when:\nChanCurrTxRate <= ChanPrevTxRate minus the value of\nthis object. A value of `0' will disable the trap.")
adslAtucInitFailureTrapEnable = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 15, 1, 11), Integer().subtype(subtypeSpec=SingleValueConstraint(1,2,)).subtype(namedValues=NamedValues(("enable", 1), ("disable", 2), )).clone(2)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: adslAtucInitFailureTrapEnable.setDescription("Enables and disables the InitFailureTrap.  This\nobject is defaulted disable(2).")
adslAturThresh15MinLofs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 15, 1, 12), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 900))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: adslAturThresh15MinLofs.setDescription("The number of Loss of Frame Seconds\nencountered by an ADSL interface within any given 15\nminutes performance data collection period, which\ncauses the SNMP agent to send an\nadslAturPerfLofsThreshTrap.\nOne trap will be sent per interval per interface.\nA value of `0' will disable the trap.")
adslAturThresh15MinLoss = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 15, 1, 13), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 900))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: adslAturThresh15MinLoss.setDescription("The number of Loss of Signal Seconds\nencountered by an ADSL interface within any given 15\nminutes performance data collection period, which\ncauses the SNMP agent to send an\nadslAturPerfLossThreshTrap.\nOne trap will be sent per interval per interface.\nA value of `0' will disable the trap.")
adslAturThresh15MinLprs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 15, 1, 14), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 900))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: adslAturThresh15MinLprs.setDescription("The number of Loss of Power Seconds\nencountered by an ADSL interface within any given 15\nminutes performance data collection period, which\ncauses the SNMP agent to send an\nadslAturPerfLprsThreshTrap.\nOne trap will be sent per interval per interface.\nA value of `0' will disable the trap.")
adslAturThresh15MinESs = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 15, 1, 15), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 900))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: adslAturThresh15MinESs.setDescription("The number of Errored Seconds\nencountered by an ADSL interface within any given 15\nminutes performance data collection period, which\ncauses the SNMP agent to send an\nadslAturPerfESsThreshTrap.\nOne trap will be sent per interval per interface.\nA value of `0' will disable the trap.")
adslAturThreshFastRateUp = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 15, 1, 16), Unsigned32()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: adslAturThreshFastRateUp.setDescription("Applies to `Fast' channels only.\nConfigured change in rate causing an\nadslAturRateChangeTrap.  A trap is produced when:\nChanCurrTxRate >= ChanPrevTxRate plus the value of\nthis object. A value of `0' will disable the trap.")
adslAturThreshInterleaveRateUp = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 15, 1, 17), Unsigned32()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: adslAturThreshInterleaveRateUp.setDescription("Applies to `Interleave' channels only.\nconfigured change in rate causing an\nadslAturRateChangeTrap.  A trap is produced when:\nChanCurrTxRate >= ChanPrevTxRate plus the value of\nthis object. A value of `0' will disable the trap.")
adslAturThreshFastRateDown = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 15, 1, 18), Unsigned32()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: adslAturThreshFastRateDown.setDescription("Applies to `Fast' channels only.\nConfigured change in rate causing an\nadslAturRateChangeTrap.  A trap is produced when:\nChanCurrTxRate <= ChanPrevTxRate minus the value of\nthis object. A value of `0' will disable the trap.")
adslAturThreshInterleaveRateDown = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 15, 1, 19), Unsigned32()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: adslAturThreshInterleaveRateDown.setDescription("Applies to `Interleave' channels only.\nConfigured change in rate causing an\nadslAturRateChangeTrap.  A trap is produced when:\nChanCurrTxRate <= ChanPrevTxRate minus the value of\nthis object. A value of `0' will disable the trap.")
adslLineAlarmConfProfileRowStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 15, 1, 20), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: adslLineAlarmConfProfileRowStatus.setDescription("This object is used to create a new row or modify or\ndelete an existing row in this table.\n\nA profile activated by setting this object to\n`active'.  When `active' is set, the system\nwill validate the profile.\n\nBefore a profile can be deleted or taken out of\nservice, (by setting this object to `destroy' or\n`outOfService') it must be first unreferenced\nfrom all associated lines.\n\nIf the implementator of this MIB has chosen not\nto implement `dynamic assignment' of profiles, this\nobject's MIN-ACCESS is read-only and its value\nis always to be `active'.")
adslLCSMib = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 94, 1, 1, 16))
adslTraps = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 94, 1, 2))
adslAtucTraps = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 94, 1, 2, 1))
adslAturTraps = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 94, 1, 2, 2))
adslConformance = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 94, 1, 3))
adslGroups = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 94, 1, 3, 1))
adslCompliances = MibIdentifier((1, 3, 6, 1, 2, 1, 10, 94, 1, 3, 2))

# Augmentions

# Notifications

adslAtucPerfLofsThreshTrap = NotificationType((1, 3, 6, 1, 2, 1, 10, 94, 1, 2, 1, 0, 1)).setObjects(*(("ADSL-LINE-MIB", "adslAtucPerfCurr15MinLofs"), ("ADSL-LINE-MIB", "adslAtucThresh15MinLofs"), ) )
if mibBuilder.loadTexts: adslAtucPerfLofsThreshTrap.setDescription("Loss of Framing 15-minute interval threshold reached.")
adslAtucPerfLossThreshTrap = NotificationType((1, 3, 6, 1, 2, 1, 10, 94, 1, 2, 1, 0, 2)).setObjects(*(("ADSL-LINE-MIB", "adslAtucPerfCurr15MinLoss"), ("ADSL-LINE-MIB", "adslAtucThresh15MinLoss"), ) )
if mibBuilder.loadTexts: adslAtucPerfLossThreshTrap.setDescription("Loss of Signal 15-minute interval threshold reached.")
adslAtucPerfLprsThreshTrap = NotificationType((1, 3, 6, 1, 2, 1, 10, 94, 1, 2, 1, 0, 3)).setObjects(*(("ADSL-LINE-MIB", "adslAtucThresh15MinLprs"), ("ADSL-LINE-MIB", "adslAtucPerfCurr15MinLprs"), ) )
if mibBuilder.loadTexts: adslAtucPerfLprsThreshTrap.setDescription("Loss of Power 15-minute interval threshold reached.")
adslAtucPerfESsThreshTrap = NotificationType((1, 3, 6, 1, 2, 1, 10, 94, 1, 2, 1, 0, 4)).setObjects(*(("ADSL-LINE-MIB", "adslAtucThresh15MinESs"), ("ADSL-LINE-MIB", "adslAtucPerfCurr15MinESs"), ) )
if mibBuilder.loadTexts: adslAtucPerfESsThreshTrap.setDescription("Errored Second 15-minute interval threshold reached.")
adslAtucRateChangeTrap = NotificationType((1, 3, 6, 1, 2, 1, 10, 94, 1, 2, 1, 0, 5)).setObjects(*(("ADSL-LINE-MIB", "adslAtucChanCurrTxRate"), ("ADSL-LINE-MIB", "adslAtucChanPrevTxRate"), ) )
if mibBuilder.loadTexts: adslAtucRateChangeTrap.setDescription("The ATUCs transmit rate has changed (RADSL mode only)")
adslAtucPerfLolsThreshTrap = NotificationType((1, 3, 6, 1, 2, 1, 10, 94, 1, 2, 1, 0, 6)).setObjects(*(("ADSL-LINE-MIB", "adslAtucThresh15MinLols"), ("ADSL-LINE-MIB", "adslAtucPerfCurr15MinLols"), ) )
if mibBuilder.loadTexts: adslAtucPerfLolsThreshTrap.setDescription("Loss of Link 15-minute interval threshold reached.")
adslAtucInitFailureTrap = NotificationType((1, 3, 6, 1, 2, 1, 10, 94, 1, 2, 1, 0, 7)).setObjects(*(("ADSL-LINE-MIB", "adslAtucCurrStatus"), ) )
if mibBuilder.loadTexts: adslAtucInitFailureTrap.setDescription("ATUC initialization failed. See adslAtucCurrStatus\nfor potential reasons.")
adslAturPerfLofsThreshTrap = NotificationType((1, 3, 6, 1, 2, 1, 10, 94, 1, 2, 2, 0, 1)).setObjects(*(("ADSL-LINE-MIB", "adslAturThresh15MinLofs"), ("ADSL-LINE-MIB", "adslAturPerfCurr15MinLofs"), ) )
if mibBuilder.loadTexts: adslAturPerfLofsThreshTrap.setDescription("Loss of Framing 15-minute interval threshold reached.")
adslAturPerfLossThreshTrap = NotificationType((1, 3, 6, 1, 2, 1, 10, 94, 1, 2, 2, 0, 2)).setObjects(*(("ADSL-LINE-MIB", "adslAturThresh15MinLoss"), ("ADSL-LINE-MIB", "adslAturPerfCurr15MinLoss"), ) )
if mibBuilder.loadTexts: adslAturPerfLossThreshTrap.setDescription("Loss of Signal 15-minute interval threshold reached.")
adslAturPerfLprsThreshTrap = NotificationType((1, 3, 6, 1, 2, 1, 10, 94, 1, 2, 2, 0, 3)).setObjects(*(("ADSL-LINE-MIB", "adslAturPerfCurr15MinLprs"), ("ADSL-LINE-MIB", "adslAturThresh15MinLprs"), ) )
if mibBuilder.loadTexts: adslAturPerfLprsThreshTrap.setDescription("Loss of Power 15-minute interval threshold reached.")
adslAturPerfESsThreshTrap = NotificationType((1, 3, 6, 1, 2, 1, 10, 94, 1, 2, 2, 0, 4)).setObjects(*(("ADSL-LINE-MIB", "adslAturPerfCurr15MinESs"), ("ADSL-LINE-MIB", "adslAturThresh15MinESs"), ) )
if mibBuilder.loadTexts: adslAturPerfESsThreshTrap.setDescription("Errored Second 15-minute interval threshold reached.")
adslAturRateChangeTrap = NotificationType((1, 3, 6, 1, 2, 1, 10, 94, 1, 2, 2, 0, 5)).setObjects(*(("ADSL-LINE-MIB", "adslAturChanCurrTxRate"), ("ADSL-LINE-MIB", "adslAturChanPrevTxRate"), ) )
if mibBuilder.loadTexts: adslAturRateChangeTrap.setDescription("The ATURs transmit rate has changed (RADSL mode only)")

# Groups

adslLineGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 10, 94, 1, 3, 1, 1)).setObjects(*(("ADSL-LINE-MIB", "adslLineSpecific"), ("ADSL-LINE-MIB", "adslLineType"), ("ADSL-LINE-MIB", "adslLineCoding"), ) )
if mibBuilder.loadTexts: adslLineGroup.setDescription("A collection of objects providing configuration\ninformation about an ADSL Line.")
adslPhysicalGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 10, 94, 1, 3, 1, 2)).setObjects(*(("ADSL-LINE-MIB", "adslAturCurrStatus"), ("ADSL-LINE-MIB", "adslAtucCurrAttainableRate"), ("ADSL-LINE-MIB", "adslAturInvVersionNumber"), ("ADSL-LINE-MIB", "adslAturCurrSnrMgn"), ("ADSL-LINE-MIB", "adslAturCurrAtn"), ("ADSL-LINE-MIB", "adslAturCurrOutputPwr"), ("ADSL-LINE-MIB", "adslAtucInvVersionNumber"), ("ADSL-LINE-MIB", "adslAturCurrAttainableRate"), ("ADSL-LINE-MIB", "adslAtucCurrOutputPwr"), ("ADSL-LINE-MIB", "adslAtucInvSerialNumber"), ("ADSL-LINE-MIB", "adslAtucInvVendorID"), ("ADSL-LINE-MIB", "adslAturInvSerialNumber"), ("ADSL-LINE-MIB", "adslAturInvVendorID"), ("ADSL-LINE-MIB", "adslAtucCurrSnrMgn"), ("ADSL-LINE-MIB", "adslAtucCurrStatus"), ("ADSL-LINE-MIB", "adslAtucCurrAtn"), ) )
if mibBuilder.loadTexts: adslPhysicalGroup.setDescription("A collection of objects providing physical\nconfiguration information of the ADSL Line.")
adslChannelGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 10, 94, 1, 3, 1, 3)).setObjects(*(("ADSL-LINE-MIB", "adslAturChanCurrTxRate"), ("ADSL-LINE-MIB", "adslAturChanPrevTxRate"), ("ADSL-LINE-MIB", "adslAtucChanCurrTxRate"), ("ADSL-LINE-MIB", "adslAtucChanCrcBlockLength"), ("ADSL-LINE-MIB", "adslAturChanCrcBlockLength"), ("ADSL-LINE-MIB", "adslAtucChanInterleaveDelay"), ("ADSL-LINE-MIB", "adslAturChanInterleaveDelay"), ("ADSL-LINE-MIB", "adslAtucChanPrevTxRate"), ) )
if mibBuilder.loadTexts: adslChannelGroup.setDescription("A collection of objects providing configuration\ninformation about an ADSL channel.")
adslAtucPhysPerfRawCounterGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 10, 94, 1, 3, 1, 4)).setObjects(*(("ADSL-LINE-MIB", "adslAtucPerfLoss"), ("ADSL-LINE-MIB", "adslAtucPerfLofs"), ("ADSL-LINE-MIB", "adslAtucPerfInits"), ("ADSL-LINE-MIB", "adslAtucPerfLols"), ("ADSL-LINE-MIB", "adslAtucPerfESs"), ("ADSL-LINE-MIB", "adslAtucPerfLprs"), ) )
if mibBuilder.loadTexts: adslAtucPhysPerfRawCounterGroup.setDescription("A collection of objects providing raw performance\ncounts on an ADSL Line (ATU-C end).")
adslAtucPhysPerfIntervalGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 10, 94, 1, 3, 1, 5)).setObjects(*(("ADSL-LINE-MIB", "adslAtucPerfPrev1DayLoss"), ("ADSL-LINE-MIB", "adslAtucIntervalLoss"), ("ADSL-LINE-MIB", "adslAtucPerfCurr1DayLoss"), ("ADSL-LINE-MIB", "adslAtucPerfCurr15MinTimeElapsed"), ("ADSL-LINE-MIB", "adslAtucPerfValidIntervals"), ("ADSL-LINE-MIB", "adslAtucIntervalLprs"), ("ADSL-LINE-MIB", "adslAtucPerfCurr1DayLols"), ("ADSL-LINE-MIB", "adslAtucPerfPrev1DayMoniSecs"), ("ADSL-LINE-MIB", "adslAtucIntervalLols"), ("ADSL-LINE-MIB", "adslAtucIntervalInits"), ("ADSL-LINE-MIB", "adslAtucPerfPrev1DayLols"), ("ADSL-LINE-MIB", "adslAtucPerfCurr15MinESs"), ("ADSL-LINE-MIB", "adslAtucIntervalValidData"), ("ADSL-LINE-MIB", "adslAtucPerfCurr1DayLofs"), ("ADSL-LINE-MIB", "adslAtucIntervalLofs"), ("ADSL-LINE-MIB", "adslAtucPerfCurr1DayLprs"), ("ADSL-LINE-MIB", "adslAtucPerfCurr15MinLprs"), ("ADSL-LINE-MIB", "adslAtucPerfCurr15MinLoss"), ("ADSL-LINE-MIB", "adslAtucPerfPrev1DayLprs"), ("ADSL-LINE-MIB", "adslAtucPerfPrev1DayInits"), ("ADSL-LINE-MIB", "adslAtucPerfCurr1DayInits"), ("ADSL-LINE-MIB", "adslAtucPerfCurr15MinInits"), ("ADSL-LINE-MIB", "adslAtucPerfCurr15MinLols"), ("ADSL-LINE-MIB", "adslAtucPerfPrev1DayESs"), ("ADSL-LINE-MIB", "adslAtucPerfCurr1DayESs"), ("ADSL-LINE-MIB", "adslAtucPerfPrev1DayLofs"), ("ADSL-LINE-MIB", "adslAtucIntervalESs"), ("ADSL-LINE-MIB", "adslAtucPerfCurr15MinLofs"), ("ADSL-LINE-MIB", "adslAtucPerfInvalidIntervals"), ) )
if mibBuilder.loadTexts: adslAtucPhysPerfIntervalGroup.setDescription("A collection of objects providing current 15-minute,\n1-day; and previous 1-day performance counts on\nADSL Line (ATU-C end) .")
adslAturPhysPerfRawCounterGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 10, 94, 1, 3, 1, 6)).setObjects(*(("ADSL-LINE-MIB", "adslAturPerfLoss"), ("ADSL-LINE-MIB", "adslAturPerfLprs"), ("ADSL-LINE-MIB", "adslAturPerfESs"), ("ADSL-LINE-MIB", "adslAturPerfLofs"), ) )
if mibBuilder.loadTexts: adslAturPhysPerfRawCounterGroup.setDescription("A collection of objects providing raw performance\ncounts on an ADSL Line (ATU-R end).")
adslAturPhysPerfIntervalGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 10, 94, 1, 3, 1, 7)).setObjects(*(("ADSL-LINE-MIB", "adslAturPerfCurr1DayLoss"), ("ADSL-LINE-MIB", "adslAturPerfPrev1DayLoss"), ("ADSL-LINE-MIB", "adslAturIntervalValidData"), ("ADSL-LINE-MIB", "adslAturPerfPrev1DayMoniSecs"), ("ADSL-LINE-MIB", "adslAturPerfPrev1DayESs"), ("ADSL-LINE-MIB", "adslAturIntervalESs"), ("ADSL-LINE-MIB", "adslAturPerfCurr1DayLprs"), ("ADSL-LINE-MIB", "adslAturIntervalLoss"), ("ADSL-LINE-MIB", "adslAturPerfCurr15MinLoss"), ("ADSL-LINE-MIB", "adslAturPerfPrev1DayLofs"), ("ADSL-LINE-MIB", "adslAturPerfCurr1DayLofs"), ("ADSL-LINE-MIB", "adslAturPerfCurr15MinLofs"), ("ADSL-LINE-MIB", "adslAturPerfInvalidIntervals"), ("ADSL-LINE-MIB", "adslAturIntervalLofs"), ("ADSL-LINE-MIB", "adslAturPerfCurr1DayESs"), ("ADSL-LINE-MIB", "adslAturPerfCurr15MinLprs"), ("ADSL-LINE-MIB", "adslAturPerfCurr1DayTimeElapsed"), ("ADSL-LINE-MIB", "adslAturPerfCurr15MinESs"), ("ADSL-LINE-MIB", "adslAturPerfValidIntervals"), ("ADSL-LINE-MIB", "adslAturPerfCurr15MinTimeElapsed"), ("ADSL-LINE-MIB", "adslAturPerfPrev1DayLprs"), ("ADSL-LINE-MIB", "adslAturIntervalLprs"), ) )
if mibBuilder.loadTexts: adslAturPhysPerfIntervalGroup.setDescription("A collection of objects providing current 15-minute,\n1-day; and previous 1-day performance counts on\nADSL Line (ATU-R end).")
adslAtucChanPerformanceGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 10, 94, 1, 3, 1, 8)).setObjects(*(("ADSL-LINE-MIB", "adslAtucChanPerfCurr15MinReceivedBlks"), ("ADSL-LINE-MIB", "adslAtucChanPerfCurr1DayUncorrectBlks"), ("ADSL-LINE-MIB", "adslAtucChanPerfCurr15MinCorrectedBlks"), ("ADSL-LINE-MIB", "adslAtucChanPerfPrev1DayMoniSecs"), ("ADSL-LINE-MIB", "adslAtucChanPerfCurr1DayTimeElapsed"), ("ADSL-LINE-MIB", "adslAtucChanIntervalReceivedBlks"), ("ADSL-LINE-MIB", "adslAtucChanIntervalUncorrectBlks"), ("ADSL-LINE-MIB", "adslAtucChanPerfPrev1DayReceivedBlks"), ("ADSL-LINE-MIB", "adslAtucChanPerfCurr15MinTransmittedBlks"), ("ADSL-LINE-MIB", "adslAtucChanCorrectedBlks"), ("ADSL-LINE-MIB", "adslAtucChanPerfCurr15MinUncorrectBlks"), ("ADSL-LINE-MIB", "adslAtucChanPerfValidIntervals"), ("ADSL-LINE-MIB", "adslAtucChanPerfCurr1DayCorrectedBlks"), ("ADSL-LINE-MIB", "adslAtucChanReceivedBlks"), ("ADSL-LINE-MIB", "adslAtucChanIntervalValidData"), ("ADSL-LINE-MIB", "adslAtucChanUncorrectBlks"), ("ADSL-LINE-MIB", "adslAtucChanPerfPrev1DayUncorrectBlks"), ("ADSL-LINE-MIB", "adslAtucChanPerfPrev1DayTransmittedBlks"), ("ADSL-LINE-MIB", "adslAtucChanIntervalCorrectedBlks"), ("ADSL-LINE-MIB", "adslAtucChanTransmittedBlks"), ("ADSL-LINE-MIB", "adslAtucChanPerfCurr1DayReceivedBlks"), ("ADSL-LINE-MIB", "adslAtucChanPerfCurr15MinTimeElapsed"), ("ADSL-LINE-MIB", "adslAtucChanPerfPrev1DayCorrectedBlks"), ("ADSL-LINE-MIB", "adslAtucChanPerfCurr1DayTransmittedBlks"), ("ADSL-LINE-MIB", "adslAtucChanIntervalTransmittedBlks"), ("ADSL-LINE-MIB", "adslAtucChanPerfInvalidIntervals"), ) )
if mibBuilder.loadTexts: adslAtucChanPerformanceGroup.setDescription("A collection of objects providing channel block\nperformance information on an ADSL channel\n(ATU-C end).")
adslAturChanPerformanceGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 10, 94, 1, 3, 1, 9)).setObjects(*(("ADSL-LINE-MIB", "adslAturChanTransmittedBlks"), ("ADSL-LINE-MIB", "adslAturChanPerfPrev1DayUncorrectBlks"), ("ADSL-LINE-MIB", "adslAturChanPerfCurr1DayCorrectedBlks"), ("ADSL-LINE-MIB", "adslAturChanIntervalCorrectedBlks"), ("ADSL-LINE-MIB", "adslAturChanPerfCurr15MinUncorrectBlks"), ("ADSL-LINE-MIB", "adslAturChanPerfCurr15MinReceivedBlks"), ("ADSL-LINE-MIB", "adslAturChanCorrectedBlks"), ("ADSL-LINE-MIB", "adslAturChanPerfPrev1DayTransmittedBlks"), ("ADSL-LINE-MIB", "adslAturChanIntervalReceivedBlks"), ("ADSL-LINE-MIB", "adslAturChanPerfCurr15MinCorrectedBlks"), ("ADSL-LINE-MIB", "adslAturChanPerfPrev1DayReceivedBlks"), ("ADSL-LINE-MIB", "adslAturChanUncorrectBlks"), ("ADSL-LINE-MIB", "adslAturChanReceivedBlks"), ("ADSL-LINE-MIB", "adslAturChanIntervalValidData"), ("ADSL-LINE-MIB", "adslAturChanPerfCurr1DayTransmittedBlks"), ("ADSL-LINE-MIB", "adslAturChanPerfPrev1DayMoniSecs"), ("ADSL-LINE-MIB", "adslAturChanPerfValidIntervals"), ("ADSL-LINE-MIB", "adslAturChanPerfCurr15MinTimeElapsed"), ("ADSL-LINE-MIB", "adslAturChanPerfPrev1DayCorrectedBlks"), ("ADSL-LINE-MIB", "adslAturChanPerfCurr1DayReceivedBlks"), ("ADSL-LINE-MIB", "adslAturChanPerfCurr1DayUncorrectBlks"), ("ADSL-LINE-MIB", "adslAturChanPerfCurr15MinTransmittedBlks"), ("ADSL-LINE-MIB", "adslAturChanIntervalTransmittedBlks"), ("ADSL-LINE-MIB", "adslAturChanPerfCurr1DayTimeElapsed"), ("ADSL-LINE-MIB", "adslAturChanIntervalUncorrectBlks"), ("ADSL-LINE-MIB", "adslAturChanPerfInvalidIntervals"), ) )
if mibBuilder.loadTexts: adslAturChanPerformanceGroup.setDescription("A collection of objects providing channel block\nperformance information on an ADSL channel\n(ATU-C end).")
adslLineConfProfileGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 10, 94, 1, 3, 1, 10)).setObjects(*(("ADSL-LINE-MIB", "adslAtucConfMinSnrMgn"), ("ADSL-LINE-MIB", "adslAtucChanConfFastMinTxRate"), ("ADSL-LINE-MIB", "adslAtucConfRateChanRatio"), ("ADSL-LINE-MIB", "adslAturConfMinSnrMgn"), ("ADSL-LINE-MIB", "adslAtucConfDownshiftSnrMgn"), ("ADSL-LINE-MIB", "adslAturConfTargetSnrMgn"), ("ADSL-LINE-MIB", "adslAtucConfMinUpshiftTime"), ("ADSL-LINE-MIB", "adslAturChanConfFastMinTxRate"), ("ADSL-LINE-MIB", "adslAturConfMinUpshiftTime"), ("ADSL-LINE-MIB", "adslAtucConfMinDownshiftTime"), ("ADSL-LINE-MIB", "adslAturChanConfMaxInterleaveDelay"), ("ADSL-LINE-MIB", "adslAturConfRateMode"), ("ADSL-LINE-MIB", "adslAtucConfTargetSnrMgn"), ("ADSL-LINE-MIB", "adslAtucChanConfMaxInterleaveDelay"), ("ADSL-LINE-MIB", "adslAturConfMinDownshiftTime"), ("ADSL-LINE-MIB", "adslAturConfDownshiftSnrMgn"), ("ADSL-LINE-MIB", "adslAturConfRateChanRatio"), ("ADSL-LINE-MIB", "adslAturChanConfFastMaxTxRate"), ("ADSL-LINE-MIB", "adslAtucChanConfInterleaveMinTxRate"), ("ADSL-LINE-MIB", "adslAturConfMaxSnrMgn"), ("ADSL-LINE-MIB", "adslAturChanConfInterleaveMinTxRate"), ("ADSL-LINE-MIB", "adslAtucConfRateMode"), ("ADSL-LINE-MIB", "adslAturConfUpshiftSnrMgn"), ("ADSL-LINE-MIB", "adslAtucConfMaxSnrMgn"), ("ADSL-LINE-MIB", "adslAtucChanConfFastMaxTxRate"), ("ADSL-LINE-MIB", "adslAturChanConfInterleaveMaxTxRate"), ("ADSL-LINE-MIB", "adslAtucConfUpshiftSnrMgn"), ("ADSL-LINE-MIB", "adslAtucChanConfInterleaveMaxTxRate"), ) )
if mibBuilder.loadTexts: adslLineConfProfileGroup.setDescription("A collection of objects providing provisioning\ninformation about an ADSL Line.")
adslLineAlarmConfProfileGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 10, 94, 1, 3, 1, 11)).setObjects(*(("ADSL-LINE-MIB", "adslAtucThresh15MinLols"), ("ADSL-LINE-MIB", "adslAtucThresh15MinESs"), ("ADSL-LINE-MIB", "adslAturThresh15MinLoss"), ("ADSL-LINE-MIB", "adslAtucThreshFastRateUp"), ("ADSL-LINE-MIB", "adslAtucInitFailureTrapEnable"), ("ADSL-LINE-MIB", "adslAtucThreshFastRateDown"), ("ADSL-LINE-MIB", "adslAtucThresh15MinLprs"), ("ADSL-LINE-MIB", "adslAtucThreshInterleaveRateUp"), ("ADSL-LINE-MIB", "adslAturThreshFastRateUp"), ("ADSL-LINE-MIB", "adslAtucThreshInterleaveRateDown"), ("ADSL-LINE-MIB", "adslAturThresh15MinLofs"), ("ADSL-LINE-MIB", "adslAturThreshFastRateDown"), ("ADSL-LINE-MIB", "adslAturThreshInterleaveRateUp"), ("ADSL-LINE-MIB", "adslAtucThresh15MinLofs"), ("ADSL-LINE-MIB", "adslAturThreshInterleaveRateDown"), ("ADSL-LINE-MIB", "adslAtucThresh15MinLoss"), ("ADSL-LINE-MIB", "adslAturThresh15MinLprs"), ("ADSL-LINE-MIB", "adslAturThresh15MinESs"), ) )
if mibBuilder.loadTexts: adslLineAlarmConfProfileGroup.setDescription("A collection of objects providing alarm provisioning\ninformation about an ADSL Line.")
adslLineConfProfileControlGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 10, 94, 1, 3, 1, 12)).setObjects(*(("ADSL-LINE-MIB", "adslLineAlarmConfProfile"), ("ADSL-LINE-MIB", "adslLineConfProfile"), ("ADSL-LINE-MIB", "adslLineAlarmConfProfileRowStatus"), ("ADSL-LINE-MIB", "adslLineConfProfileRowStatus"), ) )
if mibBuilder.loadTexts: adslLineConfProfileControlGroup.setDescription("A collection of objects providing profile\ncontrol for the ADSL system.")
adslNotificationsGroup = NotificationGroup((1, 3, 6, 1, 2, 1, 10, 94, 1, 3, 1, 13)).setObjects(*(("ADSL-LINE-MIB", "adslAtucInitFailureTrap"), ("ADSL-LINE-MIB", "adslAturPerfLossThreshTrap"), ("ADSL-LINE-MIB", "adslAtucPerfLolsThreshTrap"), ("ADSL-LINE-MIB", "adslAturPerfLofsThreshTrap"), ("ADSL-LINE-MIB", "adslAtucPerfLprsThreshTrap"), ("ADSL-LINE-MIB", "adslAturPerfLprsThreshTrap"), ("ADSL-LINE-MIB", "adslAtucRateChangeTrap"), ("ADSL-LINE-MIB", "adslAturPerfESsThreshTrap"), ("ADSL-LINE-MIB", "adslAtucPerfESsThreshTrap"), ("ADSL-LINE-MIB", "adslAtucPerfLossThreshTrap"), ("ADSL-LINE-MIB", "adslAtucPerfLofsThreshTrap"), ("ADSL-LINE-MIB", "adslAturRateChangeTrap"), ) )
if mibBuilder.loadTexts: adslNotificationsGroup.setDescription("The collection of adsl notifications.")
adslAturLineGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 10, 94, 1, 3, 1, 14)).setObjects(*(("ADSL-LINE-MIB", "adslLineCoding"), ) )
if mibBuilder.loadTexts: adslAturLineGroup.setDescription("A collection of objects providing configuration\ninformation about an ADSL Line on the ATU-R side.")
adslAturPhysicalGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 10, 94, 1, 3, 1, 15)).setObjects(*(("ADSL-LINE-MIB", "adslAturCurrSnrMgn"), ("ADSL-LINE-MIB", "adslAturCurrAtn"), ("ADSL-LINE-MIB", "adslAturCurrAttainableRate"), ("ADSL-LINE-MIB", "adslAtucInvVendorID"), ("ADSL-LINE-MIB", "adslAturInvVendorID"), ("ADSL-LINE-MIB", "adslAturCurrStatus"), ("ADSL-LINE-MIB", "adslAturInvVersionNumber"), ("ADSL-LINE-MIB", "adslAturCurrOutputPwr"), ("ADSL-LINE-MIB", "adslAtucInvVersionNumber"), ("ADSL-LINE-MIB", "adslAtucCurrAttainableRate"), ("ADSL-LINE-MIB", "adslAtucCurrOutputPwr"), ("ADSL-LINE-MIB", "adslAturInvSerialNumber"), ("ADSL-LINE-MIB", "adslAtucCurrStatus"), ) )
if mibBuilder.loadTexts: adslAturPhysicalGroup.setDescription("A collection of objects providing physical\nconfiguration information of the ADSL Line on the\nATU-R side.")
adslAturChannelGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 10, 94, 1, 3, 1, 16)).setObjects(*(("ADSL-LINE-MIB", "adslAturChanCurrTxRate"), ("ADSL-LINE-MIB", "adslAturChanPrevTxRate"), ("ADSL-LINE-MIB", "adslAtucChanCurrTxRate"), ("ADSL-LINE-MIB", "adslAturChanCrcBlockLength"), ("ADSL-LINE-MIB", "adslAturChanInterleaveDelay"), ("ADSL-LINE-MIB", "adslAtucChanInterleaveDelay"), ("ADSL-LINE-MIB", "adslAtucChanPrevTxRate"), ) )
if mibBuilder.loadTexts: adslAturChannelGroup.setDescription("A collection of objects providing configuration\ninformation about an ADSL channel on the ATU-R\nside.")
adslAturAtucPhysPerfRawCounterGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 10, 94, 1, 3, 1, 17)).setObjects(*(("ADSL-LINE-MIB", "adslAtucPerfESs"), ("ADSL-LINE-MIB", "adslAtucPerfInits"), ("ADSL-LINE-MIB", "adslAtucPerfLoss"), ("ADSL-LINE-MIB", "adslAtucPerfLofs"), ) )
if mibBuilder.loadTexts: adslAturAtucPhysPerfRawCounterGroup.setDescription("A collection of objects providing raw performance\ncounts on an ADSL Line (ATU-C end) provided by the\nATU-R agent.")
adslAturAtucPhysPerfIntervalGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 10, 94, 1, 3, 1, 18)).setObjects(*(("ADSL-LINE-MIB", "adslAtucPerfPrev1DayLoss"), ("ADSL-LINE-MIB", "adslAtucIntervalLoss"), ("ADSL-LINE-MIB", "adslAtucPerfCurr1DayLoss"), ("ADSL-LINE-MIB", "adslAtucPerfCurr15MinTimeElapsed"), ("ADSL-LINE-MIB", "adslAtucPerfValidIntervals"), ("ADSL-LINE-MIB", "adslAtucPerfPrev1DayMoniSecs"), ("ADSL-LINE-MIB", "adslAtucIntervalInits"), ("ADSL-LINE-MIB", "adslAtucPerfCurr15MinESs"), ("ADSL-LINE-MIB", "adslAtucIntervalValidData"), ("ADSL-LINE-MIB", "adslAtucPerfCurr1DayLofs"), ("ADSL-LINE-MIB", "adslAtucIntervalLofs"), ("ADSL-LINE-MIB", "adslAtucPerfCurr15MinLoss"), ("ADSL-LINE-MIB", "adslAtucPerfPrev1DayInits"), ("ADSL-LINE-MIB", "adslAtucPerfCurr1DayInits"), ("ADSL-LINE-MIB", "adslAtucPerfCurr15MinInits"), ("ADSL-LINE-MIB", "adslAtucPerfPrev1DayESs"), ("ADSL-LINE-MIB", "adslAtucPerfCurr1DayESs"), ("ADSL-LINE-MIB", "adslAtucPerfCurr1DayTimeElapsed"), ("ADSL-LINE-MIB", "adslAtucPerfPrev1DayLofs"), ("ADSL-LINE-MIB", "adslAtucIntervalESs"), ("ADSL-LINE-MIB", "adslAtucPerfCurr15MinLofs"), ("ADSL-LINE-MIB", "adslAtucPerfInvalidIntervals"), ) )
if mibBuilder.loadTexts: adslAturAtucPhysPerfIntervalGroup.setDescription("A collection of objects providing current\n15-minute, 1-day; and previous 1-day performance\ncounts on ADSL Line (ATU-C end) provided by the\nATU-R agent.")
adslAturAturPhysPerfRawCounterGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 10, 94, 1, 3, 1, 19)).setObjects(*(("ADSL-LINE-MIB", "adslAturPerfLoss"), ("ADSL-LINE-MIB", "adslAturPerfLprs"), ("ADSL-LINE-MIB", "adslAturPerfESs"), ("ADSL-LINE-MIB", "adslAturPerfLofs"), ) )
if mibBuilder.loadTexts: adslAturAturPhysPerfRawCounterGroup.setDescription("A collection of objects providing raw performance\ncounts on an ADSL Line (ATU-R end) provided by the\nATU-R agent.")
adslAturAturPhysPerfIntervalGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 10, 94, 1, 3, 1, 20)).setObjects(*(("ADSL-LINE-MIB", "adslAturPerfCurr1DayLoss"), ("ADSL-LINE-MIB", "adslAturPerfPrev1DayLoss"), ("ADSL-LINE-MIB", "adslAturIntervalValidData"), ("ADSL-LINE-MIB", "adslAturPerfPrev1DayMoniSecs"), ("ADSL-LINE-MIB", "adslAturPerfPrev1DayESs"), ("ADSL-LINE-MIB", "adslAturIntervalESs"), ("ADSL-LINE-MIB", "adslAturPerfCurr1DayLprs"), ("ADSL-LINE-MIB", "adslAturIntervalLoss"), ("ADSL-LINE-MIB", "adslAturPerfCurr15MinLoss"), ("ADSL-LINE-MIB", "adslAturPerfPrev1DayLofs"), ("ADSL-LINE-MIB", "adslAturPerfCurr1DayLofs"), ("ADSL-LINE-MIB", "adslAturPerfCurr15MinLofs"), ("ADSL-LINE-MIB", "adslAturPerfInvalidIntervals"), ("ADSL-LINE-MIB", "adslAturIntervalLofs"), ("ADSL-LINE-MIB", "adslAturPerfCurr1DayESs"), ("ADSL-LINE-MIB", "adslAturPerfCurr15MinLprs"), ("ADSL-LINE-MIB", "adslAturPerfCurr1DayTimeElapsed"), ("ADSL-LINE-MIB", "adslAturPerfCurr15MinESs"), ("ADSL-LINE-MIB", "adslAturPerfValidIntervals"), ("ADSL-LINE-MIB", "adslAturPerfCurr15MinTimeElapsed"), ("ADSL-LINE-MIB", "adslAturPerfPrev1DayLprs"), ("ADSL-LINE-MIB", "adslAturIntervalLprs"), ) )
if mibBuilder.loadTexts: adslAturAturPhysPerfIntervalGroup.setDescription("A collection of objects providing current\n15-minute, 1-day; and previous 1-day performance\ncounts on ADSL Line (ATU-R end) provided by the\nATU-R agent.")
adslAturAtucChanPerformanceGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 10, 94, 1, 3, 1, 21)).setObjects(*(("ADSL-LINE-MIB", "adslAtucChanPerfCurr15MinReceivedBlks"), ("ADSL-LINE-MIB", "adslAtucChanPerfCurr1DayUncorrectBlks"), ("ADSL-LINE-MIB", "adslAtucChanPerfCurr15MinCorrectedBlks"), ("ADSL-LINE-MIB", "adslAtucChanPerfPrev1DayMoniSecs"), ("ADSL-LINE-MIB", "adslAtucChanPerfInvalidIntervals"), ("ADSL-LINE-MIB", "adslAtucChanIntervalReceivedBlks"), ("ADSL-LINE-MIB", "adslAtucChanIntervalUncorrectBlks"), ("ADSL-LINE-MIB", "adslAtucChanPerfPrev1DayReceivedBlks"), ("ADSL-LINE-MIB", "adslAtucChanPerfCurr15MinTransmittedBlks"), ("ADSL-LINE-MIB", "adslAtucChanCorrectedBlks"), ("ADSL-LINE-MIB", "adslAtucChanPerfCurr15MinUncorrectBlks"), ("ADSL-LINE-MIB", "adslAtucChanPerfValidIntervals"), ("ADSL-LINE-MIB", "adslAtucChanPerfCurr1DayCorrectedBlks"), ("ADSL-LINE-MIB", "adslAtucChanReceivedBlks"), ("ADSL-LINE-MIB", "adslAtucChanIntervalValidData"), ("ADSL-LINE-MIB", "adslAtucChanUncorrectBlks"), ("ADSL-LINE-MIB", "adslAtucChanPerfPrev1DayUncorrectBlks"), ("ADSL-LINE-MIB", "adslAtucChanPerfPrev1DayTransmittedBlks"), ("ADSL-LINE-MIB", "adslAtucChanIntervalCorrectedBlks"), ("ADSL-LINE-MIB", "adslAtucChanTransmittedBlks"), ("ADSL-LINE-MIB", "adslAtucChanPerfCurr1DayReceivedBlks"), ("ADSL-LINE-MIB", "adslAtucChanPerfCurr15MinTimeElapsed"), ("ADSL-LINE-MIB", "adslAtucChanPerfPrev1DayCorrectedBlks"), ("ADSL-LINE-MIB", "adslAtucChanPerfCurr1DayTransmittedBlks"), ("ADSL-LINE-MIB", "adslAtucChanIntervalTransmittedBlks"), ("ADSL-LINE-MIB", "adslAtucChanPerfCurr1DayTimeElapsed"), ) )
if mibBuilder.loadTexts: adslAturAtucChanPerformanceGroup.setDescription("A collection of objects providing channel block\nperformance information on an ADSL channel\n(ATU-C end) provided by the ATU-R agent.")
adslAturAturChanPerformanceGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 10, 94, 1, 3, 1, 22)).setObjects(*(("ADSL-LINE-MIB", "adslAturChanTransmittedBlks"), ("ADSL-LINE-MIB", "adslAturChanPerfPrev1DayUncorrectBlks"), ("ADSL-LINE-MIB", "adslAturChanPerfCurr1DayCorrectedBlks"), ("ADSL-LINE-MIB", "adslAturChanIntervalCorrectedBlks"), ("ADSL-LINE-MIB", "adslAturChanPerfCurr15MinUncorrectBlks"), ("ADSL-LINE-MIB", "adslAturChanPerfCurr15MinReceivedBlks"), ("ADSL-LINE-MIB", "adslAturChanCorrectedBlks"), ("ADSL-LINE-MIB", "adslAturChanPerfPrev1DayTransmittedBlks"), ("ADSL-LINE-MIB", "adslAturChanIntervalReceivedBlks"), ("ADSL-LINE-MIB", "adslAturChanPerfCurr15MinCorrectedBlks"), ("ADSL-LINE-MIB", "adslAturChanPerfPrev1DayReceivedBlks"), ("ADSL-LINE-MIB", "adslAturChanUncorrectBlks"), ("ADSL-LINE-MIB", "adslAturChanReceivedBlks"), ("ADSL-LINE-MIB", "adslAturChanIntervalValidData"), ("ADSL-LINE-MIB", "adslAturChanPerfCurr1DayTransmittedBlks"), ("ADSL-LINE-MIB", "adslAturChanPerfPrev1DayMoniSecs"), ("ADSL-LINE-MIB", "adslAturChanPerfValidIntervals"), ("ADSL-LINE-MIB", "adslAturChanPerfCurr15MinTimeElapsed"), ("ADSL-LINE-MIB", "adslAturChanPerfPrev1DayCorrectedBlks"), ("ADSL-LINE-MIB", "adslAturChanPerfCurr1DayReceivedBlks"), ("ADSL-LINE-MIB", "adslAturChanPerfCurr1DayUncorrectBlks"), ("ADSL-LINE-MIB", "adslAturChanPerfCurr15MinTransmittedBlks"), ("ADSL-LINE-MIB", "adslAturChanIntervalTransmittedBlks"), ("ADSL-LINE-MIB", "adslAturChanPerfCurr1DayTimeElapsed"), ("ADSL-LINE-MIB", "adslAturChanIntervalUncorrectBlks"), ("ADSL-LINE-MIB", "adslAturChanPerfInvalidIntervals"), ) )
if mibBuilder.loadTexts: adslAturAturChanPerformanceGroup.setDescription("A collection of objects providing channel block\nperformance information on an ADSL channel\n(ATU-R end) provided by the ATU-R agent.")
adslAturLineAlarmConfProfileGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 10, 94, 1, 3, 1, 23)).setObjects(*(("ADSL-LINE-MIB", "adslAtucThresh15MinESs"), ("ADSL-LINE-MIB", "adslAtucThreshFastRateDown"), ("ADSL-LINE-MIB", "adslAturThresh15MinLoss"), ("ADSL-LINE-MIB", "adslAtucThreshFastRateUp"), ("ADSL-LINE-MIB", "adslAtucInitFailureTrapEnable"), ("ADSL-LINE-MIB", "adslAturThresh15MinLofs"), ("ADSL-LINE-MIB", "adslAtucThreshInterleaveRateUp"), ("ADSL-LINE-MIB", "adslAturThreshFastRateUp"), ("ADSL-LINE-MIB", "adslAtucThreshInterleaveRateDown"), ("ADSL-LINE-MIB", "adslAturThreshFastRateDown"), ("ADSL-LINE-MIB", "adslAturThreshInterleaveRateUp"), ("ADSL-LINE-MIB", "adslAtucThresh15MinLofs"), ("ADSL-LINE-MIB", "adslAturThreshInterleaveRateDown"), ("ADSL-LINE-MIB", "adslAtucThresh15MinLoss"), ("ADSL-LINE-MIB", "adslAturThresh15MinLprs"), ("ADSL-LINE-MIB", "adslAturThresh15MinESs"), ) )
if mibBuilder.loadTexts: adslAturLineAlarmConfProfileGroup.setDescription("A collection of objects providing alarm\nprovisioning\ninformation about an ADSL Line provided by the\nATU-R agent.")
adslAturLineConfProfileControlGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 10, 94, 1, 3, 1, 24)).setObjects(*(("ADSL-LINE-MIB", "adslLineAlarmConfProfile"), ("ADSL-LINE-MIB", "adslLineAlarmConfProfileRowStatus"), ) )
if mibBuilder.loadTexts: adslAturLineConfProfileControlGroup.setDescription("A collection of objects providing profile\ncontrol for the ADSL system by the ATU-R agent.")
adslAturNotificationsGroup = NotificationGroup((1, 3, 6, 1, 2, 1, 10, 94, 1, 3, 1, 25)).setObjects(*(("ADSL-LINE-MIB", "adslAtucPerfLossThreshTrap"), ("ADSL-LINE-MIB", "adslAtucRateChangeTrap"), ("ADSL-LINE-MIB", "adslAturPerfESsThreshTrap"), ("ADSL-LINE-MIB", "adslAtucPerfLofsThreshTrap"), ("ADSL-LINE-MIB", "adslAturPerfLossThreshTrap"), ("ADSL-LINE-MIB", "adslAtucPerfESsThreshTrap"), ("ADSL-LINE-MIB", "adslAturPerfLofsThreshTrap"), ("ADSL-LINE-MIB", "adslAturPerfLprsThreshTrap"), ("ADSL-LINE-MIB", "adslAturRateChangeTrap"), ) )
if mibBuilder.loadTexts: adslAturNotificationsGroup.setDescription("The collection of ADSL notifications implemented by\nthe ATU-R agent.")

# Compliances

adslLineMibAtucCompliance = ModuleCompliance((1, 3, 6, 1, 2, 1, 10, 94, 1, 3, 2, 1)).setObjects(*(("ADSL-LINE-MIB", "adslLineAlarmConfProfileGroup"), ("ADSL-LINE-MIB", "adslAtucPhysPerfIntervalGroup"), ("ADSL-LINE-MIB", "adslAturChanPerformanceGroup"), ("ADSL-LINE-MIB", "adslAturPhysPerfIntervalGroup"), ("ADSL-LINE-MIB", "adslAtucPhysPerfRawCounterGroup"), ("ADSL-LINE-MIB", "adslAtucChanPerformanceGroup"), ("ADSL-LINE-MIB", "adslPhysicalGroup"), ("ADSL-LINE-MIB", "adslAturPhysPerfRawCounterGroup"), ("ADSL-LINE-MIB", "adslLineConfProfileControlGroup"), ("ADSL-LINE-MIB", "adslLineGroup"), ("ADSL-LINE-MIB", "adslLineConfProfileGroup"), ("ADSL-LINE-MIB", "adslChannelGroup"), ) )
if mibBuilder.loadTexts: adslLineMibAtucCompliance.setDescription("The compliance statement for SNMP entities\nwhich manage ADSL ATU-C interfaces.")
adslLineMibAturCompliance = ModuleCompliance((1, 3, 6, 1, 2, 1, 10, 94, 1, 3, 2, 2)).setObjects(*(("ADSL-LINE-MIB", "adslAturLineGroup"), ("ADSL-LINE-MIB", "adslAturAturPhysPerfIntervalGroup"), ("ADSL-LINE-MIB", "adslAturPhysicalGroup"), ("ADSL-LINE-MIB", "adslAturAturPhysPerfRawCounterGroup"), ("ADSL-LINE-MIB", "adslAturAtucChanPerformanceGroup"), ("ADSL-LINE-MIB", "adslAturLineConfProfileControlGroup"), ("ADSL-LINE-MIB", "adslAturAturChanPerformanceGroup"), ("ADSL-LINE-MIB", "adslAturAtucPhysPerfRawCounterGroup"), ("ADSL-LINE-MIB", "adslAturAtucPhysPerfIntervalGroup"), ("ADSL-LINE-MIB", "adslAturLineAlarmConfProfileGroup"), ("ADSL-LINE-MIB", "adslAturChannelGroup"), ) )
if mibBuilder.loadTexts: adslLineMibAturCompliance.setDescription("The compliance statement for SNMP entities\nwhich manage ADSL ATU-R interfaces.")

# Exports

# Module identity
mibBuilder.exportSymbols("ADSL-LINE-MIB", PYSNMP_MODULE_ID=adslMIB)

# Objects
mibBuilder.exportSymbols("ADSL-LINE-MIB", adslMIB=adslMIB, adslLineMib=adslLineMib, adslMibObjects=adslMibObjects, adslLineTable=adslLineTable, adslLineEntry=adslLineEntry, adslLineCoding=adslLineCoding, adslLineType=adslLineType, adslLineSpecific=adslLineSpecific, adslLineConfProfile=adslLineConfProfile, adslLineAlarmConfProfile=adslLineAlarmConfProfile, adslAtucPhysTable=adslAtucPhysTable, adslAtucPhysEntry=adslAtucPhysEntry, adslAtucInvSerialNumber=adslAtucInvSerialNumber, adslAtucInvVendorID=adslAtucInvVendorID, adslAtucInvVersionNumber=adslAtucInvVersionNumber, adslAtucCurrSnrMgn=adslAtucCurrSnrMgn, adslAtucCurrAtn=adslAtucCurrAtn, adslAtucCurrStatus=adslAtucCurrStatus, adslAtucCurrOutputPwr=adslAtucCurrOutputPwr, adslAtucCurrAttainableRate=adslAtucCurrAttainableRate, adslAturPhysTable=adslAturPhysTable, adslAturPhysEntry=adslAturPhysEntry, adslAturInvSerialNumber=adslAturInvSerialNumber, adslAturInvVendorID=adslAturInvVendorID, adslAturInvVersionNumber=adslAturInvVersionNumber, adslAturCurrSnrMgn=adslAturCurrSnrMgn, adslAturCurrAtn=adslAturCurrAtn, adslAturCurrStatus=adslAturCurrStatus, adslAturCurrOutputPwr=adslAturCurrOutputPwr, adslAturCurrAttainableRate=adslAturCurrAttainableRate, adslAtucChanTable=adslAtucChanTable, adslAtucChanEntry=adslAtucChanEntry, adslAtucChanInterleaveDelay=adslAtucChanInterleaveDelay, adslAtucChanCurrTxRate=adslAtucChanCurrTxRate, adslAtucChanPrevTxRate=adslAtucChanPrevTxRate, adslAtucChanCrcBlockLength=adslAtucChanCrcBlockLength, adslAturChanTable=adslAturChanTable, adslAturChanEntry=adslAturChanEntry, adslAturChanInterleaveDelay=adslAturChanInterleaveDelay, adslAturChanCurrTxRate=adslAturChanCurrTxRate, adslAturChanPrevTxRate=adslAturChanPrevTxRate, adslAturChanCrcBlockLength=adslAturChanCrcBlockLength, adslAtucPerfDataTable=adslAtucPerfDataTable, adslAtucPerfDataEntry=adslAtucPerfDataEntry, adslAtucPerfLofs=adslAtucPerfLofs, adslAtucPerfLoss=adslAtucPerfLoss, adslAtucPerfLols=adslAtucPerfLols, adslAtucPerfLprs=adslAtucPerfLprs, adslAtucPerfESs=adslAtucPerfESs, adslAtucPerfInits=adslAtucPerfInits, adslAtucPerfValidIntervals=adslAtucPerfValidIntervals, adslAtucPerfInvalidIntervals=adslAtucPerfInvalidIntervals, adslAtucPerfCurr15MinTimeElapsed=adslAtucPerfCurr15MinTimeElapsed, adslAtucPerfCurr15MinLofs=adslAtucPerfCurr15MinLofs, adslAtucPerfCurr15MinLoss=adslAtucPerfCurr15MinLoss, adslAtucPerfCurr15MinLols=adslAtucPerfCurr15MinLols, adslAtucPerfCurr15MinLprs=adslAtucPerfCurr15MinLprs, adslAtucPerfCurr15MinESs=adslAtucPerfCurr15MinESs, adslAtucPerfCurr15MinInits=adslAtucPerfCurr15MinInits, adslAtucPerfCurr1DayTimeElapsed=adslAtucPerfCurr1DayTimeElapsed, adslAtucPerfCurr1DayLofs=adslAtucPerfCurr1DayLofs, adslAtucPerfCurr1DayLoss=adslAtucPerfCurr1DayLoss, adslAtucPerfCurr1DayLols=adslAtucPerfCurr1DayLols, adslAtucPerfCurr1DayLprs=adslAtucPerfCurr1DayLprs, adslAtucPerfCurr1DayESs=adslAtucPerfCurr1DayESs, adslAtucPerfCurr1DayInits=adslAtucPerfCurr1DayInits, adslAtucPerfPrev1DayMoniSecs=adslAtucPerfPrev1DayMoniSecs, adslAtucPerfPrev1DayLofs=adslAtucPerfPrev1DayLofs, adslAtucPerfPrev1DayLoss=adslAtucPerfPrev1DayLoss, adslAtucPerfPrev1DayLols=adslAtucPerfPrev1DayLols, adslAtucPerfPrev1DayLprs=adslAtucPerfPrev1DayLprs, adslAtucPerfPrev1DayESs=adslAtucPerfPrev1DayESs, adslAtucPerfPrev1DayInits=adslAtucPerfPrev1DayInits, adslAturPerfDataTable=adslAturPerfDataTable, adslAturPerfDataEntry=adslAturPerfDataEntry, adslAturPerfLofs=adslAturPerfLofs, adslAturPerfLoss=adslAturPerfLoss, adslAturPerfLprs=adslAturPerfLprs, adslAturPerfESs=adslAturPerfESs, adslAturPerfValidIntervals=adslAturPerfValidIntervals, adslAturPerfInvalidIntervals=adslAturPerfInvalidIntervals, adslAturPerfCurr15MinTimeElapsed=adslAturPerfCurr15MinTimeElapsed, adslAturPerfCurr15MinLofs=adslAturPerfCurr15MinLofs, adslAturPerfCurr15MinLoss=adslAturPerfCurr15MinLoss, adslAturPerfCurr15MinLprs=adslAturPerfCurr15MinLprs, adslAturPerfCurr15MinESs=adslAturPerfCurr15MinESs, adslAturPerfCurr1DayTimeElapsed=adslAturPerfCurr1DayTimeElapsed, adslAturPerfCurr1DayLofs=adslAturPerfCurr1DayLofs, adslAturPerfCurr1DayLoss=adslAturPerfCurr1DayLoss, adslAturPerfCurr1DayLprs=adslAturPerfCurr1DayLprs, adslAturPerfCurr1DayESs=adslAturPerfCurr1DayESs, adslAturPerfPrev1DayMoniSecs=adslAturPerfPrev1DayMoniSecs, adslAturPerfPrev1DayLofs=adslAturPerfPrev1DayLofs, adslAturPerfPrev1DayLoss=adslAturPerfPrev1DayLoss, adslAturPerfPrev1DayLprs=adslAturPerfPrev1DayLprs, adslAturPerfPrev1DayESs=adslAturPerfPrev1DayESs, adslAtucIntervalTable=adslAtucIntervalTable, adslAtucIntervalEntry=adslAtucIntervalEntry, adslAtucIntervalNumber=adslAtucIntervalNumber, adslAtucIntervalLofs=adslAtucIntervalLofs, adslAtucIntervalLoss=adslAtucIntervalLoss, adslAtucIntervalLols=adslAtucIntervalLols, adslAtucIntervalLprs=adslAtucIntervalLprs, adslAtucIntervalESs=adslAtucIntervalESs, adslAtucIntervalInits=adslAtucIntervalInits, adslAtucIntervalValidData=adslAtucIntervalValidData, adslAturIntervalTable=adslAturIntervalTable, adslAturIntervalEntry=adslAturIntervalEntry, adslAturIntervalNumber=adslAturIntervalNumber, adslAturIntervalLofs=adslAturIntervalLofs, adslAturIntervalLoss=adslAturIntervalLoss, adslAturIntervalLprs=adslAturIntervalLprs, adslAturIntervalESs=adslAturIntervalESs, adslAturIntervalValidData=adslAturIntervalValidData, adslAtucChanPerfDataTable=adslAtucChanPerfDataTable, adslAtucChanPerfDataEntry=adslAtucChanPerfDataEntry, adslAtucChanReceivedBlks=adslAtucChanReceivedBlks, adslAtucChanTransmittedBlks=adslAtucChanTransmittedBlks, adslAtucChanCorrectedBlks=adslAtucChanCorrectedBlks, adslAtucChanUncorrectBlks=adslAtucChanUncorrectBlks, adslAtucChanPerfValidIntervals=adslAtucChanPerfValidIntervals, adslAtucChanPerfInvalidIntervals=adslAtucChanPerfInvalidIntervals, adslAtucChanPerfCurr15MinTimeElapsed=adslAtucChanPerfCurr15MinTimeElapsed, adslAtucChanPerfCurr15MinReceivedBlks=adslAtucChanPerfCurr15MinReceivedBlks, adslAtucChanPerfCurr15MinTransmittedBlks=adslAtucChanPerfCurr15MinTransmittedBlks, adslAtucChanPerfCurr15MinCorrectedBlks=adslAtucChanPerfCurr15MinCorrectedBlks)
mibBuilder.exportSymbols("ADSL-LINE-MIB", adslAtucChanPerfCurr15MinUncorrectBlks=adslAtucChanPerfCurr15MinUncorrectBlks, adslAtucChanPerfCurr1DayTimeElapsed=adslAtucChanPerfCurr1DayTimeElapsed, adslAtucChanPerfCurr1DayReceivedBlks=adslAtucChanPerfCurr1DayReceivedBlks, adslAtucChanPerfCurr1DayTransmittedBlks=adslAtucChanPerfCurr1DayTransmittedBlks, adslAtucChanPerfCurr1DayCorrectedBlks=adslAtucChanPerfCurr1DayCorrectedBlks, adslAtucChanPerfCurr1DayUncorrectBlks=adslAtucChanPerfCurr1DayUncorrectBlks, adslAtucChanPerfPrev1DayMoniSecs=adslAtucChanPerfPrev1DayMoniSecs, adslAtucChanPerfPrev1DayReceivedBlks=adslAtucChanPerfPrev1DayReceivedBlks, adslAtucChanPerfPrev1DayTransmittedBlks=adslAtucChanPerfPrev1DayTransmittedBlks, adslAtucChanPerfPrev1DayCorrectedBlks=adslAtucChanPerfPrev1DayCorrectedBlks, adslAtucChanPerfPrev1DayUncorrectBlks=adslAtucChanPerfPrev1DayUncorrectBlks, adslAturChanPerfDataTable=adslAturChanPerfDataTable, adslAturChanPerfDataEntry=adslAturChanPerfDataEntry, adslAturChanReceivedBlks=adslAturChanReceivedBlks, adslAturChanTransmittedBlks=adslAturChanTransmittedBlks, adslAturChanCorrectedBlks=adslAturChanCorrectedBlks, adslAturChanUncorrectBlks=adslAturChanUncorrectBlks, adslAturChanPerfValidIntervals=adslAturChanPerfValidIntervals, adslAturChanPerfInvalidIntervals=adslAturChanPerfInvalidIntervals, adslAturChanPerfCurr15MinTimeElapsed=adslAturChanPerfCurr15MinTimeElapsed, adslAturChanPerfCurr15MinReceivedBlks=adslAturChanPerfCurr15MinReceivedBlks, adslAturChanPerfCurr15MinTransmittedBlks=adslAturChanPerfCurr15MinTransmittedBlks, adslAturChanPerfCurr15MinCorrectedBlks=adslAturChanPerfCurr15MinCorrectedBlks, adslAturChanPerfCurr15MinUncorrectBlks=adslAturChanPerfCurr15MinUncorrectBlks, adslAturChanPerfCurr1DayTimeElapsed=adslAturChanPerfCurr1DayTimeElapsed, adslAturChanPerfCurr1DayReceivedBlks=adslAturChanPerfCurr1DayReceivedBlks, adslAturChanPerfCurr1DayTransmittedBlks=adslAturChanPerfCurr1DayTransmittedBlks, adslAturChanPerfCurr1DayCorrectedBlks=adslAturChanPerfCurr1DayCorrectedBlks, adslAturChanPerfCurr1DayUncorrectBlks=adslAturChanPerfCurr1DayUncorrectBlks, adslAturChanPerfPrev1DayMoniSecs=adslAturChanPerfPrev1DayMoniSecs, adslAturChanPerfPrev1DayReceivedBlks=adslAturChanPerfPrev1DayReceivedBlks, adslAturChanPerfPrev1DayTransmittedBlks=adslAturChanPerfPrev1DayTransmittedBlks, adslAturChanPerfPrev1DayCorrectedBlks=adslAturChanPerfPrev1DayCorrectedBlks, adslAturChanPerfPrev1DayUncorrectBlks=adslAturChanPerfPrev1DayUncorrectBlks, adslAtucChanIntervalTable=adslAtucChanIntervalTable, adslAtucChanIntervalEntry=adslAtucChanIntervalEntry, adslAtucChanIntervalNumber=adslAtucChanIntervalNumber, adslAtucChanIntervalReceivedBlks=adslAtucChanIntervalReceivedBlks, adslAtucChanIntervalTransmittedBlks=adslAtucChanIntervalTransmittedBlks, adslAtucChanIntervalCorrectedBlks=adslAtucChanIntervalCorrectedBlks, adslAtucChanIntervalUncorrectBlks=adslAtucChanIntervalUncorrectBlks, adslAtucChanIntervalValidData=adslAtucChanIntervalValidData, adslAturChanIntervalTable=adslAturChanIntervalTable, adslAturChanIntervalEntry=adslAturChanIntervalEntry, adslAturChanIntervalNumber=adslAturChanIntervalNumber, adslAturChanIntervalReceivedBlks=adslAturChanIntervalReceivedBlks, adslAturChanIntervalTransmittedBlks=adslAturChanIntervalTransmittedBlks, adslAturChanIntervalCorrectedBlks=adslAturChanIntervalCorrectedBlks, adslAturChanIntervalUncorrectBlks=adslAturChanIntervalUncorrectBlks, adslAturChanIntervalValidData=adslAturChanIntervalValidData, adslLineConfProfileTable=adslLineConfProfileTable, adslLineConfProfileEntry=adslLineConfProfileEntry, adslLineConfProfileName=adslLineConfProfileName, adslAtucConfRateMode=adslAtucConfRateMode, adslAtucConfRateChanRatio=adslAtucConfRateChanRatio, adslAtucConfTargetSnrMgn=adslAtucConfTargetSnrMgn, adslAtucConfMaxSnrMgn=adslAtucConfMaxSnrMgn, adslAtucConfMinSnrMgn=adslAtucConfMinSnrMgn, adslAtucConfDownshiftSnrMgn=adslAtucConfDownshiftSnrMgn, adslAtucConfUpshiftSnrMgn=adslAtucConfUpshiftSnrMgn, adslAtucConfMinUpshiftTime=adslAtucConfMinUpshiftTime, adslAtucConfMinDownshiftTime=adslAtucConfMinDownshiftTime, adslAtucChanConfFastMinTxRate=adslAtucChanConfFastMinTxRate, adslAtucChanConfInterleaveMinTxRate=adslAtucChanConfInterleaveMinTxRate, adslAtucChanConfFastMaxTxRate=adslAtucChanConfFastMaxTxRate, adslAtucChanConfInterleaveMaxTxRate=adslAtucChanConfInterleaveMaxTxRate, adslAtucChanConfMaxInterleaveDelay=adslAtucChanConfMaxInterleaveDelay, adslAturConfRateMode=adslAturConfRateMode, adslAturConfRateChanRatio=adslAturConfRateChanRatio, adslAturConfTargetSnrMgn=adslAturConfTargetSnrMgn, adslAturConfMaxSnrMgn=adslAturConfMaxSnrMgn, adslAturConfMinSnrMgn=adslAturConfMinSnrMgn, adslAturConfDownshiftSnrMgn=adslAturConfDownshiftSnrMgn, adslAturConfUpshiftSnrMgn=adslAturConfUpshiftSnrMgn, adslAturConfMinUpshiftTime=adslAturConfMinUpshiftTime, adslAturConfMinDownshiftTime=adslAturConfMinDownshiftTime, adslAturChanConfFastMinTxRate=adslAturChanConfFastMinTxRate, adslAturChanConfInterleaveMinTxRate=adslAturChanConfInterleaveMinTxRate, adslAturChanConfFastMaxTxRate=adslAturChanConfFastMaxTxRate, adslAturChanConfInterleaveMaxTxRate=adslAturChanConfInterleaveMaxTxRate, adslAturChanConfMaxInterleaveDelay=adslAturChanConfMaxInterleaveDelay, adslLineConfProfileRowStatus=adslLineConfProfileRowStatus, adslLineAlarmConfProfileTable=adslLineAlarmConfProfileTable, adslLineAlarmConfProfileEntry=adslLineAlarmConfProfileEntry, adslLineAlarmConfProfileName=adslLineAlarmConfProfileName, adslAtucThresh15MinLofs=adslAtucThresh15MinLofs, adslAtucThresh15MinLoss=adslAtucThresh15MinLoss, adslAtucThresh15MinLols=adslAtucThresh15MinLols, adslAtucThresh15MinLprs=adslAtucThresh15MinLprs, adslAtucThresh15MinESs=adslAtucThresh15MinESs, adslAtucThreshFastRateUp=adslAtucThreshFastRateUp, adslAtucThreshInterleaveRateUp=adslAtucThreshInterleaveRateUp, adslAtucThreshFastRateDown=adslAtucThreshFastRateDown, adslAtucThreshInterleaveRateDown=adslAtucThreshInterleaveRateDown, adslAtucInitFailureTrapEnable=adslAtucInitFailureTrapEnable, adslAturThresh15MinLofs=adslAturThresh15MinLofs, adslAturThresh15MinLoss=adslAturThresh15MinLoss, adslAturThresh15MinLprs=adslAturThresh15MinLprs, adslAturThresh15MinESs=adslAturThresh15MinESs, adslAturThreshFastRateUp=adslAturThreshFastRateUp, adslAturThreshInterleaveRateUp=adslAturThreshInterleaveRateUp, adslAturThreshFastRateDown=adslAturThreshFastRateDown, adslAturThreshInterleaveRateDown=adslAturThreshInterleaveRateDown, adslLineAlarmConfProfileRowStatus=adslLineAlarmConfProfileRowStatus, adslLCSMib=adslLCSMib, adslTraps=adslTraps, adslAtucTraps=adslAtucTraps, adslAturTraps=adslAturTraps, adslConformance=adslConformance, adslGroups=adslGroups, adslCompliances=adslCompliances)

# Notifications
mibBuilder.exportSymbols("ADSL-LINE-MIB", adslAtucPerfLofsThreshTrap=adslAtucPerfLofsThreshTrap, adslAtucPerfLossThreshTrap=adslAtucPerfLossThreshTrap, adslAtucPerfLprsThreshTrap=adslAtucPerfLprsThreshTrap, adslAtucPerfESsThreshTrap=adslAtucPerfESsThreshTrap, adslAtucRateChangeTrap=adslAtucRateChangeTrap, adslAtucPerfLolsThreshTrap=adslAtucPerfLolsThreshTrap, adslAtucInitFailureTrap=adslAtucInitFailureTrap, adslAturPerfLofsThreshTrap=adslAturPerfLofsThreshTrap, adslAturPerfLossThreshTrap=adslAturPerfLossThreshTrap, adslAturPerfLprsThreshTrap=adslAturPerfLprsThreshTrap, adslAturPerfESsThreshTrap=adslAturPerfESsThreshTrap, adslAturRateChangeTrap=adslAturRateChangeTrap)

# Groups
mibBuilder.exportSymbols("ADSL-LINE-MIB", adslLineGroup=adslLineGroup, adslPhysicalGroup=adslPhysicalGroup, adslChannelGroup=adslChannelGroup, adslAtucPhysPerfRawCounterGroup=adslAtucPhysPerfRawCounterGroup, adslAtucPhysPerfIntervalGroup=adslAtucPhysPerfIntervalGroup, adslAturPhysPerfRawCounterGroup=adslAturPhysPerfRawCounterGroup, adslAturPhysPerfIntervalGroup=adslAturPhysPerfIntervalGroup, adslAtucChanPerformanceGroup=adslAtucChanPerformanceGroup, adslAturChanPerformanceGroup=adslAturChanPerformanceGroup, adslLineConfProfileGroup=adslLineConfProfileGroup, adslLineAlarmConfProfileGroup=adslLineAlarmConfProfileGroup, adslLineConfProfileControlGroup=adslLineConfProfileControlGroup, adslNotificationsGroup=adslNotificationsGroup, adslAturLineGroup=adslAturLineGroup, adslAturPhysicalGroup=adslAturPhysicalGroup, adslAturChannelGroup=adslAturChannelGroup, adslAturAtucPhysPerfRawCounterGroup=adslAturAtucPhysPerfRawCounterGroup, adslAturAtucPhysPerfIntervalGroup=adslAturAtucPhysPerfIntervalGroup, adslAturAturPhysPerfRawCounterGroup=adslAturAturPhysPerfRawCounterGroup, adslAturAturPhysPerfIntervalGroup=adslAturAturPhysPerfIntervalGroup, adslAturAtucChanPerformanceGroup=adslAturAtucChanPerformanceGroup, adslAturAturChanPerformanceGroup=adslAturAturChanPerformanceGroup, adslAturLineAlarmConfProfileGroup=adslAturLineAlarmConfProfileGroup, adslAturLineConfProfileControlGroup=adslAturLineConfProfileControlGroup, adslAturNotificationsGroup=adslAturNotificationsGroup)

# Compliances
mibBuilder.exportSymbols("ADSL-LINE-MIB", adslLineMibAtucCompliance=adslLineMibAtucCompliance, adslLineMibAturCompliance=adslLineMibAturCompliance)
