# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .property_value_py3 import PropertyValue


class BinaryPropertyValue(PropertyValue):
    """Describes a Service Fabric property value of type Binary.

    All required parameters must be populated in order to send to Azure.

    :param kind: Required. Constant filled by server.
    :type kind: str
    :param data: Required. Array of bytes to be sent as an integer array. Each
     element of array is a number between 0 and 255.
    :type data: list[int]
    """

    _validation = {
        'kind': {'required': True},
        'data': {'required': True},
    }

    _attribute_map = {
        'kind': {'key': 'Kind', 'type': 'str'},
        'data': {'key': 'Data', 'type': '[int]'},
    }

    def __init__(self, *, data, **kwargs) -> None:
        super(BinaryPropertyValue, self).__init__(**kwargs)
        self.data = data
        self.kind = 'Binary'
