# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .proxy_only_resource import ProxyOnlyResource


class SitePhpErrorLogFlag(ProxyOnlyResource):
    """Used for getting PHP error logging flag.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :param kind: Kind of resource.
    :type kind: str
    :ivar type: Resource type.
    :vartype type: str
    :param local_log_errors: Local log_errors setting.
    :type local_log_errors: str
    :param master_log_errors: Master log_errors setting.
    :type master_log_errors: str
    :param local_log_errors_max_length: Local log_errors_max_len setting.
    :type local_log_errors_max_length: str
    :param master_log_errors_max_length: Master log_errors_max_len setting.
    :type master_log_errors_max_length: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'local_log_errors': {'key': 'properties.localLogErrors', 'type': 'str'},
        'master_log_errors': {'key': 'properties.masterLogErrors', 'type': 'str'},
        'local_log_errors_max_length': {'key': 'properties.localLogErrorsMaxLength', 'type': 'str'},
        'master_log_errors_max_length': {'key': 'properties.masterLogErrorsMaxLength', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(SitePhpErrorLogFlag, self).__init__(**kwargs)
        self.local_log_errors = kwargs.get('local_log_errors', None)
        self.master_log_errors = kwargs.get('master_log_errors', None)
        self.local_log_errors_max_length = kwargs.get('local_log_errors_max_length', None)
        self.master_log_errors_max_length = kwargs.get('master_log_errors_max_length', None)
